<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Auto_Body_Types extends Widget_Base {

    public function get_name() {
        return 'templines-auto-body-types';
    }

    public function get_title() {
        return esc_html__( 'Auto Body Types', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fa fa-font templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    public function templines_get_body($type = null){

        $terms = get_terms( array(
            'taxonomy' => 'auto-body',
            'hide_empty' => '0'
        ) );

        $options[0] = esc_html__( 'Select a Auto Bodies', 'templines-helper-core' );

        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
            foreach ( $terms as $cat ) {
                $options[$cat->slug] = $cat->name;
            }
        } else {
            $options[0] = esc_html__( 'Create a Body First', 'templines-helper-core' );
        }

        return $options;
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_auto_body_types_style',
            [
                'label' => __( 'General Settings', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'cats', [
                'label' => esc_html__( 'Choose Bodies', 'templines-helper-core'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->templines_get_body(),
                'show_label' => true,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'css_animation',
            [
                'label' => __( 'CSS Animation', 'templines-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'no'                  => esc_html__( 'No', 'autozone' ),
                    'bounce'            => esc_html__( 'bounce', 'autozone' ),
                    'flash'             => esc_html__( 'flash', 'autozone' ),
                    'pulse'             => esc_html__( 'pulse', 'autozone' ),
                    'rubberBand'        => esc_html__( 'rubberBand', 'autozone' ),
                    'shake'             => esc_html__( 'shake', 'autozone' ),
                    'swing'             => esc_html__( 'swing', 'autozone' ),
                    'tada'              => esc_html__( 'tada', 'autozone' ),
                    'wobble'            => esc_html__( 'wobble', 'autozone' ),
                    'jello'             => esc_html__( 'jello', 'autozone' ),
                    'bounceIn'          => esc_html__( 'bounceIn', 'autozone' ),
                    'bounceInDown'      => esc_html__( 'bounceInDown', 'autozone' ),
                    'bounceInLeft'      => esc_html__( 'bounceInLeft', 'autozone' ),
                    'bounceInRight'     => esc_html__( 'bounceInRight', 'autozone' ),
                    'bounceInUp'        => esc_html__( 'bounceInUp', 'autozone' ),
                    'bounceOut'         => esc_html__( 'bounceOut', 'autozone' ),
                    'bounceOutDown'     => esc_html__( 'bounceOutDown', 'autozone' ),
                    'bounceOutLeft'     => esc_html__( 'bounceOutLeft', 'autozone' ),
                    'bounceOutRight'    => esc_html__( 'bounceOutRight', 'autozone' ),
                    'bounceOutUp'       => esc_html__( 'bounceOutUp', 'autozone' ),
                    'fadeIn'            => esc_html__( 'fadeIn', 'autozone' ),
                    'fadeInDown'        => esc_html__( 'fadeInDown', 'autozone' ),
                    'fadeInDownBig'     => esc_html__( 'fadeInDownBig', 'autozone' ) ,
                    'fadeInLeft'        => esc_html__( 'fadeInLeft', 'autozone' ),
                    'fadeInLeftBig'     => esc_html__( 'fadeInLeftBig', 'autozone' ),
                    'fadeInRight'       => esc_html__( 'fadeInRight', 'autozone' ),
                    'fadeInRightBig'    => esc_html__( 'fadeInRightBig', 'autozone' ),
                    'fadeInUp'          => esc_html__( 'fadeInUp', 'autozone' ),
                    'fadeInUpBig'       => esc_html__( 'fadeInUpBig', 'autozone' ),
                    'fadeOut'           => esc_html__( 'fadeOut', 'autozone' ),
                    'fadeOutDown'       => esc_html__( 'fadeOutDown', 'autozone' ),
                    'fadeOutDownBig'    => esc_html__( 'fadeOutDownBig', 'autozone' ) ,
                    'fadeOutLeft'       => esc_html__( 'fadeOutLeft', 'autozone' ),
                    'fadeOutLeftBig'    => esc_html__( 'fadeOutLeftBig', 'autozone' ),
                    'fadeOutRight'      => esc_html__( 'fadeOutRight', 'autozone' ),
                    'fadeOutRightBig'   => esc_html__( 'fadeOutRightBig', 'autozone' ),
                    'fadeOutUp'         => esc_html__( 'fadeOutUp', 'autozone' ),
                    'fadeOutUpBig'      => esc_html__( 'fadeOutUpBig', 'autozone' ),
                    'flip'              => esc_html__( 'flip', 'autozone' ),
                    'flipInX'           => esc_html__( 'flipInX', 'autozone' ),
                    'flipInY'           => esc_html__( 'flipInY', 'autozone' ),
                    'flipOutX'          => esc_html__( 'flipOutX', 'autozone' ),
                    'flipOutY'          => esc_html__( 'flipOutY', 'autozone' ),
                    'lightSpeedIn'      => esc_html__( 'lightSpeedIn', 'autozone' ),
                    'lightSpeedOut'     => esc_html__( 'lightSpeedOut', 'autozone' ),
                    'rotateIn'          => esc_html__( 'rotateIn', 'autozone' ),
                    'rotateInDownLeft'  => esc_html__( 'rotateInDownLeft', 'autozone' ),
                    'rotateInDownRight' => esc_html__( 'rotateInDownRight', 'autozone' ),
                    'rotateInUpLeft'    => esc_html__( 'rotateInUpLeft', 'autozone' ),
                    'rotateInUpRight'   => esc_html__( 'rotateInUpRight', 'autozone' ),
                    'rotateOut'         => esc_html__( 'rotateOut', 'autozone' ),
                    'rotateOutDownLeft' => esc_html__( 'rotateOutDownLeft', 'autozone' ),
                    'rotateOutDownRight'=> esc_html__( 'rotateOutDownRight', 'autozone' ),
                    'rotateOutUpLeft'   => esc_html__( 'rotateOutUpLeft', 'autozone' ),
                    'rotateOutUpRight'  => esc_html__( 'rotateOutUpRight', 'autozone' ),
                    'slideInUp'         => esc_html__( 'slideInUp', 'autozone' ),
                    'slideInDown'       => esc_html__( 'slideInDown', 'autozone' ),
                    'slideInLeft'       => esc_html__( 'slideInLeft', 'autozone' ),
                    'slideInRight'      => esc_html__( 'slideInRight', 'autozone' ),
                    'slideOutUp'        => esc_html__( 'slideOutUp', 'autozone' ),
                    'slideOutDown'      => esc_html__( 'slideOutDown', 'autozone' ),
                    'slideOutLeft'      => esc_html__( 'slideOutLeft', 'autozone' ),
                    'slideOutRight'     => esc_html__( 'slideOutRight', 'autozone' ),
                    'zoomIn'            => esc_html__( 'zoomIn', 'autozone' ),
                    'zoomInDown'        => esc_html__( 'zoomInDown', 'autozone' ),
                    'zoomInLeft'        => esc_html__( 'zoomInLeft', 'autozone' ),
                    'zoomInRight'       => esc_html__( 'zoomInRight', 'autozone' ),
                    'zoomInUp'          => esc_html__( 'zoomInUp', 'autozone' ),
                    'zoomOut'           => esc_html__( 'zoomOut', 'autozone' ),
                    'zoomOutDown'       => esc_html__( 'zoomOutDown', 'autozone' ),
                    'zoomOutLeft'       => esc_html__( 'zoomOutLeft', 'autozone' ),
                    'zoomOutRight'      => esc_html__( 'zoomOutRight', 'autozone' ),
                    'zoomOutUp'         => esc_html__( 'zoomOutUp', 'autozone' ),
                    'hinge'             => esc_html__( 'hinge', 'autozone' ),
                    'rollIn'            => esc_html__( 'rollIn', 'autozone' ),
                    'rollOut'           => esc_html__( 'rollOut', 'autozone' ),

                ],
                'default' => 'no',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $this->add_render_attribute( 'wrapper', 'class', 'page-builder-custom-auto-body-types-wrap' );
        $settings = $this->get_settings_for_display();
        ?>
<?php
        global $post;

        $figure = '';

        if( $settings['cats'] == '' ):
            $out = '<p>'.esc_html__('No Body Types selected. To fix this, please login to your WP Admin area and set the body types you want to show by editing this shortcode and setting one or more body types in the multi checkbox field "Body Types".', 'autozone');
        else:

            $out = $settings['css_animation'] != '' ? '<div class="animated" data-animation="' . esc_attr($settings['css_animation']) . '">' : '<div>';
            $out .= '	
			<ul class="list-type">
		';

            $include = array();
            foreach($settings['cats'] as $val){
                $term = get_term_by('slug', $val, 'auto-body');
                if( isset($term->term_id) ){
                    $include[] = $term->term_id;
                }
            }

            $args = array( 'taxonomy' => 'auto-body', 'hide_empty' => '0', 'include' => implode(',', $include));
            $autos_categories = get_categories ($args);
            $Settings = new PIXAD_Settings();
            $options = $Settings->getSettings( 'WP_OPTIONS', '_pixad_autos_settings', true );
            $url_page_listings = get_page_uri( $options['autos_listing_car_page']);

            if( $autos_categories ):
                foreach($autos_categories as $auto_cat) :
                    $auto_t_id = $auto_cat->term_id;
                    $auto_cat_meta = get_option("auto_body_$auto_t_id");
                    $auto_cat_thumb_url = get_option("pixad_body_thumb$auto_t_id");
                    $auto_link = get_term_link( $auto_cat );
                    $term_listings = $auto_cat->slug;
                    $str_url = home_url() . '/' .  $url_page_listings . '/?body=' . $term_listings ;
                    if($auto_cat_thumb_url){
                        $img_src = wp_get_attachment_image_src( attachment_url_to_postid( $auto_cat_thumb_url ), 'autozone-body-thumb' );
                        $figure = '<img src="'.esc_url($img_src[0]).'" alt="'.esc_attr($auto_cat->name).'">';
                    } elseif(isset($auto_cat_meta['pixad_body_icon'])){
                        $figure = '<i class="icon '. esc_attr($auto_cat_meta['pixad_body_icon']) .'"></i>';
                    }
                    $out .= '
				<li class="list-type__item">
					<a class="list-type__link" href="'.esc_url($str_url).'">
						<div class="list-type__inner">
                        
                        	<div class="list-type__inne_figure">
							'.wp_kses_post($figure).'
                            </div>
                            
							<div class="decor-1 center-block"></div>
							<div class="list-type__name">'.wp_kses_post($auto_cat->name).'</div>
							<div class="list-type__info">'.wp_kses_post($auto_cat->count).' '.esc_html__('Offers', 'autozone').'</div>
						</div>
					</a>
				</li>
	';
                endforeach;
            endif;

            $out .= '            
			</ul>
	';

            $out .= '</div>';
        endif;
        echo $out; ?>

<?php

    }
}
