<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;






if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_Amount_Box extends Widget_Base {

    public function get_name() {
        return 'templines-amount-box';
    }

    public function get_title() {
        return esc_html__( 'Amount Box', 'templines-helper-core' );
    }

    public function get_icon() {
        return 'fas fa-layer-group templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }



    protected function register_controls() {
        // Sub Title
        $this->start_controls_section(
            'section_elementor_list_general',
            [
                'label' => __( 'General Amount Box Setting', 'templines-helper-core' ),
            ]
        );

        $repeater = new Repeater();
        //Title
        $repeater->add_control(
            'title',
            [
                'label' => __( 'Title', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'COUNTRIES REACHED', 'templines-helper-core' ),
            ]
        );
        //Strong Title
        $repeater->add_control(
            'amount',
            [
                'label' => __( 'Amount', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '900', 'templines-helper-core' ),
            ]
        );
        //Icon
        /*
        $repeater->add_control(
            'type',
            [
                'label' => __( 'Icon library', 'tm-helper-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'pixflaticon'               =>          esc_attr__('Pixflaticon','tm-helper-core'),
                    'pixfontawesome'              =>          esc_attr__('Pixfontawesome','tm-helper-core'),
                    'pixelegant'              =>          esc_attr__('Pixelegant','tm-helper-core'),
                    'pixsimple'              =>          esc_attr__('Pixsimple','tm-helper-core'),
                    'pixcustom1'              =>          esc_attr__('Pixcustom1','tm-helper-core'),
                    'pixcustom2'              =>          esc_attr__('Pixcustom2','tm-helper-core'),
                    'fontawesome'              =>          esc_attr__('Fontawesome','tm-helper-core'),
                ],
                'default' => 'pixflaticon'
            ]
        );
        $repeater->add_control(
            'icon_pixflaticon',
            [
                'label' => __( 'Flaticon', 'tm-helper-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flaticon-automobile5' => [
                        'title' => __( 'Automobile5', 'templines-helper-core' ),
                        'icon' => 'flaticon-automobile5',
                    ],
                ],
                'default' => 'flaticon-automobile5'
            ]
        );
        */
        
        $repeater->add_control(
            'icon_svg',
            [
                'label'            => __( 'Icon', 'templines-helper-core' ),
                'type'             => Controls_Manager::ICONS,
                'label_block'      => true,
                'default'          => [
                    'value'   => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'fa4compatibility' => 'icon'
            ]
        );
        $this->add_control(
            'list_amount',
            [
                'label'       => 'Amount Box List',
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );



        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();?>
<ul class="list-progress list-unstyled">
    <?php foreach ($settings['list_amount'] as $item){ ?>
    <li class="list-progress__item">
        <?php Icons_Manager::render_icon( $item['icon_svg']);?>
        <div class="list-progress__inner">
            <span class="chart" data-percent="<?php echo esc_attr($item['amount']);?>"><span class="percent"><?php echo wp_kses_post($item['amount']);?></span>+<canvas height="0" width="0"></canvas></span>
            <span class="list-progress__name"><?php echo wp_kses_post($item['title']);?></span>
        </div>
    </li>
    <?php } ?>
</ul>
<?php
    }
}
