<?php
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Templines_3d_Viewer extends Widget_Base {

    public function get_name() {
        return 'templines-3d-viewer';
    }

    public function get_title() {
        return esc_html__( '3D Viewer', 'templines-helper-core' );
    }

    public function get_icon() {
          return 'fa fa-layer-group templines-icon';
    }

    public function get_categories() {
        return array('templines-helper-core-elements');
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_elementor_3d_viewer_style',
            [
                'label' => __( 'General Styles', 'templines-helper-core' ),
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __( 'Choose Image', 'templines-helper-core' ),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => __( 'Number of frames', 'templines-helper-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '16', 'templines-helper-core' ),
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();


        $out = '';

        $img_id = $settings['image']['id'];
        $img_link = wp_get_attachment_image_src( $img_id, 'full' );
        $img_link = $img_link[0];
        $image_meta = autozone_wp_get_attachment($img_id);
        $image_alt = $image_meta['alt'] == '' ? $image_meta['title'] : $image_meta['alt'];
        $number = $settings['number'] == '' ? 16 : $settings['number'];

        $out = '
            <div class="cd-product-viewer-wrapper" data-frame="'.esc_attr($number).'" data-friction="0.33">
                <div>
                    <style scoped> html .cd-product-viewer-wrapper .product-sprite{background: url('.esc_url($img_link).') no-repeat center center; background-size: 100%;}</style>
                    <figure class="product-viewer">
                        <div class="product-sprite" data-image="'.esc_url($img_link).'"></div>
                    </figure> <!-- .product-viewer -->
    
                    <div class="cd-product-viewer-handle">
                        <span class="fill"></span>
                        <span class="handle">'.esc_html__( 'Handle', 'autozone' ).'</span>
                    </div>
                </div>
            </div> 
        ';

        echo $out;
        ?>



<?php }
}
