<?php

defined( 'ABSPATH' ) or die();

class Templines_Helper_Core_Elementor {

    private static $_instance = null;

    private $_version;
    private $file;
    private $dir;
    private $widgets_dir;
    private $assets_dir;
    private $assets_url;
    private $_token;

    function __construct( $file, $version = '1.0.0' ) {

        $this->_version    = $version;
        $this->file        = $file;
        $this->dir         = dirname( $this->file );
        $this->widgets_dir = trailingslashit( $this->dir ) . 'elementor';
        $this->assets_dir  = trailingslashit( $this->dir ) . 'assets';
        $this->assets_url  = esc_url( trailingslashit( plugins_url( '/elementor/assets/', $this->file ) ) );
        $this->_token      = 'templines_helper-core-elementor';

        $this->load_elementor_plugin_files();

        add_action( 'elementor/init', [ $this, 'load_elementor_widgets' ] );
        add_action( 'elementor/elements/categories_registered', [ $this, 'add_widget_category' ], 1 );
        add_action( 'elementor/widgets/widgets_registered', [ $this, 'elementor_widgets_init' ] );
        add_action( 'elementor/frontend/after_register_scripts', [ $this, 'elementor_add_js' ],99 );
        add_action( 'elementor/frontend/after_register_styles', [ $this, 'elementor_add_css' ] );
        add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'elementor_add_css_editor' ] );
        add_action( 'elementor/controls/controls_registered', [ $this, 'elementorregister_controls' ] );


        // Custom Standart Option
        Templines_Helper_Core_Elements_Section()->init();
        Templines_Helper_Core_Default_Item_Option()->init();
    }

    public function elementorregister_controls() {
        $controls_manager = \Elementor\Plugin::$instance->controls_manager;
        $controls_manager->register_control( 'templines-hotspot', new Templines_Hotspot_Control() );
    }

    public function add_widget_category( $elements_manager ) {

        $elements_manager->add_category(
            'templines-helper-core-elements',
            [
                'title' => esc_html__( 'Theme Custom Elements', 'templines-helper-core' ),
                'icon'  => 'templines-logo',
            ]
        );

    }

    public function load_elementor_widgets() {


        require_once $this->widgets_dir . '/widgets/welcome_banner.php';
        require_once $this->widgets_dir . '/widgets/vehicle_search.php';
        require_once $this->widgets_dir . '/widgets/auto_models.php';
        require_once $this->widgets_dir . '/widgets/title.php';
        require_once $this->widgets_dir . '/widgets/service_box.php';
        require_once $this->widgets_dir . '/widgets/latest_autos.php';
        require_once $this->widgets_dir . '/widgets/amount_box.php';
        require_once $this->widgets_dir . '/widgets/auto_body_types.php';
        require_once $this->widgets_dir . '/widgets/team.php';
        require_once $this->widgets_dir . '/widgets/image_carousel.php';
        require_once $this->widgets_dir . '/widgets/blog_box.php';
        require_once $this->widgets_dir . '/widgets/reviews.php';
        require_once $this->widgets_dir . '/widgets/customer_favourites.php';
        require_once $this->widgets_dir . '/widgets/sale_product.php';
        require_once $this->widgets_dir . '/widgets/3d_viewer.php';
        require_once $this->widgets_dir . '/widgets/map.php';
        require_once $this->widgets_dir . '/widgets/brand.php';
        require_once $this->widgets_dir . '/widgets/social_buttons.php';
        require_once $this->widgets_dir . '/widgets/custom_post.php';
        require_once $this->widgets_dir . '/widgets/custom_product.php';
        require_once $this->widgets_dir . '/widgets/custom_auto.php';
        require_once $this->widgets_dir . '/widgets/border-decor.php';
        require_once $this->widgets_dir . '/widgets/icon_box.php';
        require_once $this->widgets_dir . '/widgets/testimonials.php';
        require_once $this->widgets_dir . '/widgets/autos.php';
        require_once $this->widgets_dir . '/widgets/hotspot-control.php';
        require_once $this->widgets_dir . '/widgets/hotspot-carousel.php';
        require_once $this->widgets_dir . '/widgets/product-slider.php';


       // require_once $this->widgets_dir . '/widgets/pricing.php';
       // require_once $this->widgets_dir . '/widgets/button.php';
       // require_once $this->widgets_dir . '/widgets/button_advanced.php';
      //  require_once $this->widgets_dir . '/widgets/icon_box.php';
      //  require_once $this->widgets_dir . '/widgets/action_content.php';
      //  require_once $this->widgets_dir . '/widgets/blockquote.php';
      //  require_once $this->widgets_dir . '/widgets/image_carousel.php';
      //  require_once $this->widgets_dir . '/widgets/text_editor.php';
      //  require_once $this->widgets_dir . '/widgets/contacts.php';
    }

    public function elementor_widgets_init() {
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Welcome_Banner() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Border_Decor() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Vehicle_Search() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Auto_Models() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Title() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Service_Box() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Latest_Autos() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Amount_Box() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Auto_Body_Types() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Team() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Image_Carousel() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Blog_Box() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Reviews() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Customer_Favourites() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Sale_Product() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_3d_Viewer() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Map() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Brand() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Social_Buttons() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Custom_Post() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Custom_Product() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Custom_Auto() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Icon_Box() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Testimonials() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Autos() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Elementor_Hotspot_Carousel() );
        \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Product_Slider() );


        // \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Pricing() );
        //  \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Button() );
        //  \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Button_Advanced() );
        //  \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Action_Content() );
        //  \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Icon_Box() );

        //  \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Custom_Blockquote() );
        //   \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Image_Decor() );
        //  \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Image_Gallery() );
        //  \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Custom_Text_Editor() );
        //  \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Templines_Contacts() );
    }

    /** Add Custom Widgets*/
    public function load_elementor_plugin_files() {
        require_once $this->widgets_dir . '/custom_default_element/templines-helping-core-change-default-section.php';
        require_once $this->widgets_dir . '/custom_default_element/templines-helping-core-default-option.php';

    }


    public function elementor_add_js() {
        $is_preview_mode = class_exists( 'Elementor\Plugin' ) && \Elementor\Plugin::$instance->preview->is_preview_mode();
        if ( $is_preview_mode ) {
            wp_register_script( $this->_token . '-elementor', esc_url( $this->assets_url ) . 'js/elementor.js', ['jquery'], $this->_version );
            wp_enqueue_script( $this->_token . '-elementor' );
            wp_register_script( $this->_token . '-custom-animation-elementor', esc_url( $this->assets_url ) . 'js/elementor_custom_animation.js', ['jquery'], $this->_version );
            wp_enqueue_script( $this->_token . '-custom-animation-elementor' );
        }
    }

    public function elementor_add_css() {
    }

    public function elementor_add_css_editor() {
        wp_register_style( $this->_token . '-elementor', esc_url( $this->assets_url ) . 'css/elementor.css', [], $this->_version );
        wp_enqueue_style( $this->_token . '-elementor' );
    }

    public static function instance( $file = '', $version = '1.0.0' ) {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self( $file, $version );
        }

        return self::$_instance;
    } // End instance ()


    public function __clone() {
        _doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?', 'templines-helper-core' ), $this->_version );
    } // End __clone ()


    public function __wakeup() {
        _doing_it_wrong( __FUNCTION__, __( 'Cheatin&#8217; huh?', 'templines-helper-core' ), $this->_version );
    } // End __wakeup ()


}

// Custom Controle
require_once(TEMPLINES_HELPER_CORE_PLUGIN_PATH. '/elementor/custom-controle/image-selector/custom-control-init.php' );