<?php

/**
 * Class description
 *
 * @author    Templines
 * @license   GPL-2.0+
 */

// If this file is called directly, abort.
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Utils;
use Elementor\Icons_Manager;
use Elementor\Group_Control_Background;

if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'Templines_Helper_Core_Elements_Section' ) ) {

	/**
	 * Define Templines_Helper_Core_Elements_Ext_Section class
	 */
	class Templines_Helper_Core_Elements_Section {

		/**
		 * [$parallax_sections description]
		 * @var array
		 */
		public $parallax_sections = array();

		/**
		 * A reference to an instance of this class.
		 *
		 * @since  1.0.0
		 * @access private
		 * @var    object
		 */
		private static $instance = null;

		/**
		 * Init Handler
		 */
		public function init() {
            add_action('elementor/element/section/section_layout/after_section_end', array($this, 'register_controls'), 10);

        }


		public function register_controls( $element ) {
            $element->start_controls_section(
                'section_custom_section_decor',
                [
                    'label' => esc_html__( 'Templines Section Decors', 'templines-helper-core' ),
                    'tab'   => Elementor\Controls_Manager::TAB_ADVANCED,
                ]
            );

            $element->add_responsive_control(
                'templines-decor-top',
                [
                    'label'             => __( 'Top Decor', 'templines-helper-core' ),
                    'type'              => Controls_Manager::SELECT,
                    'options' => [
                        'disable'  => __( 'None', 'templines-helper-core' ),
                        //'section-top border-section-top_mod-b bg_inner'  => __( 'Enable', 'templines-helper-core' ),
                    ],
                    'prefix_class' => 'border-',
                ]
            );

            $element->end_controls_section();
		}

		/**
		 * Returns the instance.
		 *
		 * @since  1.0.0
		 * @access public
		 * @return object
		 */
		public static function get_instance() {
			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
			}
			return self::$instance;
		}

	}
}

/**
 * Returns instance of Templines_Helper_Core_Elements_Ext_Section
 *
 * @return object
 */
function templines_helper_core_elements_section() {
	return Templines_Helper_Core_Elements_Section::get_instance();
}
