(function ($) {
	"use strict";
	$(function () {
		var $templines_hotspot_data_field = null;
		var $templines_hotspot_data = null;
		$(window).resize(templines_hotspot_debounce(function () {
			templines_hotspot_show_all();
		}, 500));
		$(document)
			.on('click', '.js-templines-edit-hotspot', function () {
				var $this = $(this);
				var $repeater = $this.closest('.elementor-repeater-row-controls');
				var $image = $repeater.find('.elementor-control-' + $this.data('control') + ' .elementor-control-media__preview');
				var image = $image.css('background-image').slice(4, -1).replace(/"/g, "");
				$templines_hotspot_data_field = null;
				$templines_hotspot_data = null;
				if (image && $('.templines-hotspot').length === 0) {

					$('body').append('<div class="templines-hotspot"><div class="templines-hotspot__wrap js-templines-hotspot-wrap"><a class="templines-hotspot__close js-templines-close-hotspot dashicons dashicons-no-alt" href="#" onclick="return false;"></a><img alt="" src="" class="templines-hotspot__image js-templines-hotspot-image"></div></div>');

					$(".js-templines-hotspot-image").one("load", function () {
						templines_hotspot_show_all();
					}).attr('src', image);

					$templines_hotspot_data_field = $repeater.find('.js-templines-hotspot-data');
					var val = $templines_hotspot_data_field.val();
					if (val != '') {
						$templines_hotspot_data = JSON.parse(val);
					} else {
						$templines_hotspot_data = [];
					}
				}
			})
			.on('click', '.js-templines-close-hotspot', function () {
				var $this = $(this);
				var $popup = $this.closest('.templines-hotspot');
				$popup.remove();
				$templines_hotspot_data_field = null;
				$templines_hotspot_data = null;
			})
			.on('click', '.js-templines-hotspot-image', function (e) {
				if ($templines_hotspot_data !== null) {
					var $this = $(this);
					var width = $this.width();
					var height = $this.height();
					var x = e.pageX - $this.offset().left;
					var y = e.pageY - $this.offset().top;
					var title = prompt($templines_hotspot_data_field.data('prompt'), "");
					if (title != null && title != "") {
						$templines_hotspot_data.push({
							x    : x / width * 100,
							y    : y / height * 100,
							title: title
						});
						var index = $templines_hotspot_data.length - 1;
						templines_hotspot_show_spot($templines_hotspot_data[index], index);
						$templines_hotspot_data_field.val(JSON.stringify($templines_hotspot_data)).trigger('input');
					}
				}
			});

		function templines_hotspot_show_all() {
			if ($templines_hotspot_data !== null) {
				$('.js-templines-hotspot-point').remove();
				$templines_hotspot_data.forEach(function (item, i, arr) {
					templines_hotspot_show_spot(item, i);
				});
			}
		}

		function templines_hotspot_debounce(func, wait, immediate) {
			var timeout;
			return function () {
				var context = this, args = arguments;
				var later = function () {
					timeout = null;
					if (!immediate) func.apply(context, args);
				};
				var callNow = immediate && !timeout;
				clearTimeout(timeout);
				timeout = setTimeout(later, wait);
				if (callNow) func.apply(context, args);
			};
		}

		function templines_hotspot_show_spot(point, index) {
			var $wrap = $('.js-templines-hotspot-wrap');
			var $image = $wrap.find('.js-templines-hotspot-image');
			var left = Math.round(point.x * $image.width() / 100);
			var top = Math.round(point.y * $image.height() / 100);
			if ($wrap.length == 1) {
				var $point = $('<span data-index="' + index + '" class="templines-hotspot__point js-templines-hotspot-point" style="left: ' + left + 'px;top: ' + top + 'px;"><a href="#" onclick="return false;" class="templines-hotspot__point-edit dashicons dashicons-edit js-point-edit"></a><a href="#" onclick="return false;" class="templines-hotspot__point-close dashicons dashicons-no-alt js-point-close"></a></span>');
				$point.attr('data-title', point.title);
				var $edit = $point.find('.js-point-edit');
				var $close = $point.find('.js-point-close');
				$edit.data('index', index).click(function () {
					var $this = $(this);
					var index = $this.data('index');
					var point = $templines_hotspot_data[index];
					var title = prompt($templines_hotspot_data_field.data('prompt'), point.title);
					var $point = $this.closest('.js-templines-hotspot-point');
					if (title === null) {
						return;
					}
					if (title !== "") {
						point.title = title;
						$templines_hotspot_data[index] = point;
						$point.attr('data-title', title);
						$templines_hotspot_data_field.val(JSON.stringify($templines_hotspot_data)).trigger('input');
					} else {
						$point.find('.js-point-close').trigger('click');
					}
				});
				$close.data('index', index).click(function () {
					$templines_hotspot_data.splice($(this).data('index'), 1);
					$templines_hotspot_data_field.val(JSON.stringify($templines_hotspot_data)).trigger('input');
					templines_hotspot_show_all();
				});

				$wrap.append($point);
			}
		}
	});

})(jQuery);
