jQuery.noConflict()(function($) {
    var templines_nav_text = [
        '<i class="ip-z-arrow-right h-carousel__prev"></i>',
        '<i class="ip-z-arrow-right h-carousel__next"></i>'
    ];

    templines_init_hotspot_points = function ($containers) {
        jQuery('.c-hotspot-carousel__image-wrap').each(function () {
            var $container = $(this);
            var width = $container.width();
            var height = $container.height();
            if (width <= 1 || height <= 1) {
                return;
            }
            $container.find('.c-hotspot-carousel__point-popup--left,.c-hotspot-carousel__point-popup--right,.c-hotspot-carousel__point-popup--top').removeClass('c-hotspot-carousel__point-popup--left c-hotspot-carousel__point-popup--right c-hotspot-carousel__point-popup--top');
            $container.find('.js-carousel-point').each(function () {
                var $this = $(this);
                var left_css = Math.round($this.data('left') * width / 100);
                var top_css = Math.round($this.data('top') * height / 100);
                $this.css({
                    'left': left_css + 'px',
                    'top': top_css + 'px',
                });
                $this.addClass('init');
                var $popup = $this.find('.c-hotspot-carousel__point-popup');
                var left = $popup.offset().left - $container.offset().left;
                var top = $popup.offset().top - $container.offset().top;
                var right = width - (left + $popup.outerWidth()) - 30;
                left -= 30;

                if (left < 0 && right >= 0) {
                    $popup.addClass('c-hotspot-carousel__point-popup--left');
                }
                if (right < 0 && left >= 0) {
                    $popup.addClass('c-hotspot-carousel__point-popup--right');
                }
                if (top < 0) {
                    $popup.addClass('c-hotspot-carousel__point-popup--top');
                }
            });
        });
    };

    jQuery('.js-hotspot-carousel').each(function () {
        var $this = $(this);
        $this.addClass('owl-carousel').owlCarousel({
            center : false,
            loop   : false,
            items  : 1,
            margin : 0,
            navigation: !$this.hasClass('h-carousel--hide'),
            pagination: !$this.hasClass('h-carousel--dots-hide'),
            navigationText: templines_nav_text
        });
        $this.find('.c-hotspot-carousel__image').each(function () {
            var $this = $(this);
            var isLoaded = this.complete && this.naturalHeight !== 0;
            if ($this.attr('loading') == 'lazy' && !isLoaded) {
                $this.on('load', function (e) {
                    templines_init_hotspot_points($(this).closest('.c-hotspot-carousel__image-wrap'));
                });
            } else {
                templines_init_hotspot_points($(this).closest('.c-hotspot-carousel__image-wrap'));
            }
        });
        $('.c-hotspot-carousel__image[loading]').on('load', function () {
            $('.c-hotspot-carousel__image[loading]').removeAttr('loading');
        });
    });
});