<?php

//Theme Option -> WooCommerce
$theme_woo_panel = new Inzofin_WP_Customize_Panel( $wp_customize, 'theme_woo_panel', array(
	'title'			=> esc_html__( 'WooCommerce', 'inzofin' ),
	'description'	=> esc_html__( 'These are the WooCommerce settings of inzofin Theme.', 'inzofin' ),
	'priority'		=> 12,
	'panel'			=> 'inzofin_theme_panel'
));
$wp_customize->add_panel( $theme_woo_panel );

//WooCommerce -> Woo General
$inzofin_woo_general_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_woo_general_section', array(
	'title'			=> esc_html__( 'Woo General', 'inzofin' ),
	'description'	=> esc_html__( 'This is the setting for woocommerce general options.', 'inzofin' ),
	'priority'		=> 1,
	'panel'			=> 'theme_woo_panel'
));
$wp_customize->add_section( $inzofin_woo_general_section );

//Woo General
$wp_customize->add_setting('ajax_trigger_inzofin_woo_general_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_woo_general_section', array(
	'section'		=> 'inzofin_woo_general_section'
)));

//WooCommerce -> Archive Template
$inzofin_woo_archive_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_woo_archive_section', array(
	'title'			=> esc_html__( 'Archive Template', 'inzofin' ),
	'description'	=> esc_html__( 'This is the setting for woocommerce archive page template.', 'inzofin' ),
	'priority'		=> 2,
	'panel'			=> 'theme_woo_panel'
));
$wp_customize->add_section( $inzofin_woo_archive_section );

//Archive Template
$wp_customize->add_setting('ajax_trigger_inzofin_woo_archive_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_woo_archive_section', array(
	'section'		=> 'inzofin_woo_archive_section'
)));

//WooCommerce -> Single Product Template
$inzofin_woo_single_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_woo_single_section', array(
	'title'			=> esc_html__( 'Single Product Template', 'inzofin' ),
	'description'	=> esc_html__( 'This is the setting for woocommerce single product template.', 'inzofin' ),
	'priority'		=> 3,
	'panel'			=> 'theme_woo_panel'
));
$wp_customize->add_section( $inzofin_woo_single_section );

//Single Product Template
$wp_customize->add_setting('ajax_trigger_inzofin_woo_single_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_woo_single_section', array(
	'section'		=> 'inzofin_woo_single_section'
)));

//WooCommerce -> Woo Related Slider
$inzofin_general_woo_slide_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_general_woo_slide_section', array(
	'title'			=> esc_html__( 'Woo Related Slider', 'inzofin' ),
	'description'	=> esc_html__( 'This is the setting for woo related products slider', 'inzofin' ),
	'priority'		=> 4,
	'panel'			=> 'theme_woo_panel'
));
$wp_customize->add_section( $inzofin_general_woo_slide_section );

//Woo Related Slider
$wp_customize->add_setting('ajax_trigger_inzofin_general_woo_slide_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_general_woo_slide_section', array(
	'section'		=> 'inzofin_general_woo_slide_section'
)));