<?php

//Theme Option -> Import and Export
$theme_import_export_panel = new Inzofin_WP_Customize_Panel( $wp_customize, 'theme_import_export_panel', array(
	'title'			=> esc_html__( 'Import and Export', 'inzofin' ),
	'description'	=> esc_html__( 'This is the setting for import or export of current site theme options.', 'inzofin' ),
	'priority'		=> 14,
	'panel'			=> 'inzofin_theme_panel'
));
$wp_customize->add_panel( $theme_import_export_panel );

//Import and Export -> Import
$inzofin_import_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_import_section', array(
	'title'			=> esc_html__( 'Import', 'inzofin' ),
	'description'	=> esc_html__( 'This is the import setting for current theme option values.', 'inzofin' ),
	'priority'		=> 1,
	'panel'			=> 'theme_import_export_panel'
));
$wp_customize->add_section( $inzofin_import_section );

//Import
$wp_customize->add_setting('ajax_trigger_inzofin_import_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_import_section', array(
	'section'		=> 'inzofin_import_section'
)));

//Import and Export -> Export
$inzofin_export_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_export_section', array(
	'title'			=> esc_html__( 'Export', 'inzofin' ),
	'description'	=> esc_html__( 'This is the export setting for current theme option values.', 'inzofin' ),
	'priority'		=> 2,
	'panel'			=> 'theme_import_export_panel'
));
$wp_customize->add_section( $inzofin_export_section );

//Export
$wp_customize->add_setting('ajax_trigger_inzofin_export_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_export_section', array(
	'section'		=> 'inzofin_export_section'
)));