<?php

//Theme Option -> General
$theme_general_panel = new Inzofin_WP_Customize_Panel( $wp_customize, 'theme_general_panel', array(
	'title'			=> esc_html__( 'General', 'inzofin' ),
	'description'	=> esc_html__( 'These are the general settings of Inzofin theme', 'inzofin' ),
	'priority'		=> 1,
	'panel'			=> 'inzofin_theme_panel'
));
$wp_customize->add_panel( $theme_general_panel );

//General -> Layout
$inzofin_layout_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_layout_section', array(
	'title'			=> esc_html__( 'Layout', 'inzofin' ),
	'description'	=> esc_html__( 'This is the setting for theme layouts', 'inzofin' ),
	'priority'		=> 1,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $inzofin_layout_section );

//Layout
$wp_customize->add_setting('ajax_trigger_inzofin_layout_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_layout_section', array(
	'section'		=> 'inzofin_layout_section'
)));

//General -> Loaders
$inzofin_loader_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_loader_section', array(
	'title'			=> esc_html__('Loaders', 'inzofin'),
	'description'	=> esc_html__( 'This is the setting for theme loader images.', 'inzofin' ),
	'priority'		=> 2,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $inzofin_loader_section );

//Loaders
$wp_customize->add_setting('ajax_trigger_inzofin_loader_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_loader_section', array(
	'section'		=> 'inzofin_loader_section'
)));

//General -> Theme Logo
$inzofin_logo_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_logo_section', array(
	'title'			=> esc_html__('Site Logo\'s', 'inzofin'),
	'description'	=> esc_html__( 'This is the setting for all the site logo\'s.', 'inzofin' ),
	'priority'		=> 3,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $inzofin_logo_section );

//Theme Logo
$wp_customize->add_setting('ajax_trigger_inzofin_logo_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_logo_section', array(
	'section'		=> 'inzofin_logo_section'
)));

//General -> API's
$inzofin_api_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_api_section', array(
	'title'			=> esc_html__('API', 'inzofin'),
	'description'	=> esc_html__( 'This is the setting for all the api\'s where used in this site.', 'inzofin' ),
	'priority'		=> 4,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $inzofin_api_section );

//API's
$wp_customize->add_setting('ajax_trigger_inzofin_api_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_api_section', array(
	'section'		=> 'inzofin_api_section'
)));

//General -> Comments
$inzofin_comments_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_comments_section', array(
	'title'			=> esc_html__('Comments', 'inzofin'),
	'description'	=> esc_html__( 'This is the setting for comments.', 'inzofin' ),
	'priority'		=> 5,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $inzofin_comments_section );

//Comments
$wp_customize->add_setting('ajax_trigger_inzofin_comments_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_comments_section', array(
	'section'		=> 'inzofin_comments_section'
)));

//General -> Smooth Scroll
$inzofin_smooth_scroll_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_smooth_scroll_section', array(
	'title'			=> esc_html__('Smooth Scroll', 'inzofin'),
	'description'	=> esc_html__( 'This is the setting for page smooth scroll.', 'inzofin' ),
	'priority'		=> 6,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $inzofin_smooth_scroll_section );

//Smooth Scroll
$wp_customize->add_setting('ajax_trigger_inzofin_smooth_scroll_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_smooth_scroll_section', array(
	'section'		=> 'inzofin_smooth_scroll_section'
)));

//General -> Media Settings
$inzofin_media_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_media_section', array(
	'title'			=> esc_html__('Media Settings', 'inzofin'),
	'description'	=> esc_html__( 'This is the setting for media sizes', 'inzofin' ),
	'priority'		=> 7,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $inzofin_media_section );

//Media Settings
$wp_customize->add_setting('ajax_trigger_inzofin_media_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_media_section', array(
	'section'		=> 'inzofin_media_section'
)));

//General -> RTL
$inzofin_rtl_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_rtl_section', array(
	'title'			=> esc_html__('RTL', 'inzofin'),
	'description'	=> esc_html__( 'This is the setting for theme view RTL', 'inzofin' ),
	'priority'		=> 8,
	'panel'			=> 'theme_general_panel'
));
$wp_customize->add_section( $inzofin_rtl_section );

//RTL
$wp_customize->add_setting('ajax_trigger_inzofin_rtl_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_rtl_section', array(
	'section'		=> 'inzofin_rtl_section'
)));