<?php

//Layout Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Layout', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Option
$settings = array(
	'id'			=> 'blog-page-title-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Page Title Option', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable page title.', 'inzofin' ),
	'default'		=> 1,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Items
$settings = array(
	'id'			=> 'template-blog-pagetitle-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Page Title Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed items for page title wrap, drag from disabled and put enabled.', 'inzofin' ),
	'default' 		=> array(
		'disabled' => array(
			'description' => esc_html__( 'Page Title Description', 'inzofin' )
		),
		'Left'  => array(
			'title' => esc_html__( 'Page Title Text', 'inzofin' ),
		),
		'Center' => array(),
		'Right'  => array(
			'breadcrumb'	=> esc_html__( 'Breadcrumb', 'inzofin' )
		)
	),
	'required'		=> array( 'blog-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Blog Settings', 'inzofin' ),
	'description'	=> esc_html__( 'This is settings for blog page layout, sidebar sticky and etc.', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Template
$settings = array(
	'id'			=> 'blog-page-template',
	'type'			=> 'radioimage',
	'title'			=> esc_html__( 'Blog Template', 'inzofin' ),
	'description'	=> esc_html__( 'Choose your current blog page template.', 'inzofin' ),
	'default'		=> 'right-sidebar',
	'items' 		=> array(
		'no-sidebar'	=> INZOFIN_ADMIN_URL . '/customizer/assets/images/page-layouts/1.png',
		'right-sidebar'	=> INZOFIN_ADMIN_URL . '/customizer/assets/images/page-layouts/2.png',
		'left-sidebar'	=> INZOFIN_ADMIN_URL . '/customizer/assets/images/page-layouts/3.png',
		'both-sidebar'	=> INZOFIN_ADMIN_URL . '/customizer/assets/images/page-layouts/4.png'		
	),
	'cols'			=> '4',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Left Sidebar
$settings = array(
	'id'			=> 'blog-left-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Left Sidebar', 'inzofin' ),
	'description'	=> esc_html__( 'Select widget area for showing on left side.', 'inzofin' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 0
);
InzofinCustomizerConfig::buildFields( $settings );

//Right Sidebar
$settings = array(
	'id'			=> 'blog-right-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Right Sidebar', 'inzofin' ),
	'description'	=> esc_html__( 'Select widget area for showing on right side.', 'inzofin' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 0
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Post Template
$settings = array(
	'id'			=> 'blog-post-template',
	'type'			=> 'radioimage',
	'title'			=> esc_html__( 'Blog Post Template', 'inzofin' ),
	'description'	=> esc_html__( 'Choose your current blog post template.', 'inzofin' ),
	'default'		=> 'standard',
	'items' 		=> array(
		'standard'	=> INZOFIN_ADMIN_URL . '/customizer/assets/images/post-layouts/1.png',
		'grid'		=> INZOFIN_ADMIN_URL . '/customizer/assets/images/post-layouts/2.png',
		'list'		=> INZOFIN_ADMIN_URL . '/customizer/assets/images/post-layouts/3.png'		
	),
	'cols'			=> '3',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Top Standard Post
$settings = array(
	'id'			=> 'blog-top-standard-post',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Top Standard Post', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable to show top post layout standard others selected layout.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Grid Columns
$settings = array(
	'id'			=> 'blog-grid-cols',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Grid Columns', 'inzofin' ),
	'description'	=> esc_html__( 'Select grid columns.', 'inzofin' ),
	'choices'		=> array(
		'4'		=> esc_html__( '4 Columns', 'inzofin' ),
		'3'		=> esc_html__( '3 Columns', 'inzofin' ),
		'2'		=> esc_html__( '2 Columns', 'inzofin' ),
	),
	'default'		=> '2',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Post Grid Gutter
$settings = array(
	'id'			=> 'blog-grid-gutter',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Blog Post Grid Gutter', 'inzofin' ),
	'description'	=> esc_html__( 'Enter grid gutter size. Example 20', 'inzofin' ),
	'default'		=> '30',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Grid Type
$settings = array(
	'id'			=> 'blog-grid-type',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Grid Type', 'inzofin' ),
	'description'	=> esc_html__( 'Select grid type normal or isotope.', 'inzofin' ),
	'choices'		=> array(
		'normal'		=> esc_html__( 'Normal Grid', 'inzofin' ),
		'isotope'		=> esc_html__( 'Isotope Grid', 'inzofin' ),
	),
	'default'		=> 'normal',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Infinite Scroll
$settings = array(
	'id'			=> 'blog-infinite-scroll',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Infinite Scroll', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable infinite scroll for blog post.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Post Excerpt Length
$settings = array(
	'id'			=> 'blog-excerpt',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Post Excerpt Length', 'inzofin' ),
	'description'	=> esc_html__( 'Set blog post excerpt length. Example 15', 'inzofin' ),
	'default'		=> '15',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Post Top Meta Items
$settings = array(
	'id'			=> 'blog-topmeta-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Blog Post Top Meta Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed blog post top meta items drag from disabled and put enabled part. ie: Left or Right.', 'inzofin' ),
	'default' 		=> array(
		'Left'  => array(
			'date'		=> esc_html__( 'Date', 'inzofin' )
		),
		'Right'  => array(
			'category'	=> esc_html__( 'Category', 'inzofin' )
		),
		'disabled' => array(
			'social'	=> esc_html__( 'Social Share', 'inzofin' ),
			'comments'	=> esc_html__( 'Comments', 'inzofin' ),
			'likes'		=> esc_html__( 'Likes', 'inzofin' ),
			'author'	=> esc_html__( 'Author', 'inzofin' ),
			'views'		=> esc_html__( 'Views', 'inzofin' ),
			'more'		=> esc_html__( 'Read More', 'inzofin' ),
			'favourite'	=> esc_html__( 'Favourite', 'inzofin' )
		)
	),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Post Bottom Meta Items
$settings = array(
	'id'			=> 'blog-bottommeta-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Blog Post Bottom Meta Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed blog post bottom meta items drag from disabled and put enabled part. ie: Left or Right.', 'inzofin' ),
	'default' 		=> array(
		'Left'  => array(
			'more'		=> esc_html__( 'Read More', 'inzofin' ),
		),
		'Right'  => array(),
		'disabled' => array(
			'comments'	=> esc_html__( 'Comments', 'inzofin' ),
			'category'	=> esc_html__( 'Category', 'inzofin' ),
			'social'	=> esc_html__( 'Social Share', 'inzofin' ),
			'comments'	=> esc_html__( 'Comments', 'inzofin' ),
			'likes'		=> esc_html__( 'Likes', 'inzofin' ),
			'author'	=> esc_html__( 'Author', 'inzofin' ),
			'views'		=> esc_html__( 'Views', 'inzofin' ),
			'date'		=> esc_html__( 'Date', 'inzofin' ),
			'favourite'	=> esc_html__( 'Favourite', 'inzofin' )
		)
	),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Post Items
$settings = array(
	'id'			=> 'blog-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Blog Post Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed blog post items drag from disabled and put enabled part. Thumbnail part covers the post format either image/audio/video/gallery/quote/link.', 'inzofin' ),
	'default' 		=> array(
		'Enabled'  		=> array(
			'title'			=> esc_html__( 'Title', 'inzofin' ),
			'top-meta'		=> esc_html__( 'Top Meta', 'inzofin' ),
			'thumb'			=> esc_html__( 'Thumbnail', 'inzofin' ),
			'content'		=> esc_html__( 'Content', 'inzofin' ),
			'bottom-meta'	=> esc_html__( 'Bottom Meta', 'inzofin' )
		),
		'disabled' => array()
	),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Post Overlay
$settings = array(
	'id'			=> 'blog-overlay-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Blog Post Overlay', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable blog post overlay.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Post Overlay Items
$settings = array(
	'id'			=> 'blog-overlay-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Blog Post Overlay Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed blog post overlay items drag from disabled and put enabled part.', 'inzofin' ),
	'default' 		=> array(
		'Enabled'  	=> array(
			'title'			=> esc_html__( 'Title', 'inzofin' ),
		),
		'disabled' => array(
			'top-meta'		=> esc_html__( 'Top Meta', 'inzofin' ),
			'bottom-meta'	=> esc_html__( 'Bottom Meta', 'inzofin' )
		)
	),
	'required'		=> array( 'blog-overlay-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Layout End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Style Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Style', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Page Title Settings', 'inzofin' ),
	'description'	=> esc_html__( 'This is page title style settings shows only when page title option active.', 'inzofin' ),
	'section_stat'	=> true,
);
InzofinCustomizerConfig::buildFields( $settings );

//Font Color
$settings = array(
	'id'			=> 'template-blog-color',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Font Color', 'inzofin' ),
	'description'	=> esc_html__( 'This is font color for current field.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'blog-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Template Link Color
$settings = array(
	'id'			=> 'template-blog-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Blog Template Link Color', 'inzofin' ),
	'description'	=> esc_html__( 'Choose Blog template color.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'blog-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Template Border
$settings = array(
	'id'			=> 'template-blog-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Blog Template Border', 'inzofin' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'blog-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Template Padding Option
$settings = array(
	'id'			=> 'template-blog-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Blog Template Padding Option', 'inzofin' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'blog-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Template Background
$settings = array(
	'id'			=> 'template-blog-background-all',
	'type'			=> 'background',
	'title'			=> esc_html__( 'Blog Template Background', 'inzofin' ),
	'description'	=> esc_html__( 'This is settings for footer background.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'blog-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Background Parallax
$settings = array(
	'id'			=> 'blog-page-title-parallax',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Background Parallax', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable page title background parallax.', 'inzofin' ),
	'default'		=> 0,
	'required'		=> array( 'blog-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Background Video
$settings = array(
	'id'			=> 'blog-page-title-bg',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Background Video', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable page title background video.', 'inzofin' ),
	'default'		=> 0,
	'required'		=> array( 'blog-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Background Video
$settings = array(
	'id'			=> 'blog-page-title-video',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Page Title Background Video', 'inzofin' ),
	'description'	=> esc_html__( 'Set page title background video for page. Only allowed youtube video id. Example: UWF7dZTLW4c', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'blog-page-title-bg', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Overlay
$settings = array(
	'id'			=> 'blog-page-title-overlay',
	'type'			=> 'alpha',
	'title'			=> esc_html__( 'Page Title Overlay', 'inzofin' ),
	'description'	=> esc_html__( 'Choose page title overlay rgba color.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'blog-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false,
	'required'		=> array( 'blog-page-title-opt', '=', 1 )
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Article Skin Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Blog Article Skin Settings', 'inzofin' ),
	'description'	=> esc_html__( 'This is skin settings for each blog article.', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Font Color
$settings = array(
	'id'			=> 'blog-article-color',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Font Color', 'inzofin' ),
	'description'	=> esc_html__( 'This is font color for blog article.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Link Color
$settings = array(
	'id'			=> 'blog-article-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Article Link Color', 'inzofin' ),
	'description'	=> esc_html__( 'Choose Article Link color for blog article.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Border
$settings = array(
	'id'			=> 'blog-article-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Article Border', 'inzofin' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Padding Option
$settings = array(
	'id'			=> 'blog-article-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Article Padding Option', 'inzofin' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Background Color
$settings = array(
	'id'			=> 'blog-article-background',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Background Color', 'inzofin' ),
	'description'	=> esc_html__( 'This is background color for blog article.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Article Skin Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Style End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Custom Text Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Custom Text', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Post Read More Text
$settings = array(
	'id'			=> 'blog-more-text',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Post Read More Text', 'inzofin' ),
	'description'	=> esc_html__( 'Set blog post read more text. Example Read More', 'inzofin' ),
	'default'		=> esc_html__( 'Read More', 'inzofin' ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Page Title
$settings = array(
	'id'			=> 'blog-page-title',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Blog Page Title', 'inzofin' ),
	'description'	=> esc_html__( 'This is a title for blog page. HTML code allowed here.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1,
	//'instant'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Page Description
$settings = array(
	'id'			=> 'blog-page-desc',
	'type'			=> 'textarea',
	'title'			=> esc_html__( 'Blog Page Description', 'inzofin' ),
	'description'	=> esc_html__( 'This is description for blog page. HTML code allowed here.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 0,
	'instant'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Custom Text End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Advanced Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Advanced', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Post Format Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Post Format Settings', 'inzofin' ),
	'description'	=> esc_html__( 'This is post format settings for blog.', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Video Format
$settings = array(
	'id'			=> 'blog-video-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Video Format', 'inzofin' ),
	'description'	=> esc_html__( 'Choose blog page video post format settings.', 'inzofin' ),
	'choices'		=> array(
		'onclick' 	=> esc_html__( 'On Click Run Video', 'inzofin' ),
		'overlay' 	=> esc_html__( 'Modal Box Video', 'inzofin' ),
		'direct' 	=> esc_html__( 'Direct Video', 'inzofin' )
	),
	'default'		=> 'onclick',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Quote Format
$settings = array(
	'id'			=> 'blog-quote-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Quote Format', 'inzofin' ),
	'description'	=> esc_html__( 'Choose blog page quote post format settings.', 'inzofin' ),
	'choices'		=> array(
		'featured' 		=> esc_html__( 'Dark Overlay', 'inzofin' ),
		'theme-overlay' => esc_html__( 'Theme Overlay', 'inzofin' ),
		'theme' 		=> esc_html__( 'Theme Color Background', 'inzofin' ),
		'none' 			=> esc_html__( 'None', 'inzofin' )
	),
	'default'		=> 'featured',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Link Format
$settings = array(
	'id'			=> 'blog-link-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Link Format', 'inzofin' ),
	'description'	=> esc_html__( 'Choose blog page link post format settings.', 'inzofin' ),
	'choices'		=> array(
		'featured' 		=> esc_html__( 'Dark Overlay', 'inzofin' ),
		'theme-overlay' => esc_html__( 'Theme Overlay', 'inzofin' ),
		'theme' 		=> esc_html__( 'Theme Color Background', 'inzofin' ),
		'none' 			=> esc_html__( 'None', 'inzofin' )
	),
	'default'		=> 'featured',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Gallery Format
$settings = array(
	'id'			=> 'blog-gallery-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Gallery Format', 'inzofin' ),
	'description'	=> esc_html__( 'Choose blog page gallery post format settings.', 'inzofin' ),
	'choices'		=> array(
		'default'	=> esc_html__( 'Default Gallery', 'inzofin' ),
		'popup' 	=> esc_html__( 'Popup Gallery', 'inzofin' ),
		'grid' 		=> esc_html__( 'Grid Popup Gallery', 'inzofin' )
	),
	'default'		=> 'default',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Post Format Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Blog Featured Slider
$settings = array(
	'id'			=> 'blog-featured-slider',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Blog Featured Slider', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable blog featured slider.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Sidebar Sticky
$settings = array(
	'id'			=> 'blog-sidebar-sticky',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Sidebar Sticky', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable sidebar sticky.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Sidebar on Mobile
$settings = array(
	'id'			=> 'blog-page-hide-sidebar',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Sidebar on Mobile', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable to show or hide sidebar on mobile.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Advanced End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );