<?php

//Theme Option -> Custom Post Type
$cpt_config_panel = new Inzofin_WP_Customize_Panel( $wp_customize, 'cpt_config_panel', array(
	'title'			=> esc_html__( 'Custom Post Types', 'inzofin' ),
	'description'	=> esc_html__( 'Custom Post Type Settings Area.', 'inzofin' ),
	'priority'		=> 10,
	'panel'			=> 'inzofin_theme_panel'
));
$wp_customize->add_panel( $cpt_config_panel );

//Custom Post Type -> General Settings
$inzofin_cpt_general_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_cpt_general_section', array(
	'title'			=> esc_html__( 'General Settings', 'inzofin' ),
	'description'	=> esc_html__( 'This is custom post type settings area.', 'inzofin' ),
	'priority'		=> 1,
	'panel'			=> 'cpt_config_panel'
));
$wp_customize->add_section( $inzofin_cpt_general_section );

//General Settings
$wp_customize->add_setting('ajax_trigger_inzofin_cpt_general_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_cpt_general_section', array(
	'section'		=> 'inzofin_cpt_general_section'
)));

//Custom Post Types
$inzofin_options = get_option( 'inzofin_theme_options_new' );
$selected_cpt = isset( $inzofin_options['cpt-opts'] ) && !empty( $inzofin_options['cpt-opts'] ) ? $inzofin_options['cpt-opts'] : '';

//Custom Post Type -> Team
if( !empty( $selected_cpt ) && is_array( $selected_cpt ) && in_array( 'team', $selected_cpt ) ){
	
	$inzofin_cpt_team_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_cpt_team_section', array(
		'title'			=> esc_html__( 'Team', 'inzofin' ),
		'description'	=> esc_html__( 'This is custom post type team setting.', 'inzofin' ),
		'priority'		=> 2,
		'panel'			=> 'cpt_config_panel'
	));
	$wp_customize->add_section( $inzofin_cpt_team_section );

	//Team
	$wp_customize->add_setting('ajax_trigger_inzofin_cpt_team_section', array(
		'default'           => '',
		'sanitize_callback' 	=> 'esc_attr'
	));
	$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_cpt_team_section', array(
		'section'		=> 'inzofin_cpt_team_section'
	)));

}// team CPT check end

//Custom Post Type -> Testimonial
if( !empty( $selected_cpt ) && is_array( $selected_cpt ) && in_array( 'testimonial', $selected_cpt ) ){
	$inzofin_cpt_testimonial_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_cpt_testimonial_section', array(
		'title'			=> esc_html__( 'Testimonial', 'inzofin' ),
		'description'	=> esc_html__( 'This is custom post type testimonial setting.', 'inzofin' ),
		'priority'		=> 3,
		'panel'			=> 'cpt_config_panel'
	));
	$wp_customize->add_section( $inzofin_cpt_testimonial_section );
	
	//Testimonial
	$wp_customize->add_setting('ajax_trigger_inzofin_cpt_testimonial_section', array(
		'default'           => '',
		'sanitize_callback' 	=> 'esc_attr'
	));
	$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_cpt_testimonial_section', array(
		'section'		=> 'inzofin_cpt_testimonial_section'
	)));
	
}// testimonial CPT check end

//Custom Post Type -> Events
if( !empty( $selected_cpt ) && is_array( $selected_cpt ) && in_array( 'events', $selected_cpt ) ){
	$inzofin_cpt_events_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_cpt_events_section', array(
		'title'			=> esc_html__( 'Events', 'inzofin' ),
		'description'	=> esc_html__( 'This is custom post type events setting.', 'inzofin' ),
		'priority'		=> 4,
		'panel'			=> 'cpt_config_panel'
	));
	$wp_customize->add_section( $inzofin_cpt_events_section );

	//Events
	$wp_customize->add_setting('ajax_trigger_inzofin_cpt_events_section', array(
		'default'           => '',
		'sanitize_callback' 	=> 'esc_attr'
	));
	$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_cpt_events_section', array(
		'section'		=> 'inzofin_cpt_events_section'
	)));
	
}// events CPT check end

//Custom Post Type -> Services
if( !empty( $selected_cpt ) && is_array( $selected_cpt ) && in_array( 'services', $selected_cpt ) ){
	$inzofin_cpt_services_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_cpt_services_section', array(
		'title'			=> esc_html__( 'Services', 'inzofin' ),
		'description'	=> esc_html__( 'This is custom post type Services setting.', 'inzofin' ),
		'priority'		=> 5,
		'panel'			=> 'cpt_config_panel'
	));
	$wp_customize->add_section( $inzofin_cpt_services_section );
	
	//Services
	$wp_customize->add_setting('ajax_trigger_inzofin_cpt_services_section', array(
		'default'           => '',
		'sanitize_callback' 	=> 'esc_attr'
	));
	$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_cpt_services_section', array(
		'section'		=> 'inzofin_cpt_services_section'
	)));
	
}// services CPT check end

//Custom Post Type -> Portfolio
if( !empty( $selected_cpt ) && is_array( $selected_cpt ) && in_array( 'portfolio', $selected_cpt ) ){
	$inzofin_cpt_portfolio_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_cpt_portfolio_section', array(
		'title'			=> esc_html__( 'Portfolio', 'inzofin' ),
		'description'	=> esc_html__( 'This is custom post type portfolio setting.', 'inzofin' ),
		'priority'		=> 6,
		'panel'			=> 'cpt_config_panel'
	));
	$wp_customize->add_section( $inzofin_cpt_portfolio_section );
	
	//Portfolio
	$wp_customize->add_setting('ajax_trigger_inzofin_cpt_portfolio_section', array(
		'default'           => '',
		'sanitize_callback' 	=> 'esc_attr'
	));
	$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_cpt_portfolio_section', array(
		'section'		=> 'inzofin_cpt_portfolio_section'
	)));
	
}// portfolio CPT check end