<?php
/**
 * Widget Popular Post
 *
 * @package feminine-munk
 */

// register feminine_munk_Popular_Post widget
function feminine_munk_register_popular_post_widget(){
    register_widget( 'feminine_munk_Popular_Post' );
}

add_action( 'widgets_init', 'feminine_munk_register_popular_post_widget' );

/**
 * Adds feminine_munk_Popular_Post widget.
 */
class feminine_munk_Popular_Post extends WP_Widget
{

    /**
     * Register widget with WordPress.
     */
    function __construct(){
        parent::__construct(
            'popular_posts', // Base ID
            __( 'Popular Post', 'feminine-munk' ), // Name
            array( 'description' => __( 'A Popular Post Widget', 'feminine-munk' ), ) // Args
        );
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ){

        $title      = !empty( $instance[ 'title' ] ) ? strip_tags( $instance[ 'title' ] ) : __( 'Popular Posts', 'feminine-munk' );
        $num_post   = !empty( $instance[ 'num_post' ] ) ? absint( $instance[ 'num_post' ] ) : 3;
        $show_thumb = !empty( $instance[ 'show_thumbnail' ] ) ? esc_attr( $instance[ 'show_thumbnail' ] ) : '';
        $show_date  = !empty( $instance[ 'show_postdate' ] ) ? esc_attr( $instance[ 'show_postdate' ] ) : '';

        $qry = new WP_Query( array(
            'post_type'           => 'post',
            'post_status'         => 'publish',
            'posts_per_page'      => $num_post,
            'ignore_sticky_posts' => true,
            'orderby'             => 'comment_count'
        ) );

        if ( $qry->have_posts() ) {
            echo $args[ 'before_widget' ];
            echo $args[ 'before_title' ] . apply_filters( 'widget_title', $title, $instance, $this->id_base ) . $args[ 'after_title' ];
            ?>
            <ul>
                <?php
                while ( $qry->have_posts() ) {
                    $qry->the_post();
                    ?>
                    <li>
                        <article class="post">
                            <?php if ( $show_thumb && has_post_thumbnail() ) { ?>
                                <a href=" <?php the_permalink(); ?>"
                                   class="post-thumbnail"> <?php the_post_thumbnail( 'feminine-munk-popular-post' ); ?></a>
                            <?php } ?>
                            <header class="entry-header">
                                <h4 class="entry-title"><a href="<?php the_permalink(); ?> "><?php the_title(); ?></a>
                                </h4>
                                <div class="entry-meta">
                                    <span class="posted-on"><a href="javascript:void(0);"> <?php the_time( 'F j, Y' ); ?> </a></span>
                                </div>
                            </header>
                        </article>
                    </li>
                    <?php
                }
                ?>
            </ul>
            <?php
            echo $args[ 'after_widget' ];
        }
        wp_reset_postdata();
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form( $instance ){
        $title          = !empty( $instance[ 'title' ] ) ? strip_tags( $instance[ 'title' ] ) : __('Popular Posts', 'feminine-munk');
        $num_post       = !empty( $instance[ 'num_post' ] ) ? absint( $instance[ 'num_post' ] ) : 3;
        $show_thumbnail = !empty( $instance[ 'show_thumbnail' ] ) ? esc_attr( $instance[ 'show_thumbnail' ] ) : '';
        $show_postdate  = !empty( $instance[ 'show_postdate' ] ) ? esc_attr( $instance[ 'show_postdate' ] ) : '';
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title', 'feminine-munk' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>"/>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'num_post' ) ); ?>"><?php _e( 'Number of Posts', 'feminine-munk' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'num_post' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'num_post' ) ); ?>" type="number" step="1" min="1" value="<?php echo esc_attr( $num_post ); ?>"/>
        </p>
        <p>
            <input id="<?php echo esc_attr( $this->get_field_id( 'show_thumbnail' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_thumbnail' ) ); ?>" type="checkbox" value="1" <?php checked( '1', $show_thumbnail ); ?>/>
            <label for="<?php echo esc_attr( $this->get_field_id( 'show_thumbnail' ) ); ?>"><?php esc_html_e( 'Show Post Thumbnail', 'feminine-munk' ); ?></label>
        </p>
        <?php
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update($new_instance, $old_instance){

        $instance = array();

        $instance[ 'title' ]          = !empty( $new_instance[ 'title' ] ) ? strip_tags( $new_instance[ 'title' ] ) : __( 'Popular Posts', 'feminine-munk' );
        $instance[ 'num_post' ]       = !empty( $new_instance[ 'num_post' ] ) ? absint( $new_instance[ 'num_post' ] ) : 3;
        $instance[ 'show_thumbnail' ] = !empty( $new_instance[ 'show_thumbnail' ] ) ? esc_attr( $new_instance[ 'show_thumbnail' ] ) : '';
        $instance[ 'show_postdate' ]  = !empty( $new_instance[ 'show_postdate' ] ) ? esc_attr( $new_instance[ 'show_postdate' ] ) : '';

        return $instance;
    }
} // class feminine_munk_Popular_Post 