<?php
/**
 * Loads the WordPress environment and template.
 * @package WordPress
 */

/**
 * This file is not added by default to WordPress theme pages when outputting
 * feed links. 
 * @package WordPress
 */

/**
 * Theme functions and definitions
 *
 * @package HelloElementor
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_VERSION', '2.3.1' );

if ( ! isset( $content_width ) ) {
	$content_width = 800; // Pixels.
}

if ( ! function_exists( 'hello_elementor_setup' ) ) {
	/**
	 * Set up theme support.
	 *
	 * @return void
	 */
	function hello_elementor_setup() {
		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_load_textdomain', [ true ], '2.0', 'hello_elementor_load_textdomain' );
		if ( apply_filters( 'hello_elementor_load_textdomain', $hook_result ) ) {
			load_theme_textdomain( 'hello-elementor', get_template_directory() . '/languages' );
		}

		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_register_menus', [ true ], '2.0', 'hello_elementor_register_menus' );
		if ( apply_filters( 'hello_elementor_register_menus', $hook_result ) ) {
			register_nav_menus( array( 'menu-1' => __( 'Primary', 'hello-elementor' ) ) );
		}

		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_add_theme_support', [ true ], '2.0', 'hello_elementor_add_theme_support' );
		if ( apply_filters( 'hello_elementor_add_theme_support', $hook_result ) ) {
			add_theme_support( 'post-thumbnails' );
			add_theme_support( 'automatic-feed-links' );
			add_theme_support( 'title-tag' );
			add_theme_support(
				'html5',
				array(
					'search-form',
					'comment-form',
					'comment-list',
					'gallery',
					'caption',
				)
			);
			add_theme_support(
				'custom-logo',
				array(
					'height'      => 100,
					'width'       => 350,
					'flex-height' => true,
					'flex-width'  => true,
				)
			);

			/*
			 * Editor Style.
			 */
			add_editor_style( 'editor-style.css' );
			
			/*
			 * Gutenberg wide images.
			 */
			add_theme_support( 'align-wide' );

			/*
			 * WooCommerce.
			 */
			$hook_result = apply_filters_deprecated( 'elementor_hello_theme_add_woocommerce_support', [ true ], '2.0', 'hello_elementor_add_woocommerce_support' );
			if ( apply_filters( 'hello_elementor_add_woocommerce_support', $hook_result ) ) {
				// WooCommerce in general.
				add_theme_support( 'woocommerce' );
				// Enabling WooCommerce product gallery features (are off by default since WC 3.0.0).
				// zoom.
				add_theme_support( 'wc-product-gallery-zoom' );
				// lightbox.
				add_theme_support( 'wc-product-gallery-lightbox' );
				// swipe.
				add_theme_support( 'wc-product-gallery-slider' );
			}
		}
	}
}
add_action( 'after_setup_theme', 'hello_elementor_setup' );

if ( ! function_exists( 'hello_elementor_scripts_styles' ) ) {
	/**
	 * Theme Scripts & Styles.
	 *
	 * @return void
	 */
	function hello_elementor_scripts_styles() {
		$enqueue_basic_style = apply_filters_deprecated( 'elementor_hello_theme_enqueue_style', [ true ], '2.0', 'hello_elementor_enqueue_style' );
		$min_suffix          = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		if ( apply_filters( 'hello_elementor_enqueue_style', $enqueue_basic_style ) ) {
			wp_enqueue_style(
				'hello-elementor',
				get_template_directory_uri() . '/style' . $min_suffix . '.css',
				[],
				HELLO_ELEMENTOR_VERSION
			);
		}

		if ( apply_filters( 'hello_elementor_enqueue_theme_style', true ) ) {
			wp_enqueue_style(
				'hello-elementor-theme-style',
				get_template_directory_uri() . '/theme' . $min_suffix . '.css',
				[],
				HELLO_ELEMENTOR_VERSION
			);
		}
	}
}
add_action( 'wp_enqueue_scripts', 'hello_elementor_scripts_styles' );

if ( ! function_exists( 'hello_elementor_register_elementor_locations' ) ) {
	/**
	 * Register Elementor Locations.
	 *
	 * @param ElementorPro\Modules\ThemeBuilder\Classes\Locations_Manager $elementor_theme_manager theme manager.
	 *
	 * @return void
	 */
	function hello_elementor_register_elementor_locations( $elementor_theme_manager ) {
		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_register_elementor_locations', [ true ], '2.0', 'hello_elementor_register_elementor_locations' );
		if ( apply_filters( 'hello_elementor_register_elementor_locations', $hook_result ) ) {
			$elementor_theme_manager->register_all_core_location();
		}
	}
}
add_action( 'elementor/theme/register_locations', 'hello_elementor_register_elementor_locations' );

if ( ! function_exists( 'hello_elementor_content_width' ) ) {
	/**
	 * Set default content width.
	 *
	 * @return void
	 */
	function hello_elementor_content_width() {
		$GLOBALS['content_width'] = apply_filters( 'hello_elementor_content_width', 800 );
	}
}
add_action( 'after_setup_theme', 'hello_elementor_content_width', 0 );

if ( is_admin() ) {
	require get_template_directory() . '/includes/admin-functions.php';
}

if ( ! function_exists( 'hello_elementor_check_hide_title' ) ) {
	/**
	 * Check hide title.
	 *
	 * @param bool $val default value.
	 *
	 * @return bool
	 */
	function hello_elementor_check_hide_title( $val ) {
		if ( defined( 'ELEMENTOR_VERSION' ) ) {
			$current_doc = \Elementor\Plugin::instance()->documents->get( get_the_ID() );
			if ( $current_doc && 'yes' === $current_doc->get_settings( 'hide_title' ) ) {
				$val = false;
			}
		}
		return $val;
	}
}
add_filter( 'hello_elementor_page_title', 'hello_elementor_check_hide_title' );

/**
 * Wrapper function to deal with backwards compatibility.
 */
if ( ! function_exists( 'hello_elementor_body_open' ) ) {
	function hello_elementor_body_open() {
		if ( function_exists( 'wp_body_open' ) ) {
			wp_body_open();
		} else {
			do_action( 'wp_body_open' );
		}
	}
}

add_action('wp_footer', 'customScript');

function customScript()
{?>
<style>
/* The Modal (background) */
.modal {
  display: none; /* Hidden by default */
  position: fixed; /* Stay in place */
  z-index: 9; /* Sit on top */
  padding-top: 3%; /* Location of the box */
  left: 0;
  top: 0;
  width: 100%; /* Full width */
  height: 100%; /* Full height */
  overflow: auto; /* Enable scroll if needed */
  background-color: rgb(0,0,0); /* Fallback color */
  background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
}

/* Modal Content */
.modal-content {
  background-color: #fefefe;
  margin: auto;
  padding: 20px;
  border: 1px solid #888;
  width: 80%;
}

/* The Close Button */
.close {
  color: #aaaaaa;
  float: right;
  font-size: 28px;
  font-weight: bold;
}

.close:hover,
.close:focus {
  color: #000;
  text-decoration: none;
  cursor: pointer;
}
#map {
  height: 350px;
}
.form-container{margin:10px 0;}
.text-center{text-align:center;}
</style>
    <script>
// Get the modal
var modal = document.getElementById("myModal");

// Get the button that opens the modal
var btn = document.getElementById("myBtn");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks the button, open the modal 


btn.onclick = function() {

	var valid = true;
	var name     = 	document.getElementById("name").value;
    var phone    = 	document.getElementById("phone").value;
    var date     = 	document.getElementById("date").value;
    var time     = 	document.getElementById("time").value;
	  //var address = 	document.getElementById("pac-input").value;

    if (name == "" || phone == "" || date == "" || time == "") {
		    alert("All fields are required");
        valid = false;
    }

      if(valid) {
          //document.getElementById("address-map").value = address;
          modal.style.display = "block";
      } 
}


// When the user clicks on <span> (x), close the modal
span.onclick = function() {
  modal.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}
</script>

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDMtbHe_a6OIAUsKLRY33PYBEiZmIiETC0&callback=initMap&libraries=places&v=weekly" async ></script>

  <script>
    
    let map, infowindow, geocoder,marker;

    function initMap() {
      geocoder = new google.maps.Geocoder();
      map = new google.maps.Map(document.getElementById("map"), {
        center: { lat: -34.397, lng: 150.644 },
        zoom: 6,
      });
      infowindow = new google.maps.InfoWindow();
      var marker = new google.maps.Marker({
            map: map,
            anchorPoint: new google.maps.Point(0, -29)
        });
        
      const options = {
          componentRestrictions: { country: "AE" },
          postal_code:51133,
          //fields: ["formatted_address", "geometry", "name"],
          origin: map.getCenter(),
          strictBounds: true,
          types: ["establishment"],
      };  
      // autocomplete
      var input = document.getElementById("address");
      const autocomplete = new google.maps.places.Autocomplete(input,options)


        google.maps.event.addListener(autocomplete, 'place_changed', function(){
          var place = autocomplete.getPlace();
          
          var Locationverification = getLocationData(place.address_components);
        
          if(!Locationverification)
          {
            codeAddress("Abu Dhabi United Arab Emirates");
          } else {
            codeAddress(place.formatted_address);
          }
      });

        // Try HTML5 geolocation.
        if (navigator.geolocation) {
          navigator.geolocation.getCurrentPosition(
            (position) => {
              const pos = {
                lat: position.coords.latitude,
                lng: position.coords.longitude,
              };
              infowindow.setPosition(pos);
              
              geocoder.geocode({
                latLng: pos
              }, function(responses) {
                if (responses && responses.length > 0) {
                  marker.formatted_address = responses[0].formatted_address;
                } else {
                  marker.formatted_address = 'Location not valid';
                }

                var Locationverification = getLocationData(responses[0].address_components);
                if(!Locationverification)
                {
                  codeAddress("Abu Dhabi United Arab Emirates");
                }
              });
            }
          );
        } 
    }

  function geocodePosition(pos) {

      geocoder.geocode({

        latLng: pos

      }, function(responses) {

        if (responses && responses.length > 0) {
          
          var Locationverification = getLocationData(responses[0].address_components);
          
          if(!Locationverification)
          {
            codeAddress("Abu Dhabi United Arab Emirates");
          } 
          marker.formatted_address = responses[0].formatted_address;

        } else {

         // marker.formatted_address = 'Cannot determine address at this location.';
          codeAddress("Abu Dhabi United Arab Emirates");
        }

        infowindow.setContent(marker.formatted_address+"<br>coordinates: "+marker.getPosition().toUrlValue(6));

        infowindow.open(map, marker);

        document.getElementById("address").value = marker.formatted_address;

      });
  }

  function codeAddress(location) {

    var address = location;

    geocoder.geocode( { 'address': address}, function(results, status) {

      if (status == google.maps.GeocoderStatus.OK) {

        map.setCenter(results[0].geometry.location);

    if (marker) {

          marker.setMap(null);

          if (infowindow) infowindow.close();

        }

        marker = new google.maps.Marker({

          map: map,
          draggable: true,
          position: results[0].geometry.location

        });

        google.maps.event.addListener(marker, 'dragend', function() {

          // updateMarkerStatus('Drag ended');

          geocodePosition(marker.getPosition());

        });

        google.maps.event.addListener(marker, 'click', function() {

          if (marker.formatted_address) {

            infowindow.setContent(marker.formatted_address+"<br>testing123 coordinates: "+marker.getPosition().toUrlValue(6));

            document.getElementById("address").value = marker.formatted_address;

          } else  {

            infowindow.setContent(address);

            document.getElementById("address").value = address;

            

          }

          infowindow.open(map, marker);

        });

        google.maps.event.trigger(marker, 'click');

      } else {

        alert('Geocode was not successful for the following reason: ' + status);

      }

    });

    }

    

    function getLocationData(address_components){
      var value = false;
     // let parts = responses[0].address_components;
     let parts = address_components;
        
          parts.forEach(part => {
                
            if (part.types.includes("administrative_area_level_1")) {
              var placeName = part.long_name;
              if(placeName == "Abu Dhabi"){
                value = true;
              }
            }
          });
      return value;
    }
  </script>
<?php }

// redirect after booking
add_action( 'wp_footer', 'redirect_cf7' );
 
function redirect_cf7() {
?>
<script type="text/javascript">
document.addEventListener( 'wpcf7mailsent', function( event ) {
    console.log(event);
   if ( "3841" == event.detail.contactFormId || "3963" == event.detail.contactFormId) { 
      var thankYouPage = "<?php echo get_permalink( 3906 ); ?>";
      window.location = thankYouPage;
    } 
}, false );
</script>
<?php
}