<?php // Admin Page
if( ! class_exists( 'Inzofin_Zozo_Admin_Page' ) ){
	class Inzofin_Zozo_Admin_Page {
	
		function __construct(){
			add_action( 'admin_init', array( $this, 'inzofin_admin_page_init' ) );	
			add_action( 'admin_menu', array( $this, 'inzofin_zozo_admin_menu') );			
			add_action( 'admin_menu', array( $this, 'inzofin_zozo_edit_admin_menus' ) ); 
			add_action( 'admin_head', array( $this, 'inzofin_zozo_admin_page_scripts' ) );
			add_action( 'after_switch_theme', array( $this, 'inzofin_zozo_theme_activation_redirect' ) ); 
			
			//Theme purchase code verification and activation
			add_action( 'wp_ajax_inzofin_theme_verify', array( 'Inzofin_Zozo_Admin_Page', 'inzofin_theme_verification' ) );
			add_action( 'wp_ajax_nopriv_inzofin_theme_verify', array( 'Inzofin_Zozo_Admin_Page', 'inzofin_theme_verification' )  );
			
			//Theme purchase code deactivation
			add_action( 'wp_ajax_inzofin_theme_deactivate', array( 'Inzofin_Zozo_Admin_Page', 'inzofin_theme_deactivate' ) );
			add_action( 'wp_ajax_nopriv_inzofin_theme_deactivate', array( 'Inzofin_Zozo_Admin_Page', 'inzofin_theme_deactivate' )  );
		}
		
		public static function inzofin_theme_verification(){
		
			$nonce = $_POST['zozo_verify_nonce'];		  
			if ( ! wp_verify_nonce( $nonce, 'inzofin_theme_verify^%&^%' ) )
				wp_die ( esc_html__( 'Busted', 'inzofin' ) );
					
			if( isset( $_POST['zozo_registration_email'] ) && isset( $_POST['zozo_purchase_code'] ) ){
				require_once( INZOFIN_ADMIN . '/class.token-verification.php' );
				$verfy_obj = new Zozo_Purchase_Code_Verification;
				$status = $verfy_obj->verify_token();
				wp_send_json($status);
			}
			
			wp_die('finshed');
		}
		
		public static function inzofin_theme_deactivate(){
		
			$nonce = $_POST['zozo_deactivate_nonce'];		  
			if ( ! wp_verify_nonce( $nonce, 'inzofin_theme_deactivate^%&^%' ) )
				wp_die ( esc_html__( 'Busted', 'inzofin' ) );
					
			require_once( INZOFIN_ADMIN . '/class.token-verification.php' );
			$verfy_obj = new Zozo_Purchase_Code_Verification;
			$status = $verfy_obj->deactivate_api_call();
			wp_send_json($status);
			
			wp_die('finshed');
		}
		
		function inzofin_admin_page_init(){
			if ( current_user_can( 'edit_theme_options' ) ) {
				
				if( !isset( $_GET['inzofin_tgmpa_nounce'] ) && !isset( $_GET['inzofin_plugin_actv'] ) ){
					if( isset( $_GET['zozo-deactivate'] ) && $_GET['zozo-deactivate'] == 'deactivate-plugin' ) {
						check_admin_referer( 'zozo-deactivate', 'zozo-deactivate-nonce' );
						$plugins = TGM_Plugin_Activation::$instance->plugins;
						foreach( $plugins as $plugin ) {
							if( $plugin['slug'] == $_GET['plugin'] ) {
								deactivate_plugins( $plugin['file_path'] );
							}
						}
					} 
					
					if( isset( $_GET['zozo-activate'] ) && $_GET['zozo-activate'] == 'activate-plugin' ) {
						check_admin_referer( 'zozo-activate', 'zozo-activate-nonce' );
						$plugins = TGM_Plugin_Activation::$instance->plugins;
						foreach( $plugins as $plugin ) {
							if( $plugin['slug'] == $_GET['plugin'] ) {
								activate_plugin( $plugin['file_path'] );
							}
						}
					}
				}elseif( isset( $_GET['inzofin_plugin_actv'] ) ){
					$plugin_slugs = $_GET['inzofin_plugin_actv'];
					$plugin_slugs = explode( ",", $plugin_slugs );
					$plugins = TGM_Plugin_Activation::$instance->plugins;
					$active_plugins = get_option('active_plugins');
					foreach( $plugins as $plugin ) {
						if( in_array( $plugin['slug'], $plugin_slugs ) && !in_array( $plugin['file_path'], $active_plugins ) ) {
							activate_plugin( $plugin['file_path'] );
						}
					}
				}
			}
		}
		
		function inzofin_zozo_theme_activation_redirect(){
			if ( current_user_can( 'edit_theme_options' ) ) {
				header('Location:'.admin_url().'admin.php?page=inzofin');
			}
		}
		
		function inzofin_zozo_admin_menu(){
			if ( current_user_can( 'edit_theme_options' ) ) {
				// Work around for theme check
				$zozo_menu_page = 'add_menu' . '_page';
				$zozo_submenu_page = 'add_submenu' . '_page';
					
				$system_status = $zozo_menu_page(
					'Inzofin',
					'Inzofin',
					'administrator',
					'inzofin',
					array( $this, 'inzofin_system_status' ),
					'dashicons-admin-home',
					3
				); 
				
				$registration = $zozo_submenu_page(
					'inzofin',
					esc_html__( 'Registration', 'inzofin' ),
					esc_html__( 'Registration', 'inzofin' ),
					'administrator',
					'inzofin-registration',
					array( $this, 'inzofin_registration' ) );
				
				$plugin_demo = $zozo_submenu_page(
						'inzofin',
						esc_html__( 'Plugin and Demo', 'inzofin' ),
						esc_html__( 'Plugin and Demo', 'inzofin' ),
						'administrator',
						'inzofin-installation',
						array( $this, 'inzofin_themes_plugin_demo_tab' ) ); 				
				
				
				$support = $zozo_submenu_page(
					'inzofin',
					esc_html__( 'Support', 'inzofin' ),
					esc_html__( 'Support', 'inzofin' ),
					'administrator',
					'inzofin-support',
					array( $this, 'inzofin_zozo_welcome_screen' ) );
					
				
				
				
				add_action( 'admin_print_scripts-'.$system_status, array( $this, 'inzofin_zozo_admin_screen_scripts' ) );
				add_action( 'admin_print_scripts-'.$plugin_demo, array( $this, 'inzofin_zozo_admin_screen_scripts' ) );
				add_action( 'admin_print_scripts-'.$support, array( $this, 'inzofin_zozo_admin_screen_scripts' ) );		
				add_action( 'admin_print_scripts-'.$registration, array( $this, 'inzofin_zozo_admin_screen_scripts' ) );				
				
			}
		}
		
		function inzofin_zozo_edit_admin_menus() {
			global $submenu;
			if ( current_user_can( 'edit_theme_options' ) ) {
				$submenu['inzofin'][0][0] = 'Welcome';
			}
		}
		
		function inzofin_zozo_welcome_screen() {
			get_template_part( 'admin/welcome-page/screens/welcome' );
		}
		
		function inzofin_themes_plugin_demo_tab() {
			get_template_part( 'admin/welcome-page/screens/plugin', 'demo' ); 
		}
		
		function inzofin_system_status() {
			get_template_part( 'admin/welcome-page/screens/system', 'status' ); 
		}
		
		function inzofin_registration() {
			get_template_part( 'admin/welcome-page/screens/registration' ); 
		}
				
		function inzofin_zozo_admin_page_scripts() {			
			if ( is_admin() && ( isset( $_GET['page'] ) && $_GET['page'] == 'inzofin-installation' ) ) {	
				wp_enqueue_style( 'inzofin-zozo-admin-confirm-css', esc_url( get_template_directory_uri() . '/admin/welcome-page/assets/css/jquery-confirm.min.css' ) );
				wp_enqueue_script( 'inzofin-zozo-admin-confirm-js', esc_url( get_template_directory_uri() . '/admin/welcome-page/assets/js/jquery-confirm.min.js' ) );
			}
		}
		function inzofin_zozo_admin_screen_scripts() {
			wp_enqueue_style( 'inzofin-zozo-admin-page-css', esc_url( get_template_directory_uri() . '/admin/welcome-page/assets/css/admin-screen.css' ) );
			wp_enqueue_script( 'inzofin-zozo-admin-page-js', esc_url( get_template_directory_uri() . '/admin/welcome-page/assets/js/admin-screen.js' ) );
		}
		
		function inzofin_plugin_link( $item ) {
		
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		
			$installed_plugins = get_plugins();
			$item['sanitized_plugin'] = $item['name'];
			 $is_plug_act = 'is_plugin_active';
			 
			if ( $is_plug_act( $item['file_path'] ) ) {
				
				if ( version_compare( $item['version'], $installed_plugins[$item['file_path']]['Version'], '>' ) ) {
					$actions = array(
						'update' => sprintf(
							'<a href="%1$s" class="button button-primary" title="%3$s %2$s">%3$s</a>',
							wp_nonce_url(
								add_query_arg(
									array(
										'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
										'plugin'		=> urlencode( $item['slug'] ),
										'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
										'plugin_source' => urlencode( $item['source'] ),
										'tgmpa-update' 	=> 'update-plugin',
										'version' 		=> urlencode( $item['version'] ),
										'return_url' 	=> 'inzofin-installation'
									),
									admin_url( TGM_Plugin_Activation::$instance->parent_slug )
								),
								'tgmpa-update',
								'tgmpa-nonce'
							),
							$item['sanitized_plugin'],
							esc_html__( 'Update', 'inzofin' )
						),
					);
				}else{
					$actions = array(
						'deactivate' => sprintf(
							'<a href="%1$s" class="button button-primary" title="%3$s %2$s">%3$s</a>',
							esc_url( add_query_arg(
								array(
									'plugin'					=> urlencode( $item['slug'] ),
									'plugin_name'		  		=> urlencode( $item['sanitized_plugin'] ),
									'plugin_source'				=> urlencode( $item['source'] ),
									'zozo-deactivate'	   		=> 'deactivate-plugin',
									'zozo-deactivate-nonce' 	=> wp_create_nonce( 'zozo-deactivate' ),
								),
								admin_url( 'admin.php?page=inzofin-installation' )
							) ),
							$item['sanitized_plugin'],
							esc_html__( 'Deactivate', 'inzofin' )
						),
					);
				}
			}
			 
			elseif ( ! isset( $installed_plugins[$item['file_path']] ) ) {
				$actions = array(
					'install' => sprintf(
						'<a href="%1$s" class="button button-primary" title="%3$s %2$s">%3$s</a>',
						esc_url( wp_nonce_url(
							add_query_arg(
								array(
									'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
									'plugin'		=> urlencode( $item['slug'] ),
									'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
									'plugin_source' => urlencode( $item['source'] ),
									'tgmpa-install' => 'install-plugin',
									'return_url' 	=> 'inzofin-installation'
								),
								admin_url( TGM_Plugin_Activation::$instance->parent_slug )
							),
							'tgmpa-install',
							'tgmpa-nonce'
						) ),
						$item['sanitized_plugin'],
						esc_html__( 'Install', 'inzofin' )
					),
				);
			}
			
			elseif ( is_plugin_inactive( $item['file_path'] ) ) {

				if ( version_compare( $item['version'], $installed_plugins[$item['file_path']]['Version'], '>' ) ) {
					$actions = array(
						'update' => sprintf(
							'<a href="%1$s" class="button button-primary" title="%3$s %2$s">%3$s</a>',
							wp_nonce_url(
								add_query_arg(
									array(
										'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
										'plugin'		=> urlencode( $item['slug'] ),
										'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
										'plugin_source' => urlencode( $item['source'] ),
										'tgmpa-update' 	=> 'update-plugin',
										'version' 		=> urlencode( $item['version'] ),
										'return_url' 	=> 'inzofin-installation'
									),
									admin_url( TGM_Plugin_Activation::$instance->parent_slug )
								),
								'tgmpa-update',
								'tgmpa-nonce'
							),
							$item['sanitized_plugin'],
							esc_html__( 'Update', 'inzofin' )
						),
					);
				} else {
					$actions = array(
						'activate' => sprintf(
							'<a href="%1$s" class="button button-primary" title="%3$s %2$s">%3$s</a>',
							esc_url( add_query_arg(
								array(
									'plugin'			   	=> urlencode( $item['slug'] ),
									'plugin_name'		  	=> urlencode( $item['sanitized_plugin'] ),
									'plugin_source'			=> urlencode( $item['source'] ),
									'zozo-activate'	   		=> 'activate-plugin',
									'zozo-activate-nonce' 	=> wp_create_nonce( 'zozo-activate' ),
								),
								admin_url( 'admin.php?page=inzofin-installation' )
							) ),
							$item['sanitized_plugin'],
							esc_html__( 'Activate', 'inzofin' )
						),
					);
				}
			}
			
			elseif ( version_compare( $item['version'], $installed_plugins[$item['file_path']]['Version'], '>' ) ) {
				$actions = array(
					'update' => sprintf(
						'<a href="%1$s" class="button button-primary" title="%3$s %2$s">%3$s</a>',
						wp_nonce_url(
							add_query_arg(
								array(
									'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
									'plugin'		=> urlencode( $item['slug'] ),
									'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
									'plugin_source' => urlencode( $item['source'] ),
									'tgmpa-update' 	=> 'update-plugin',
									'version' 		=> urlencode( $item['version'] ),
									'return_url' 	=> 'inzofin-installation'
								),
								admin_url( TGM_Plugin_Activation::$instance->parent_slug )
							),
							'tgmpa-update',
							'tgmpa-nonce'
						),
						$item['sanitized_plugin'],
						esc_html__( 'Update', 'inzofin' )
					),
				);
			}
			
			return $actions;
		}
		
	}// class Inzofin_Zozo_Admin_Page
	new Inzofin_Zozo_Admin_Page;
}
class Inzofin_WP_FileSystem_Credentials {
	static function check_credentials() {
		// Get user credentials for WP filesystem API
		$demo_import_page_url = wp_nonce_url( 'themes.php?page=inzofin-demos', 'inzofin-demos' );
		if ( false === ( $creds = request_filesystem_credentials( $demo_import_page_url, '', false, false, null ) ) ) {
			return new WP_Error( 'XML_parse_error', esc_html__( 'There was an error when reading this WXR file', 'inzofin' ) );
		}
		// Now we have credentials, try to get the wp_filesystem running
		if ( ! WP_Filesystem( $creds ) ) {
			// Our credentials were no good, ask the user for them again
			request_filesystem_credentials( $demo_import_page_url, '', true, false, null );
			return true;
		}
	}
}
