<?php
$zozo_theme = wp_get_theme();
if($zozo_theme->parent_theme) {
    $template_dir =  basename( get_template_directory() );
    $zozo_theme = wp_get_theme($template_dir);
}
$zozo_theme_version = $zozo_theme->get( 'Version' );
$zozo_theme_name = $zozo_theme->get('Name');
$zozothemes_url = 'http://docs.zozothemes.com';
$zozothemescommunity_url = 'https://zozothemes.com';
?>
<div class="wrap about-wrap welcome-wrap zozothemes-wrap">
	<h1 class="hide" style="display:none;"></h1>
	<div class="zozothemes-welcome-inner">
		<div class="welcome-wrap">
			<h1><?php echo esc_html__( "Welcome to", "inzofin" ) . ' ' . '<span>'. $zozo_theme_name .'</span>'; ?></h1>
			<div class="theme-logo"><span class="theme-version"><?php esc_html_e( 'Version', 'inzofin' ); ?> <?php echo esc_attr( $zozo_theme_version ); ?></span></div>
			
			<div class="about-text"><?php echo esc_html__( "Nice!", "inzofin" ) . ' ' . $zozo_theme_name . ' ' . esc_html__( "is now installed and ready to use. Get ready to build your site with more powerful WordPress theme. We hope you enjoy using it.", "inzofin" ); ?></div>
		</div>
		<h2 class="zozo-nav-tab-wrapper nav-tab-wrapper">
			<?php
			printf( '<a href="%s" class="nav-tab">%s</a>', admin_url( 'admin.php?page=inzofin' ), esc_html__( "System Status", "inzofin" ) );
			printf( '<a href="#" class="nav-tab nav-tab-active">%s</a>', esc_html__( "Registration", "inzofin" ) );
			printf( '<a href="%s" class="nav-tab">%s</a>', admin_url( 'admin.php?page=inzofin-installation' ), esc_html__( "Plugin and Demo", "inzofin" ) );
			printf( '<a href="%s" class="nav-tab">%s</a>', admin_url( 'admin.php?page=inzofin-support' ),  esc_html__( "Support", "inzofin" ) );
			?>
		</h2>
	</div>
	
	<?php 
		require_once( INZOFIN_ADMIN . '/class.token-verification.php' );
		$verfied_stat = Zozo_Purchase_Code_Verification::check_theme_activated();
	?>
	<div class="zozo-envato-registration-form-wrap">
		<?php if( !$verfied_stat ): ?>
		<h2 class="text-center"><?php esc_html_e( "Activate your Licence", "inzofin" ); ?></h2>
		<p class="text-center"><?php esc_html_e( "Welcome and thank you for Choosing Inzofin Theme!
The Inzofin theme needs to be activated to enable demo import installation and customer support service.", "inzofin" ); ?></p>	
		<a href="<?php echo esc_url( 'https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-' ); ?>" target="_blank"><?php esc_html_e( "How to find purchase code?", "inzofin" ); ?></a>
		<form id="zozo-envato-registration-form" class="zozo-envato-registration-form" method="post">
			<?php wp_nonce_field( 'inzofin_theme_verify^%&^%', 'zozo_verify_nonce' ); ?>
			<div class="form-fields">
				<div class="zozo-input-group">
					<input type="text" name="zozo_registration_email" value="" placeholder="<?php esc_html_e( 'Enter E-mail address', 'inzofin' ); ?>">
					<input type="text" name="zozo_purchase_code" value="" placeholder="<?php esc_html_e( 'Enter your theme purchase code', 'inzofin' ); ?>">
				</div>
				<div class="submit-group">
					<input type="submit" name="submit" id="submit" class="button inzofin-btn" value="<?php esc_html_e( 'Activate', 'inzofin' ); ?>" />
					<span class="process-loader"><img src="<?php echo esc_url( INZOFIN_ADMIN_URL . '/welcome-page/assets/images/loader.gif' ); ?>" alt="<?php esc_html_e( 'Loader', 'inzofin' ) ?>" /></span>
				</div>
			</div>	

			<div class="verfication-alert text-center"><span class="verfication-txt"></span></div>
			
		</form>
		<?php else: ?>
		<div class="theme-activated-wrap text-center">
			<h2><?php esc_html_e( 'Thank you!', 'inzofin' ) ?></h2>
			<p><strong><?php esc_html_e( 'Your theme\'s license is activated successfully.', 'inzofin' ) ?></strong></p>
		</div>
		<form id="zozo-envato-deactivation-form" class="zozo-envato-deactivation-form text-center" method="post">
			<?php wp_nonce_field( 'inzofin_theme_deactivate^%&^%', 'zozo_deactivate_nonce' ); ?>
			<div class="submit-group">
				<input type="submit" name="submit" class="button inzofin-btn" value="<?php esc_html_e( 'Deactivate', 'inzofin' ); ?>" />
				<span class="process-loader"><img src="<?php echo esc_url( INZOFIN_ADMIN_URL . '/welcome-page/assets/images/loader.gif' ); ?>" alt="<?php esc_html_e( 'Loader', 'inzofin' ) ?>" /></span>
			</div>
		</form>
		<?php endif; ?>
		
		<div class="registration-token-instruction">
			<p class="text-center"><strong><?php esc_html_e( '1 license = 1 domain = 1 website', 'inzofin' ); ?></strong></p>
			<p class="text-center"><?php printf( '%1$s <a href="%2$s" target="_blank">%3$s</a>',
				esc_html__( 'You can always buy more licences for this product:', 'inzofin' ),
				esc_url( 'https://themeforest.net/user/zozothemes/portfolio' ),
				esc_html__( 'ThemeForest ZOZOTHEMES', 'inzofin' )
				); ?>
			</p>
		</div>
	</div>
	
</div>