<?php
/**
 * Enqueue Google Web Fonts.
 */
function inzofin_theme_default_fonts_url() {
    $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'inzofin' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Source Sans Pro:400,500,600,700,900|Open Sans:700,600,500,400&subset=latin' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}
function inzofin_enqueue_google_web_fonts() {
	wp_enqueue_style( 'inzofin-google-fonts', inzofin_theme_default_fonts_url(), array(), null, 'all' );
}
function inzofin_default_theme_options(){
	$cur_theme = wp_get_theme();	
	if ( $cur_theme->get( 'Name' ) == 'Inzofin' || $cur_theme->get( 'Name' ) == 'Inzofin Child' ){
		$input_val = inzofin_default_theme_values();
		$inzofin_default_options = json_decode( $input_val, true );
		update_option( 'inzofin_theme_options_new', $inzofin_default_options );
	}
}

function inzofin_set_google_fonts(){
	if( !class_exists( "InzofinThemeStyles" ) ){
		require_once INZOFIN_INC . '/theme-class/theme-style-class.php';
	}
	//Save Google Fonts
	$ats = new InzofinThemeStyles;
	$ats->inzofin_typo_generate( 'body-typography' );
	$ats->inzofin_typo_generate( 'h1-typography' );
	$ats->inzofin_typo_generate( 'h2-typography' );
	$ats->inzofin_typo_generate( 'h3-typography' );
	$ats->inzofin_typo_generate( 'h4-typography' );
	$ats->inzofin_typo_generate( 'h5-typography' );
	$ats->inzofin_typo_generate( 'h6-typography' );
	$ats->inzofin_typo_generate( 'widgets-content' );
	$ats->inzofin_typo_generate( 'widgets-title' );
	$ats->inzofin_typo_generate( 'header-topbar-typography' );
	$ats->inzofin_typo_generate( 'header-logobar-typography' );
	$ats->inzofin_typo_generate( 'header-navbar-typography' );
	$ats->inzofin_typo_generate( 'secondary-space-typography' );
	$ats->inzofin_typo_generate( 'header-fixed-typography' );
	$ats->inzofin_typo_generate( 'mobile-menu-typography' );
	$ats->inzofin_typo_generate( 'top-sliding-typography' );
	$ats->inzofin_typo_generate( 'main-menu-typography' );
	$ats->inzofin_typo_generate( 'dropdown-menu-typography' );
	$ats->inzofin_typo_generate( 'footer-typography' );
	$ats->inzofin_typo_generate( 'footer-top-typography' );
	$ats->inzofin_typo_generate( 'footer-middle-typography' );
	$ats->inzofin_typo_generate( 'footer-bottom-typography' );
	
	update_option( 'inzofin_custom_google_fonts', InzofinThemeStyles::$embrad_gf_array );
	$google_fonts = get_option( 'inzofin_custom_google_fonts' );
	return $google_fonts;
}

function inzofin_default_font_and_styles( $return = false ){
	
	//Set google fonts
	inzofin_set_google_fonts();
	
	$custom_css = inzofin_get_dynamic_styles();
	update_option( 'inzofin_theme_custom_styles', $custom_css );

}

if ( ! class_exists( 'InzofinFamework' ) ) {
	add_action("after_switch_theme", "inzofin_default_theme_options", 10);
	add_action("after_switch_theme", "inzofin_default_font_and_styles", 900);
	add_action( 'wp_enqueue_scripts', 'inzofin_enqueue_google_web_fonts' );
}
function inzofin_default_theme_values(){
	$theme_opt_def =  '{"page-layout":"wide","site-width":"1200","page-content-padding":{"left":"","right":"","top":"","bottom":""},"cpt-opts":{"portfolio":"portfolio","team":"team","testimonial":"testimonial","events":"events","services":"services"},"page-loader":"1","page-loader-img":{"id":"12161","url":"http:\/\/elementor.zozothemes.com\/inzofin\/wp-content\/uploads\/sites\/41\/2021\/04\/inzofin-loader.gif"},"infinite-loader-img":{"id":"","url":""},"logo":{"id":"","url":""},"sticky-logo":{"id":"","url":""},"mobile-logo":{"id":"","url":""},"mailchimp-api":"","google-api":"","comments-type":"wp","comments-like":"0","comments-share":"0","fb-developer-key":"","fb-comments-number":"5","smooth-opt":"0","scroll-time":"600","scroll-distance":"40","berater-grid-large":{"width":"440","height":"260"},"berater-grid-small":{"width":"220","height":"130"},"berater-team-medium":{"width":"300","height":"300"},"rtl":"0","theme-color":"#2dc55f","secondary-color":"#2dc55f","theme-link-color":{"regular":"#252525","hover":"#2dc55f","active":"#2dc55f"},"body-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":"0"},"body-typography":{"font_family":"Open Sans","font_weight":"400","font_sub":"latin","text_align":"","text_transform":"","font_size":"16","line_height":"30","letter_spacing":"","font_color":"#797979"},"h1-typography":{"font_family":"Source Sans Pro","font_weight":"700","font_sub":"","text_align":"","text_transform":"","font_size":"44","line_height":"40","letter_spacing":"","font_color":"#14212b"},"h2-typography":{"font_family":"Source Sans Pro","font_weight":"700","font_sub":"","text_align":"","text_transform":"","font_size":"40","line_height":"46","letter_spacing":"","font_color":"#14212b"},"h3-typography":{"font_family":"Source Sans Pro","font_weight":"700","font_sub":"","text_align":"","text_transform":"","font_size":"34","line_height":"40","letter_spacing":"","font_color":"#14212b"},"h4-typography":{"font_family":"Source Sans Pro","font_weight":"700","font_sub":"","text_align":"","text_transform":"","font_size":"28","line_height":"32","letter_spacing":"","font_color":"#14212b"},"h5-typography":{"font_family":"Source Sans Pro","font_weight":"700","font_sub":"","text_align":"","text_transform":"","font_size":"24","line_height":"30","letter_spacing":"","font_color":"#14212b"},"h6-typography":{"font_family":"Source Sans Pro","font_weight":"700","font_sub":"","text_align":"","text_transform":"","font_size":"16","line_height":"26","letter_spacing":"","font_color":"#14212b"},"widgets-title":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"22","line_height":"30","letter_spacing":"","font_color":""},"widgets-content":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":"#797979"},"main-menu-typography":{"font_family":"Open Sans","font_weight":"700","font_sub":"","text_align":"","text_transform":"uppercase","font_size":"15","line_height":"","letter_spacing":"0.2","font_color":"#252525"},"dropdown-menu-typography":{"font_family":"Open Sans","font_weight":"700","font_sub":"","text_align":"","text_transform":"capitalize","font_size":"15","line_height":"","letter_spacing":"","font_color":"#797979"},"top-sliding-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"header-topbar-typography":{"font_family":"Open Sans","font_weight":"400","font_sub":"","text_align":"","text_transform":"","font_size":"15","line_height":"","letter_spacing":"","font_color":"#ffffff"},"header-logobar-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"15","line_height":"26","letter_spacing":"","font_color":"#ffffff"},"header-navbar-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"15","line_height":"","letter_spacing":"","font_color":"#ffffff"},"header-fixed-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"mobile-menu-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":""},"footer-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":"#f7f7f7"},"footer-top-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":"#ffffff"},"footer-middle-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":"#f7f7f7"},"footer-bottom-typography":{"font_family":"","font_weight":"","font_sub":"","text_align":"","text_transform":"","font_size":"","line_height":"","letter_spacing":"","font_color":"#f7f7f7"},"header-layout":"wide","header-template":"custom","header-type":"default","header-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":"0"},"header-items":{"Normal":{"header-nav":"Nav Bar"},"disabled":{"header-logo":"Logo Section","header-topbar":"Top Bar"}},"header-address-label":"Address","header-address-text":" 684 West College St. Sun City, USA","header-phone-label":"Phone","header-phone-text":" (310) 123-4567","header-email-label":"Email","header-email-text":"info@example.com","header-slider-position":"bottom","header-absolute":"0","sticky-part":"1","sticky-part-scrollup":"0","mainmenu-menutype":"advanced","dropdown-menu-background":"","dropdown-menu-link-color":{"regular":"#252525","hover":"#2dc55f","active":"#2dc55f"},"dropdown-menu-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"menu-tag":"1","menu-tag-hot-text":"Hot","menu-tag-hot-bg":"","menu-tag-new-text":"New","menu-tag-new-bg":"","menu-tag-trend-text":"Trend","menu-tag-trend-bg":"","secondary-menu":"1","secondary-menu-type":"left-push","secondary-menu-space-width":"350","header-top-sliding-switch":"0","header-top-sliding-device":["desktop","tab"],"header-top-sliding-cols":"3","header-top-sliding-sidebar-1":"","header-top-sliding-sidebar-2":"","header-top-sliding-sidebar-3":"","header-top-sliding-sidebar-4":"","top-sliding-background":"","top-sliding-link-color":{"regular":"","hover":"","active":""},"top-sliding-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"top-sliding-padding":{"left":"","right":"","top":"","bottom":""},"search-toggle-form":"3","header-topbar-height":"50","header-topbar-background":"#070e20","header-topbar-link-color":{"regular":"#ffffff","hover":"#2dc55f","active":"#2dc55f"},"header-topbar-border":{"left":"","right":"","top":"","bottom":"","style":"none","color":"#e5e5e5"},"header-topbar-padding":{"left":"","right":"","top":"","bottom":""},"header-topbar-text-1":"Customer service: <a href=\"tel:18002162020\">1 (800) 216 20 20<\/a>","header-topbar-text-2":"<div class=\"custom-logins\">\r\n<a href=\"#\">Login\r\n<\/a>or<a href=\"#\"> Register<\/a><\/div>","header-topbar-text-3":"Welcome To Klenster","header-topbar-date":"l, F j, Y","header-topbar-items":{"disabled":{"header-topbar-search":"Search","header-cart":"Cart","header-topbar-date":"Date","header-topbar-text-3":"Custom Text 3","header-topbar-menu":"Top Bar Menu","header-phone":"Phone Number","header-topbar-search-toggle":"Search Toggle","header-topbar-text-2":"Custom Text 2","header-topbar-text-1":"Custom Text 1"},"Left":{"header-address":"Address Text"},"Right":{"header-email":"Email","header-topbar-social":"Social"}},"header-logobar-height":"100","header-logobar-sticky-height":"90","header-logobar-background":"#ffffff","header-logobar-link-color":{"regular":"#000000","hover":"#2dc55f","active":"#2dc55f"},"header-logobar-border":{"left":"","right":"","top":"","bottom":"1","style":"solid","color":"rgba(225,227,230,0.2)"},"header-logobar-padding":{"left":"","right":"","top":"","bottom":""},"sticky-header-logobar-color":"","sticky-header-logobar-background":"","sticky-header-logobar-link-color":{"regular":"","hover":"","active":""},"sticky-header-logobar-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"sticky-header-logobar-padding":{"left":"","right":"","top":"","bottom":""},"header-logobar-text-1":"<ul class=\"berater-header-custom-info\">\r\n    <li class=\"berater-header-email\">\r\n        <div class=\"media\">\r\n            <i class=\"ti-email\"><\/i>\r\n            <div class=\"media-body\">\r\n                <p class=\"lable-txt mb-2\">If your any query:<\/p>\r\n\t\t\t\t<p class=\"info-text mt-0 mb-0\"><a href=\"mailto:info@example.com\">info@example.com<\/a><\/p>\r\n            <\/div>\r\n        <\/div>\r\n    <\/li>\r\n    <li class=\"berater-header-phone\">\r\n        <div class=\"media\">\r\n            <i class=\"ti-mobile\"><\/i>\r\n            <div class=\"media-body\">\r\n                <p class=\"lable-txt mb-2\">Have any question?<\/p>\r\n                <p class=\"info-text mb-0\"><a href=\"tele:(155)56554515\"> (155)56554515<\/a><\/p>\r\n            <\/div>\r\n        <\/div>\r\n    <\/li>\r\n<\/ul>","header-logobar-text-2":"<ul class=\"berater-header-custom-info\">\r\n    <li class=\"berater-header-hours\">\r\n\t\t<p class=\"lable-txt mb-2\">Mon to Fri: 08:00AM - 8:00PM<\/p>\r\n    <\/li>\r\n<\/ul>","header-logobar-text-3":"<div class=\"header-button\">\r\n<a href=\"#\" class=\"btn btn-default\">Contact Us<\/a>\r\n<\/div>","header-logobar-items":{"disabled":{"header-logobar-secondary-toggle":"Secondary Toggle","header-logobar-menu":"Main Menu","header-logobar-logo":"Logo","header-logobar-sticky-logo":"Sticky Logo","header-cart":"Cart","header-phone":"Phone Number","header-address":"Address Text","header-email":"Email","multi-info":"Address, Phone, Email","header-logobar-search":"Search","header-logobar-search-toggle":"Search Toggle","header-logobar-social":"Social"},"Left":{"header-logobar-text-1":"Custom Text 1"},"Right":{"header-logobar-text-2":"Custom Text 2","header-logobar-text-3":"Custom Text 3"}},"header-navbar-height":"100","header-navbar-sticky-height":"100","header-navbar-background":"","header-navbar-link-color":{"regular":"#0e0e0e","hover":"#2dc55f","active":"#2dc55f"},"header-navbar-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"header-navbar-padding":{"left":"","right":"","top":"","bottom":""},"sticky-header-navbar-color":"#0e0e0e","sticky-header-navbar-link-color":{"regular":"#1c1c25","hover":"#2dc55f","active":"#2dc55f"},"sticky-header-navbar-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"sticky-header-navbar-padding":{"left":"","right":"","top":"","bottom":""},"header-navbar-text-1":"<div class=\"header-button\">\r\n<a href=\"#\" class=\"btn btn-default\">Contact Us<\/a>\r\n<\/div>","header-navbar-text-2":"<ul class=\"inzofin-header-custom-info\">\r\n   <li class=\"inzofin-header-phone\">\r\n      <div class=\"media\">\r\n         <i class=\"ti-comments\"><\/i>\r\n         <div class=\"media-body\">\r\n            <p class=\"info-text mb-2\">Have any question?<\/p>\r\n            <h6 class=\"mt-0 mb-0\"><a href=\"tel:2324567890\">  (232) 456-7890<\/a><\/h6>\r\n         <\/div>\r\n      <\/div>\r\n   <\/li>\r\n<\/ul>","header-navbar-text-3":"","header-navbar-items":{"disabled":{"header-navbar-text-3":"Custom Text 3","header-navbar-search":"Search","header-navbar-social":"Social","header-phone":"Phone Number","header-address":"Address Text","header-cart":"Cart","header-email":"Email","header-navbar-secondary-toggle":"Secondary Toggle","header-navbar-text-1":"Custom Text 1","header-wishlist":"Wishlist","header-navbar-sticky-logo":"Stikcy Logo","header-navbar-text-2":"Custom Text 2"},"Left":{"header-navbar-logo":"Logo"},"Center":{"header-navbar-menu":"Main Menu"},"Right":{"header-navbar-search-toggle":"Search Toggle"}},"header-fixed-width":"350","header-fixed-link-color":{"regular":"","hover":"","active":""},"header-fixed-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"header-fixed-padding":{"left":"","right":"","top":"","bottom":""},"header-fixed-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"header-fixed-text-1":"","header-fixed-text-2":"","header-fixed-items":{"disabled":{"header-fixed-text-1":"Custom Text 1","header-fixed-text-2":"Custom Text 2","header-fixed-search":"Search Form","header-fixed-social":"Social"},"Top":{"header-fixed-logo":"Logo"},"Middle":{"header-fixed-menu":"Menu"}},"mobile-topbar-opt":"0","mobile-topbar-text-1":"","mobile-header-from":"1025","mobile-header-from-custom":"767","mobile-header-height":"70","mobile-header-background":"#ffffff","mobile-header-link-color":{"regular":"#171422","hover":"#2dc55f","active":"#2dc55f"},"mobile-header-sticky":"0","mobile-header-sticky-scrollup":"0","mobile-header-sticky-height":"70","mobile-header-sticky-background":"#ffffff","mobile-header-sticky-link-color":{"regular":"#171422","hover":"#2dc55f","active":"#2dc55f"},"mobile-header-items":{"disabled":{"mobile-header-cart":"Cart Icon"},"Left":{"mobile-header-menu":"Menu Icon"},"Center":{"mobile-header-logo":"Logo"},"Right":{"mobile-header-search":"Search Icon"}},"mobile-menu-max-width":"","mobile-menu-link-color":{"regular":"#171422","hover":"#2dc55f","active":"#2dc55f"},"mobile-menu-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"mobile-menu-padding":{"left":"","right":"","top":"","bottom":""},"mobile-menu-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"mobile-menu-animate-from":"left","mobile-menu-text-1":"","mobile-menu-text-2":"","mobile-menu-items":{"disabled":{"mobile-menu-text-1":"Custom Text 1","mobile-menu-text-2":"Custom Text 2","mobile-menu-social":"Social"},"Top":{"mobile-menu-logo":"Logo"},"Middle":{"mobile-menu-mainmenu":"Menu"},"Bottom":{"mobile-menu-search":"Search Form"}},"footer-layout":"wide","footer-template":"custom","back-to-top":"1","back-to-top-position":"right","hidden-footer":"0","footer-link-color":{"regular":"#f7f7f7","hover":"#2dc55f","active":"#2dc55f"},"footer-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"footer-padding":{"left":"","right":"","top":"","bottom":""},"footer-background":{"bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center center","bg_media":{"id":"7515","url":""},"bg_color":"","bg_transparent":"1"},"footer-background-overlay":"","footer-items":{"Enabled":{"footer-top":"Footer Top","footer-middle":"Footer Middle","footer-bottom":"Footer Bottom"}},"footer-top-container":"wide","footer-top-layout":"4-4-4","footer-top-sidebar-1":"zozo-custom-footer-top-1","footer-top-sidebar-2":"zozo-custom-footer-top-2","footer-top-sidebar-3":"zozo-custom-footer-top-3","footer-top-sidebar-4":"","footer-top-sidebar-5":"","footer-top-link-color":{"regular":"#f7f7f7","hover":"#070e20","active":"#070e20"},"footer-top-border":{"left":"","right":"","top":"","bottom":"1","style":"solid","color":"#0e162b"},"footer-top-padding":{"left":"","right":"","top":"0","bottom":"0"},"footer-top-margin":{"left":"","right":"","top":"","bottom":""},"footer-top-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"5472","url":""},"bg_color":"#0e162b","bg_transparent":"0"},"footer-top-background-overlay":"","footer-top-title-color":"#ffffff","footer-middle-container":"wide","footer-middle-layout":"3-3-3-3","footer-middle-sidebar-1":"sidebar-2","footer-middle-sidebar-2":"sidebar-3","footer-middle-sidebar-3":"sidebar-4","footer-middle-sidebar-4":"sidebar-5","footer-middle-sidebar-5":"","footer-middle-link-color":{"regular":"#f7f7f7","hover":"#2dc55f","active":"#2dc55f"},"footer-middle-border":{"left":"","right":"","top":"","bottom":"1","style":"solid","color":"#1e2840"},"footer-middle-padding":{"left":"","right":"","top":"65","bottom":"65"},"footer-middle-margin":{"left":"","right":"","top":"","bottom":""},"footer-middle-background":{"bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center center","bg_media":{"id":"11709","url":"http:\/\/localhost\/development\/inzofin\/wp-content\/uploads\/2021\/04\/shapes6.png"},"bg_color":"","bg_transparent":"0"},"footer-middle-background-overlay":"#070e20","footer-middle-title-color":"#ffffff","footer-bottom-container":"wide","copyright-text":"@ Copyright 2022. WordPress Theme by <a href=\"https:\/\/zozothemes.com\/\" target=\"_blank\">Zozothemes<\/a>","footer-bottom-fixed":"0","footer-bottom-widget":"","footer-bottom-items":{"disabled":{"widget":"Custom Widget","menu":"Footer Menu","social":"Footer Social Links"},"Center":{"copyright":"Copyright Text"}},"footer-bottom-link-color":{"regular":"#2dc55f","hover":"#ffffff","active":"#ffffff"},"footer-bottom-border":{"left":"","right":"","top":"","bottom":"","style":"none","color":""},"footer-bottom-padding":{"left":"","right":"","top":"20","bottom":"20"},"footer-bottom-margin":{"left":"","right":"","top":"","bottom":""},"footer-bottom-background":{"bg_repeat":"","bg_size":"","bg_attachment":"","bg_position":"","bg_media":{"id":"","url":""},"bg_color":"#070e20","bg_transparent":"0"},"footer-bottom-background-overlay":"","footer-bottom-title-color":"","search-content":"post_page","page-page-title-opt":"1","template-page-color":"#ffffff","template-page-link-color":{"regular":"#2dc55f","hover":"#eaeaea","active":"#2dc55f"},"template-page-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-page-padding":{"left":"","right":"","top":"105","bottom":"105"},"template-page-background-all":{"bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center center","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"page-page-title-parallax":"0","page-page-title-bg":"0","page-page-title-video":"","page-page-title-overlay":"rgba(0,15,33,0.71)","template-page-page-title-items-opt":"1","template-page-pagetitle-items":{"Left":{"title":"Page Title Text","breadcrumb":"Breadcrumb"}},"page-page-template":"no-sidebar","page-left-sidebar":"","page-right-sidebar":"sidebar-1","page-sidebar-sticky":"1","page-page-hide-sidebar":"1","blog-page-title-opt":"1","template-blog-color":"#ffffff","template-blog-link-color":{"regular":"#2dc55f","hover":"#ffffff","active":"#2dc55f"},"template-blog-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-blog-padding":{"left":"","right":"","top":"105","bottom":"105"},"template-blog-background-all":{"bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center center","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"blog-page-title-parallax":"0","blog-page-title-bg":"0","blog-page-title-video":"","blog-page-title-overlay":"rgba(0,15,33,0.71)","blog-page-title":"Latest Posts","blog-page-desc":"","template-blog-page-title-items-opt":"0","template-blog-pagetitle-items":{"disabled":{"description":"Page Title Description"},"Left":{"title":"Page Title Text","breadcrumb":"Breadcrumb"}},"blog-featured-slider":"0","blog-article-color":"","blog-article-link-color":{"regular":"","hover":"","active":""},"blog-article-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"blog-article-padding":{"left":"","right":"","top":"","bottom":""},"blog-article-background":"","blog-video-format":"onclick","blog-quote-format":"featured","blog-link-format":"featured","blog-gallery-format":"default","blog-page-template":"right-sidebar","blog-left-sidebar":"sidebar-1","blog-right-sidebar":"sidebar-1","blog-sidebar-sticky":"1","blog-page-hide-sidebar":"1","blog-post-template":"grid","blog-top-standard-post":"0","blog-grid-cols":"2","blog-grid-gutter":"33","blog-grid-type":"isotope","blog-infinite-scroll":"0","blog-more-text":"Read More","blog-excerpt":"17","blog-topmeta-items":{"Left":{"date":"Date"},"disabled":{"social":"Social Share","category":"Category","likes":"Likes","views":"Views","comments":"Comments","author":"Author","more":"Read More","favourite":"Favourite"}},"blog-bottommeta-items":{"Left":{"author":"Author","comments":"Comments"},"disabled":{"more":"Read More","date":"Date","category":"Category","social":"Social Share","likes":"Likes","views":"Views","favourite":"Favourite"}},"blog-items":{"Enabled":{"thumb":"Thumbnail","top-meta":"Top Meta","bottom-meta":"Bottom Meta","title":"Title"},"disabled":{"content":"Content"}},"blog-overlay-opt":"0","blog-overlay-items":{"Enabled":{"bottom-meta":"Bottom Meta"},"disabled":{"title":"Title","top-meta":"Top Meta"}},"archive-page-title-opt":"1","template-archive-color":"#ffffff","template-archive-link-color":{"regular":"#2dc55f","hover":"#ffffff","active":"#2dc55f"},"template-archive-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-archive-padding":{"left":"","right":"","top":"105","bottom":"105"},"template-archive-background-all":{"bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center center","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"archive-page-title-parallax":"0","archive-page-title-bg":"0","archive-page-title-video":"","archive-page-title-overlay":"rgba(0,15,33,0.71)","template-archive-page-title-items-opt":"1","template-archive-pagetitle-items":{"Left":{"title":"Page Title Text","breadcrumb":"Breadcrumb"}},"archive-featured-slider":"0","archive-article-color":"","archive-article-link-color":{"regular":"","hover":"","active":""},"archive-article-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"archive-article-padding":{"left":"","right":"","top":"","bottom":""},"archive-article-background":"","archive-video-format":"onclick","archive-quote-format":"featured","archive-link-format":"featured","archive-gallery-format":"default","archive-page-template":"right-sidebar","archive-left-sidebar":"sidebar-1","archive-right-sidebar":"sidebar-1","archive-sidebar-sticky":"0","archive-page-hide-sidebar":"1","archive-post-template":"grid","archive-top-standard-post":"0","archive-grid-cols":"2","archive-grid-gutter":"33","archive-grid-type":"isotope","archive-infinite-scroll":"0","archive-more-text":"Read More","archive-excerpt":"15","archive-topmeta-items":{"Left":{"date":"Date"},"disabled":{"social":"Social Share","comments":"Comments","likes":"Likes","views":"Views","more":"Read More","author":"Author","category":"Category","favourite":"Favourite"}},"archive-bottommeta-items":{"Left":{"author":"Author","comments":"Comments"},"disabled":{"category":"Category","social":"Social Share","likes":"Likes","more":"Read More","views":"Views","date":"Date","favourite":"Favourite"}},"archive-items":{"Enabled":{"thumb":"Thumbnail","top-meta":"Top Meta","bottom-meta":"Bottom Meta","title":"Title"},"disabled":{"content":"Content"}},"archive-overlay-opt":"0","archive-overlay-items":{"Enabled":{"title":"Title"},"disabled":{"top-meta":"Top Meta","bottom-meta":"Bottom Meta"}},"single-post-page-title-opt":"1","template-single-post-color":"#ffffff","template-single-post-link-color":{"regular":"#2dc55f","hover":"#ffffff","active":"#2dc55f"},"template-single-post-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-single-post-padding":{"left":"","right":"","top":"105","bottom":"105"},"template-single-post-background-all":{"bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center center","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"single-post-page-title-parallax":"0","single-post-page-title-bg":"0","single-post-page-title-video":"","single-post-page-title-overlay":"rgba(0,15,33,0.71)","template-single-post-page-title-items-opt":"1","template-single-post-pagetitle-items":{"Left":{"title":"Page Title Text","breadcrumb":"Breadcrumb"}},"single-post-featured-slider":"0","single-post-article-color":"","single-post-article-link-color":{"regular":"","hover":"","active":""},"single-post-article-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"single-post-article-padding":{"left":"","right":"","top":"","bottom":""},"single-post-article-background":"","single-post-article-overlay-color":"","single-post-article-overlay-link-color":{"regular":"","hover":"","active":""},"single-post-article-overlay-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"single-post-article-overlay-padding":{"left":"","right":"","top":"","bottom":""},"single-post-article-overlay-background":"","single-post-video-format":"onclick","single-post-quote-format":"featured","single-post-link-format":"featured","single-post-gallery-format":"default","single-post-page-template":"right-sidebar","single-post-left-sidebar":"sidebar-1","single-post-right-sidebar":"sidebar-1","single-post-sidebar-sticky":"0","single-post-page-hide-sidebar":"1","single-post-full-wrap":"0","single-post-topmeta-items":{"Left":{"author":"Author","date":"Date","category":"Category"},"disabled":{"social":"Social Share","author":"Author","likes":"Likes","views":"Views","tag":"Tags","favourite":"Favourite","comments":"Comments"}},"single-post-bottommeta-items":{"Left":{"tag":"Tags"},"Right":{"comments":"Comments"},"disabled":{"date":"Date","likes":"Likes","author":"Author","category":"Category","social":"Social Share","views":"Views","favourite":"Favourite"}},"single-post-items":{"Enabled":{"thumb":"Thumbnail","top-meta":"Top Meta","content":"Content","bottom-meta":"Bottom Meta"},"disabled":{"title":"Title"}},"single-post-overlay-opt":"0","single-post-overlay-items":{"Enabled":{"title":"Title"},"disabled":{"top-meta":"Top Meta","bottom-meta":"Bottom Meta"}},"single-post-page-items":{"Enabled":{"post-items":"Post Items","post-nav":"Post Navigation","author-info":"Author Info","comment":"Comment"},"disabled":{"related-slider":"Related Slider"}},"related-max-posts":"5","related-posts-filter":"category","featured-slide-items":"3","featured-slide-tab":"1","featured-slide-mobile":"1","featured-slide-scrollby":"1","featured-slide-autoplay":"0","featured-slide-center":"0","featured-slide-duration":"5000","featured-slide-smartspeed":"250","featured-slide-margin":"10","featured-slide-pagination":"0","featured-slide-navigation":"0","featured-slide-autoheight":"0","related-slide-items":"3","related-slide-tab":"1","related-slide-mobile":"1","related-slide-scrollby":"1","related-slide-autoplay":"0","related-slide-center":"0","related-slide-duration":"5000","related-slide-smartspeed":"250","related-slide-margin":"10","related-slide-pagination":"0","related-slide-navigation":"0","related-slide-autoheight":"0","blog-slide-items":"3","blog-slide-tab":"1","blog-slide-mobile":"1","blog-slide-scrollby":"1","blog-slide-autoplay":"0","blog-slide-center":"0","blog-slide-duration":"5000","blog-slide-smartspeed":"250","blog-slide-margin":"10","blog-slide-pagination":"0","blog-slide-navigation":"0","blog-slide-autoheight":"0","single-slide-items":"3","single-slide-tab":"1","single-slide-mobile":"1","single-slide-scrollby":"1","single-slide-autoplay":"0","single-slide-center":"0","single-slide-duration":"5000","single-slide-smartspeed":"250","single-slide-margin":"10","single-slide-pagination":"0","single-slide-navigation":"0","single-slide-autoheight":"0","social-icons-type":"squared","social-icons-type-footer":"circled","social-icons-fore":"white","social-icons-hfore":"h-own","social-icons-bg":"bg-transparent","social-icons-hbg":"hbg-transparent","social-fb":"#","social-twitter":"","social-instagram":"","social-pinterest":"","social-gplus":"","social-youtube":"","social-vimeo":"","social-soundcloud":"","social-yahoo":"","social-tumblr":"","social-mailto":"","social-flickr":"","social-dribbble":"","social-linkedin":"","social-rss":"","team-page-template":"no-sidebar","team-left-sidebar":"","team-right-sidebar":"sidebar-1","team-title-opt":"1","cpt-team-slug":"team","cpt-team-layout":"default","maintenance-mode":"0","maintenance-type":"cs","maintenance-custom":"","maintenance-phone":"","maintenance-email":"","maintenance-address":"","mobile-topbar-items":{"disabled":{"custom-1":"Custom Text","address":"Address"},"Enabled":{"phone":"Phone","mail":"Mail"}},"comments-social-shares":["fb","twitter","linkedin","pinterest"],"testimonial-page-template":"no-sidebar","testimonial-left-sidebar":"sidebar-1","testimonial-right-sidebar":"sidebar-1","testimonial-title-opt":"1","cpt-testimonial-slug":"testimonial","events-page-template":"no-sidebar","events-left-sidebar":"","events-right-sidebar":"sidebar-1","event-title-opt":"1","cpt-events-slug":"event","cpt-event-layout":"1","services-page-template":"left-sidebar","services-left-sidebar":"zozo-custom-services-sidebar","services-right-sidebar":"","service-title-opt":"0","cpt-services-slug":"service","portfolio-page-template":"no-sidebar","portfolio-left-sidebar":"","portfolio-right-sidebar":"sidebar-1","portfolio-title-opt":"0","cpt-portfolio-slug":"portfolio","cpt-portfolio-category-slug":"portfolio-category","cpt-portfolio-tag-slug":"portfolio-tag","portfolio-meta-items":{"Enabled":{"date":"Date","client":"Client","duration":"Duration","place":"Place","estimation":"Estimation","category":"Category"},"Disabled":{"url":"Url","tag":"Tags","share":"Share"}},"portfolio-client-label":"Client","portfolio-date-label":"Date","portfolio-duration-label":"Duration","portfolio-estimation-label":"Estimation","portfolio-place-label":"Place","portfolio-url-label":"URL","portfolio-category-label":"Category","portfolio-tags-label":"Tags","portfolio-share-label":"Share","portfolio-layout":"2","portfolio-grid-cols":"2","portfolio-grid-gutter":"20","portfolio-grid-type":"isotope","portfolio-related-opt":"0","portfolio-related-slide-items":"3","portfolio-related-slide-tab":"1","portfolio-related-slide-mobile":"1","portfolio-related-slide-scrollby":"1","portfolio-related-slide-autoplay":"0","portfolio-related-slide-center":"0","portfolio-related-slide-duration":"5000","portfolio-related-slide-smartspeed":"250","portfolio-related-slide-margin":"10","portfolio-related-slide-pagination":"0","portfolio-related-slide-navigation":"0","portfolio-related-slide-autoheight":"0","portfolio-single-slider-opt":"0","portfolio-single-slide-items":"3","portfolio-single-slide-tab":"1","portfolio-single-slide-mobile":"1","portfolio-single-slide-scrollby":"1","portfolio-single-slide-autoplay":"0","portfolio-single-slide-center":"0","portfolio-single-slide-duration":"5000","portfolio-single-slide-smartspeed":"250","portfolio-single-slide-margin":"10","portfolio-single-slide-pagination":"0","portfolio-single-slide-navigation":"0","portfolio-single-slide-autoheight":"0","logo-height":"53","sticky-logo-height":"52","mobile-logo-height":"38","header-topbar-sticky-height":"45","woo-page-title-opt":"1","template-woo-color":"#ffffff","template-woo-link-color":{"regular":"#2dc55f","hover":"#ffffff","active":"#2dc55f"},"template-woo-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-woo-padding":{"left":"","right":"","top":"105","bottom":"105"},"template-woo-background-all":{"bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center center","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"woo-page-title-parallax":"0","woo-page-title-bg":"","woo-page-title-video":"","woo-page-title-overlay":"rgba(0,15,33,0.71)","template-woo-page-title-items-opt":"1","template-woo-pagetitle-items":{"Left":{"title":"Page Title Text","breadcrumb":"Breadcrumb"}},"wooarchive-page-template":"no-sidebar","wooarchive-left-sidebar":"","wooarchive-right-sidebar":"","woo-shop-archive-columns":"4","woo-page-template":"no-sidebar","woo-left-sidebar":"","woo-right-sidebar":"","woo-shop-columns":"4","woo-shop-ppp":"8","woo-related-ppp":"3","woo-related-slide-items":"4","woo-related-slide-tab":"1","woo-related-slide-mobile":"1","woo-related-slide-scrollby":"1","woo-related-slide-autoplay":"1","woo-related-slide-center":"0","woo-related-slide-duration":"5000","woo-related-slide-smartspeed":"250","woo-related-slide-margin":"30","woo-related-slide-pagination":"1","woo-related-slide-navigation":"0","woo-related-slide-autoheight":"0","woo-related-slide-infinite":"0","single-product-page-title-opt":"1","template-single-color":"","template-single-link-color":{"regular":"#073a7b","hover":"#073a7b","active":"#073a7b"},"template-single-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"template-single-padding":{"left":"","right":"","top":"350","bottom":"0"},"template-single-background-all":{"bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center center","bg_media":{"id":"6120","url":""},"bg_color":"","bg_transparent":""},"single-product-page-title-parallax":"0","single-product-page-title-bg":"0","single-product-page-title-video":"","single-product-page-title-overlay":"rgba(0,15,33,0.71)","template-single-product-page-title-items-opt":"1","template-single-product-pagetitle-items":{"disabled":{"title":"Page Title Text"},"Left":{"breadcrumb":"Breadcrumb"}},"template-single-product-padding":{"left":"","right":"","top":"105","bottom":"105"},"template-single-product-background-all":{"bg_repeat":"no-repeat","bg_size":"cover","bg_attachment":"","bg_position":"center center","bg_media":{"id":"","url":""},"bg_color":"","bg_transparent":""},"template-single-product-link-color":{"regular":"#2dc55f","hover":"#ffffff","active":"#2dc55f"},"template-single-product-color":"#ffffff","template-single-product-border":{"left":"","right":"","top":"","bottom":"","style":"","color":""},"services-page-hide-sidebar":"1","post-social-shares":{"fb":"fb","twitter":"twitter","linkedin":"linkedin","pinterest":"pinterest"},"portfolio-page-hide-sidebar":"0","theme-btn-color":{"regular":"#2dc55f","hover":"#fc7223","active":"#fc7223"}}'; //Here Theme Default Values
	return $theme_opt_def;
}