<?php

//Theme Option -> Theme Template
$theme_template_panel = new Inzofin_WP_Customize_Panel( $wp_customize, 'theme_template_panel', array(
	'title'			=> esc_html__( 'Theme Template', 'inzofin' ),
	'description'	=> esc_html__( 'These is the template settings for page.', 'inzofin' ),
	'priority'		=> 7,
	'panel'			=> 'inzofin_theme_panel'
));
$wp_customize->add_panel( $theme_template_panel );

//Theme Template -> Template General
$inzofin_general_template_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_general_template_section', array(
	'title'			=> esc_html__( 'Template General', 'inzofin' ),
	'description'	=> esc_html__( 'This is the setting for template general.', 'inzofin' ),
	'priority'		=> 1,
	'panel'			=> 'theme_template_panel'
));
$wp_customize->add_section( $inzofin_general_template_section );

//Template General
$wp_customize->add_setting('ajax_trigger_inzofin_general_template_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_general_template_section', array(
	'section'		=> 'inzofin_general_template_section'
)));

//Theme Template -> Page Template
$inzofin_page_template_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_page_template_section', array(
	'title'			=> esc_html__( 'Page Template', 'inzofin' ),
	'description'	=> esc_html__( 'This is the setting for page template.', 'inzofin' ),
	'priority'		=> 2,
	'panel'			=> 'theme_template_panel'
));
$wp_customize->add_section( $inzofin_page_template_section );

//Page Template
$wp_customize->add_setting('ajax_trigger_inzofin_page_template_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_page_template_section', array(
	'section'		=> 'inzofin_page_template_section'
)));

//Theme Template -> Blog Template
$inzofin_blog_template_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_blog_template_section', array(
	'title'			=> esc_html__( 'Blog Template', 'inzofin' ),
	'description'	=> esc_html__( 'This is the setting for blog template.', 'inzofin' ),
	'priority'		=> 3,
	'panel'			=> 'theme_template_panel'
));
$wp_customize->add_section( $inzofin_blog_template_section );

//Blog Template
$wp_customize->add_setting('ajax_trigger_inzofin_blog_template_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_blog_template_section', array(
	'section'		=> 'inzofin_blog_template_section'
)));

//Theme Template -> Archive Template
$inzofin_archive_template_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_archive_template_section', array(
	'title'			=> esc_html__( 'Archive Template', 'inzofin' ),
	'description'	=> esc_html__( 'This is the setting for archive template.', 'inzofin' ),
	'priority'		=> 4,
	'panel'			=> 'theme_template_panel'
));
$wp_customize->add_section( $inzofin_archive_template_section );

//Archive Template
$wp_customize->add_setting('ajax_trigger_inzofin_archive_template_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_archive_template_section', array(
	'section'		=> 'inzofin_archive_template_section'
)));

//Theme Template -> Single Post Template
$inzofin_single_post_template_section = new Inzofin_WP_Customize_Section( $wp_customize, 'inzofin_single_post_template_section', array(
	'title'			=> esc_html__( 'Single Post Template', 'inzofin' ),
	'description'	=> esc_html__( 'This is the setting for single post template.', 'inzofin' ),
	'priority'		=> 9,
	'panel'			=> 'theme_template_panel'
));
$wp_customize->add_section( $inzofin_single_post_template_section );

//Single Post Template
$wp_customize->add_setting('ajax_trigger_inzofin_single_post_template_section', array(
	'default'           => '',
	'sanitize_callback' 	=> 'esc_attr'
));
$wp_customize->add_control( new Trigger_Custom_control( $wp_customize, 'ajax_trigger_inzofin_single_post_template_section', array(
	'section'		=> 'inzofin_single_post_template_section'
)));