<?php

//Layout Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Layout', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Option
$settings = array(
	'id'			=> 'single-post-page-title-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Page Title Option', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable page title.', 'inzofin' ),
	'default'		=> 1,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Items
$settings = array(
	'id'			=> 'template-single-post-pagetitle-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Page Title Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed items for page title wrap, drag from disabled and put enabled.', 'inzofin' ),
	'default' 		=> array(
		'disabled' => array(),
		'Left'  => array(
			'title' => esc_html__( 'Page Title Text', 'inzofin' ),
		),
		'Center' => array(),
		'Right'  => array(
			'breadcrumb'	=> esc_html__( 'Breadcrumb', 'inzofin' )
		)
	),
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Archive Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Archive Settings', 'inzofin' ),
	'description'	=> esc_html__( 'This is settings for single post page layout, sidebar sticky and etc.', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Archive Template
$settings = array(
	'id'			=> 'single-post-page-template',
	'type'			=> 'radioimage',
	'title'			=> esc_html__( 'Archive Template', 'inzofin' ),
	'description'	=> esc_html__( 'Choose your current single post page template.', 'inzofin' ),
	'default'		=> 'right-sidebar',
	'items' 		=> array(
		'no-sidebar'	=> INZOFIN_ADMIN_URL . '/customizer/assets/images/page-layouts/1.png',
		'right-sidebar'	=> INZOFIN_ADMIN_URL . '/customizer/assets/images/page-layouts/2.png',
		'left-sidebar'	=> INZOFIN_ADMIN_URL . '/customizer/assets/images/page-layouts/3.png',
		'both-sidebar'	=> INZOFIN_ADMIN_URL . '/customizer/assets/images/page-layouts/4.png'		
	),
	'cols'			=> '4',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Left Sidebar
$settings = array(
	'id'			=> 'single-post-left-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Left Sidebar', 'inzofin' ),
	'description'	=> esc_html__( 'Select widget area for showing on left side.', 'inzofin' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Right Sidebar
$settings = array(
	'id'			=> 'single-post-right-sidebar',
	'type'			=> 'sidebars',
	'title'			=> esc_html__( 'Right Sidebar', 'inzofin' ),
	'description'	=> esc_html__( 'Select widget area for showing on right side.', 'inzofin' ),
	'default'		=> 'sidebar-1',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Full Width Wrap
$settings = array(
	'id'			=> 'single-post-full-wrap',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Full Width Wrap', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable to show or hide full width post wrapper.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Article Top Meta Items
$settings = array(
	'id'			=> 'single-post-topmeta-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Single Post Article Top Meta Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed single post article top meta items drag from disabled and put enabled part. ie: Left or Right.', 'inzofin' ),
	'default' 		=> array(
		'Left'  => array(
			'author'	=> esc_html__( 'Author', 'inzofin' )						
		),
		'Right'  => array(
			'date'		=> esc_html__( 'Date', 'inzofin' )
		),
		'disabled' => array(
			'social'	=> esc_html__( 'Social Share', 'inzofin' ),						
			'likes'		=> esc_html__( 'Likes', 'inzofin' ),
			'author'	=> esc_html__( 'Author', 'inzofin' ),
			'views'		=> esc_html__( 'Views', 'inzofin' ),
			'tag'		=> esc_html__( 'Tags', 'inzofin' ),
			'favourite'	=> esc_html__( 'Favourite', 'inzofin' ),						
			'comments'	=> esc_html__( 'Comments', 'inzofin' ),
			'category'	=> esc_html__( 'Category', 'inzofin' )
		)
	),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Article Bottom Meta Items
$settings = array(
	'id'			=> 'single-post-bottommeta-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Single Post Article Bottom Meta Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed single post article bottom meta items drag from disabled and put enabled part. ie: Left or Right.', 'inzofin' ),
	'default' 		=> array(
		'Left'  => array(
			'category'	=> esc_html__( 'Category', 'inzofin' ),
		),
		'Right'  => array(),
		'disabled' => array(
			'social'	=> esc_html__( 'Social Share', 'inzofin' ),
			'date'		=> esc_html__( 'Date', 'inzofin' ),						
			'social'	=> esc_html__( 'Social Share', 'inzofin' ),						
			'likes'		=> esc_html__( 'Likes', 'inzofin' ),
			'author'	=> esc_html__( 'Author', 'inzofin' ),
			'views'		=> esc_html__( 'Views', 'inzofin' ),
			'favourite'	=> esc_html__( 'Favourite', 'inzofin' ),
			'comments'	=> esc_html__( 'Comments', 'inzofin' ),
			'tag'		=> esc_html__( 'Tags', 'inzofin' )
		)
	),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Article Items
$settings = array(
	'id'			=> 'single-post-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Single Post Article Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed single post article items drag from disabled and put enabled part. Thumbnail part covers the post format either image/audio/video/gallery/quote/link.', 'inzofin' ),
	'default' 		=> array(
		'Enabled'  => array(
			'title'	=> esc_html__( 'Title', 'inzofin' ),
			'top-meta'	=> esc_html__( 'Top Meta', 'inzofin' ),
			'thumb'	=> esc_html__( 'Thumbnail', 'inzofin' ),
			'content'	=> esc_html__( 'Content', 'inzofin' ),
			'bottom-meta'	=> esc_html__( 'Bottom Meta', 'inzofin' ),
		),
		'disabled' => array()
	),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Article Overlay
$settings = array(
	'id'			=> 'single-post-overlay-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Single Post Article Overlay', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable single post article overlay.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Article Overlay Items
$settings = array(
	'id'			=> 'single-post-overlay-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Single Post Article Overlay Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed single post article overlay items drag from disabled and put enabled part.', 'inzofin' ),
	'default' 		=> array(
		'Enabled'  => array(
			'title'			=> esc_html__( 'Title', 'inzofin' ),
		),
		'disabled' => array(
			'top-meta'		=> esc_html__( 'Top Meta', 'inzofin' ),
			'bottom-meta'	=> esc_html__( 'Bottom Meta', 'inzofin' )
		)
	),
	'required'		=> array( 'single-post-overlay-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Page Items
$settings = array(
	'id'			=> 'single-post-page-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Single Post Page Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed single post items drag from disabled and put enabled part.', 'inzofin' ),
	'default' 		=> array(
		'Enabled'  => array(
			'post-items'	=> esc_html__( 'Post Items', 'inzofin' ),
			'author-info'	=> esc_html__( 'Author Info', 'inzofin' ),
			'post-nav'		=> esc_html__( 'Post Navigation', 'inzofin' ),
			'related-slider'=> esc_html__( 'Related Slider', 'inzofin' ),
			'comment'		=> esc_html__( 'Comment', 'inzofin' )
		),
		'disabled' => array()
	),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Layout End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Style Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Style', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Page Title Settings', 'inzofin' ),
	'description'	=> esc_html__( 'This is page title style settings shows only when page title option active.', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Font Color
$settings = array(
	'id'			=> 'template-single-post-color',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Font Color', 'inzofin' ),
	'description'	=> esc_html__( 'This is font color for current field.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Template  Link Color
$settings = array(
	'id'			=> 'template-single-post-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Single Post Template  Link Color', 'inzofin' ),
	'description'	=> esc_html__( 'Choose Single post title bar link color.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Template  Border
$settings = array(
	'id'			=> 'template-single-post-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Single Post Template  Border', 'inzofin' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Template  Padding Option
$settings = array(
	'id'			=> 'template-single-post-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Single Post Template  Padding Option', 'inzofin' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Template  Background
$settings = array(
	'id'			=> 'template-single-post-background-all',
	'type'			=> 'background',
	'title'			=> esc_html__( 'Single Post Template  Background', 'inzofin' ),
	'description'	=> esc_html__( 'This is settings for footer background.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Background Parallax
$settings = array(
	'id'			=> 'single-post-page-title-parallax',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Background Parallax', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable page title background parallax.', 'inzofin' ),
	'default'		=> 0,
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Background Video
$settings = array(
	'id'			=> 'single-post-page-title-bg',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Background Video', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable page title background video.', 'inzofin' ),
	'default'		=> 0,
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Background Video
$settings = array(
	'id'			=> 'single-post-page-title-video',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Page Title Background Video', 'inzofin' ),
	'description'	=> esc_html__( 'Set page title background video for page. Only allowed youtube video id. Example: UWF7dZTLW4c', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-bg', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Overlay
$settings = array(
	'id'			=> 'single-post-page-title-overlay',
	'type'			=> 'alpha',
	'title'			=> esc_html__( 'Page Title Overlay', 'inzofin' ),
	'description'	=> esc_html__( 'Choose page title overlay rgba color.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Items Option
$settings = array(
	'id'			=> 'template-single-post-page-title-items-opt',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Page Title Items Option', 'inzofin' ),
	'description'	=> esc_html__( 'Enable to make page title items custom layout.', 'inzofin' ),
	'default'		=> 0,
	'required'		=> array( 'single-post-page-title-opt', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Page Title Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false,
	'required'		=> array( 'single-post-page-title-opt', '=', 1 )
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Article Skin Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Single Post Article Skin Settings', 'inzofin' ),
	'description'	=> esc_html__( 'This is skin settings for each single post article.', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Font Color
$settings = array(
	'id'			=> 'single-post-article-color',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Font Color', 'inzofin' ),
	'description'	=> esc_html__( 'This is font color for single post article.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Link Color
$settings = array(
	'id'			=> 'single-post-article-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Article Link Color', 'inzofin' ),
	'description'	=> esc_html__( 'Choose single post article link color for single post article.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Border
$settings = array(
	'id'			=> 'single-post-article-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Article Border', 'inzofin' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Padding Option
$settings = array(
	'id'			=> 'single-post-article-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Article Padding Option', 'inzofin' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Background
$settings = array(
	'id'			=> 'single-post-article-background',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Background Color', 'inzofin' ),
	'description'	=> esc_html__( 'This is background color for single post article.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 0
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Article Skin Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Article Overlay Skin Settings
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Single Post Article Overlay Skin Settings', 'inzofin' ),
	'description'	=> esc_html__( 'This is overlay skin settings for each single post article.', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Font Color
$settings = array(
	'id'			=> 'single-post-article-overlay-color',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Font Color', 'inzofin' ),
	'description'	=> esc_html__( 'This is font color for single post article.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Link Color
$settings = array(
	'id'			=> 'single-post-article-overlay-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Article Link Color', 'inzofin' ),
	'description'	=> esc_html__( 'Choose single post article overlay link color for single post article.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 0
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Border
$settings = array(
	'id'			=> 'single-post-article-overlay-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Article Border', 'inzofin' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Padding Option
$settings = array(
	'id'			=> 'single-post-article-overlay-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Article Padding Option', 'inzofin' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Article Background
$settings = array(
	'id'			=> 'single-post-article-overlay-background',
	'type'			=> 'color',
	'title'			=> esc_html__( 'Article Background Color', 'inzofin' ),
	'description'	=> esc_html__( 'This is background color for single post article.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Article Overlay Skin Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Style End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Advanced Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Advanced', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Post Format Settings Start
$settings = array(
	'type'			=> 'section',
	'label'			=> esc_html__( 'Post Format Settings', 'inzofin' ),
	'description'	=> esc_html__( 'This is post format settings for single post.', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Video Format
$settings = array(
	'id'			=> 'single-post-video-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Video Format', 'inzofin' ),
	'description'	=> esc_html__( 'Choose single post page video post format settings.', 'inzofin' ),
	'choices'		=> array(
		'onclick' 	=> esc_html__( 'On Click Run Video', 'inzofin' ),
		'overlay' 	=> esc_html__( 'Modal Box Video', 'inzofin' ),
		'direct' 	=> esc_html__( 'Direct Video', 'inzofin' )
	),
	'default'		=> 'onclick',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Quote Format
$settings = array(
	'id'			=> 'single-post-quote-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Quote Format', 'inzofin' ),
	'description'	=> esc_html__( 'Choose single post page quote post format settings.', 'inzofin' ),
	'choices'		=> array(
		'featured' 		=> esc_html__( 'Dark Overlay', 'inzofin' ),
		'theme-overlay' => esc_html__( 'Theme Overlay', 'inzofin' ),
		'theme' 		=> esc_html__( 'Theme Color Background', 'inzofin' ),
		'none' 			=> esc_html__( 'None', 'inzofin' )
	),
	'default'		=> 'featured',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Link Format
$settings = array(
	'id'			=> 'single-post-link-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Link Format', 'inzofin' ),
	'description'	=> esc_html__( 'Choose single post page link post format settings.', 'inzofin' ),
	'choices'		=> array(
		'featured' 		=> esc_html__( 'Dark Overlay', 'inzofin' ),
		'theme-overlay' => esc_html__( 'Theme Overlay', 'inzofin' ),
		'theme' 		=> esc_html__( 'Theme Color Background', 'inzofin' ),
		'none' 			=> esc_html__( 'None', 'inzofin' )
	),
	'default'		=> 'featured',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Gallery Format
$settings = array(
	'id'			=> 'single-post-gallery-format',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Gallery Format', 'inzofin' ),
	'description'	=> esc_html__( 'Choose single post page gallery post format settings.', 'inzofin' ),
	'choices'		=> array(
		'default'	=> esc_html__( 'Default Gallery', 'inzofin' ),
		'popup' 	=> esc_html__( 'Popup Gallery', 'inzofin' ),
		'grid' 		=> esc_html__( 'Grid Popup Gallery', 'inzofin' )
	),
	'default'		=> 'default',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Post Format Settings End
$settings = array(
	'type'			=> 'section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Single Post Featured Slider
$settings = array(
	'id'			=> 'single-post-featured-slider',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Single Post Featured Slider', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable single post featured slider.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Sidebar Sticky
$settings = array(
	'id'			=> 'single-post-sidebar-sticky',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Sidebar Sticky', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable sidebar sticky.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Sidebar on Mobile
$settings = array(
	'id'			=> 'single-post-page-hide-sidebar',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Sidebar on Mobile', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable to show or hide sidebar on mobile.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Related Post Max Limit
$settings = array(
	'id'			=> 'related-max-posts',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Related Post Max Limit', 'inzofin' ),
	'description'	=> esc_html__( 'Enter related post maximum limit for get from posts query. Example 5', 'inzofin' ),
	'default'		=> '5',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Related Posts From
$settings = array(
	'id'			=> 'related-posts-filter',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Related Posts From', 'inzofin' ),
	'description'	=> esc_html__( 'Select related posts gets from category or tag.', 'inzofin' ),
	'choices'		=> array(
		'category'	=> esc_html__( 'Category', 'inzofin' ),
		'tag'		=> esc_html__( 'Tag', 'inzofin' )
	),
	'default'		=> 'category',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Advanced End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );