<?php

//Maintenance Mode Option
$settings = array(
	'id'			=> 'maintenance-mode',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Maintenance Mode Option', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable maintenance mode.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Maintenance Type
$settings = array(
	'id'			=> 'maintenance-type',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Maintenance Type', 'inzofin' ),
	'description'	=> esc_html__( 'Select maintenance mode page coming soon or maintenance.', 'inzofin' ),
	'choices'		=> array(
		'cs'		=> esc_html__( 'Coming Soon', 'inzofin' ),
		'mn'		=> esc_html__( 'Maintenance', 'inzofin' ),
		'cus'		=> esc_html__( 'Custom', 'inzofin' )
	),
	'default'		=> 'cs',
	'required'		=> array( 'maintenance-mode', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Maintenance Custom Page
$settings = array(
	'id'			=> 'maintenance-custom',
	'type'			=> 'pages',
	'title'			=> esc_html__( 'Maintenance Custom Page', 'inzofin' ),
	'description'	=> esc_html__( 'Enter service slug for register custom post type.', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'maintenance-mode', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Phone Number
$settings = array(
	'id'			=> 'maintenance-phone',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Phone Number', 'inzofin' ),
	'description'	=> esc_html__( 'Enter phone number shown on when maintenance mode actived', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'maintenance-mode', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Email Id
$settings = array(
	'id'			=> 'maintenance-email',
	'type'			=> 'text',
	'title'			=> esc_html__( 'Email Id', 'inzofin' ),
	'description'	=> esc_html__( 'Enter email id shown on when maintenance mode actived', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'maintenance-mode', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Address
$settings = array(
	'id'			=> 'maintenance-address',
	'type'			=> 'textarea',
	'title'			=> esc_html__( 'Address', 'inzofin' ),
	'description'	=> esc_html__( 'Place here your address and info', 'inzofin' ),
	'default'		=> '',
	'required'		=> array( 'maintenance-mode', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );