<?php

//Layout Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Layout', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Footer Layout
$settings = array(
	'id'			=> 'footer-layout',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Footer Layout', 'inzofin' ),
	'description'	=> esc_html__( 'Choose footer layout boxed or wide.', 'inzofin' ),
	'choices'		=> array(
		'boxed'		=> esc_html__( 'Boxed', 'inzofin' ),
		'wide'		=> esc_html__( 'Wide', 'inzofin' )
	),
	'default'		=> 'wide',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Footer Template
$settings = array(
	'id'			=> 'footer-template',
	'type'			=> 'radioimage',
	'title'			=> esc_html__( 'Footer Template', 'inzofin' ),
	'description'	=> esc_html__( 'Choose footer template. Current footer layout needed option values you can see after refresh this customizer page.', 'inzofin' ),
	'default'		=> '1',
	'items' 		=> array(
		'1'		=> INZOFIN_ADMIN_URL . '/customizer/assets/images/footer-layouts/1.jpg',
		'2'		=> INZOFIN_ADMIN_URL . '/customizer/assets/images/footer-layouts/2.jpg',
		'3'		=> INZOFIN_ADMIN_URL . '/customizer/assets/images/footer-layouts/3.jpg',
		'4'		=> INZOFIN_ADMIN_URL . '/customizer/assets/images/footer-layouts/4.jpg',
		'5'		=> INZOFIN_ADMIN_URL . '/customizer/assets/images/footer-layouts/5.jpg',
		'6'		=> INZOFIN_ADMIN_URL . '/customizer/assets/images/footer-layouts/6.jpg',
		'7'		=> INZOFIN_ADMIN_URL . '/customizer/assets/images/footer-layouts/7.jpg',
		'8'		=> INZOFIN_ADMIN_URL . '/customizer/assets/images/footer-layouts/8.jpg',
		'custom'=> INZOFIN_ADMIN_URL . '/customizer/assets/images/footer-layouts/custom.jpg'
	),
	'cols'			=> '1',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Footer Items
$settings = array(
	'id'			=> 'footer-items',
	'type'			=> 'dragdrop',
	'title'			=> esc_html__( 'Footer Items', 'inzofin' ),
	'description'	=> esc_html__( 'Needed footer items drag from disabled and put enabled.', 'inzofin' ),
	'default' 		=> array(
		'Enabled'  => array(
			'footer-middle'	=> esc_html__( 'Footer Middle', 'inzofin' ),
			'footer-bottom'	=> esc_html__( 'Footer Bottom', 'inzofin' )
		),
		'disabled' => array(
			'footer-top' 	=> esc_html__( 'Footer Top', 'inzofin' )
		)
	),
	'required'		=> array( 'footer-template', '=', 'custom' ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Layout End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );

//Style Start
$settings = array(
	'type'			=> 'toggle_section',
	'label'			=> esc_html__( 'Style', 'inzofin' ),
	'section_stat'	=> true
);
InzofinCustomizerConfig::buildFields( $settings );

//Back to Top
$settings = array(
	'id'			=> 'back-to-top',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Back to Top', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable back to top icon.', 'inzofin' ),
	'default'		=> 1,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Back to Top Button Position
$settings = array(
	'id'			=> 'back-to-top-position',
	'type'			=> 'select',
	'title'			=> esc_html__( 'Back to Top Button Position', 'inzofin' ),
	'description'	=> esc_html__( 'Choose position right/left for back to top button.', 'inzofin' ),
	'choices'		=> array(
		'right'		=> esc_html__( 'Right', 'inzofin' ),
		'left'		=> esc_html__( 'Left', 'inzofin' )
	),
	'default'		=> 'right',
	'required'		=> array( 'back-to-top', '=', 1 ),
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Hidden Footer
$settings = array(
	'id'			=> 'hidden-footer',
	'type'			=> 'toggle',
	'title'			=> esc_html__( 'Hidden Footer', 'inzofin' ),
	'description'	=> esc_html__( 'Enable/Disable hidden footer.', 'inzofin' ),
	'default'		=> 0,
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Footer Link Color
$settings = array(
	'id'			=> 'footer-link-color',
	'type'			=> 'link',
	'title'			=> esc_html__( 'Footer Link Color', 'inzofin' ),
	'description'	=> esc_html__( 'Choose footer general link color.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Footer Border
$settings = array(
	'id'			=> 'footer-border',
	'type'			=> 'border',
	'title'			=> esc_html__( 'Footer Border', 'inzofin' ),
	'description'	=> esc_html__( 'Here you can set border. No need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Footer Padding Option
$settings = array(
	'id'			=> 'footer-padding',
	'type'			=> 'dimension',
	'title'			=> esc_html__( 'Footer Padding Option', 'inzofin' ),
	'description'	=> esc_html__( 'Here no need to put dimension units like px, em etc. Example 10 10 20 10.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Footer Background
$settings = array(
	'id'			=> 'footer-background',
	'type'			=> 'background',
	'title'			=> esc_html__( 'Footer Background', 'inzofin' ),
	'description'	=> esc_html__( 'This is settings for footer background.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Footer Background Overlay
$settings = array(
	'id'			=> 'footer-background-overlay',
	'type'			=> 'alpha',
	'title'			=> esc_html__( 'Footer Background Overlay', 'inzofin' ),
	'description'	=> esc_html__( 'Choose footer background overlay color and opacity.', 'inzofin' ),
	'default'		=> '',
	'refresh'		=> 1
);
InzofinCustomizerConfig::buildFields( $settings );

//Style End
$settings = array(
	'type'			=> 'toggle_section',
	'section_stat'	=> false
);
InzofinCustomizerConfig::buildFields( $settings );