(function( $ ) {
	"use strict";
	jQuery( document ).ready(function() {
		$(".inzofin-post-featured-status").change(function(){
												 
			var postid = $(this).attr('data-post');
			var stat;
			if( $(this).is( ":checked" ) ) {
				stat = 1;
			}else{
				stat = 0;
			}
			$( "#post-featured-stat-msg-" + postid ).text( inzofin_admin_ajax_var.process + "..." );
			if( postid ){
				// Ajax call
				$.ajax({
					type: "post",
					url: ajaxurl,
					data: "action=inzofin-post-featured-active&nonce="+inzofin_admin_ajax_var.featured_nonce+"&featured-stat="+ stat +"&postid="+ postid,
					success: function(data){
						$( "#post-featured-stat-msg-"+ postid ).text( "" );
					}
				});
			}
		});
		$( document ).on( "click", ".export-custom-sidebar", function() {
			// Ajax call
			$.ajax({
				type: "post",
				url: ajaxurl,
				data: "action=inzofin-custom-sidebar-export&nonce="+inzofin_admin_ajax_var.sidebar_nounce,
				success: function( data ){
					
					$("<a />", {
						"download": "custom-sidebars.json",
						"href" : "data:application/json," + encodeURIComponent( data )
					}).appendTo("body").on( "click", function() {
						$(this).remove();
					})[0].click ();
				}
			});
			return false;
		});
		
		if( $( '#import-code-value' ).length ){
			$( document ).on( "click", "#redux-import", function( e ) {
				$( '#redux-import' ).attr( "disabled", "disabled" );
				if ( $( '#import-code-value' ).val() === "" && $( '#import-link-value' ).val() === "" ) {
					e.preventDefault();
					return false;
				}else{
					var json_data = '';
					var stat = '';
					if( $( '#import-code-value' ).val() != "" ){
						json_data = $( '#import-code-value' ).val();
						stat = 'data';
					}else if( $( '#import-link-value' ).val() != "" ){
						json_data = $( '#import-link-value' ).val()
						stat = 'url';
					}
					var post_data = { action: "inzofin-redux-themeopt-import", nonce: inzofin_admin_ajax_var.redux_themeopt_import, json_data : json_data, stat: stat };
					jQuery.post(ajaxurl, post_data, function( response ) {
						location.reload(true);
						$( '#redux-import' ).removeAttr( "disabled" );
					});
					
					return false;
				}
			});
		}

		$(document).find( '.widget-color-field' ).wpColorPicker({
			change: function(event, ui){ 
				$(this).parents("form").find('input[name="savewidget"]').removeAttr("disabled");					
			}
		});
		
		//Save customizer auto load option
		$( document ).on( "change", ".inzofin-customizer-option .switch-checkbox", function( e ) {
			var auto_load_stat = $(this).is(":checked") ? 1 : 0;
			$.ajax({
				type: "post",
				url: ajaxurl,
				data: "action=inzofin-customizer-auto-load&nonce="+inzofin_admin_ajax_var.customizer_nounce+'&auto_load='+auto_load_stat,
				success: function( data ){
					console.log(data);
				}
			});
			return false;
		});
		
		if( $("#zozo-envato-registration-form").length ){
			$("#zozo-envato-registration-form").on( "submit", function(e) {
				e.preventDefault();
				var _form = $("#zozo-envato-registration-form");
				
				//enable loader
				$(_form).find('input[type="submit"]').attr("disabled", "disabled");
				$(_form).find(".process-loader").addClass("active");
				$(_form).find(".verfication-txt").removeClass("active");
				
				var form_data = $(_form).serialize();
				$.ajax({
					type: 'POST',
					url: ajaxurl,
					data: "action=inzofin_theme_verify&"+form_data,
					success: function(data){
						$(_form).find('input[type="submit"]').removeAttr("disabled");
						$(_form).find(".process-loader").removeClass("active");
						console.log(data);
						if( data.error_message ){
							if( data.error_message == 'already' ){
								$(_form).find(".verfication-txt").html(inzofin_admin_ajax_var.already_used);
								$(_form).find(".verfication-txt").addClass("active");
							}else{							
								$(_form).find(".verfication-txt").html(data.error_message);
								$(_form).find(".verfication-txt").addClass("active");
							}
						}else if( data.status && data.status == 'success' ){
							window.location = location.href;
						}
					},
					error: function(response, errorThrown){
						window.location = location.href;
					}
				});
			});
		}
		
		if( $("#zozo-envato-deactivation-form").length ){
			$("#zozo-envato-deactivation-form").on( "submit", function(e) {
				e.preventDefault();
				var _form = $("#zozo-envato-deactivation-form");
				//enable loader
				$(_form).find('input[type="submit"]').attr("disabled", "disabled");
				$(_form).find(".process-loader").addClass("active");
				
				var form_data = $(_form).serialize();
				$.ajax({
					type: 'POST',
					url: ajaxurl,
					data: "action=inzofin_theme_deactivate&"+form_data,
					success: function(data){
						console.log(data);
						$(_form).find('input[type="submit"]').removeAttr("disabled");
						$(_form).find(".process-loader").removeClass("active");
						window.location = location.href;
					},
					error: function(response, errorThrown){
						window.location = location.href;
					}
				});
				
			});
		}
	
	});
	
})(jQuery);