<?php
/**
 * The template for displaying 404 pages (not found)
 *
 */
get_header();

$ahe = new InzofinHeaderElements;
$aps = new InzofinPostSettings;
$template = 'page'; // template id
$aps->inzofin_set_post_template( $template );
$template_class = $aps->inzofin_template_content_class();
?>
<div class="wrap">
	<div id="primary" class="content-area error-404-area inzofin-page">
		<main id="main" class="site-main">
		
			<?php $ahe->inzofin_page_title( $template ); ?>
		
			<section class="error-404 not-found text-center">
				<div class="container">
					<header class="page-header">
						
						<div class="image-wrap-404">
							<img src="<?php echo esc_url( INZOFIN_ASSETS . '/images/404.png' ); ?>" alt="<?php esc_html_e( 'Error 404', 'inzofin' ); ?>">
							
						</div>	
						
						<div class="relative mb-2">
							<h3 class="page-title"><?php esc_html_e( 'Page Not Found', 'inzofin' ); ?></h3>
						</div>
						<?php 
							$home_url = home_url( '/' ); 
						?>
							<p class="error-description">
								<?php esc_html_e( 'Sorry we cannot find that page!', 'inzofin' ); ?>
								<?php esc_html_e( 'Go back to home', 'inzofin' ); ?>
							</p>							
							<a class="home-link" href="<?php echo esc_url( $home_url ); ?>">
								<?php esc_html_e( 'Home Page', 'inzofin' ); ?>
							</a>
					</header><!-- .page-header -->
				</div><!-- .container -->
			</section><!-- .error-404 -->
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .wrap -->
<?php get_footer();
