<?php 
add_action( 'admin_menu', 'inzofin_admin_menu' );
function inzofin_admin_menu() {
	add_submenu_page(
		'inzofin',
		esc_html__( 'Elementor Settings', 'inzofin' ),
		esc_html__( 'Elementor Settings', 'inzofin' ),
		'administrator',
		'inzofin-addons',
		'classic_elementor_addon_admin_page'
	);
}

function change_admin_menu_name(){
	global $submenu;
	if(isset($submenu['inzofin-addons'])){
		$submenu['inzofin-addons'][0][0] = esc_html__( 'Widgets Settings', 'inzofin-core' );
	}
}
add_action( 'admin_menu', 'change_admin_menu_name');    

function classic_elementor_addon_admin_page(){
	?>
	<div class="inzofin-admin-wrap">
		<h1><?php esc_html_e( 'Inzofin Elementor Addons', 'inzofin-core' ); ?></h1>
		<p class="pa-title-sub"><?php esc_html_e( 'Thank you for using Inzofin Elementor Addons for Elementor. This plugin has been developed by ', 'inzofin-core' ); ?><strong><?php echo esc_html( 'zozothemes' ); ?></strong></p>
		
		<?php
			$shortcode_stat = array(
				'animated-text' 	=> esc_html__( 'Animated Text', 'inzofin-core' ),
				'circle-progress'	=> esc_html__( 'Circle Progress', 'inzofin-core' ),
				'contact-form' 		=> esc_html__( 'Contact Form', 'inzofin-core' ),
				'contact-info' 		=> esc_html__( 'Contact Info', 'inzofin-core' ),
				'content-carousel' 	=> esc_html__( 'Content Carousel', 'inzofin-core' ),
				'counter' 			=> esc_html__( 'Counter', 'inzofin-core' ),
				'day-counter' 		=> esc_html__( 'Day Counter', 'inzofin-core' ),
				'feature-box' 		=> esc_html__( 'Feature Box', 'inzofin-core' ),
				'flip-box' 			=> esc_html__( 'Flip Box', 'inzofin-core' ),
				'google-map' 		=> esc_html__( 'Google Map', 'inzofin-core' ),
				'icon' 				=> esc_html__( 'Icon', 'inzofin-core' ),
				'icon-list' 		=> esc_html__( 'Icon List', 'inzofin-core' ),
				'image-grid' 		=> esc_html__( 'Image Grid', 'inzofin-core' ),
				'modal-popup' 		=> esc_html__( 'Modal Popup', 'inzofin-core' ),
				'pricing-table' 	=> esc_html__( 'Pricing Table', 'inzofin-core' ),
				'section-title' 	=> esc_html__( 'Section Title', 'inzofin-core' ),
				'social-links' 		=> esc_html__( 'Social Links', 'inzofin-core' ),
				'timeline' 			=> esc_html__( 'Timeline', 'inzofin-core' ),
				'timeline-slide' 	=> esc_html__( 'Timeline Slide', 'inzofin-core' ),
				'chart' 			=> esc_html__( 'Chart', 'inzofin-core' ),
				'recent-popular' 	=> esc_html__( 'Recent/Popular Post', 'inzofin-core' ),
				'blog' 				=> esc_html__( 'Blog', 'inzofin-core' ),
				'portfolio' 		=> esc_html__( 'Portfolio', 'inzofin-core' ),
				'team' 				=> esc_html__( 'Team', 'inzofin-core' ),
				'event' 			=> esc_html__( 'Event', 'inzofin-core' ),
				'service' 			=> esc_html__( 'Service', 'inzofin-core' ),
				'testimonial' 		=> esc_html__( 'Testimonial', 'inzofin-core' ),
				'toggle-content' 	=> esc_html__( 'Toggle Content', 'inzofin-core' ),
				'mailchimp' 		=> esc_html__( 'Mailchimp', 'inzofin-core' ),
				'popup-anything' 	=> esc_html__( 'Popup Anything', 'inzofin-core' ),
				'popover' 			=> esc_html__( 'Popover', 'inzofin-core' ),
				'round-tab' 		=> esc_html__( 'Round Tab', 'inzofin-core' )
			);
			
			if ( isset( $_POST['save_inzofin_shortcodes_options'] ) && wp_verify_nonce( $_POST['save_inzofin_shortcodes_options'], 'inzofin_plugin_shortcodes_options' ) ) {
				update_option( 'inzofin_shortcodes', $_POST['inzofin_shortcodes'] );
			}
			$inzofin_shortcodes = get_option('inzofin_shortcodes');
			
		?>
		
		<div class="inzofin-admin-content-wrap">
			<form method="post" action="#" enctype="multipart/form-data" id="inzofin-plugin-form-wrapper">
				<?php wp_nonce_field( 'inzofin_plugin_shortcodes_options', 'save_inzofin_shortcodes_options' ); ?>
				<input class="inzofin-plugin-submit button button-primary" type="submit" value="<?php echo esc_attr__( 'Save', 'inzofin-core' ); ?>" />
				<div class="inzofin-shortcodes-container">
			<?php
				$row = 1;
				foreach( $shortcode_stat as $key => $value ){
				
					$shortcode_name = str_replace( "-", "_", $key );
					if( !empty( $inzofin_shortcodes ) ){
						if( isset( $inzofin_shortcodes[$shortcode_name] ) ){
							$saved_val = 'on';
						}else{
							$saved_val = 'off';
						}
					}else{
						$saved_val = 'on';
					}
					$checked_stat = $saved_val == 'on' ? 'checked="checked"' : '';
				
					if( $row % 4 == 1 ) echo '<div class="inzofin-row">';
					
						echo '
						<div class="inzofin-col-3">
							<div class="element-group">
								<h4>'. esc_html( $value ) .'</h4>
								<label class="switch">
									<input class="switch-checkbox" type="checkbox" name="inzofin_shortcodes['. esc_attr( $shortcode_name ) .']" '. $checked_stat .'>
									<span class="slider round"></span>
								</label>
							</div><!-- .element-group -->
						</div><!-- .inzofin-col-2 -->';
									
					if( $row % 4 == 0 ) echo '</div><!-- .inzofin-row -->';
					$row++;
				}
				
				if( $row % 4 != 1 ) echo '</div><!-- .inzofin-row unexpceted close -->';
			?>
				</div> <!-- .inzofin-shortcodes-container -->
			</form>
		</div><!-- .inzofin-admin-content-wrap -->
		
		<div class="inzofin-customizer-options-wrap">
			<h2><?php esc_html_e( 'Enable/Disable Customizer Auto Refresh Option', 'inzofin-core' ); ?></h2>
			<?php 
				$customizer_auto_load = get_option( 'inzofin_customizer_auto_load' );;
				$checked_stat = $customizer_auto_load == '1' ? 'checked="checked"' : '';
			?>
			<div class="inzofin-customizer-option">
				<label class="switch">
					<input class="switch-checkbox" type="checkbox" <?php echo ''. $checked_stat ?>>
					<span class="slider round"></span>
				</label>
			</div>
			<p><?php esc_html_e( 'If you want to live editor experience, Just turn on this option. No need to auto load customizer editor for every option change means turn off this option.' ); ?></p>
		</div><!-- .inzofin-customizer-options-wrap -->
		
	</div><!-- .inzofin-admin-wrap -->
	<?php
}

add_action('wp_ajax_inzofin-customizer-auto-load', 'inzofin_customizer_auto_load_option');
function inzofin_customizer_auto_load_option(){
	$nonce = $_POST['nonce'];
  
    if ( ! wp_verify_nonce( $nonce, 'inzofin-customizer-#$%&*(' ) )
        die ( esc_html__( 'Busted!', 'inzofin' ) );
	
	$auto_load = isset( $_POST['auto_load'] ) && $_POST['auto_load'] == '1' ? 1 : 0;
	update_option( 'inzofin_customizer_auto_load', $auto_load );
	echo 'success';
	exit;
}