<?php
/* Inzofin Page Options */
$prefix = 'inzofin_post_';
$fields = array(
	array( 
		'label'	=> esc_html__( 'Post General Settings', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are single post general settings.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Post Layout', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose post layout for current post single view.', 'inzofin-core' ), 
		'id'	=> $prefix.'layout',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'wide' => esc_html__( 'Wide', 'inzofin-core' ),
			'boxed' => esc_html__( 'Boxed', 'inzofin-core' )			
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Post Content Padding Option', 'inzofin-core' ),
		'id'	=> $prefix.'content_padding_opt',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'		
	),
	array( 
		'label'	=> esc_html__( 'Post Content Padding', 'inzofin-core' ), 
		'desc'	=> esc_html__( 'Set the top/right/bottom/left padding of post content.', 'inzofin-core' ),
		'id'	=> $prefix.'content_padding',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'space',
		'required'	=> array( $prefix.'content_padding_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Template Option', 'inzofin-core' ),
		'id'	=> $prefix.'template_opt',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'		
	),
	array( 
		'label'	=> esc_html__( 'Post Template', 'inzofin-core' ),
		'id'	=> $prefix.'template',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'image_select',
		'options' => array(
			'no-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/1.png' ), 
			'right-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/2.png' ), 
			'left-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/3.png' ), 
			'both-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/4.png' ), 
		),
		'default'	=> 'right-sidebar',
		'required'	=> array( $prefix.'template_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Left Sidebar', 'inzofin-core' ),
		'id'	=> $prefix.'left_sidebar',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'template_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Right Sidebar', 'inzofin-core' ),
		'id'	=> $prefix.'right_sidebar',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'template_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Sidebar On Mobile', 'inzofin-core' ),
		'id'	=> $prefix.'sidebar_mobile',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'1' => esc_html__( 'Show', 'inzofin-core' ),
			'0' => esc_html__( 'Hide', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Featured Slider', 'inzofin-core' ),
		'id'	=> $prefix.'featured_slider',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'1' => esc_html__( 'Enable', 'inzofin-core' ),
			'0' => esc_html__( 'Disable', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Full Width Wrap', 'inzofin-core' ),
		'id'	=> $prefix.'full_wrap',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'1' => esc_html__( 'Enable', 'inzofin-core' ),
			'0' => esc_html__( 'Disable', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Post Items Option', 'inzofin-core' ),
		'id'	=> $prefix.'items_opt',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'		
	),
	array( 
		'label'	=> esc_html__( 'Post Items', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Needed single post items drag from disabled and put enabled part.', 'inzofin-core' ),
		'id'	=> $prefix.'items',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'dragdrop_multi',
		'dd_fields' => array ( 
			'Enabled'  => array(
				'title' 	=> esc_html__( 'Title', 'inzofin-core' ),
				'top-meta'	=> esc_html__( 'Top Meta', 'inzofin-core' ),
				'thumb' 	=> esc_html__( 'Thumbnail', 'inzofin-core' ),
				'content' 	=> esc_html__( 'Content', 'inzofin-core' ),
				'bottom-meta'		=> esc_html__( 'Bottom Meta', 'inzofin-core' )
			),
			'disabled' => array()
		),
		'required'	=> array( $prefix.'items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Overlay', 'inzofin-core' ),
		'id'	=> $prefix.'overlay_opt',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'1' => esc_html__( 'Enable', 'inzofin-core' ),
			'0' => esc_html__( 'Disable', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Post Overlay Items', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Needed overlay post items drag from disabled and put enabled part.', 'inzofin-core' ),
		'id'	=> $prefix.'overlay_items',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'dragdrop_multi',
		'dd_fields' => array ( 
			'Enabled'  => array(
				'title' 	=> esc_html__( 'Title', 'inzofin-core' )
			),
			'disabled' => array(
				'top-meta'	=> esc_html__( 'Top Meta', 'inzofin-core' ),
				'bottom-meta'		=> esc_html__( 'Bottom Meta', 'inzofin-core' )
			)
		),
		'required'	=> array( $prefix.'overlay_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Page Items Option', 'inzofin-core' ),
		'id'	=> $prefix.'page_items_opt',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'		
	),
	array( 
		'label'	=> esc_html__( 'Post Page Items', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Needed post page items drag from disabled and put enabled part.', 'inzofin-core' ),
		'id'	=> $prefix.'page_items',
		'tab'	=> esc_html__( 'General', 'inzofin-core' ),
		'type'	=> 'dragdrop_multi',
		'dd_fields' => array ( 
			'Enabled'  => array(
				'post-items' 	=> esc_html__( 'Post Items', 'inzofin-core' ),
				'author-info'	=> esc_html__( 'Author Info', 'inzofin-core' ),
				'related-slider'=> esc_html__( 'Related Slider', 'inzofin-core' ),
				'post-nav' 	=> esc_html__( 'Post Nav', 'inzofin-core' ),
				'comment' 	=> esc_html__( 'Comment', 'inzofin-core' )
			),
			'disabled' => array()
		),
		'default'	=> 'post-items,author-info,related-slider,post-nav,comment',
		'required'	=> array( $prefix.'page_items_opt', 'custom' )
	),
	//Header
	array( 
		'label'	=> esc_html__( 'Header General Settings', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header general settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Layout', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose post layout for current post header layout.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_layout',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'wide' => esc_html__( 'Wide', 'inzofin-core' ),
			'boxed' => esc_html__( 'Boxed', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Type', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose post layout for current post header type.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_type',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'default' => esc_html__( 'Default', 'inzofin-core' ),
			'left-sticky' => esc_html__( 'Left Sticky', 'inzofin-core' ),
			'right-sticky' => esc_html__( 'Right Sticky', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Background Image', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header background image for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'image',
		'id'	=> $prefix.'header_bg_img',
		'required'	=> array( $prefix.'header_type', 'default' )
	),
	array( 
		'label'	=> esc_html__( 'Header Items Options', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_items_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Items', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header general items for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'header_items',
		'dd_fields' => array ( 
			'Normal' => array( 
				'header-topbar' 	=> esc_html__( 'Topbar', 'inzofin-core' ),
				'header-logo'	=> esc_html__( 'Logo Bar', 'inzofin-core' )
			),
			'Sticky' => array( 
				'header-nav' 	=> esc_html__( 'Navbar', 'inzofin-core' )
			),
			'disabled' => array()
		),
		'required'	=> array( $prefix.'header_items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Absolute Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header absolute to change header look transparent.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_absolute_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'1' => esc_html__( 'Enable', 'inzofin-core' ),
			'0' => esc_html__( 'Disable', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header sticky options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_sticky_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'sticky' => esc_html__( 'Header Sticky Part', 'inzofin-core' ),
			'sticky-scroll' => esc_html__( 'Sticky Scroll Up', 'inzofin-core' ),
			'none' => esc_html__( 'None', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header topbar settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Options', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_topbar_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Height', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header topbar height for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_topbar_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_topbar_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Height', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header topbar sticky height for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_topbar_sticky_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_topbar_opt', 'custom' )
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are header topbar skin settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Skin Settings', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header topbar skin settings options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_topbar_skin_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header topbar font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_topbar_font',
		'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Background', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header topbar background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_topbar_bg',
		'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header topbar link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_topbar_link',
		'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header topbar border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_topbar_border',
		'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header topbar padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_topbar_padding',
		'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Skin Settings', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header top bar sticky skin settings options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_topbar_sticky_skin_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header top bar sticky font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_topbar_sticky_font',
		'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Background', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header top bar sticky background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_topbar_sticky_bg',
		'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header top bar sticky link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_topbar_sticky_link',
		'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header top bar sticky border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_topbar_sticky_border',
		'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Sticky Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header top bar sticky padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_topbar_sticky_padding',
		'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Items Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header topbar items enable options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_topbar_items_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Top Bar Items', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header topbar items for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'header_topbar_items',
		'dd_fields' => array ( 
			'Left'  => array(
				'header-topbar-date' => esc_html__( 'Date', 'inzofin-core' ),						
			),
			'Center' => array(),
			'Right' => array(),
			'disabled' => array(
				'header-topbar-text-1'	=> esc_html__( 'Custom Text 1', 'inzofin-core' ),
				'header-topbar-text-2'	=> esc_html__( 'Custom Text 2', 'inzofin-core' ),
				'header-topbar-text-3'	=> esc_html__( 'Custom Text 3', 'inzofin-core' ),
				'header-topbar-menu'    => esc_html__( 'Top Bar Menu', 'inzofin-core' ),
				'header-topbar-social'	=> esc_html__( 'Social', 'inzofin-core' ),
				'header-topbar-search'	=> esc_html__( 'Search', 'inzofin-core' )
			)
		),
		'required'	=> array( $prefix.'header_topbar_items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Options', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_logo_bar_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Height', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar height for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_logo_bar_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_logo_bar_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Height', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky height for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_logo_bar_sticky_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_logo_bar_opt', 'custom' )
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are header logo bar skin settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Skin Settings', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header logo bar skin settings options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_logo_bar_skin_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_logo_bar_font',
		'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Background', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_logo_bar_bg',
		'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_logo_bar_link',
		'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_logo_bar_border',
		'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_logo_bar_padding',
		'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Skin Settings', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header logo bar sticky skin settings options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_logobar_sticky_skin_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_logobar_sticky_font',
		'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Background', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_logobar_sticky_bg',
		'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_logobar_sticky_link',
		'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_logobar_sticky_border',
		'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Sticky Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar sticky padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_logobar_sticky_padding',
		'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Items Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header logo bar items enable options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_logo_bar_items_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Logo Bar Items', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header logo bar items for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'header_logo_bar_items',
		'dd_fields' => array ( 
			'Left'  => array(
				'header-logobar-logo'		=> esc_html__( 'Logo', 'inzofin-core' ),
				'header-logobar-sticky-logo' => esc_html__( 'Sticky Logo', 'inzofin-core' )											
			),
			'Center' => array(),
			'Right' => array(),
			'disabled' => array(
				'header-logobar-social'		=> esc_html__( 'Social', 'inzofin-core' ),
				'header-logobar-search'		=> esc_html__( 'Search', 'inzofin-core' ),
				'header-logobar-secondary-toggle'	=> esc_html__( 'Secondary Toggle', 'inzofin-core' ),	
				'header-phone'   			=> esc_html__( 'Phone Number', 'inzofin-core' ),
				'header-address'  			=> esc_html__( 'Address Text', 'inzofin-core' ),
				'header-email'   			=> esc_html__( 'Email', 'inzofin-core' ),
				'header-logobar-menu'   	=> esc_html__( 'Main Menu', 'inzofin-core' ),
				'header-logobar-search-toggle'	=> esc_html__( 'Search Toggle', 'inzofin-core' ),
				'header-logobar-text-1'		=> esc_html__( 'Custom Text 1', 'inzofin-core' ),
				'header-logobar-text-2'		=> esc_html__( 'Custom Text 2', 'inzofin-core' ),
				'header-logobar-text-3'		=> esc_html__( 'Custom Text 3', 'inzofin-core' ),	
				'header-cart'   			=> esc_html__( 'Cart', 'inzofin-core' ),
				'header-wishlist'   		=> esc_html__( 'Wishlist', 'inzofin-core' ),
				'multi-info'   				=> esc_html__( 'Address, Phone, Email', 'inzofin-core' )
			)
		),
		'required'	=> array( $prefix.'header_logo_bar_items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Options', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_navbar_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Height', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar height for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_navbar_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_navbar_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Height', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky height for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_navbar_sticky_height',
		'property' => 'height',
		'required'	=> array( $prefix.'header_navbar_opt', 'custom' )
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are header navbar skin settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Skin Settings', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header navbar skin settings options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_navbar_skin_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_navbar_font',
		'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Background', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_navbar_bg',
		'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_navbar_link',
		'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_navbar_border',
		'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_navbar_padding',
		'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Skin Settings', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header navbar sticky skin settings options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_navbar_sticky_skin_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_navbar_sticky_font',
		'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Background', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_navbar_sticky_bg',
		'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_navbar_sticky_link',
		'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_navbar_sticky_border',
		'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Sticky Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar sticky padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_navbar_sticky_padding',
		'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Items Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header navbar items enable options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_navbar_items_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Navbar Items', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header navbar items for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'header_navbar_items',
		'dd_fields' => array ( 
			'Left'  => array(											
				'header-navbar-menu'    => esc_html__( 'Main Menu', 'inzofin-core' ),
			),
			'Center' => array(
			),
			'Right' => array(
				'header-navbar-search'	=> esc_html__( 'Search', 'inzofin-core' ),
			),
			'disabled' => array(
				'header-navbar-text-1'	=> esc_html__( 'Custom Text 1', 'inzofin-core' ),
				'header-navbar-text-2'	=> esc_html__( 'Custom Text 2', 'inzofin-core' ),
				'header-navbar-text-3'	=> esc_html__( 'Custom Text 3', 'inzofin-core' ),
				'header-navbar-logo'	=> esc_html__( 'Logo', 'inzofin-core' ),
				'header-navbar-social'	=> esc_html__( 'Social', 'inzofin-core' ),
				'header-navbar-secondary-toggle'	=> esc_html__( 'Secondary Toggle', 'inzofin-core' ),
				'header-navbar-search-toggle'	=> esc_html__( 'Search Toggle', 'inzofin-core' ),
				'header-navbar-sticky-logo'	=> esc_html__( 'Stikcy Logo', 'inzofin-core' ),
				'header-cart'   		=> esc_html__( 'Cart', 'inzofin-core' )
			)
		),
		'required'	=> array( $prefix.'header_navbar_items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header sticky settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Options', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header sticky part option.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_stikcy_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Width', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky part width for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dimension',
		'id'	=> $prefix.'header_stikcy_width',
		'property' => 'width',
		'required'	=> array( $prefix.'header_stikcy_opt', 'custom' )
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are header Sticky skin settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Skin Settings', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header Sticky skin settings options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_stikcy_skin_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'header_stikcy_font',
		'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Background', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'header_stikcy_bg',
		'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'header_stikcy_link',
		'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',

		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'header_stikcy_border',
		'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'header_stikcy_padding',
		'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Items Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose header Sticky items enable options.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_stikcy_items_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Header Sticky/Fixed Part Items', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are header Sticky items for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'header_stikcy_items',
		'dd_fields' => array ( 
			'Top'  => array(
				'header-fixed-logo' => esc_html__( 'Logo', 'inzofin-core' )
			),
			'Middle'  => array(
				'header-fixed-menu'	=> esc_html__( 'Menu', 'inzofin-core' )					
			),
			'Bottom'  => array(
				'header-fixed-social'	=> esc_html__( 'Social', 'inzofin-core' )					
			),
			'disabled' => array(
				'header-fixed-text-1'	=> esc_html__( 'Custom Text 1', 'inzofin-core' ),
				'header-fixed-text-2'	=> esc_html__( 'Custom Text 2', 'inzofin-core' ),				
				'header-fixed-search'	=> esc_html__( 'Search Form', 'inzofin-core' )
			)
		),
		'required'	=> array( $prefix.'header_stikcy_items_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Bar', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are post title bar settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Post Title Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose post title enable or disable.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_post_title_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'1' => esc_html__( 'Enable', 'inzofin-core' ),
			'0' => esc_html__( 'Disable', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Post Title Text', 'inzofin-core' ),
		'desc'	=> esc_html__( 'If this post title is empty, then showing current post default title.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_post_title_text',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'text',
		'default'	=> '',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Description', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Enter post title description.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_post_title_desc',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'textarea',
		'default'	=> '',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Background Parallax', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose post title background parallax.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_post_title_parallax',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'1' => esc_html__( 'Enable', 'inzofin-core' ),
			'0' => esc_html__( 'Disable', 'inzofin-core' )
		),
		'default'	=> 'theme-default',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Background Video Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose post title background video option.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_post_title_video_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'1' => esc_html__( 'Enable', 'inzofin-core' ),
			'0' => esc_html__( 'Disable', 'inzofin-core' )
		),
		'default'	=> 'theme-default',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Background Video', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Enter youtube video ID. Example: ZSt9tm3RoUU.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_post_title_video',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'text',
		'default'	=> '',
		'required'	=> array( $prefix.'header_post_title_video_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Bar Items Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose post title bar items option.', 'inzofin-core' ), 
		'id'	=> $prefix.'post_title_items_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Bar Items', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are post title bar items for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'post_title_items',
		'dd_fields' => array ( 
			'Left'  => array(
				'title' => esc_html__( 'Post Title Text', 'inzofin-core' ),
			),
			'Center'  => array(
				
			),
			'Right'  => array(
				'breadcrumb'	=> esc_html__( 'Breadcrumb', 'inzofin-core' )
			),
			'disabled' => array()
		),
		'required'	=> array( $prefix.'post_title_items_opt', 'custom' )
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are post title skin settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'label',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Skin Settings', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose post title skin settings options.', 'inzofin-core' ), 
		'id'	=> $prefix.'post_title_skin_opt',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default',
		'required'	=> array( $prefix.'header_post_title_opt', '1' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are post title font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'post_title_font',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Background Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are post title background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'post_title_bg',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Background Image', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Enter post title background image url.', 'inzofin-core' ), 
		'id'	=> $prefix.'post_title_bg_img',
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'url',
		'default'	=> '',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are post title link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'post_title_link',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are post title border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'post_title_border',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are post title padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'post_title_padding',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Post Title Overlay', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are post title overlay color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'post_title_overlay',
		'required'	=> array( $prefix.'post_title_skin_opt', 'custom' )
	),
	//Footer
	array( 
		'label'	=> 'Footer General',
		'desc'	=> esc_html__( 'These all are header footer settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Layout', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer layout for current post.', 'inzofin-core' ), 
		'id'	=> $prefix.'footer_layout',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'wide' => esc_html__( 'Wide', 'inzofin-core' ),
			'boxed' => esc_html__( 'Boxed', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Hidden Footer', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose hidden footer option.', 'inzofin-core' ), 
		'id'	=> $prefix.'hidden_footer',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'1' => esc_html__( 'Enable', 'inzofin-core' ),
			'0' => esc_html__( 'Disable', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are footer skin settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Skin Settings', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer skin settings options.', 'inzofin-core' ), 
		'id'	=> $prefix.'footer_skin_opt',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_font',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Background Image', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer background image for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'image',
		'id'	=> $prefix.'footer_bg_img',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Background Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_bg',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Background Overlay', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer background overlay color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'footer_bg_overlay',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'footer_link',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'footer_border',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'footer_padding',
		'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Items Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer items enable options.', 'inzofin-core' ), 
		'id'	=> $prefix.'footer_items_opt',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Items', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer items for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'footer_items',
		'dd_fields' => array ( 
			'Enabled'  => array(
				'footer-bottom'	=> esc_html__( 'Footer Bottom', 'inzofin-core' )
			),
			'disabled' => array(
				'footer-top' => esc_html__( 'Footer Top', 'inzofin-core' ),
				'footer-middle'	=> esc_html__( 'Footer Middle', 'inzofin-core' )
			)
		),
		'required'	=> array( $prefix.'footer_items_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Top',
		'desc'	=> esc_html__( 'These all are footer top settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Skin', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer top skin options.', 'inzofin-core' ), 
		'id'	=> $prefix.'footer_top_skin_opt',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer top font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_top_font',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Widget Title color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer top widget title color.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_top_widget_title_color',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Background', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'footer_top_bg',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer top link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'footer_top_link',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer top border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'footer_top_border',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Top Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer top padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'footer_top_padding',
		'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Top Columns and Sidebars Settings',
		'desc'	=> esc_html__( 'These all are footer top columns and sidebar settings.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Layout Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer layout option.', 'inzofin-core' ), 
		'id'	=> $prefix.'footer_top_layout_opt',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Layout', 'inzofin-core' ),
		'id'	=> $prefix.'footer_top_layout',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'image_select',
		'options' => array(
			'3-3-3-3'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-1.png',
			'4-4-4'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-2.png',
			'3-6-3'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-3.png',
			'6-6'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-4.png',
			'9-3'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-5.png',
			'3-9'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-6.png',
			'4-2-2-2-2'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-8.png',
			'6-2-2-2'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-9.png',
			'12'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-7.png'
		),
		'default'	=> '4-4-4',
		'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer First Column',
		'desc'	=> esc_html__( 'Select footer first column widget.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'id'	=> $prefix.'footer_top_sidebar_1',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Second Column',
		'desc'	=> esc_html__( 'Select footer second column widget.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'id'	=> $prefix.'footer_top_sidebar_2',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Third Column',
		'desc'	=> esc_html__( 'Select footer third column widget.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'id'	=> $prefix.'footer_top_sidebar_3',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Fourth Column',
		'desc'	=> esc_html__( 'Select footer fourth column widget.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'id'	=> $prefix.'footer_top_sidebar_4',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Middle',
		'desc'	=> esc_html__( 'These all are footer middle settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Skin', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer middle skin options.', 'inzofin-core' ), 
		'id'	=> $prefix.'footer_middle_skin_opt',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer middle font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_middle_font',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Widget Title Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer middle widget title color.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_middle_widget_title_color',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Background', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'footer_middle_bg',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer middle link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'footer_middle_link',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer middle border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'footer_middle_border',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Middle Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer middle padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'footer_middle_padding',
		'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Middle Columns and Sidebars Settings',
		'desc'	=> esc_html__( 'These all are footer middle columns and sidebar settings.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Layout Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer layout option.', 'inzofin-core' ), 
		'id'	=> $prefix.'footer_middle_layout_opt',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Layout', 'inzofin-core' ),
		'id'	=> $prefix.'footer_middle_layout',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'image_select',
		'options' => array(
			'3-3-3-3'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-1.png',
			'4-4-4'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-2.png',
			'3-6-3'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-3.png',
			'6-6'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-4.png',
			'9-3'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-5.png',
			'3-9'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-6.png',
			'4-2-2-2-2'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-8.png',
			'6-2-2-2'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-9.png',
			'12'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-7.png'
		),
		'default'	=> '4-4-4',
		'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer First Column',
		'desc'	=> esc_html__( 'Select footer first column widget.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'id'	=> $prefix.'footer_middle_sidebar_1',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Second Column',
		'desc'	=> esc_html__( 'Select footer second column widget.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'id'	=> $prefix.'footer_middle_sidebar_2',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Third Column',
		'desc'	=> esc_html__( 'Select footer third column widget.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'id'	=> $prefix.'footer_middle_sidebar_3',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Fourth Column',
		'desc'	=> esc_html__( 'Select footer fourth column widget.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'id'	=> $prefix.'footer_middle_sidebar_4',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
	),
	array( 
		'label'	=> 'Footer Bottom',
		'desc'	=> esc_html__( 'These all are footer bottom settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Fixed', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer bottom fixed option.', 'inzofin-core' ), 
		'id'	=> $prefix.'footer_bottom_fixed',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'1' => esc_html__( 'Enable', 'inzofin-core' ),
			'0' => esc_html__( 'Disable', 'inzofin-core' )			
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> '',
		'desc'	=> esc_html__( 'These all are footer bottom skin settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Skin', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer bottom skin options.', 'inzofin-core' ), 
		'id'	=> $prefix.'footer_bottom_skin_opt',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Font Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom font color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'color',
		'id'	=> $prefix.'footer_bottom_font',
		'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Background', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom background color for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'alpha_color',
		'id'	=> $prefix.'footer_bottom_bg',
		'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Link Color', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom link color settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'link_color',
		'id'	=> $prefix.'footer_bottom_link',
		'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Border', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom border settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'space',
		'color' => 1,
		'border_style' => 1,
		'id'	=> $prefix.'footer_bottom_border',
		'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Padding', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom padding settings for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'space',
		'id'	=> $prefix.'footer_bottom_padding',
		'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Widget Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer bottom widget options.', 'inzofin-core' ), 
		'id'	=> $prefix.'footer_bottom_widget_opt',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> 'Footer Bottom Widget',
		'desc'	=> esc_html__( 'Select footer bottom widget.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'id'	=> $prefix.'footer_bottom_widget',
		'type'	=> 'sidebar',
		'required'	=> array( $prefix.'footer_bottom_widget_opt', 'custom' )
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Items Option', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose footer bottom items options.', 'inzofin-core' ), 
		'id'	=> $prefix.'footer_bottom_items_opt',
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Footer Bottom Items', 'inzofin-core' ),
		'desc'	=> esc_html__( 'These all are footer bottom items for current post.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
		'type'	=> 'dragdrop_multi',
		'id'	=> $prefix.'footer_bottom_items',
		'dd_fields' => array ( 
			'Left'  => array(
				'copyright' => esc_html__( 'Copyright Text', 'inzofin-core' )
			),
			'Center'  => array(
				'menu'	=> esc_html__( 'Footer Menu', 'inzofin-core' )
			),
			'Right'  => array(),
			'disabled' => array(
				'social'	=> esc_html__( 'Footer Social Links', 'inzofin-core' ),
				'widget'	=> esc_html__( 'Custom Widget', 'inzofin-core' )
			)
		),
		'required'	=> array( $prefix.'footer_bottom_items_opt', 'custom' )
	),
	//Header Slider
	array( 
		'label'	=> esc_html__( 'Slider', 'inzofin-core' ),
		'desc'	=> esc_html__( 'This header slider settings.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Slider', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Slider Option', 'inzofin-core' ),
		'id'	=> $prefix.'header_slider_opt',
		'tab'	=> esc_html__( 'Slider', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'bottom' => esc_html__( 'Below Header', 'inzofin-core' ),
			'top' => esc_html__( 'Above Header', 'inzofin-core' ),
			'none' => esc_html__( 'None', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Slider Shortcode', 'inzofin-core' ),
		'desc'	=> esc_html__( 'This is the place for enter slider shortcode. Example revolution slider shortcodes.', 'inzofin-core' ), 
		'id'	=> $prefix.'header_slider',
		'tab'	=> esc_html__( 'Slider', 'inzofin-core' ),
		'type'	=> 'textarea',
		'default'	=> ''
	),
	//Post Format
	array( 
		'label'	=> esc_html__( 'Video', 'inzofin-core' ),
		'desc'	=> esc_html__( 'This part for if you choosed video format, then you must choose video type and give video id.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Video Modal', 'inzofin-core' ),
		'id'	=> $prefix.'video_modal',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'onclick' => esc_html__( 'On Click Run Video', 'inzofin-core' ),
			'overlay' => esc_html__( 'Modal Box Video', 'inzofin-core' ),
			'direct' => esc_html__( 'Direct Video', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Video Type', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose video type.', 'inzofin-core' ), 
		'id'	=> $prefix.'video_type',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'' => esc_html__( 'None', 'inzofin-core' ),
			'youtube' => esc_html__( 'Youtube', 'inzofin-core' ),
			'vimeo' => esc_html__( 'Vimeo', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom Video', 'inzofin-core' )
		),
		'default'	=> ''
	),
	array( 
		'label'	=> esc_html__( 'Video ID', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Enter Video ID Example: ZSt9tm3RoUU. If you choose custom video type then you enter custom video url and video must be mp4 format.', 'inzofin-core' ), 
		'id'	=> $prefix.'video_id',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'text',
		'default'	=> ''
	),
	array( 
		'type'	=> 'line',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' )
	),
	array( 
		'label'	=> esc_html__( 'Audio', 'inzofin-core' ),
		'desc'	=> esc_html__( 'This part for if you choosed audio format, then you must give audio id.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Audio Type', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Choose audio type.', 'inzofin-core' ), 
		'id'	=> $prefix.'audio_type',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'' => esc_html__( 'None', 'inzofin-core' ),
			'soundcloud' => esc_html__( 'Soundcloud', 'inzofin-core' ),
			'custom' => esc_html__( 'Custom Audio', 'inzofin-core' )
		),
		'default'	=> ''
	),
	array( 
		'label'	=> esc_html__( 'Audio ID', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Enter soundcloud audio ID. Example: 315307209.', 'inzofin-core' ), 
		'id'	=> $prefix.'audio_id',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'text',
		'default'	=> ''
	),
	array( 
		'type'	=> 'line',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' )
	),
	array( 
		'label'	=> esc_html__( 'Gallery', 'inzofin-core' ),
		'desc'	=> esc_html__( 'This part for if you choosed gallery format, then you must choose gallery images here.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Gallery Modal', 'inzofin-core' ),
		'id'	=> $prefix.'gallery_modal',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'default' => esc_html__( 'Default Gallery', 'inzofin-core' ),
			'popup' => esc_html__( 'Popup Gallery', 'inzofin-core' ),
			'grid' => esc_html__( 'Grid Popup Gallery', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Choose Gallery Images', 'inzofin-core' ),
		'id'	=> $prefix.'gallery',
		'type'	=> 'gallery',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' )
	),
	array( 
		'type'	=> 'line',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' )
	),
	array( 
		'label'	=> esc_html__( 'Quote', 'inzofin-core' ),
		'desc'	=> esc_html__( 'This part for if you choosed quote format, then you must fill the quote text and author name box.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Quote Modal', 'inzofin-core' ),
		'id'	=> $prefix.'quote_modal',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'featured' => esc_html__( 'Dark Overlay', 'inzofin-core' ),
			'theme-overlay' => esc_html__( 'Theme Overlay', 'inzofin-core' ),
			'theme' => esc_html__( 'Theme Color Background', 'inzofin-core' ),
			'none' => esc_html__( 'None', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Quote Text', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Enter quote text.', 'inzofin-core' ), 
		'id'	=> $prefix.'quote_text',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'textarea',
		'default'	=> ''
	),
	array( 
		'label'	=> esc_html__( 'Quote Author', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Enter quote author name.', 'inzofin-core' ), 
		'id'	=> $prefix.'quote_author',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'text',
		'default'	=> ''
	),
	array( 
		'type'	=> 'line',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' )
	),
	array( 
		'label'	=> esc_html__( 'Link', 'inzofin-core' ),
		'desc'	=> esc_html__( 'This part for if you choosed link format, then you must fill the external link box.', 'inzofin-core' ), 
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'label'
	),
	array( 
		'label'	=> esc_html__( 'Link Modal', 'inzofin-core' ),
		'id'	=> $prefix.'link_modal',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'select',
		'options' => array ( 
			'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
			'featured' => esc_html__( 'Dark Overlay', 'inzofin-core' ),
			'theme-overlay' => esc_html__( 'Theme Overlay', 'inzofin-core' ),
			'theme' => esc_html__( 'Theme Color Background', 'inzofin-core' ),
			'none' => esc_html__( 'None', 'inzofin-core' )
		),
		'default'	=> 'theme-default'
	),
	array( 
		'label'	=> esc_html__( 'Link Text', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Enter link text to show.', 'inzofin-core' ), 
		'id'	=> $prefix.'link_text',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'text',
		'default'	=> ''
	),
	array( 
		'label'	=> esc_html__( 'External Link', 'inzofin-core' ),
		'desc'	=> esc_html__( 'Enter external link.', 'inzofin-core' ), 
		'id'	=> $prefix.'extrenal_link',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
		'type'	=> 'url',
		'default'	=> ''
	),
	array( 
		'type'	=> 'line',
		'tab'	=> esc_html__( 'Format', 'inzofin-core' )
	),
	
);
/**
 * Instantiate the class with all variables to create a meta box
 * var $id string meta box id
 * var $title string title
 * var $fields array fields
 * var $page string|array post type to add meta box to
 * var $js bool including javascript or not
 */
 
$post_box = new Custom_Add_Meta_Box( 'inzofin_post_metabox', esc_html__( 'Inzofin Post Options', 'inzofin-core' ), $fields, 'post', true );

/* Inzofin Page Options */
function inzofin_metabox_fields( $prefix ){
	
	$inzofin_menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
	$inzofin_nav_menus = array( "none" => esc_html__( "None", "inzofin" ) );
	foreach( $inzofin_menus as $menu ){
		$inzofin_nav_menus[$menu->slug] = $menu->name;
	}
			
	$fields = array(
		array( 
			'label'	=> esc_html__( 'Page General Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are page general settings.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'General', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Page Layout', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose page layout for current post single view.', 'inzofin-core' ), 
			'id'	=> $prefix.'layout',
			'tab'	=> esc_html__( 'General', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'wide' => esc_html__( 'Wide', 'inzofin-core' ),
				'boxed' => esc_html__( 'Boxed', 'inzofin-core' )			
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Page Content Padding Option', 'inzofin-core' ),
			'id'	=> $prefix.'content_padding_opt',
			'tab'	=> esc_html__( 'General', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'		
		),
		array( 
			'label'	=> esc_html__( 'Page Content Padding', 'inzofin-core' ), 
			'desc'	=> esc_html__( 'Set the top/right/bottom/left padding of page content.', 'inzofin-core' ),
			'id'	=> $prefix.'content_padding',
			'tab'	=> esc_html__( 'General', 'inzofin-core' ),
			'type'	=> 'space',
			'required'	=> array( $prefix.'content_padding_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Background Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose color setting for current page background.', 'inzofin-core' ),
			'tab'	=> esc_html__( 'General', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'main_bg_color'
		),
		array( 
				'label'	=> esc_html__( 'Page Background Image', 'inzofin-core' ),
				'desc'	=> esc_html__( 'Choose custom logo image for current page.', 'inzofin-core' ), 
				'tab'	=> esc_html__( 'General', 'inzofin-core' ),
				'type'	=> 'image',
				'id'	=> $prefix.'main_bg_image'
			),
		array( 
			'label'	=> esc_html__( 'Page Margin', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are margin settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'General', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'main_margin'
		),
		array( 
			'label'	=> esc_html__( 'Page Template Option', 'inzofin-core' ),
			'id'	=> $prefix.'template_opt',
			'tab'	=> esc_html__( 'General', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'		
		),
		array( 
			'label'	=> esc_html__( 'Page Template', 'inzofin-core' ),
			'id'	=> $prefix.'template',
			'tab'	=> esc_html__( 'General', 'inzofin-core' ),
			'type'	=> 'image_select',
			'options' => array(
				'no-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/1.png' ), 
				'right-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/2.png' ), 
				'left-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/3.png' ), 
				'both-sidebar'	=> get_theme_file_uri( '/assets/images/page-layouts/4.png' ), 
			),
			'default'	=> 'right-sidebar',
			'required'	=> array( $prefix.'template_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Left Sidebar', 'inzofin-core' ),
			'id'	=> $prefix.'left_sidebar',
			'tab'	=> esc_html__( 'General', 'inzofin-core' ),
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'template_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Right Sidebar', 'inzofin-core' ),
			'id'	=> $prefix.'right_sidebar',
			'tab'	=> esc_html__( 'General', 'inzofin-core' ),
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'template_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Sidebar On Mobile', 'inzofin-core' ),
			'id'	=> $prefix.'sidebar_mobile',
			'tab'	=> esc_html__( 'General', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'1' => esc_html__( 'Show', 'inzofin-core' ),
				'0' => esc_html__( 'Hide', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header General Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header general settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Extra Class', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter extra class name for additional class name for header.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_extra_class',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'One Page Menu Offset', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter one page menu offset for desktop menu.', 'inzofin-core' ), 
			'id'	=> $prefix.'one_page_menu_offset',
			'tab'	=> esc_html__( 'One Page', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> '60'
		),
		array( 
			'label'	=> esc_html__( 'One Page Mobile Menu Offset', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter one page mobile menu offset for desktop menu.', 'inzofin-core' ), 
			'id'	=> $prefix.'one_page_mobmenu_offset',
			'tab'	=> esc_html__( 'One Page', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> '60'
		),
		array( 
			'label'	=> esc_html__( 'Header Layout', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose page layout for current page header layout.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_layout',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'wide' => esc_html__( 'Wide', 'inzofin-core' ),
				'boxed' => esc_html__( 'Boxed', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Type', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose page layout for current page header type.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_type',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'default' => esc_html__( 'Default', 'inzofin-core' ),
				'left-sticky' => esc_html__( 'Left Sticky', 'inzofin-core' ),
				'right-sticky' => esc_html__( 'Right Sticky', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Background Image', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header background image for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'image',
			'id'	=> $prefix.'header_bg_img',
			'required'	=> array( $prefix.'header_type', 'default' )
		),
		array( 
			'label'	=> esc_html__( 'Header Items Options', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_items_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Items', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header general items for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'header_items',
			'dd_fields' => array ( 
				'Normal' => array( 
					'header-topbar' 	=> esc_html__( 'Topbar', 'inzofin-core' ),
					'header-logo'	=> esc_html__( 'Logo Bar', 'inzofin-core' )
				),
				'Sticky' => array( 
					'header-nav' 	=> esc_html__( 'Navbar', 'inzofin-core' )
				),
				'disabled' => array()
			),
			'required'	=> array( $prefix.'header_items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Absolute Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header absolute to change header look transparent.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_absolute_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'1' => esc_html__( 'Enable', 'inzofin-core' ),
				'0' => esc_html__( 'Disable', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header sticky options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_sticky_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'sticky' => esc_html__( 'Header Sticky Part', 'inzofin-core' ),
				'sticky-scroll' => esc_html__( 'Sticky Scroll Up', 'inzofin-core' ),
				'none' => esc_html__( 'None', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Secondary Space Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose secondary space option for enable secondary menu space for current page.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_secondary_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'enable' => esc_html__( 'Enable', 'inzofin-core' ),
				'disable' => esc_html__( 'Disable', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Secondary Space Animate Type', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose secondary space option animate type for current page.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_secondary_animate',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array(
				'left-push'		=> esc_html__( 'Left Push', 'inzofin-core' ),
				'left-overlay'	=> esc_html__( 'Left Overlay', 'inzofin-core' ),
				'right-push'	=> esc_html__( 'Right Push', 'inzofin-core' ),
				'right-overlay'	=> esc_html__( 'Right Overlay', 'inzofin-core' ),
				'full-overlay'	=> esc_html__( 'Full Page Overlay', 'inzofin-core' ),
			),
			'default'	=> 'left-push',
			'required'	=> array( $prefix.'header_secondary_opt', 'enable' )
		),
		array( 
			'label'	=> esc_html__( 'Secondary Space Width', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Set secondary space width for current page. Example 300', 'inzofin-core' ), 
			'id'	=> $prefix.'header_secondary_width',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> '',
			'required'	=> array( $prefix.'header_secondary_opt', 'enable' )
		),
		array( 
			'label'	=> esc_html__( 'Custom Logo', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose custom logo image for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'image',
			'id'	=> $prefix.'custom_logo',
		),
		array( 
			'label'	=> esc_html__( 'Custom Sticky Logo', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose custom sticky logo image for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'image',
			'id'	=> $prefix.'custom_sticky_logo',
		),
		array( 
			'label'	=> esc_html__( 'Select Navigation Menu', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose navigation menu for current page.', 'inzofin-core' ), 
			'id'	=> $prefix.'nav_menu',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => $inzofin_nav_menus
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header topbar settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Options', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_topbar_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Height', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header topbar height for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_topbar_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_topbar_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Height', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header topbar sticky height for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_topbar_sticky_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_topbar_opt', 'custom' )
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are header topbar skin settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Skin Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header topbar skin settings options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_topbar_skin_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header topbar font color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_topbar_font',
			'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Background', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header topbar background color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_topbar_bg',
			'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header topbar link color settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_topbar_link',
			'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header topbar border settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_topbar_border',
			'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header topbar padding settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_topbar_padding',
			'required'	=> array( $prefix.'header_topbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Skin Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header top bar sticky skin settings options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_topbar_sticky_skin_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header top bar sticky font color for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_topbar_sticky_font',
			'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Background', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header top bar sticky background color for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_topbar_sticky_bg',
			'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header top bar sticky link color settings for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_topbar_sticky_link',
			'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header top bar sticky border settings for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_topbar_sticky_border',
			'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Sticky Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header top bar sticky padding settings for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_topbar_sticky_padding',
			'required'	=> array( $prefix.'header_topbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Items Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header topbar items enable options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_topbar_items_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Top Bar Items', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header topbar items for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'header_topbar_items',
			'dd_fields' => array ( 
				'Left'  => array(
					'header-topbar-date' => esc_html__( 'Date', 'inzofin-core' ),						
				),
				'Center' => array(),
				'Right' => array(),
				'disabled' => array(
					'header-topbar-text-1'	=> esc_html__( 'Custom Text 1', 'inzofin-core' ),
					'header-topbar-text-2'	=> esc_html__( 'Custom Text 2', 'inzofin-core' ),
					'header-topbar-text-3'	=> esc_html__( 'Custom Text 3', 'inzofin-core' ),
					'header-topbar-menu'    => esc_html__( 'Top Bar Menu', 'inzofin-core' ),
					'header-topbar-social'	=> esc_html__( 'Social', 'inzofin-core' ),
					'header-topbar-search'	=> esc_html__( 'Search', 'inzofin-core' ),
					'header-topbar-search-toggle'	=> esc_html__( 'Search Toggle', 'inzofin-core' ),
					'header-cart'   		=> esc_html__( 'Cart', 'inzofin-core' )
				)
			),
			'required'	=> array( $prefix.'header_topbar_items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Options', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_logo_bar_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Height', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar height for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_logo_bar_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_logo_bar_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Height', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky height for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_logo_bar_sticky_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_logo_bar_opt', 'custom' )
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are header logo bar skin settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Skin Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header logo bar skin settings options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_logo_bar_skin_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar font color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_logo_bar_font',
			'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Background', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar background color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_logo_bar_bg',
			'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar link color settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_logo_bar_link',
			'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar border settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_logo_bar_border',
			'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar padding settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_logo_bar_padding',
			'required'	=> array( $prefix.'header_logo_bar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Skin Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header logo bar sticky skin settings options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_logobar_sticky_skin_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky font color for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_logobar_sticky_font',
			'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Background', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky background color for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_logobar_sticky_bg',
			'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky link color settings for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_logobar_sticky_link',
			'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky border settings for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_logobar_sticky_border',
			'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Sticky Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar sticky padding settings for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_logobar_sticky_padding',
			'required'	=> array( $prefix.'header_logobar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Items Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header logo bar items enable options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_logo_bar_items_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Logo Bar Items', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header logo bar items for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'header_logo_bar_items',
			'dd_fields' => array ( 
				'Left'  => array(
					'header-logobar-logo'		=> esc_html__( 'Logo', 'inzofin-core' ),
					'header-logobar-sticky-logo' => esc_html__( 'Sticky Logo', 'inzofin-core' )											
				),
				'Center' => array(),
				'Right' => array(),
				'disabled' => array(
					'header-logobar-social'		=> esc_html__( 'Social', 'inzofin-core' ),
					'header-logobar-search'		=> esc_html__( 'Search', 'inzofin-core' ),
					'header-logobar-secondary-toggle'	=> esc_html__( 'Secondary Toggle', 'inzofin-core' ),	
					'header-phone'   			=> esc_html__( 'Phone Number', 'inzofin-core' ),
					'header-address'  			=> esc_html__( 'Address Text', 'inzofin-core' ),
					'header-email'   			=> esc_html__( 'Email', 'inzofin-core' ),
					'header-logobar-menu'   	=> esc_html__( 'Main Menu', 'inzofin-core' ),
					'header-logobar-search-toggle'	=> esc_html__( 'Search Toggle', 'inzofin-core' ),
					'header-logobar-text-1'		=> esc_html__( 'Custom Text 1', 'inzofin-core' ),
					'header-logobar-text-2'		=> esc_html__( 'Custom Text 2', 'inzofin-core' ),
					'header-logobar-text-3'		=> esc_html__( 'Custom Text 3', 'inzofin-core' ),	
					'header-cart'   			=> esc_html__( 'Cart', 'inzofin-core' ),
					'header-wishlist'   		=> esc_html__( 'Wishlist', 'inzofin-core' ),
					'multi-info'   				=> esc_html__( 'Address, Phone, Email', 'inzofin-core' )
				)
			),
			'required'	=> array( $prefix.'header_logo_bar_items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Options', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header items options for enable header drag and drop items.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_navbar_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Height', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar height for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_navbar_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_navbar_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Height', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky height for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_navbar_sticky_height',
			'property' => 'height',
			'required'	=> array( $prefix.'header_navbar_opt', 'custom' )
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are header navbar skin settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Skin Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header navbar skin settings options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_navbar_skin_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar font color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_navbar_font',
			'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Background', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar background color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_navbar_bg',
			'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar link color settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_navbar_link',
			'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar border settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_navbar_border',
			'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar padding settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_navbar_padding',
			'required'	=> array( $prefix.'header_navbar_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Skin Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header navbar sticky skin settings options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_navbar_sticky_skin_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky font color for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_navbar_sticky_font',
			'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Background', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky background color for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_navbar_sticky_bg',
			'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky link color settings for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_navbar_sticky_link',
			'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky border settings for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_navbar_sticky_border',
			'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Sticky Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar sticky padding settings for current post.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_navbar_sticky_padding',
			'required'	=> array( $prefix.'header_navbar_sticky_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Items Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header navbar items enable options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_navbar_items_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Navbar Items', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header navbar items for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'header_navbar_items',
			'dd_fields' => array ( 
				'Left'  => array(
					'header-navbar-logo'		=> esc_html__( 'Logo', 'inzofin' ),
					'header-navbar-sticky-logo'	=> esc_html__( 'Stikcy Logo', 'inzofin' ),
					'header-navbar-menu'    	=> esc_html__( 'Main Menu', 'inzofin' )										
				),
				'Center' => array(),
				'Right' => array(),
				'disabled' => array(					
					'header-navbar-text-1'		=> esc_html__( 'Custom Text 1', 'inzofin' ),
					'header-navbar-text-2'		=> esc_html__( 'Custom Text 2', 'inzofin' ),
					'header-navbar-text-3'		=> esc_html__( 'Custom Text 3', 'inzofin' ),					
					'header-navbar-social'		=> esc_html__( 'Social', 'inzofin' ),
					'header-navbar-secondary-toggle'	=> esc_html__( 'Secondary Toggle', 'inzofin' ),					
					'header-navbar-search'		=> esc_html__( 'Search', 'inzofin' ),
					'header-phone'   			=> esc_html__( 'Phone Number', 'inzofin' ),
					'header-address'  			=> esc_html__( 'Address Text', 'inzofin' ),
					'header-email'   			=> esc_html__( 'Email', 'inzofin' ),
					'header-navbar-search-toggle'	=> esc_html__( 'Search Toggle', 'inzofin' ),
					'header-cart'   			=> esc_html__( 'Cart', 'inzofin' ),
					'header-wishlist'   		=> esc_html__( 'Wishlist', 'inzofin' )
				)
			),
			'required'	=> array( $prefix.'header_navbar_items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header sticky settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Options', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header sticky part option.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_stikcy_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Width', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header sticky part width for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dimension',
			'id'	=> $prefix.'header_stikcy_width',
			'property' => 'width',
			'required'	=> array( $prefix.'header_stikcy_opt', 'custom' )
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are header sticky skin settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Skin Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header sticky skin settings options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_stikcy_skin_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header sticky font color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'header_stikcy_font',
			'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Background', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header sticky background color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'header_stikcy_bg',
			'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header Sticky link color settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'header_stikcy_link',
			'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header sticky border settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'header_stikcy_border',
			'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header sticky padding settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'header_stikcy_padding',
			'required'	=> array( $prefix.'header_stikcy_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Items Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose header sticky items enable options.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_stikcy_items_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Header Sticky/Fixed Part Items', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are header sticky items for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'header_stikcy_items',
			'dd_fields' => array ( 
				'Top'  => array(
					'header-fixed-logo' => esc_html__( 'Logo', 'inzofin-core' )
				),
				'Middle'  => array(
					'header-fixed-menu'	=> esc_html__( 'Menu', 'inzofin-core' )					
				),
				'Bottom'  => array(
					'header-fixed-social'	=> esc_html__( 'Social', 'inzofin-core' )					
				),
				'disabled' => array(
					'header-fixed-text-1'	=> esc_html__( 'Custom Text 1', 'inzofin-core' ),
					'header-fixed-text-2'	=> esc_html__( 'Custom Text 2', 'inzofin-core' ),					
					'header-fixed-search'	=> esc_html__( 'Search Form', 'inzofin-core' )
				)
			),
			'required'	=> array( $prefix.'header_stikcy_items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Bar', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are page title bar settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Page Title Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose page title enable or disable.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_page_title_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'1' => esc_html__( 'Enable', 'inzofin-core' ),
				'0' => esc_html__( 'Disable', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Page Title Text', 'inzofin-core' ),
			'desc'	=> esc_html__( 'If this page title is empty, then showing current page default title.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_page_title_text',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> '',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Description', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter page title description.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_page_title_desc',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'textarea',
			'default'	=> '',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Background Parallax', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose page title background parallax.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_page_title_parallax',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'1' => esc_html__( 'Enable', 'inzofin-core' ),
				'0' => esc_html__( 'Disable', 'inzofin-core' )
			),
			'default'	=> 'theme-default',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Background Video Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose page title background video option.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_page_title_video_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'1' => esc_html__( 'Enable', 'inzofin-core' ),
				'0' => esc_html__( 'Disable', 'inzofin-core' )
			),
			'default'	=> 'theme-default',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Background Video', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter youtube video ID. Example: ZSt9tm3RoUU.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_page_title_video',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> '',
			'required'	=> array( $prefix.'header_page_title_video_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Bar Items Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose page title bar items option.', 'inzofin-core' ), 
			'id'	=> $prefix.'page_title_items_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Bar Items', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are page title bar items for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'page_title_items',
			'dd_fields' => array ( 
				'Left'  => array(
					'title' => esc_html__( 'Page Title Text', 'inzofin-core' ),
				),
				'Center'  => array(
					
				),
				'Right'  => array(
					'breadcrumb'	=> esc_html__( 'Breadcrumb', 'inzofin-core' )
				),
				'disabled' => array(
					'description' => esc_html__( 'Page Title Description', 'inzofin-core' )
				)
			),
			'required'	=> array( $prefix.'page_title_items_opt', 'custom' )
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are page title skin settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'label',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Skin Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose page title skin settings options.', 'inzofin-core' ), 
			'id'	=> $prefix.'page_title_skin_opt',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default',
			'required'	=> array( $prefix.'header_page_title_opt', '1' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are page title font color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'page_title_font',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Description Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'This is page title description color.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'page_title_desc_color',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Background', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are page title background color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'page_title_bg',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Background Image', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter page title background image url.', 'inzofin-core' ), 
			'id'	=> $prefix.'page_title_bg_img',
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> '',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are page title link color settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'page_title_link',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are page title border settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'page_title_border',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are page title padding settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'page_title_padding',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Page Title Overlay', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are page title overlay color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Header', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'page_title_overlay',
			'required'	=> array( $prefix.'page_title_skin_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer General',
			'desc'	=> esc_html__( 'These all are header footer settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Layout', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer layout for current page.', 'inzofin-core' ), 
			'id'	=> $prefix.'footer_layout',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'wide' => esc_html__( 'Wide', 'inzofin-core' ),
				'boxed' => esc_html__( 'Boxed', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Hidden Footer', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose hidden footer option.', 'inzofin-core' ), 
			'id'	=> $prefix.'hidden_footer',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'1' => esc_html__( 'Enable', 'inzofin-core' ),
				'0' => esc_html__( 'Disable', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are footer skin settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Skin Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer skin settings options.', 'inzofin-core' ), 
			'id'	=> $prefix.'footer_skin_opt',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer font color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_font',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Background Image', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer background image for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'image',
			'id'	=> $prefix.'footer_bg_img',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Background Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer background color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_bg',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Background Overlay', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer background overlay color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'footer_bg_overlay',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer link color settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'footer_link',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer border settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'footer_border',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer padding settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'footer_padding',
			'required'	=> array( $prefix.'footer_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Items Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer items enable options.', 'inzofin-core' ), 
			'id'	=> $prefix.'footer_items_opt',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Items', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer items for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'footer_items',
			'dd_fields' => array ( 
				'Enabled'  => array(
					'footer-bottom'	=> esc_html__( 'Footer Bottom', 'inzofin-core' )
				),
				'disabled' => array(
					'footer-top' => esc_html__( 'Footer Top', 'inzofin-core' ),
					'footer-middle'	=> esc_html__( 'Footer Middle', 'inzofin-core' )
				)
			),
			'required'	=> array( $prefix.'footer_items_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Top',
			'desc'	=> esc_html__( 'These all are footer top settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Skin', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer top skin options.', 'inzofin-core' ), 
			'id'	=> $prefix.'footer_top_skin_opt',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer top font color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_top_font',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Widget Title color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer top widget title color.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_top_widget_title_color',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Background', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer background color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'footer_top_bg',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer top link color settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'footer_top_link',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer top border settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'footer_top_border',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Top Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer top padding settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'footer_top_padding',
			'required'	=> array( $prefix.'footer_top_skin_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Top Columns and Sidebars Settings',
			'desc'	=> esc_html__( 'These all are footer top columns and sidebar settings.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Layout Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer layout option.', 'inzofin-core' ), 
			'id'	=> $prefix.'footer_top_layout_opt',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Layout', 'inzofin-core' ),
			'id'	=> $prefix.'footer_top_layout',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'image_select',
			'options' => array(
				'3-3-3-3'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-1.png',
				'4-4-4'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-2.png',
				'3-6-3'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-3.png',
				'6-6'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-4.png',
				'9-3'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-5.png',
				'3-9'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-6.png',
				'4-2-2-2-2'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-8.png',
				'6-2-2-2'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-9.png',
				'12'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-7.png'
			),
			'default'	=> '4-4-4',
			'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer First Column',
			'desc'	=> esc_html__( 'Select footer first column widget.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'id'	=> $prefix.'footer_top_sidebar_1',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Second Column',
			'desc'	=> esc_html__( 'Select footer second column widget.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'id'	=> $prefix.'footer_top_sidebar_2',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Third Column',
			'desc'	=> esc_html__( 'Select footer third column widget.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'id'	=> $prefix.'footer_top_sidebar_3',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Fourth Column',
			'desc'	=> esc_html__( 'Select footer fourth column widget.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'id'	=> $prefix.'footer_top_sidebar_4',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_top_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Middle',
			'desc'	=> esc_html__( 'These all are footer middle settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Skin', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer middle skin options.', 'inzofin-core' ), 
			'id'	=> $prefix.'footer_middle_skin_opt',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer middle font color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_middle_font',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Widget Title Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer middle widget title color.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_middle_widget_title_color',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Background', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer background color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'footer_middle_bg',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer middle link color settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'footer_middle_link',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer middle border settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'footer_middle_border',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Middle Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer middle padding settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'footer_middle_padding',
			'required'	=> array( $prefix.'footer_middle_skin_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Middle Columns and Sidebars Settings',
			'desc'	=> esc_html__( 'These all are footer middle columns and sidebar settings.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Layout Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer layout option.', 'inzofin-core' ), 
			'id'	=> $prefix.'footer_middle_layout_opt',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Layout', 'inzofin-core' ),
			'id'	=> $prefix.'footer_middle_layout',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'image_select',
			'options' => array(
				'3-3-3-3'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-1.png',
				'4-4-4'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-2.png',
				'3-6-3'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-3.png',
				'6-6'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-4.png',
				'9-3'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-5.png',
				'3-9'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-6.png',
				'4-2-2-2-2'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-8.png',
				'6-2-2-2'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-9.png',
				'12'		=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/footer/footer-7.png'
			),
			'default'	=> '4-4-4',
			'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer First Column',
			'desc'	=> esc_html__( 'Select footer first column widget.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'id'	=> $prefix.'footer_middle_sidebar_1',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Second Column',
			'desc'	=> esc_html__( 'Select footer second column widget.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'id'	=> $prefix.'footer_middle_sidebar_2',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Third Column',
			'desc'	=> esc_html__( 'Select footer third column widget.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'id'	=> $prefix.'footer_middle_sidebar_3',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Fourth Column',
			'desc'	=> esc_html__( 'Select footer fourth column widget.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'id'	=> $prefix.'footer_middle_sidebar_4',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_middle_layout_opt', 'custom' )
		),
		array( 
			'label'	=> 'Footer Bottom',
			'desc'	=> esc_html__( 'These all are footer bottom settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Fixed', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer bottom fixed option.', 'inzofin-core' ), 
			'id'	=> $prefix.'footer_bottom_fixed',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'1' => esc_html__( 'Enable', 'inzofin-core' ),
				'0' => esc_html__( 'Disable', 'inzofin-core' )			
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> '',
			'desc'	=> esc_html__( 'These all are footer bottom skin settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Skin', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer bottom skin options.', 'inzofin-core' ), 
			'id'	=> $prefix.'footer_bottom_skin_opt',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Font Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom font color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'color',
			'id'	=> $prefix.'footer_bottom_font',
			'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Background', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom background color for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'alpha_color',
			'id'	=> $prefix.'footer_bottom_bg',
			'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Link Color', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom link color settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'link_color',
			'id'	=> $prefix.'footer_bottom_link',
			'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Border', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom border settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'space',
			'color' => 1,
			'border_style' => 1,
			'id'	=> $prefix.'footer_bottom_border',
			'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Padding', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom padding settings for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'space',
			'id'	=> $prefix.'footer_bottom_padding',
			'required'	=> array( $prefix.'footer_bottom_skin_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Widget Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer bottom widget options.', 'inzofin-core' ), 
			'id'	=> $prefix.'footer_bottom_widget_opt',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> 'Footer Bottom Widget',
			'desc'	=> esc_html__( 'Select footer bottom widget.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'id'	=> $prefix.'footer_bottom_widget',
			'type'	=> 'sidebar',
			'required'	=> array( $prefix.'footer_bottom_widget_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Items Option', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose footer bottom items options.', 'inzofin-core' ), 
			'id'	=> $prefix.'footer_bottom_items_opt',
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Footer Bottom Items', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are footer bottom items for current page.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Footer', 'inzofin-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'footer_bottom_items',
			'dd_fields' => array ( 
				'Left'  => array(
					'copyright' => esc_html__( 'Copyright Text', 'inzofin-core' )
				),
				'Center'  => array(
					'menu'	=> esc_html__( 'Footer Menu', 'inzofin-core' )
				),
				'Right'  => array(),
				'disabled' => array(
					'social'	=> esc_html__( 'Footer Social Links', 'inzofin-core' ),
					'widget'	=> esc_html__( 'Custom Widget', 'inzofin-core' )
				)
			),
			'required'	=> array( $prefix.'footer_bottom_items_opt', 'custom' )
		),
		//Header Slider
		array( 
			'label'	=> esc_html__( 'Slider', 'inzofin-core' ),
			'desc'	=> esc_html__( 'This header slider settings.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Slider', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Slider Option', 'inzofin-core' ),
			'id'	=> $prefix.'header_slider_opt',
			'tab'	=> esc_html__( 'Slider', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'bottom' => esc_html__( 'Below Header', 'inzofin-core' ),
				'top' => esc_html__( 'Above Header', 'inzofin-core' ),
				'none' => esc_html__( 'None', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Slider Shortcode', 'inzofin-core' ),
			'desc'	=> esc_html__( 'This is the place for enter slider shortcode. Example revolution slider shortcodes.', 'inzofin-core' ), 
			'id'	=> $prefix.'header_slider',
			'tab'	=> esc_html__( 'Slider', 'inzofin-core' ),
			'type'	=> 'textarea',
			'default'	=> ''
		),
	);
	return $fields;
}
$page_fields = inzofin_metabox_fields( 'inzofin_page_' );
$page_box = new Custom_Add_Meta_Box( 'inzofin_page_metabox', esc_html__( 'Inzofin Page Options', 'inzofin-core' ), $page_fields, 'page', true );

/* Custom Post Type Options */
$inzofin_cpt = InzofinFamework::inzofin_static_theme_mod( 'cpt-opts' );

// Portfolio Options
if( is_array( $inzofin_cpt ) && in_array( "portfolio", $inzofin_cpt ) ){
	
	// CPT Portfolio Metabox
	$prefix = 'inzofin_portfolio_';
	$portfolio_fields = array(
		array( 
			'label'	=> esc_html__( 'Portfolio General Settings', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are single portfolio general settings.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Portfolio', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Layout Option', 'inzofin-core' ),
			'id'	=> $prefix.'layout_opt',
			'tab'	=> esc_html__( 'Portfolio', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'		
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Layout', 'inzofin-core' ),
			'id'	=> $prefix.'layout',
			'tab'	=> esc_html__( 'Portfolio', 'inzofin-core' ),
			'type'	=> 'image_select',
			'options' => array(
				'1'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/1.png', 
				'2'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/2.png',
				'3'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/3.png',
				'4'	=> INZOFIN_THEME_ADMIN_URL . '/customizer/assets/images/portfolio-layouts/4.png'
	
			),
			'default'	=> '1',
			'required'	=> array( $prefix.'layout_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Sticky Column', 'inzofin-core' ),
			'id'	=> $prefix.'sticky',
			'tab'	=> esc_html__( 'Portfolio', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'none' => esc_html__( 'None', 'inzofin-core' ),
				'right' => esc_html__( 'Right Column', 'inzofin-core' ),
				'left' => esc_html__( 'Left Column', 'inzofin-core' )
			),
			'default'	=> 'none'		
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Format', 'inzofin-core' ),
			'id'	=> $prefix.'format',
			'tab'	=> esc_html__( 'Portfolio', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'standard' => esc_html__( 'Standard', 'inzofin-core' ),
				'video' => esc_html__( 'Video', 'inzofin-core' ),
				'audio' => esc_html__( 'Audio', 'inzofin-core' ),
				'gallery' => esc_html__( 'Gallery', 'inzofin-core' ),
				'gmap' => esc_html__( 'Google Map', 'inzofin-core' )
			),
			'default'	=> 'standard'		
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Meta Items Options', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose portfolio meta items option.', 'inzofin-core' ), 
			'id'	=> $prefix.'items_opt',
			'tab'	=> esc_html__( 'Portfolio', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'theme-default' => esc_html__( 'Theme Default', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom', 'inzofin-core' )
			),
			'default'	=> 'theme-default'
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Meta Items', 'inzofin-core' ),
			'desc'	=> esc_html__( 'These all are meta items for portfolio. drag and drop needed items from disabled part to enabled.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Portfolio', 'inzofin-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'items',
			'dd_fields' => array ( 
				'Enabled'  => array(
					'date'		=> esc_html__( 'Date', 'inzofin-core' ),
					'client'	=> esc_html__( 'Client', 'inzofin-core' ),
					'category'	=> esc_html__( 'Category', 'inzofin-core' ),
					'share'		=> esc_html__( 'Share', 'inzofin-core' ),
				),
				'disabled' => array(
					'tag'		=> esc_html__( 'Tags', 'inzofin-core' ),
					'duration'	=> esc_html__( 'Duration', 'inzofin-core' ),
					'url'		=> esc_html__( 'URL', 'inzofin-core' ),
					'place'		=> esc_html__( 'Place', 'inzofin-core' ),
					'estimation'=> esc_html__( 'Estimation', 'inzofin-core' ),
				)
			),
			'required'	=> array( $prefix.'items_opt', 'custom' )
		),
		array( 
			'label'	=> esc_html__( 'Custom Redirect URL', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter url for custom webpage redirection. This link only for portfolio archive layout not for single portfolio.', 'inzofin-core' ), 
			'id'	=> $prefix.'custom_url',
			'tab'	=> esc_html__( 'Portfolio', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Custom Redirect URL Target', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose custom url page navigate to blank or same page.', 'inzofin-core' ), 
			'id'	=> $prefix.'custom_url_target',
			'tab'	=> esc_html__( 'Portfolio', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'_blank' => esc_html__( 'Blank', 'inzofin-core' ),
				'_self' => esc_html__( 'Self', 'inzofin-core' )
			),
			'default'	=> '_blank'
		),
		array( 
			'label'	=> esc_html__( 'Portfolio Date', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose/Enter portfolio date.', 'inzofin-core' ), 
			'id'	=> $prefix.'date',
			'tab'	=> esc_html__( 'Info', 'inzofin-core' ),
			'type'	=> 'date',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Date Format', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter date format to show selcted portfolio date. Example: F j, Y', 'inzofin-core' ), 
			'id'	=> $prefix.'date_format',
			'tab'	=> esc_html__( 'Info', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> 'F j, Y'
		),
		array( 
			'label'	=> esc_html__( 'Client Name', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter client name.', 'inzofin-core' ), 
			'id'	=> $prefix.'client_name',
			'tab'	=> esc_html__( 'Info', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Duration', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter duration years or months.', 'inzofin-core' ), 
			'id'	=> $prefix.'duration',
			'tab'	=> esc_html__( 'Info', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Estimation', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter project estimation.', 'inzofin-core' ), 
			'id'	=> $prefix.'estimation',
			'tab'	=> esc_html__( 'Info', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Place', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter project place.', 'inzofin-core' ), 
			'id'	=> $prefix.'place',
			'tab'	=> esc_html__( 'Info', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'URL', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter project URL.', 'inzofin-core' ), 
			'id'	=> $prefix.'url',
			'tab'	=> esc_html__( 'Info', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		//Portfolio Format
		array( 
			'label'	=> esc_html__( 'Video', 'inzofin-core' ),
			'desc'	=> esc_html__( 'This part for if you choosed video format, then you must choose video type and give video id.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Video Modal', 'inzofin-core' ),
			'id'	=> $prefix.'video_modal',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'onclick' => esc_html__( 'On Click Run Video', 'inzofin-core' ),
				'overlay' => esc_html__( 'Modal Box Video', 'inzofin-core' ),
				'direct' => esc_html__( 'Direct Video', 'inzofin-core' )
			),
			'default'	=> 'direct'
		),
		array( 
			'label'	=> esc_html__( 'Video Type', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose video type.', 'inzofin-core' ), 
			'id'	=> $prefix.'video_type',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'' => esc_html__( 'None', 'inzofin-core' ),
				'youtube' => esc_html__( 'Youtube', 'inzofin-core' ),
				'vimeo' => esc_html__( 'Vimeo', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom Video', 'inzofin-core' )
			),
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Video ID', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter Video ID Example: ZSt9tm3RoUU. If you choose custom video type then you enter custom video url and video must be mp4 format.', 'inzofin-core' ), 
			'id'	=> $prefix.'video_id',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'type'	=> 'line',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' )
		),
		array( 
			'label'	=> esc_html__( 'Audio', 'inzofin-core' ),
			'desc'	=> esc_html__( 'This part for if you choosed audio format, then you must give audio id.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Audio Type', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose audio type.', 'inzofin-core' ), 
			'id'	=> $prefix.'audio_type',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'' => esc_html__( 'None', 'inzofin-core' ),
				'soundcloud' => esc_html__( 'Soundcloud', 'inzofin-core' ),
				'custom' => esc_html__( 'Custom Audio', 'inzofin-core' )
			),
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Audio ID', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter soundcloud audio ID. Example: 315307209.', 'inzofin-core' ), 
			'id'	=> $prefix.'audio_id',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'type'	=> 'line',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' )
		),
		array( 
			'label'	=> esc_html__( 'Gallery', 'inzofin-core' ),
			'desc'	=> esc_html__( 'This part for if you choosed gallery format, then you must choose gallery images here.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Gallery Modal', 'inzofin-core' ),
			'id'	=> $prefix.'gallery_modal',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'default' => esc_html__( 'Default Gallery', 'inzofin-core' ),
				'normal' => esc_html__( 'Normal Gallery', 'inzofin-core' ),
				'grid' => esc_html__( 'Grid/Masonry Gallery', 'inzofin-core' )
			),
			'default'	=> 'default'
		),
		array( 
			'label'	=> esc_html__( 'Grid Gutter Size', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter gallery grid gutter size. Example 20', 'inzofin-core' ), 
			'id'	=> $prefix.'grid_gutter',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> '',
			'required'	=> array( $prefix.'gallery_modal', 'grid' )
		),
		array( 
			'label'	=> esc_html__( 'Grid Columns', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter gallery grid columns count. Example 2', 'inzofin-core' ), 
			'id'	=> $prefix.'grid_cols',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> '',
			'required'	=> array( $prefix.'gallery_modal', 'grid' )
		),
		array( 
			'label'	=> esc_html__( 'Choose Gallery Images', 'inzofin-core' ),
			'id'	=> $prefix.'gallery',
			'type'	=> 'gallery',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' )
		),
		array( 
			'type'	=> 'line',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' )
		),
		array( 
			'label'	=> esc_html__( 'Google Map', 'inzofin-core' ),
			'desc'	=> esc_html__( 'This part for if you choosed google map format, then you must give google map lat, lang and map style.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'label'
		),
		array( 
			'label'	=> esc_html__( 'Google Map Latitude', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter google latitude.', 'inzofin-core' ), 
			'id'	=> $prefix.'gmap_latitude',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Google Map Longitude', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter google longitude.', 'inzofin-core' ), 
			'id'	=> $prefix.'gmap_longitude',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Google Map Marker URL', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter google map custom marker url.', 'inzofin-core' ), 
			'id'	=> $prefix.'gmap_marker',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Google Map Style', 'inzofin-core' ),
			'id'	=> $prefix.'gmap_style',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'standard' => esc_html__( 'Standard', 'inzofin-core' ),
				'silver' => esc_html__( 'Silver', 'inzofin-core' ),
				'retro' => esc_html__( 'Retro', 'inzofin-core' ),
				'dark' => esc_html__( 'Dark', 'inzofin-core' ),
				'night' => esc_html__( 'Night', 'inzofin-core' ),
				'aubergine' => esc_html__( 'Aubergine', 'inzofin-core' )
			),
			'default'	=> 'standard'
		),
		array( 
			'type'	=> 'line',
			'tab'	=> esc_html__( 'Format', 'inzofin-core' )
		),
	);
	// CPT Portfolio Options
	$portfolio_box = new Custom_Add_Meta_Box( 'inzofin_portfolio_metabox', esc_html__( 'Inzofin Portfolio Options', 'inzofin-core' ), $portfolio_fields, 'inzofin-portfolio', true );
	
	// CPT Portfolio Page Options
	$portfolio_page_box = new Custom_Add_Meta_Box( 'inzofin_portfolio_page_metabox', esc_html__( 'Inzofin Page Options', 'inzofin-core' ), $page_fields, 'inzofin-portfolio', true );
} // In theme option CPT option if portfolio exists
// Testimonial Options
if( is_array( $inzofin_cpt ) && in_array( "testimonial", $inzofin_cpt ) ){
	
	$prefix = 'inzofin_testimonial_';
	$testimonial_fields = array(	
		array( 
			'label'	=> esc_html__( 'Author Designation', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter author designation.', 'inzofin-core' ), 
			'id'	=> $prefix.'designation',
			'tab'	=> esc_html__( 'Testimonial', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Company Name', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter company name.', 'inzofin-core' ), 
			'id'	=> $prefix.'company_name',
			'tab'	=> esc_html__( 'Testimonial', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Company URL', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter company URL.', 'inzofin-core' ), 
			'id'	=> $prefix.'company_url',
			'tab'	=> esc_html__( 'Testimonial', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Rating', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Set user rating.', 'inzofin-core' ), 
			'id'	=> $prefix.'rating',
			'tab'	=> esc_html__( 'Testimonial', 'inzofin-core' ),
			'type'	=> 'rating',
			'default'	=> ''
		)
	);
	
	// CPT Testimonial Options
	$testimonial_box = new Custom_Add_Meta_Box( 'inzofin_testimonial_metabox', esc_html__( 'Inzofin Testimonial Options', 'inzofin-core' ), $testimonial_fields, 'inzofin-testimonial', true );
	
	// CPT Testimonial Page Options
	$testimonial_page_box = new Custom_Add_Meta_Box( 'inzofin_testimonial_page_metabox', esc_html__( 'Inzofin Page Options', 'inzofin-core' ), $page_fields, 'inzofin-testimonial', true );
	
} // In theme option CPT option if testimonial exists
// Team Options
if( is_array( $inzofin_cpt ) && in_array( "team", $inzofin_cpt ) ){
	
	$prefix = 'inzofin_team_';
	$team_fields = array(	
		array( 
			'label'	=> esc_html__( 'Member Designation', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter member designation.', 'inzofin-core' ), 
			'id'	=> $prefix.'designation',
			'tab'	=> esc_html__( 'Team', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Member Email', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter member email.', 'inzofin-core' ), 
			'id'	=> $prefix.'email',
			'tab'	=> esc_html__( 'Team', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Link Target', 'inzofin-core' ),
			'id'	=> $prefix.'link_target',
			'tab'	=> esc_html__( 'Social', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'_blank' => esc_html__( 'New Window', 'inzofin-core' ),
				'_self' => esc_html__( 'Self Window', 'inzofin-core' )
			),
			'default'	=> '_blank'
		),
		array( 
			'label'	=> esc_html__( 'Facebook', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Facebook profile link.', 'inzofin-core' ), 
			'id'	=> $prefix.'facebook',
			'tab'	=> esc_html__( 'Social', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Twitter', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Twitter profile link.', 'inzofin-core' ), 
			'id'	=> $prefix.'twitter',
			'tab'	=> esc_html__( 'Social', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Instagram', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Instagram profile link.', 'inzofin-core' ), 
			'id'	=> $prefix.'instagram',
			'tab'	=> esc_html__( 'Social', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Linkedin', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Linkedin profile link.', 'inzofin-core' ), 
			'id'	=> $prefix.'linkedin',
			'tab'	=> esc_html__( 'Social', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Pinterest', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Pinterest profile link.', 'inzofin-core' ), 
			'id'	=> $prefix.'pinterest',
			'tab'	=> esc_html__( 'Social', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Dribbble', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Dribbble profile link.', 'inzofin-core' ), 
			'id'	=> $prefix.'dribbble',
			'tab'	=> esc_html__( 'Social', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Flickr', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Flickr profile link.', 'inzofin-core' ), 
			'id'	=> $prefix.'flickr',
			'tab'	=> esc_html__( 'Social', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Youtube', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Youtube profile link.', 'inzofin-core' ), 
			'id'	=> $prefix.'youtube',
			'tab'	=> esc_html__( 'Social', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Vimeo', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Vimeo profile link.', 'inzofin-core' ), 
			'id'	=> $prefix.'vimeo',
			'tab'	=> esc_html__( 'Social', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		)
	);
	
	// CPT Team Options
	$team_box = new Custom_Add_Meta_Box( 'inzofin_team_metabox', esc_html__( 'Inzofin Team Options', 'inzofin-core' ), $team_fields, 'inzofin-team', true );
	
	// CPT Team Page Options
	$team_page_box = new Custom_Add_Meta_Box( 'inzofin_team_page_metabox', esc_html__( 'Inzofin Page Options', 'inzofin-core' ), $page_fields, 'inzofin-team', true );
	
} // In theme option CPT option if team exists
// Event Options
if( is_array( $inzofin_cpt ) && in_array( "events", $inzofin_cpt ) ){
	
	$prefix = 'inzofin_event_';
	$event_fields = array(	
		array( 
			'label'	=> esc_html__( 'Event Organiser Name', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter event organiser name.', 'inzofin-core' ), 
			'id'	=> $prefix.'organiser_name',
			'tab'	=> esc_html__( 'Events', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event Organiser Designation', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter event organiser designation.', 'inzofin-core' ), 
			'id'	=> $prefix.'organiser_designation',
			'tab'	=> esc_html__( 'Events', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event Start Date', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter event start date.', 'inzofin-core' ), 
			'id'	=> $prefix.'start_date',
			'tab'	=> esc_html__( 'Events', 'inzofin-core' ),
			'type'	=> 'date',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event End Date', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter event end date.', 'inzofin-core' ), 
			'id'	=> $prefix.'end_date',
			'tab'	=> esc_html__( 'Events', 'inzofin-core' ),
			'type'	=> 'date',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Date Format', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter date format to show selcted event date. Example: F j, Y', 'inzofin-core' ), 
			'id'	=> $prefix.'date_format',
			'tab'	=> esc_html__( 'Events', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> 'F j, Y'
		),
		array( 
			'label'	=> esc_html__( 'Event Start Time', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter event start time.', 'inzofin-core' ), 
			'id'	=> $prefix.'time',
			'tab'	=> esc_html__( 'Events', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event Cost', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter event cost.', 'inzofin-core' ), 
			'id'	=> $prefix.'cost',
			'tab'	=> esc_html__( 'Events', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Custom Link for Event Item', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter custom link to redirect custom event page.', 'inzofin-core' ), 
			'id'	=> $prefix.'link',
			'tab'	=> esc_html__( 'Events', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Custom Link Target', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose custom link target to new window or self window.', 'inzofin-core' ), 
			'id'	=> $prefix.'link_target',
			'tab'	=> esc_html__( 'Events', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'_blank' => esc_html__( 'New Window', 'inzofin-core' ),
				'_self' => esc_html__( 'Self Window', 'inzofin-core' )
			),
			'default'	=> '_blank'
		),
		array( 
			'label'	=> esc_html__( 'Custom Link Button Text', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter custom link buttom text: Example More About Event.', 'inzofin-core' ), 
			'id'	=> $prefix.'link_text',
			'tab'	=> esc_html__( 'Events', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event Schedule Content', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter event schedule content. You can place here Shortcodes.', 'inzofin-core' ), 
			'id'	=> $prefix.'schedule_content',
			'tab'	=> esc_html__( 'Events', 'inzofin-core' ),
			'type'	=> 'textarea',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Venue Name', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter event venue name.', 'inzofin-core' ), 
			'id'	=> $prefix.'venue_name',
			'tab'	=> esc_html__( 'Address', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Venue Address', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter event venue address.', 'inzofin-core' ), 
			'id'	=> $prefix.'venue_address',
			'tab'	=> esc_html__( 'Address', 'inzofin-core' ),
			'type'	=> 'textarea',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'E-mail', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter email id for clarification about event.', 'inzofin-core' ), 
			'id'	=> $prefix.'email',
			'tab'	=> esc_html__( 'Address', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Phone', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter phone number for contact about event.', 'inzofin-core' ), 
			'id'	=> $prefix.'phone',
			'tab'	=> esc_html__( 'Address', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Website', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter event website.', 'inzofin-core' ), 
			'id'	=> $prefix.'website',
			'tab'	=> esc_html__( 'Address', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Latitude', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter map latitude.', 'inzofin-core' ), 
			'id'	=> $prefix.'gmap_latitude',
			'tab'	=> esc_html__( 'GMap', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Longitude', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter map longitude.', 'inzofin-core' ), 
			'id'	=> $prefix.'gmap_longitude',
			'tab'	=> esc_html__( 'GMap', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Google Map Marker URL', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter google map custom marker url.', 'inzofin-core' ), 
			'id'	=> $prefix.'gmap_marker',
			'tab'	=> esc_html__( 'GMap', 'inzofin-core' ),
			'type'	=> 'url',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Google Map Style', 'inzofin-core' ),
			'id'	=> $prefix.'gmap_style',
			'tab'	=> esc_html__( 'GMap', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'standard' => esc_html__( 'Standard', 'inzofin-core' ),
				'silver' => esc_html__( 'Silver', 'inzofin-core' ),
				'retro' => esc_html__( 'Retro', 'inzofin-core' ),
				'dark' => esc_html__( 'Dark', 'inzofin-core' ),
				'night' => esc_html__( 'Night', 'inzofin-core' ),
				'aubergine' => esc_html__( 'Aubergine', 'inzofin-core' )
			),
			'default'	=> 'standard'
		),
		array( 
			'label'	=> esc_html__( 'Google Map Height', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter map height in values. Example 400', 'inzofin-core' ), 
			'id'	=> $prefix.'gmap_height',
			'tab'	=> esc_html__( 'GMap', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> '400'
		),
		array( 
			'label'	=> esc_html__( 'Contact Form', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Contact form shortcode here.', 'inzofin-core' ), 
			'id'	=> $prefix.'contact_form',
			'tab'	=> esc_html__( 'Contact', 'inzofin-core' ),
			'type'	=> 'textarea',
			'default'	=> ''
		),
		array( 
			'label'	=> esc_html__( 'Event Info Columns', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Enter column division values like given format. Example 3-3-6', 'inzofin-core' ), 
			'id'	=> $prefix.'col_layout',
			'tab'	=> esc_html__( 'Layout', 'inzofin-core' ),
			'type'	=> 'text',
			'default'	=> '3-3-6'
		),
		array( 
			'label'	=> esc_html__( 'Event Detail Items', 'inzofin-core' ),
			'desc'	=> esc_html__( 'This is layout settings for event.', 'inzofin-core' ), 
			'tab'	=> esc_html__( 'Layout', 'inzofin-core' ),
			'type'	=> 'dragdrop_multi',
			'id'	=> $prefix.'event_info_items',
			'dd_fields' => array ( 
				'Enable'  => array(
					'event-details' => esc_html__( 'Event Details', 'inzofin-core' ),
					'event-venue' => esc_html__( 'Event Venue', 'inzofin-core' ),
					'event-map' => esc_html__( 'Event Map', 'inzofin-core' )
				),
				'disabled' => array(
					'event-form'	=> esc_html__( 'Event Form', 'inzofin-core' ),
				)
			),
		),
		array( 
			'label'	=> esc_html__( 'Navigation', 'inzofin-core' ),
			'id'	=> $prefix.'nav_position',
			'tab'	=> esc_html__( 'Layout', 'inzofin-core' ),
			'type'	=> 'select',
			'options' => array ( 
				'top' => esc_html__( 'Top', 'inzofin-core' ),
				'bottom' => esc_html__( 'Bottom', 'inzofin-core' )
			),
			'default'	=> 'top'
		),
	);
	
	// CPT Events Options
	$event_box = new Custom_Add_Meta_Box( 'inzofin_event_metabox', esc_html__( 'Inzofin Event Options', 'inzofin-core' ), $event_fields, 'inzofin-events', true );
	
	// CPT Events Page Options
	$event_page_box = new Custom_Add_Meta_Box( 'inzofin_event_page_metabox', esc_html__( 'Inzofin Page Options', 'inzofin-core' ), $page_fields, 'inzofin-events', true );
	
} // In theme option CPT option if event exists
// Service Options
if( is_array( $inzofin_cpt ) && in_array( "services", $inzofin_cpt ) ){
	
	$prefix = 'inzofin_service_';
	
	$service_fields = array(	
		array( 
			'label'	=> esc_html__( 'Service Image', 'inzofin-core' ),
			'desc'	=> esc_html__( 'Choose service image for show front.', 'inzofin-core' ), 
			'id'	=> $prefix.'title_img',
			'tab'	=> esc_html__( 'Service', 'inzofin-core' ),
			'type'	=> 'image',
			'default'	=> ''
		)
	);
	
	// CPT Service Options
	$service_box = new Custom_Add_Meta_Box( 'inzofin_service_metabox', esc_html__( 'Inzofin Service Options', 'inzofin-core' ), $service_fields, 'inzofin-services', true );
	
	// CPT Events Page Options
	$service_page_box = new Custom_Add_Meta_Box( 'inzofin_service_page_metabox', esc_html__( 'Inzofin Page Options', 'inzofin-core' ), $page_fields, 'inzofin-services', true );
	
}
