<?php
	global $cws_theme_funcs;
	$post_type = "post";
	$post_type_obj = get_post_type_object( $post_type );
	$post_type_name = isset( $post_type_obj->labels->name ) && !empty( $post_type_obj->labels->name ) ? $post_type_obj->labels->name : $post_type;
	$params = array(
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Blog View', 'vintwood' ),
			"param_name"	=> "display_style",
			"value"			=> array(
				esc_html__( 'Grid', 'vintwood' ) => 'grid',
				esc_html__( 'Carousel', 'vintwood' ) => 'carousel'
			)
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Aligning', 'vintwood' ),
			"param_name"	=> "blog_aligning",
			"value"			=> array(
				esc_html__( 'Center', 'vintwood' ) => 'center',
				esc_html__( 'Left', 'vintwood' ) => 'left',
				esc_html__( 'Right', 'vintwood' ) => 'right'
			)
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Button Aligning', 'vintwood' ),
			"param_name"	=> "button_aligning",
			"value"			=> array(
				esc_html__( 'Center', 'vintwood' ) => 'center',
				esc_html__( 'Left', 'vintwood' ) => 'left',
				esc_html__( 'Right', 'vintwood' ) => 'right'
			)
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'auto_play_carousel',
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "carousel" )
							),
			'value'			=> array(
				esc_html__( 'AutoPlay Carousel', 'vintwood' ) => true
			)
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'navigation_carousel',
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "carousel" )
							),
			'value'			=> array(
				esc_html__( 'Add Navigation Controls', 'vintwood' ) => true
			)
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'pagination_carousel',
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "carousel" )
							),
			'value'			=> array(
				esc_html__( 'Add Navigation Bullets', 'vintwood' ) => true
			) 
		),
	);
	$taxes = get_object_taxonomies ( $post_type, 'object' );
	$avail_taxes = array(
		esc_html__( 'None', 'vintwood' )	=> '',
		esc_html__( 'Titles', 'vintwood' )	=> 'title',
		);
	foreach ( $taxes as $tax => $tax_obj ){
		$tax_name = isset( $tax_obj->labels->name ) && !empty( $tax_obj->labels->name ) ? $tax_obj->labels->name : $tax;
		$avail_taxes[$tax_name] = $tax;
	}
	array_push( $params, array(
		"type"				=> "dropdown",
		"heading"			=> esc_html__( 'Filter by', 'vintwood' ),
		"param_name"		=> $post_type . "_tax",
		"value"				=> $avail_taxes
		));
	foreach ( $avail_taxes as $tax_name => $tax ) {
		if ($tax == 'title'){
			global $wpdb;
    		$results = $wpdb->get_results( $wpdb->prepare( "SELECT ID, post_title FROM {$wpdb->posts} WHERE post_type LIKE %s and post_status = 'publish'", $post_type ) );
    		$titles_arr = array();
		    foreach( $results as $index => $post ) {
		    	$post_title = $post->post_title;
		        $titles_arr[$post_title] =  $post->ID;
		    }
			array_push( $params, array(
				"type"			=> "cws_dropdown",
				"multiple"		=> "true",
				"heading"		=> esc_html__( 'Titles', 'vintwood' ),
				"param_name"	=> "titles",
				'edit_field_class'			=> 'inside-box vc_col-xs-12',
				"dependency"	=> array(
									"element"	=> $post_type . "_tax",
									"value"		=> 'title'
								),
				"value"			=> $titles_arr
			));		
		} else {
			$terms = get_terms( $tax );
			$avail_terms = array();
			if ( !is_a( $terms, 'WP_Error' ) ){
				foreach ( $terms as $term ) {
					$avail_terms[$term->name] = $term->slug;
				}
			}
			array_push( $params, array(
				"type"			=> "cws_dropdown",
				"multiple"		=> "true",
				"heading"		=> $tax_name,
				"param_name"	=> "{$post_type}_{$tax}_terms",
				"dependency"	=> array(
					"element"	=> $post_type . "_tax",
					"value"		=> $tax
					),
				"value"			=> $avail_terms
				));				
		}
	}
	$params2 = array(
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order by', 'vintwood' ),
			'param_name'	=> 'orderby',
			'save_always'	=> true,
			'value'			=> array(
				esc_html__( 'Date', 'vintwood' ) => 'date',
				esc_html__( 'Title', 'vintwood' ) => 'title',
			),
			"dependency"	=> array(
								"element"	=> "post_tax",
								"value"		=> array( "title","category","post_tag","post_format", )
							),
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'vintwood' ),
			'param_name'	=> 'order',
			'save_always'	=> true,
			'value'			=> array(
				esc_html__( 'DESC', 'vintwood' ) => 'DESC',
				esc_html__( 'ASC', 'vintwood' ) => 'ASC',
			),
			"dependency"	=> array(
								"element"	=> "post_tax",
								"value"		=> array( "title","category","post_tag","post_format", )
							),
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Layout', 'vintwood' ),
			'param_name'	=> 'layout',
			'save_always'	=> true,
			'value'			=> array(
				esc_html__( 'Default', 'vintwood' ) => 'def',
				esc_html__( 'Large Image', 'vintwood' ) => '1',
				esc_html__( 'Medium Image', 'vintwood' ) => 'medium',
				esc_html__( 'Small Image', 'vintwood' ) => 'small',
				esc_html__( 'Two Columns', 'vintwood' ) => '2',
				esc_html__( 'Three Columns', 'vintwood' ) => '3',
				esc_html__( 'Four Columns', 'vintwood' ) => '4',
				esc_html__( 'Checkerboard', 'vintwood' ) => 'checkerboard',
			)
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Content Alignment', 'vintwood' ),
			"param_name"	=> "content_align",
			"dependency" 	=> array(
								"element"	=> "layout",
								"value"		=> array( "checkerboard")
							),			
			"value"			=> array(
				esc_html__( "Top", 'vintwood' ) 	=> 'top',
				esc_html__( "Center", 'vintwood' )	=> 'center',
				esc_html__( "Bottom", 'vintwood' )	=> 'bottom'
			)		
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'huge_spacings',
			"dependency" 	=> array(
				"element"	=> "layout",
				"value"		=> array( "checkerboard" )
			),
			'value'			=> array(
				esc_html__( 'Add spacings', 'vintwood' ) => true
			)
		),	
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'crop_featured',
			'value'			=> array(
				esc_html__( 'Crop featured', 'vintwood' ) => true
			)
		),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'More button caption', 'vintwood' ),
			"param_name"	=> "more_btn_text",
			"value"			=> "CONTINUE READING"
		),		
		array(
			'type'				=> 'cws_dropdown',
			'multiple'			=> false,
			'heading'			=> esc_html__( 'Show', 'vintwood' ),
			'param_name'		=> 'link_show',
			'value'				=> array(
				esc_html__( 'Make Image Clickable', 'vintwood' ) => 'single_link',
				esc_html__( 'No Clickable', 'vintwood' ) => '',
			),
			"std"				=> "dots",
		),	
		array(
			'type'			=> 'checkbox',
			'param_name'	=> $post_type . '_hide_meta_override',
			'value'			=> array(
				esc_html__( 'Hide Meta Data', 'vintwood' ) => true
			)
		),	
		array(
			'type'			=> 'cws_dropdown',
			'multiple'		=> "true",
			'heading'		=> esc_html__( 'Hide', 'vintwood' ),
			'param_name'	=> $post_type . '_hide_meta',
			'dependency'	=> array(
					'element'	=> $post_type . '_hide_meta_override',
					'not_empty'	=> true
			),
			'value'			=> array(
				esc_html__( 'None', 'vintwood' )			=> '',
				esc_html__( 'Title', 'vintwood' )		=> 'title',
				esc_html__( 'Categories', 'vintwood' )	=> 'cats',
				esc_html__( 'Tags', 'vintwood' )			=> 'tags',
				esc_html__( 'Author', 'vintwood' )		=> 'author',
				esc_html__( 'Likes', 'vintwood' )		=> 'likes',
				esc_html__( 'Date', 'vintwood' )			=> 'date',
				esc_html__( 'Comments', 'vintwood' )		=> 'comments',
				esc_html__( 'Read More', 'vintwood' )	=> 'read_more',
				esc_html__( 'Social Icons', 'vintwood' )	=> 'social',
				esc_html__( 'Excerpt', 'vintwood' )	=> 'excerpt',		
			)
		),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Items to display', 'vintwood' ),
			"param_name"	=> "total_items_count",
			"value"			=> esc_html( get_option( 'posts_per_page' ) )
		),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Items per Page', 'vintwood' ),
			"param_name"	=> "items_pp",
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "grid" )
							),
			"value"			=> esc_html( get_option( 'posts_per_page' ) )
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Pagination', 'vintwood' ),
			"param_name"	=> 'pagination_grid',
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "grid" )
							),
			"value"			=> array(
				esc_html__( "Standard", 'vintwood' ) 	=> 'standard',
				esc_html__( "Load More", 'vintwood' )	=> 'load_more',
				esc_html__( "Standard With Ajax", 'vintwood' )	=> 'standard_with_ajax',
			)		
		),	
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Pagination Aligning', 'vintwood' ),
			"param_name"	=> "aligning",
			"dependency"	=> array(
					"element"	=> "pagination_grid",
					"value"		=> "load_more"
			),	
			"value"			=> array(
				esc_html__( 'Center', 'vintwood' )		=> 'center',
				esc_html__( 'Left', 'vintwood' )		=> 'left',
				esc_html__( 'Right', 'vintwood' )		=> 'right'
			),
		),
		vc_map_add_css_animation(),		

	);

	$params = array_merge($params, $params2);

	$def_chars_count = $cws_theme_funcs->cws_get_option( 'def_chars_count' );
	$def_chars_count = isset( $def_chars_count ) && is_numeric( $def_chars_count ) ? $def_chars_count : '';
	array_push( $params, array(
		'type'			=> 'textfield',
		'heading'		=> esc_html__( 'Content Character Limit', 'vintwood' ),
		'param_name'	=> 'chars_count',
		'value'			=> 	$def_chars_count	
	));
	array_push( $params, array(
		"type"				=> "textfield",
		"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
		"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
		"param_name"		=> "el_class",
		"value"				=> ""
	));

	vc_map( array(
		"name"				=> esc_html__( 'CWS Blog', 'vintwood' ),
		"base"				=> "cws_sc_vc_blog",
		'category'			=> "By CWS",
		"weight"			=> 80,
		"icon"     			=> "cws_icon",		
		"params"			=> $params
	));

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_CWS_Sc_Vc_Blog extends WPBakeryShortCode {
    }
}

?>