<?php
	// Map Shortcode in Visual Composer
	global $cws_theme_funcs;
	$first_color 			= $cws_theme_funcs->cws_get_option( 'theme-first-color' );
	$font_options 			= $cws_theme_funcs->cws_get_option( 'body-font' );
	$font_color 			= $font_options['color'];
	$icon_params 			= cws_ext_icon_vc_sc_config_params();
	$params 				= cws_ext_merge_arrs( array(
		array(
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Post Count', 'vintwood' ),
				"param_name"	=> "number",
				"value"			=> "4"
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Posts per slide', 'vintwood' ),
				"param_name"	=> "visible_number",
				"value"			=> "2"
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			)
		)
	));
	vc_map( array(
		"name"				=> esc_html__( 'CWS Twitter', 'vintwood' ),
		"base"				=> "cws_sc_twitter",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Twitter extends WPBakeryShortCode {
	    }
	}
?>