<?php
	global $cws_theme_funcs;
	$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	// Map Shortcode in Visual Composer
	vc_map( array(
		"name"				=> esc_html__( 'CWS Tips', 'vintwood' ),
		"base"				=> "cws_sc_tips",
		'category'			=> "By CWS",
                "icon"                          => "cws_icon",
		"weight"			=> 80,
        'description' => esc_html__( 'Image Tips with tooltip', 'vintwood' ),
        "params" => array(
        	array(
        		"type" => "attach_image",
        		"heading" => esc_html__("Image", "vintwood"),
        		"param_name" => "image",
        		"value" => "",
        		"description" => esc_html__("Select image from media library.", "vintwood")
        		),
        	array(
        		"type" => "textfield",
        		"heading" => esc_html__("Resize image to this width", "vintwood"),
        		"param_name" => "width",
        		"value" => "",
        		"description" => esc_html__("You can resize image to this width, or keep it to blank to use the original image.", "vintwood")
        		),
        	array(
        		"type" => "textarea_html",
        		"holder" => "div",
        		"heading" => esc_html__("Tooltip content, divide each one with [cwstips][/cwstips], please edit in text mode:", "vintwood"),
        		"param_name" => "content",
        		"value" => esc_html__("[cwstips]
        			You have to wrap each tooltip block in <strong>cwstips</strong>.
        			[/cwstips]
        			[cwstips]
        			Hello tooltip 2, you can customize the icon color, link, arrow position, tooltip content etc in the backend.
        			[/cwstips]
        			[cwstips]
        			Hello tooltip 3
        			[/cwstips]
        			", "vintwood"), "description" => esc_html__("Enter content for each block here. Divide each with [cwstips].", "vintwood") ),
        	array(
        		"type" => "dropdown",
        		"heading" => esc_html__("Display which tooltip by default?", "vintwood"),
        		"param_name" => "isdisplayall",
        		'value' => array(__("Display all of them when loaded", "vintwood") => "on", esc_html__("Display a specified one (customize it below:)", "vintwood") => "specify", esc_html__("Hide them all when loaded", "vintwood") => "off"),
        		'std' => 'off',
        		"description" => esc_html__('Default all the tooltips are hidden. Though you can choose to open all of them or a single one when page is loaded.', 'vintwood')
        		),
        	array(
        		"type" => "textfield",
        		"heading" => esc_html__("Display this tooltip when page loaded:", "vintwood"),
        		"param_name" => "displayednum",
        		"value" => "1",
        		"dependency" => Array('element' => "isdisplayall", 'value' => array('specify')),
        		"description" => esc_html__("You can specify to display which tooltip in current image. Default is <strong>1</strong>, which stand for the number 1 tooltip will be opened when page is loaded.", "vintwood")
        		),
        	array(
        		"type" => "dropdown",
        		"holder" => "",
        		"class" => "vintwood",
        		"heading" => esc_html__("Display the tips with?", "vintwood"),
        		"param_name" => "icontype",
        		"value" => array(__("single dot", "vintwood") => "dot", esc_html__("number", "vintwood") => "number", esc_html__("Font Awesome icon", "vintwood") => "icon"),
        		"description" => ""
        		),
        	array(
        		"type" => "textfield",
        		"heading" => esc_html__("Numbers start from", "vintwood"),
        		"param_name" => "startnumber",
        		"value" => "1",
        		"dependency" => Array('element' => "icontype", 'value' => array('number')),
        		"description" => esc_html__("Default is start from 1, you can specify other value here, like 4.", "vintwood")
        		),
        	array(
        		"type" => "exploded_textarea",
        		"holder" => "",
        		"class" => "vintwood",
        		"heading" => esc_html__("Font Awesome icon for each tips:", 'vintwood'),
        		"param_name" => "fonticon",
        		"value" => esc_html__("fa-hand-o-right,fa-image,fa-coffee,fa-comment", 'vintwood'),
        		"dependency" => Array('element' => "icontype", 'value' => array('icon')),
        		"description" => esc_html__("Put the <a href='http://fortawesome.github.io/Font-Awesome/icons/' target='_blank'>Font Awesome icon</a> here, divide with linebreak (Enter).", 'vintwood')
        		),
        	array(
        		"type" => "exploded_textarea",
        		"holder" => "",
        		"class" => "vintwood",
        		"heading" => esc_html__("Each tips icon's position", 'vintwood'),
        		"param_name" => "position",
        		"value" => esc_html__("25%|30%,35%|20%,45%|60%,75%|20%", 'vintwood'),
        		"description" => esc_html__("Position of each icon in <strong>top|left</strong> format. Please update via dragging the tips icon in the Visual Composer Frontend editor. See a <a href='http://youtu.be/9j1XhIQw9JE' target='_blank'>Youtube video demo</a>.", 'vintwood')
        		),
        	array(
        		"type" => "colorpicker",
        		"holder" => "div",
        		"class" => "",
        		"heading" => esc_html__("Global tips icon color", 'vintwood'),
        		"param_name" => "iconbackground",
        		"value" => 'rgba(0,0,0,0.8)',
        		"description" => esc_html__("Global color for the tips icon. Or you can specify different color for each icon below.", 'vintwood')
        		),
        	array(
        		"type" => "colorpicker",
        		"holder" => "div",
        		"class" => "",
        		"heading" => esc_html__("Hotspot circle dot (or Font Awesome icon) color", 'vintwood'),
        		"param_name" => "circlecolor",
        		"value" => '#FFFFFF',
        		"description" => esc_html__("Color for the tips circle dot. Default is white.", 'vintwood')
        		),
        	array(
        		"type" => "exploded_textarea",
        		"holder" => "",
        		"class" => "vintwood",
        		"heading" => esc_html__("Each tips icon's color", 'vintwood'),
        		"param_name" => "color",
        		"value" => "",
        		"description" => esc_html__("Color for each icon, you can use the value like #663399 or the name of the color like blue here. Divide each with linebreaks (Enter).", 'vintwood')
        		),
        	array(
        		"type" => "dropdown",
        		"holder" => "",
        		"class" => "vintwood",
        		"heading" => esc_html__("Display pulse animation for the tips icon?", "vintwood"),
        		"param_name" => "ispulse",
        		"value" => array(__("yes", "vintwood") => "yes", esc_html__("no", "vintwood") => "no"),
        		"description" => ""
        		),
        	array(
        		"type" => "dropdown",
        		"holder" => "",
        		"class" => "vintwood",
        		"heading" => esc_html__("Select pulse border color", "vintwood"),
        		"param_name" => "pulsecolor",
        		"value" => array(__("Default", "vintwood") => "pulse-white", esc_html__("gray", "vintwood") => "pulse-gray", esc_html__("red", "vintwood") => "pulse-red", esc_html__("green", "vintwood") => "pulse-green", esc_html__("yellow", "vintwood") => "pulse-yellow", esc_html__("blue", "vintwood") => "pulse-blue", esc_html__("purple", "vintwood") => "pulse-purple"),
        		"dependency" => Array('element' => "ispulse", 'value' => array('yes')),
        		"std" => "pulse-white",
        		"description" => esc_html__("You can select the pulse border color here, default is white.", "vintwood")
        		),
        	array(
        		"type" => "exploded_textarea",
        		"holder" => "",
        		"class" => "vintwood",
        		"heading" => esc_html__("Tooltip arrow position for each tips", 'vintwood'),
        		"param_name" => "arrowposition",
        		"value" => "",
        		"description" => esc_html__("The arrow position for each tooltip, default is top. The available options are: <strong>top, right, bottom, left, top-right, top-left, bottom-right, bottom-left</strong>. Divide each with linebreaks (Enter)", 'vintwood')
        		),

        	array(
        		"type" => "textfield",
        		"heading" => esc_html__("Hotspot icon opacity", "vintwood"),
        		"param_name" => "opacity",
        		"value" => "1",
        		"description" => esc_html__("The opacity of each icon, default is 1", "vintwood")
        		),
        	array(
        		"type" => "dropdown",
        		"holder" => "",
        		"class" => "vintwood",
        		"heading" => esc_html__("Tooltip style", "vintwood"),
        		"param_name" => "tooltipstyle",
        		"value" => array(__("shadow", "vintwood") => "shadow", esc_html__("light", "vintwood") => "light", esc_html__("noir", "vintwood") => "noir", esc_html__("punk", "vintwood") => "punk"),
        		"description" => ""
        		),
        	array(
        		"type" => "dropdown",
        		"holder" => "",
        		"class" => "vintwood",
        		"heading" => esc_html__("Tooltip trigger when user", "vintwood"),
        		"param_name" => "trigger",
        		"value" => array(__("hover", "vintwood") => "hover", esc_html__("click", "vintwood") => "click"),
        		"description" => esc_html__("Select how to trigger the tooltip.", "vintwood")
        		),
        	array(
        		"type" => "dropdown",
        		"holder" => "",
        		"class" => "vintwood",
        		"heading" => esc_html__("Tooltip animation", "vintwood"),
        		"param_name" => "tooltipanimation",
        		"value" => array(__("grow", "vintwood") => "grow", esc_html__("fade", "vintwood") => "fade", esc_html__("swing", "vintwood") => "swing", esc_html__("slide", "vintwood") => "slide", esc_html__("fall", "vintwood") => "fall"),
        		"description" => esc_html__("Choose the animation for the tooltip.", "vintwood")
        		),
        	array(
        		"type" => "exploded_textarea",
        		"holder" => "",
        		"class" => "vintwood",
        		"heading" => esc_html__("Link for each tips icon", 'vintwood'),
        		"param_name" => "links",
        		"value" => "",
        		"description" => esc_html__("Specify link for each icon, divide each with linebreaks (Enter).", 'vintwood')
        		),
        	array(
        		"type" => "dropdown",
        		"heading" => esc_html__("How to open the link for the icon?", "vintwood"),
        		"param_name" => "custom_links_target",
        		"description" => esc_html__('Select how to open the links', 'vintwood'),
        		'value' => array(__("Same window", "vintwood") => "_self", esc_html__("New window", "vintwood") => "_blank")
        		),
        	array(
        		"type" => "textfield",
        		"heading" => esc_html__("maxWidth of the tooltip", "vintwood"),
        		"param_name" => "maxwidth",
        		"value" => "240",
        		"description" => esc_html__("maxWidth for the tooltip, 0 is auto width, you can specify a value here, default is 240.", "vintwood")
        		),
        	array(
        		"type" => "textfield",
        		"heading" => esc_html__("Container width", "vintwood"),
        		"param_name" => "containerwidth",
        		"value" => "",
        		"description" => esc_html__("You can specify the container width here, default is 100%. You can try other value like 80%, it will be align center automatically.", "vintwood")
        		),
        	array(
        		"type" => "textfield",
        		"heading" => esc_html__("Margin offset", "vintwood"),
        		"param_name" => "marginoffset",
        		"value" => "",
        		"description" => esc_html__("The margin offset for the tips icon in small screen. For example <strong>-6px 0 0 -6px</strong> will move the icons upper left for 6px offset in small screen. Leave here to be blank if you do not want it.", "vintwood")
        		),
        	array(
        		"type" => "textfield",
        		"heading" => esc_html__("Extra class name for the container", "vintwood"),
        		"param_name" => "extra_class",
        		"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "vintwood")
        		)

        	)
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Tips extends WPBakeryShortCode {
	    }
	}
?>