<?php
	global $cws_theme_funcs;
	$body_font_options = $cws_theme_funcs->cws_get_option( 'body-font' );
	$body_font_color = esc_attr( $body_font_options['color'] );
	$theme_first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );	
	$theme_second_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-second-color' ) );	
	$theme_helper_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-helper-color' ) );
	$icon_params = cws_ext_icon_vc_sc_config_params();
	$params = cws_ext_merge_arrs( array(
		array(
			array(
				"type"			=> "textfield",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Subtitle', 'vintwood' ),
				"param_name"	=> "subtitle",
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "subtitile_decor",
				"value"			=> array( esc_html__( 'Add Subtitle Decoration Lines', 'vintwood' ) => true ),
				"dependency"	=> array(
					"element"	=> "subtitle",
					"not_empty"	=> true
				),
				"std"			=> "1"
			),
			array(
				"type"			=> "textfield",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Title', 'vintwood' ),
				"param_name"	=> "title",
			),
			array(
				"heading"		=> esc_html__( 'Drop-Shadow Properties', 'vintwood' ),
				"param_name"	=> "drop_shadow_prop",
				"type"			=> "textfield",
				"dependency"	=> array(
					"element"	=> "title",
					"not_empty"	=> true
				),
				"value"			=> '5px 6px'
			),
			array(
				"heading"		=> esc_html__( 'Drop-Shadow Color', 'vintwood' ),
				"param_name"	=> "drop_shadow_color",
				"type"			=> "colorpicker",
				"dependency"	=> array(
					"element"	=> "title",
					"not_empty"	=> true
				),
				"value"			=> "#A9C9BB"
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Title HTML Tag', 'vintwood' ),
				"param_name"	=> "title_tag",
				"value"			=> array(
					esc_html__( "Default - (H3)", 'vintwood' ) 	=> 'h3',
					esc_html__( "H1", 'vintwood' ) 				=> 'h1',
					esc_html__( "H2", 'vintwood' ) 				=> 'h2',
					esc_html__( "H3", 'vintwood' ) 				=> 'h3',
					esc_html__( "H4", 'vintwood' ) 				=> 'h4',
					esc_html__( "H5", 'vintwood' ) 				=> 'h5',
					esc_html__( "H6", 'vintwood' ) 				=> 'h6',
				)	
			),
			array(
				"type"			=> "textfield",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Banner', 'vintwood' ),
				"param_name"	=> "banner",
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Text Alignment', 'vintwood' ),
				"param_name"	=> "text_alignment",
				"value"			=> array(
					esc_html__( "Left", 'vintwood' ) 		=> 'left',
					esc_html__( "Center", 'vintwood' )		=> 'center',
					esc_html__( "Right", 'vintwood' )		=> 'right'
				)	
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "no_infinite",
				"value"			=> array( esc_html__( 'Disable infinite line', 'vintwood' ) => true )
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "tablet_center",
				"value"			=> array( esc_html__( 'Align center on tablet devices', 'vintwood' ) => true )
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "mobile_center",
				"value"			=> array( esc_html__( 'Align center on mobile devices', 'vintwood' ) => true )
			),
			array(
				"type"			=> "textarea_html",
				"heading"		=> esc_html__( 'Text', 'vintwood' ),
				"param_name"	=> "content",
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_button",
				"value"			=> array( esc_html__( 'Add Button', 'vintwood' ) => true )
			),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Button Title', 'vintwood' ),
				"param_name"		=> "button_title",
				"value"				=> "",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				)
			),	
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Button URL', 'vintwood' ),
				"param_name"		=> "button_url",
				"value"				=> "#",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				)
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			),	
			array(
				"type"			=> "css_editor",
				"param_name"	=> "custom_styles",
				"group"			=> esc_html__( "Styling", 'vintwood' )
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "customize_size",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> array( esc_html__( 'Customize Sizes', 'vintwood' ) => true )				
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Title Margins', 'vintwood' ),
				"param_name"	=> "title_margins",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"description"	=> esc_html__( '1, 2( top/bottom, left/right ) or 4, space separated, values with units', 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_size",
					"not_empty"	=> true
				),
				"value"			=> "0px 0px 0px 0px"
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Text Margins', 'vintwood' ),
				"param_name"	=> "text_margins",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"description"	=> esc_html__( '1, 2( top/bottom, left/right ) or 4, space separated, values with units', 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_size",
					"not_empty"	=> true
				),
				"value"			=> "0px 0px 0px 0px"
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Subtitle Size', 'vintwood' ),
				"param_name"	=> "subtitle_size",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_size",
					"not_empty"	=> true
				),
				"value"			=> "30px"
			),	
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Title Size', 'vintwood' ),
				"param_name"	=> "title_size",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_size",
					"not_empty"	=> true
				),
				"value"			=> "175px"
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Banner Size', 'vintwood' ),
				"param_name"	=> "banner_size",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_size",
					"not_empty"	=> true
				),
				"value"			=> "45px"
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "customize_colors",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> array( esc_html__( 'Customize Colors', 'vintwood' ) => true ),
				"std"			=> "1"
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Font Color', 'vintwood' ),
				"param_name"	=> "custom_font_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $body_font_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Subtitle Color', 'vintwood' ),
				"param_name"	=> "custom_subtitle_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $theme_first_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Title Color', 'vintwood' ),
				"param_name"	=> "custom_title_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $theme_second_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Title Background Color', 'vintwood' ),
				"param_name"	=> "custom_title_bg_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> ''
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Banner Font Color', 'vintwood' ),
				"param_name"	=> "custom_banner_font_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> "#eae5de"
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Banner Background Color', 'vintwood' ),
				"param_name"	=> "custom_banner_bg_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $theme_second_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Button Color', 'vintwood' ),
				"param_name"	=> "custom_button_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $theme_second_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Button Color on Hover', 'vintwood' ),
				"param_name"	=> "custom_hover_button_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $theme_first_color
			),
		)
	));
	vc_map( array(
		"name"				=> esc_html__( 'CWS Text', 'vintwood' ),
		"base"				=> "cws_sc_text",
		'category'			=> "By CWS",
		// "icon"				=> "boc_spacing",
		"icon"     			=> "cws_icon",		
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Text extends WPBakeryShortCode {
	    }
	}
?>