<?php
	global $cws_theme_funcs;
	$params = array(
		array(
			"type"			=> "textfield",
			"admin_label"	=> true,
			"heading"		=> esc_html__( 'Title', 'vintwood' ),
			"param_name"	=> "title",
			"value"			=> ""
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Title Alignment', 'vintwood' ),
			"param_name"	=> "title_align",
			"value"			=> array(
				esc_html__( "Left", 'vintwood' ) 	=> 'left',
				esc_html__( "Right", 'vintwood' )	=> 'right',
				esc_html__( "Center", 'vintwood' )	=> 'center'
			)		
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Layout', 'vintwood' ),
			"param_name"	=> "display_style",
			"value"			=> array(
								esc_html__( 'Grid', 'vintwood' ) => 'grid',
								/*esc_html__( 'Grid with Filter', 'vintwood' ) => 'filter',*/
								esc_html__( 'Carousel', 'vintwood' ) => 'carousel'
							)
		), 
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Columns', 'vintwood' ),
			"param_name"	=> "layout",
			"value"			=> array(
				esc_html__( 'Default', 'vintwood' ) => 'def',
				esc_html__( 'One Column', 'vintwood' ) => '1',
				esc_html__( 'Two Columns', 'vintwood' ) => '2',
				esc_html__( 'Three Columns', 'vintwood' ) => '3'
			)
		),
	);


	$taxes = get_object_taxonomies ( 'cws_testimonial', 'object' );
	$avail_taxes = array(
		esc_html__( 'None', 'vintwood' )	=> ''
	);
	foreach ( $taxes as $tax => $tax_obj ){
		$tax_name = isset( $tax_obj->labels->name ) && !empty( $tax_obj->labels->name ) ? $tax_obj->labels->name : $tax;
		$avail_taxes[$tax_name] = $tax;
	}
	array_push( $params, array(
		"type"				=> "dropdown",
		"heading"			=> esc_html__( 'Filter by', 'vintwood' ),
		"param_name"		=> "tax",
		"value"				=> $avail_taxes
	));
	foreach ( $avail_taxes as $tax_name => $tax ) {
		$terms = get_terms( $tax );
		$avail_terms = array(
			''				=> ''
		);
		if ( !is_a( $terms, 'WP_Error' ) ){
			foreach ( $terms as $term ) {
				$avail_terms[$term->name] = $term->slug;
			}
		}
		array_push( $params, array(
			"type"			=> "cws_dropdown",
			"multiple"		=> "true",
			"heading"		=> $tax_name,
			"param_name"	=> "{$tax}_terms",
			"dependency"	=> array(
								"element"	=> "tax",
								"value"		=> $tax
							),
			"value"			=> $avail_terms
		));				
	}

	$params2 = array(
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'auto_play_carousel',
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "carousel" )
							),
			'value'			=> array(
				esc_html__( 'AutoPlay Carousel', 'vintwood' ) => true
			)
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'bvnvnvbnvbn',
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "carousel" )
							),
			'value'			=> array(
				esc_html__( 'Add Navigation Arrows', 'vintwood' ) => true
			)
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'pagination_carousel',
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "carousel" )
							),
			'value'			=> array(
				esc_html__( 'Add Navigation Bullets', 'vintwood' ) => true
			)
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "customize_colors",
			"dependency" 	=> array(
				"element"	=> "display_style",
				"value"		=> array( "carousel" )
				),
			"value"			=> array( esc_html__( 'Customize Colors Carousel', 'vintwood' ) => true )
			),
		array(
			"type"			=> "colorpicker",
			"heading"		=> esc_html__( 'Navigation Color', 'vintwood' ),
			"param_name"	=> "custom_arrow_color",
			"dependency"	=> array(
				"element"	=> "customize_colors",
				"not_empty"	=> true
				),
			"value"			=> ""
			),
		array(
			"type"			=> "colorpicker",
			"heading"		=> esc_html__( 'Pagination Color', 'vintwood' ),
			"param_name"	=> "custom_pagination_color",
			"dependency"	=> array(
				"element"	=> "customize_colors",
				"not_empty"	=> true
				),
			"value"			=> ""
			),

		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'hide_data_override',
			'value'			=> array(
				esc_html__( 'Hide Meta Data', 'vintwood' ) => true
			)
		),
		array(
			'type'				=> 'cws_dropdown',
			'multiple'			=> "true",
			'heading'			=> esc_html__( 'Hide', 'vintwood' ),
			'param_name'		=> 'data_to_hide',
			'dependency'		=> array(
				'element'			=> 'hide_data_override',
				'not_empty'			=> true
			),
			'value'				=> array(
				esc_html__( 'None', 'vintwood' )			=> '',
				esc_html__( 'Positions', 'vintwood' )	=> 'poss',
				esc_html__( 'Background', 'vintwood' )	=> 'background',
				esc_html__( 'Raiting', 'vintwood' )		=> 'raiting',
				esc_html__( 'Excerpt', 'vintwood' )		=> 'excerpt',
			)
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'change_title',
			'value'			=> array(
				esc_html__( 'Change Details Button', 'vintwood' ) => true
			)
		),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Title Button', 'vintwood' ),
			"param_name"	=> "title_btn",
			'dependency'		=> array(
				'element'			=> 'change_title',
				'not_empty'			=> true
			),
			"value"			=> esc_html__( 'Read More', 'vintwood' )
		),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Items to display', 'vintwood' ),
			"param_name"	=> "total_items_count",
			"value"			=> esc_html( get_option( 'posts_per_page' ) )
		),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Items per Page', 'vintwood' ),
			"param_name"	=> "items_pp",
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "grid", "filter" )
							),
			"value"			=> esc_html( get_option( 'posts_per_page' ) )
		),
	);
	$params = array_merge($params, $params2);
	array_push( $params, array(
		"type"				=> "textfield",
		"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
		"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
		"param_name"		=> "el_class",
		"value"				=> ""
	));
	vc_map( array(
		"name"				=> esc_html__( 'CWS Testimonials Grid', 'vintwood' ),
		"base"				=> "cws_sc_testimonial_posts",
		'category'			=> "By CWS",
		"weight"			=> 80,
		"icon"     			=> "cws_icon",
		"params"			=> $params
	));
	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Testimonials_Posts extends WPBakeryShortCode {
	    }
	}
?>