<?php
	// Map Shortcode in Visual Composer
	global $cws_theme_funcs;
	$first_color 			= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	$second_color 			= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-second-color' ) );
	$helper_color 			= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-helper-color' ) );

	vc_map( array(
		"name"				=> esc_html__( 'Custom Testimonials', 'vintwood' ),
		"base"				=> "cws_sc_vc_testimonial",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> array(
			array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'vintwood' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter values for graph - thumbnail, quote, author name and author status.', 'vintwood' ),
                'value' => urlencode( json_encode( array(
                    array(
                        'thumbnail' 		=> '',
                        'quote' 			=> '',
                        'author_name' 		=> 'John Doe',
                        'author_status' 	=> '',
                    ),
                    array(
                        'thumbnail' 		=> '',
                        'quote' 			=> '',
                        'author_name' 		=> 'John Doe',
                        'author_status' 	=> '',
                    ),
                    array(
                        'thumbnail' 		=> '',
                        'quote' 			=> '',
                        'author_name' 		=> 'John Doe',
                        'author_status' 	=> '',
                    ),
                ) ) ),
                'params' => array(
		            array(
						"type"			=> "attach_image",
						"heading"		=> esc_html__( 'Thumbnail', 'vintwood' ),
						"param_name"	=> "thumbnail",
					),
					array(
						"type"			=> "textarea",
						"heading"		=> esc_html__( 'Quote', 'vintwood' ),
						"param_name"	=> "quote",
					),
					array(
						"type"			=> "textfield",
						"heading"		=> esc_html__( 'Author Name', 'vintwood' ),
						"param_name"	=> "author_name",
                        'admin_label' 	=> true,
					),
                ),
            ),
			array(
                "type"          => "dropdown",
                "heading"       => esc_html__( 'Testimonials Grid', 'vintwood' ),
                "param_name"    => "item_grid",
                "value"         => array(
                    esc_html__( 'One Column', 'vintwood' )    => '1',
                    esc_html__( 'Two Columns', 'vintwood' )   => '2',
                    esc_html__( 'Three Columns', 'vintwood' ) => '3',
                ),              
            ),
            array(
                "type"          => "checkbox",
                "param_name"    => "use_carousel",
                "std"           => true,
                "value"         => array( esc_html__( 'Use Carousel', 'vintwood' ) => true )
            ),
            array(
                "type"          => "checkbox",
                "param_name"    => "autoplay",
                "value"         => array( esc_html__( 'Autoplay', 'vintwood' ) => true ),
                "dependency"	=> array(
					"element"	=> "use_carousel",
					"not_empty"	=> true
				),
            ),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Autoplay Speed', 'vintwood' ),
				"param_name"	=> "autoplay_speed",
                "dependency"	=> array(
					"element"	=> "autoplay",
					"not_empty"	=> true
				),
				"value" 		=> "3000"
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "customize_colors",
				"value"			=> array( esc_html__( 'Customize Colors', 'vintwood' ) => true )
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Text Color', 'vintwood' ),
				"param_name"	=> "text_color",
				"value"			=> '#3f485d',
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				)
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Author Color', 'vintwood' ),
				"param_name"	=> "author_color",
				"value"			=> $second_color,
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				)
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Author Background Color', 'vintwood' ),
				"param_name"	=> "author_bg_color",
				"value"			=> $helper_color,
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				)
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Carousel Dots Color', 'vintwood' ),
				"param_name"	=> "dots_color",
				"value"			=> $second_color,
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				)
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			)
		)
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Testimonial extends WPBakeryShortCode {
	    }
	}
?>