<?php
	global $cws_theme_funcs;
	$first_color  = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	$second_color  = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-second-color' ) );
	$helper_color  = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-helper-color' ) );
	$body_font_options = $cws_theme_funcs->cws_get_option( 'body-font' );
	$body_font_color = esc_attr( $body_font_options['color'] );
	$params = array(
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Layout', 'vintwood' ),
			"param_name"	=> "display_style",
			"value"			=> array(
								esc_html__( 'Grid', 'vintwood' ) => 'grid',
								esc_html__( 'Carousel', 'vintwood' ) => 'carousel'
							)
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'auto_play_carousel',
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "carousel" )
							),
			'value'			=> array(
				esc_html__( 'AutoPlay Carousel', 'vintwood' ) => true
			)
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'navigation_carousel',
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "carousel" )
							),
			'value'			=> array(
				esc_html__( 'Add Navigation Controls', 'vintwood' ) => true
			)
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'pagination_carousel',
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "carousel" )
							),
			'value'			=> array(
				esc_html__( 'Add Navigation Bullets', 'vintwood' ) => true
			)
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Columns', 'vintwood' ),
			"param_name"	=> "layout",
			"dependency"	=> array(
				"element" => "display_direction",
				"value" => "row"
			),
			"value"			=> array(
				esc_html__( 'Default', 'vintwood' ) => 'def',
				esc_html__( 'One Column', 'vintwood' ) => '1',
				esc_html__( 'Two Columns', 'vintwood' ) => '2',
				esc_html__( 'Three Columns', 'vintwood' ) => '3',
				esc_html__( 'Four Columns', 'vintwood' ) => '4',
			)
		),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Visible Characters', 'vintwood' ),
			"param_name"	=> "chars_count",
			"value"			=> '90'
		),
	);
		$taxes = get_object_taxonomies ( 'cws_staff', 'object' );
		$avail_taxes = array(
			esc_html__( 'None', 'vintwood' )	=> ''
		);
		foreach ( $taxes as $tax => $tax_obj ){
			$tax_name = isset( $tax_obj->labels->name ) && !empty( $tax_obj->labels->name ) ? $tax_obj->labels->name : $tax;
			$avail_taxes[$tax_name] = $tax;
		}
		array_push( $params, array(
			"type"				=> "dropdown",
			"heading"			=> esc_html__( 'Filter by', 'vintwood' ),
			"param_name"		=> "tax",
			"value"				=> $avail_taxes
		));
		foreach ( $avail_taxes as $tax_name => $tax ) {
			$terms = get_terms( $tax );
			$avail_terms = array(
				''				=> ''
			);
			if ( !is_a( $terms, 'WP_Error' ) ){
				foreach ( $terms as $term ) {
					$avail_terms[$term->name] = $term->slug;
				}
			}
			array_push( $params, array(
				"type"			=> "cws_dropdown",
				"multiple"		=> "true",
				"heading"		=> $tax_name,
				"param_name"	=> "{$tax}_terms",
				"dependency"	=> array(
									"element"	=> "tax",
									"value"		=> $tax
								),
				"value"			=> $avail_terms
			));				
		}
	$params2 = array(
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Items to display', 'vintwood' ),
			"param_name"	=> "total_items_count",
			"value"			=> esc_html( get_option( 'posts_per_page' ) )
		),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Items per Page', 'vintwood' ),
			"param_name"	=> "items_pp",
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "grid", "filter" )
							),
			"value"			=> esc_html( get_option( 'posts_per_page' ) )
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'customize_colors',
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			'value'			=> array(
				esc_html__( 'Customize Colors', 'vintwood' ) => true
			)
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Title Color', 'vintwood' ),
			"param_name"		=> "custom_title_color",
			"edit_field_class"	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "customize_colors",
				"not_empty"		=> true
			),
			"value"				=> "#e9e4dd"
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Terms Color', 'vintwood' ),
			"param_name"		=> "custom_terms_color",
			"edit_field_class"	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "customize_colors",
				"not_empty"		=> true
			),
			"value"				=> $second_color
		),	
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Title Background Color', 'vintwood' ),
			"param_name"		=> "title_bg_color",
			"edit_field_class"	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "customize_colors",
				"not_empty"		=> true
			),
			"value"				=> $helper_color
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Title Background Color on Hover', 'vintwood' ),
			"param_name"		=> "title_bg_hover_color",
			"edit_field_class"	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "customize_colors",
				"not_empty"		=> true
			),
			"value"				=> $second_color
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Navigation Color', 'vintwood' ),
			"param_name"		=> "custom_nav_color",
			"edit_field_class"	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "customize_colors",
				"not_empty"		=> true
			),
			"value"				=> $first_color
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Dots Color', 'vintwood' ),
			"param_name"		=> "custom_dots_color",
			"edit_field_class"	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "customize_colors",
				"not_empty"		=> true
			),
			"value"				=> $second_color
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'hide_data_override',
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			'value'			=> array(
				esc_html__( 'Hide Meta Data', 'vintwood' ) => true
			)
		),
		array(
			'type'				=> 'cws_dropdown',
			'multiple'			=> "true",
			'heading'			=> esc_html__( 'Hide', 'vintwood' ),
			'param_name'		=> 'data_to_hide',
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			'dependency'		=> array(
				'element'			=> 'hide_data_override',
				'not_empty'			=> true
			),
			'value'				=> array(
				esc_html__( 'None', 'vintwood' )			=> '',
				esc_html__( 'Departments', 'vintwood' ) 	=> 'deps',
				esc_html__( 'Positions', 'vintwood' )	=> 'poss',
				esc_html__( 'Excerpt', 'vintwood' )		=> 'excerpt',
				esc_html__( 'Social Links', 'vintwood' )	=> 'socials',
				esc_html__( 'Link to Details Page', 'vintwood' )	=> 'link_button',
				esc_html__( 'Email', 'vintwood' )			=> 'email',
				esc_html__( 'Tel', 'vintwood' )			=> 'tel',
				esc_html__( 'Experience', 'vintwood' )	=> 'experience',
				esc_html__( 'Biography', 'vintwood' )		=> 'biography',
			)
		),
		vc_map_add_css_animation(),		
	);
	$params = array_merge($params, $params2);
	array_push( $params, array(
		"type"				=> "textfield",
		"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
		"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
		"param_name"		=> "el_class",
		"value"				=> ""
	));
	vc_map( array(
		"name"				=> esc_html__( 'CWS Staff', 'vintwood' ),
		"base"				=> "cws_sc_staff_posts_grid",
		'category'			=> "By CWS",
		"weight"			=> 80,
		"icon"     			=> "cws_icon",		
		"params"			=> $params
	));
	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Staff_Posts_Grid extends WPBakeryShortCode {
	    }
	}
?>