<?php
    // Map Shortcode in Visual Composer
    $first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
    $icon_params = cws_ext_icon_vc_sc_config_params ();
    vc_map( array(
        "name"              => esc_html__( 'CWS Social Icons', 'vintwood' ),
        "base"              => "cws_sc_social_icons",
        'category'          => "By CWS",
        "weight"            => 80,
        'icon'              => 'cws_icon',
        "params"            => array(
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'vintwood' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter values for graph - value, title and color.', 'vintwood' ),
                'value' => urlencode( json_encode( array(
                    array(
                        'link' => 'https://www.facebook.com/',
                        'icon' => 'fa fa-facebook',
                        'title' => esc_html__( 'Facebook', 'vintwood' ),
                        'new_tab' => true,
                    ),
                    array(
                        'link' => 'https://twitter.com/',
                        'icon' => 'fa fa-twitter',
                        'title' => esc_html__( 'Twitter', 'vintwood' ),
                        'new_tab' => true,
                    ),
                    array(
                        'link' => 'https://www.instagram.com/',
                        'icon' => 'fa fa-instagram',
                        'title' => esc_html__( 'Instagram', 'vintwood' ),
                        'new_tab' => true,
                    ),
                ) ) ),
                'params' => array(
                    array(
                        'type' => 'iconpicker',
                        'heading' => esc_html__( 'Icon', 'vintwood' ),
                        'param_name' => 'icon',
                        'value' => 'fa fa-adjust', // default value to backend editor admin_label
                        'settings' => array(
                            'emptyIcon' => true,
                            // default true, display an "EMPTY" icon?
                            'iconsPerPage' => 200,
                            // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
                        ),
                        'description' => esc_html__( 'Select icon from library.', 'vintwood' ),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Link', 'vintwood' ),
                        'param_name' => 'link',
                        'admin_label' => true,
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Title', 'vintwood' ),
                        'param_name' => 'title',
                        'admin_label' => true,
                    ),
                    array(
                        "type"          => "checkbox",
                        "param_name"    => "new_tab",
                        "std"           => true,
                        "value"         => array( esc_html__( 'Open in New Tab', 'vintwood' ) => true )
                    ),
                ),
            ),
            // Styling
            array(
                "type"          => "dropdown",
                "heading"       => esc_html__( 'Icon Size', 'vintwood' ),
                "param_name"    => "icon_size",
                "value"         => array(
                    esc_html__( 'Regular', 'vintwood' )   => 'regular',
                    esc_html__( 'Small', 'vintwood' )     => 'small',
                    esc_html__( 'Large', 'vintwood' )     => 'large',
                ),              
                "group"         => esc_html__( "Styling", 'vintwood' ),
                'save_always' => true,
            ),
            array(
                "type"          => "dropdown",
                "heading"       => esc_html__( 'Icons Position', 'vintwood' ),
                "param_name"    => "icon_pos",
                "value"         => array(
                    esc_html__( 'Left', 'vintwood' )   => 'left',
                    esc_html__( 'Center', 'vintwood' )     => 'center',
                    esc_html__( 'Right', 'vintwood' )     => 'right',
                ),              
                "group"         => esc_html__( "Styling", 'vintwood' ),
                'save_always' => true,
            ),
            // Icon colors
            array(
                "type"          => "colorpicker",
                "heading"       => esc_html__( 'Icon Font Color', 'vintwood' ),
                "param_name"    => "icon_color",
                "group"         => esc_html__( "Styling", "vintwood" ),
                'edit_field_class'  => 'vc_col-xs-6',
                "value"         => '#fff'
            ),
            array(
                "type"          => "colorpicker",
                "heading"       => esc_html__( 'Icon Font Hover Color', 'vintwood' ),
                "param_name"    => "icon_color_hover",
                "group"         => esc_html__( "Styling", "vintwood" ),
                'edit_field_class'  => 'vc_col-xs-6',
                "value"         => $first_color
            ),
            array(
                "type"          => "colorpicker",
                "heading"       => esc_html__( 'Background Icon Color', 'vintwood' ),
                "param_name"    => "bg_color",
                "group"         => esc_html__( "Styling", "vintwood" ),
                'edit_field_class'  => 'vc_col-xs-6',
                "value"         => $first_color
            ),
            array(
                "type"          => "colorpicker",
                "heading"       => esc_html__( 'Background Icon Hover Color', 'vintwood' ),
                "param_name"    => "bg_hover_color",
                "group"         => esc_html__( "Styling", "vintwood" ),
                'edit_field_class'  => 'vc_col-xs-6',
                "value"         => '#fff'
            ),
            array(
                "type"          => "colorpicker",
                "heading"       => esc_html__( 'Stroke Icon Color', 'vintwood' ),
                "param_name"    => "stroke_color",
                "group"         => esc_html__( "Styling", "vintwood" ),
                'edit_field_class'  => 'vc_col-xs-6',
                "value"         => $first_color
            ),
            array(
                "type"          => "colorpicker",
                "heading"       => esc_html__( 'Stroke Icon Hover Color', 'vintwood' ),
                "param_name"    => "stroke_hover_color",
                "group"         => esc_html__( "Styling", "vintwood" ),
                'edit_field_class'  => 'vc_col-xs-6',
                "value"         => $first_color
            ),
            vc_map_add_css_animation(),
            // Icon Font Size
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Icon Font Size', 'vintwood'),
                'param_name' => 'icon_font',
                'value' => '15',
                'description' => esc_html__( 'Enter icon font-size in pixels.', 'vintwood' ),
                "group" => esc_html__( "Styling", 'vintwood' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
        ),
    ));

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_CWS_Sc_Social_Icons extends WPBakeryShortCode {
        }
    }

?>