<?php
	global $cws_theme_funcs;
	$def_fill_color			= "rgba(255, 255, 255, 0.95)";
	$body_font_options		= $cws_theme_funcs->cws_get_option( 'body-font' );
	$body_font_color		= esc_attr( $body_font_options['color'] );	
	$heading_font_options 	= $cws_theme_funcs->cws_get_option( 'header-font' );
	$heading_font_color 	= esc_attr( $heading_font_options['color'] );	
	$first_color 			= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	$second_color 			= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-second-color' ) );
	$helper_color 			= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-helper-color' ) );
	$icon_params 			= cws_ext_icon_vc_sc_config_params("services_type", false, array( "iconic" ) );

	$params 				= cws_ext_merge_arrs(
	array(
		array(
			array(
				"type"			=> "textfield",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Title', 'vintwood' ),
				"param_name"	=> "title",
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Type', 'vintwood' ),
				"param_name"	=> "services_type",
				"value"			=> array(
					esc_html__( 'Icon', 'vintwood' )		=> 'iconic',
					esc_html__( 'Text', 'vintwood' )		=> 'text',
				) 
			),
		),
		$icon_params,
		array(
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Icon Size', 'vintwood' ),
				"param_name"	=> "size_i",
				"value"			=> "45px"
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Alignment', 'vintwood' ),
				"param_name"	=> "alignment",
				"value"			=> array(
					esc_html__( "Left", 'vintwood' ) 	=> "left",
					esc_html__( "Right", 'vintwood' ) 	=> "right",
				)
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Text Spacing', 'vintwood' ),
				"description"	=> esc_html__( 'Top Spacing, enter values with units.', 'vintwood' ),
				"param_name"	=> "text_spacings",
				"value"			=> "0px"
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Text Line Height', 'vintwood' ),
				"description"	=> esc_html__( 'Enter values with units', 'vintwood' ),
				"param_name"	=> "text_line_height",
				"value"			=> "1.6em"
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Url', 'vintwood' ),
				"param_name"	=> "url",
			),
			array(
				"type"			=> "css_editor",
				"param_name"	=> "custom_styles",
				"group"			=> esc_html__( "Styling", 'vintwood' )
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "customize_size_title",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> array( esc_html__( 'Edit Title\'s Size', 'vintwood' ) => true )				
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Font Size', 'vintwood' ),
				"param_name"	=> "size_t",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_size_title",
					"not_empty"	=> true
				),
				"value"			=> "16px"
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "customize_colors",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> array( esc_html__( 'Customize Colors', 'vintwood' ) => true )
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Background Color', 'vintwood' ),
				"param_name"	=> "background_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $second_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Icon Color', 'vintwood' ),
				"param_name"	=> "icon_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> ""
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Icon Background Color', 'vintwood' ),
				"param_name"	=> "bg_icon_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $helper_color
			),	
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Title Color', 'vintwood' ),
				"param_name"	=> "custom_title_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $first_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Font Color', 'vintwood' ),
				"param_name"	=> "custom_font_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $body_font_color
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_hover",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> array( esc_html__( 'Customize Colors on Hover', 'vintwood' ) => true )
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Background Color', 'vintwood' ),
				"param_name"	=> "custom_background_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "add_hover",
					"not_empty"	=> true
				),
				"value"			=> $second_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Icon Color', 'vintwood' ),
				"param_name"	=> "custom_icon_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "add_hover",
					"not_empty"	=> true
				),
				"value"			=> "#fff"
			),			
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Icon Background Color', 'vintwood' ),
				"param_name"	=> "custom_bg_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "add_hover",
					"not_empty"	=> true
				),
				"value"			=> $first_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Title Color', 'vintwood' ),
				"param_name"	=> "custom_selection_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "add_hover",
					"not_empty"	=> true
				),
				"value"			=> $first_color
			),			
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Font Color', 'vintwood' ),
				"param_name"	=> "custom_f_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "add_hover",
					"not_empty"	=> true
				),
				"value"			=> $first_color
			),
			array(
				"type"			=> "textarea_html",
				"heading"		=> esc_html__( 'Description', 'vintwood' ),
				"param_name"	=> "content",
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			)	
		)
	));
	// Map Shortcode in Visual Composer
	vc_map( array(
		"name"				=> esc_html__( 'CWS Services', 'vintwood' ),
		"base"				=> "cws_sc_services",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Services extends WPBakeryShortCode {
	    }
	}
?>