<?php
	global $cws_theme_funcs;
	$helper_color 	= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-helper-color' ) );

	$params = cws_ext_merge_arrs( array(
		array(
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'URL', 'vintwood' ),
				"param_name"		=> "ribbon_link",
				"value"				=> ""
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Background Color', 'vintwood' ),
				"param_name"	=> "background_color",
				"value"			=> $helper_color
			),
			array(
				"type"			=> "attach_image",
				"heading"		=> esc_html__( 'Image', 'vintwood' ),
				"param_name"	=> "image",
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Alignment', 'vintwood' ),
				"param_name"	=> "ribbon_pos",
				"value"			=> array(
					esc_html__( 'Left', 'vintwood' ) 	=> 'left',
					esc_html__( 'Right', 'vintwood' ) 	=> 'right',
				)
			),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Ribbon Top offset', 'vintwood' ),
				"param_name"		=> "ribbon_top_offset",
				"edit_field_class"	=> "vc_col-xs-6",
				"value"				=> "0"
			),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Ribbon Side offset', 'vintwood' ),
				"param_name"		=> "ribbon_side_offset",
				"edit_field_class" 	=> "vc_col-xs-6",
				"value"				=> "0"
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			)
		),
	));

	vc_map( array(
		"name"				=> esc_html__( 'CWS Ribbon', 'vintwood' ),
		"base"				=> "cws_sc_ribbon",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Ribbon extends WPBakeryShortCode {
	    }
	}
?>