<?php
	global $cws_theme_funcs;
	$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	$second_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-second-color' ) );
	$helper_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-helper-color' ) );

	$params 		= cws_ext_merge_arrs( array(
		array(
			array(
				"type"			=> "textfield",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Title', 'vintwood' ),
				"param_name"	=> "title",
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Price', 'vintwood' ),
				"description"	=> esc_html__( 'Split integer and decimal part by dot symbol', 'vintwood' ),
				"param_name"	=> "price",
				"value"			=> "15",
				"save_always"	=> true
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Currency', 'vintwood' ),
				"param_name"	=> "currency",
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Description', 'vintwood' ),
				"param_name"	=> "price_desc",
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "highlighted",
				"value"			=> array( esc_html__( 'Highlight this Cell', 'vintwood' ) => true )			
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_button",
				"value"			=> array( esc_html__( 'Add Button', 'vintwood' ) => true )
			),
			array(
				"type"			=> "textfield",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Title', 'vintwood' ),
				"param_name"	=> "button_text",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				),
			),
			array(
				"type"			=> "textfield",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Url', 'vintwood' ),
				"param_name"	=> "button_url",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				)
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "button_new_tab",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				),
				"value"			=> array( esc_html__( 'Open Link in New Tab', 'vintwood' ) => true )
			),
			array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'vintwood' ),
                'param_name' => 'values',
                'value' => urlencode( json_encode( array(
                    array(
                        'text' 	=> '1 User Account',
                    ),
                    array(
                        'text' 	=> '1 Project',
                    ),
                    array(
                        'text' 	=> '1Gb Storage',
                    ),
                    array(
                        'text' 	=> '10 Files Upload',
                    ),
                ) ) ),
                'params' => array(
					array(
						"type"			=> "textarea",
						"heading"		=> esc_html__( 'Text Information Row', 'vintwood' ),
						"param_name"	=> "text",
					),
                ),
            ),
            array(
				"type"			=> "checkbox",
				"param_name"	=> "customize",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> array( esc_html__( 'Customize', 'vintwood' ) => true )
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Highlighted main color', 'vintwood' ),
				"param_name"	=> "highlighted_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize",
					"not_empty"	=> true
				),
				"value"			=> '#D9D052'
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Main info color', 'vintwood' ),
				"param_name"	=> "info_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize",
					"not_empty"	=> true
				),
				"value"			=> '#b16c7e'
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Borders color', 'vintwood' ),
				"param_name"	=> "borders_color",
				"edit_field_class" 	=> "vc_col-xs-6",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize",
					"not_empty"	=> true
				),
				"value"			=> '#435476'
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			),
		),
	));

	vc_map( array(
		"name"				=> esc_html__( 'CWS Pricing Plan', 'vintwood' ),
		"base"				=> "cws_sc_pricing_plan",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Pricing_Plan extends WPBakeryShortCode {
	    }
	}
?>