<?php
	global $cws_theme_funcs;
	$first_color 			= $cws_theme_funcs->cws_get_option( 'theme-first-color' );
	$second_color 			= $cws_theme_funcs->cws_get_option( 'theme-second-color' );
	$helper_color 			= $cws_theme_funcs->cws_get_option( 'theme-helper-color' );
	$params = array(
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Style', 'vintwood' ),
			"param_name"	=> "style",
			"value"			=> array(
				esc_html__( 'Default', 'vintwood' ) => 'default',
				esc_html__( 'Round', 'vintwood' ) => 'round',
			)
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "custom_title_hover",
			'value'			=> array(
				esc_html__( 'Add Custom Title Hover', 'vintwood' ) => true
			),
			"dependency" 	=> array(
				"element"	=> 'style',
				"value"		=> 'round'
			),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Layout', 'vintwood' ),
			"param_name"	=> "display_style",
			"value"			=> array(
				esc_html__( 'Grid', 'vintwood' ) => 'grid',
				esc_html__( 'Grid with Filter', 'vintwood' ) => 'filter',
				esc_html__( 'Grid with Filter(Ajax)', 'vintwood' ) => 'filter_with_ajax',
				esc_html__( 'Carousel', 'vintwood' ) => 'carousel',
				esc_html__( 'Showcase', 'vintwood' ) => 'showcase',
			)
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Columns', 'vintwood' ),
			"param_name"	=> "layout",
			"value"			=> array(
				esc_html__( 'Default', 'vintwood' ) => 'def',
				esc_html__( 'One Column', 'vintwood' ) => '1',
				esc_html__( 'Two Columns', 'vintwood' ) => '2',
				esc_html__( 'Three Columns', 'vintwood' ) => '3',
				esc_html__( 'Four Columns', 'vintwood' ) => '4',
				esc_html__( 'Five Columns', 'vintwood' ) => '5'
			)
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "crop_images",
			"dependency" 	=> array(
				"element"	=> 'layout',
				"value"		=> array( "def","2","3","4","5" )
			),
			'value'			=> array(
				esc_html__( 'Crop images', 'vintwood' ) => true
			)
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Sort by', 'vintwood' ),
			"param_name"	=> "sort_by",
			"value"			=> array(
				esc_html__( 'Date', 'vintwood' ) => 'date',
				esc_html__( 'Order ID', 'vintwood' ) => 'menu_order',
				esc_html__( 'Title', 'vintwood' ) => 'title'
			)
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Sorting', 'vintwood' ),
			"param_name"	=> "sorting",
			"value"			=> array(
				esc_html__( 'Descending', 'vintwood' ) => 'DESC',
				esc_html__( 'Ascending', 'vintwood' ) => 'ASC',
			)
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "masonry",
			"dependency" 	=> array(
				"element"	=> 'style',
				'value'		=> 'default'
			),
			'value'			=> array(
				esc_html__( 'Masonry', 'vintwood' ) => true
			)
		),
	);
	$taxes = get_object_taxonomies ( 'cws_portfolio', 'object' );
	$avail_taxes = array(
		esc_html__( 'None', 'vintwood' )	=> '',
		esc_html__( 'Titles', 'vintwood' )	=> 'title',
	);
	foreach ( $taxes as $tax => $tax_obj ){
		$tax_name = isset( $tax_obj->labels->name ) && !empty( $tax_obj->labels->name ) ? $tax_obj->labels->name : $tax;
		$avail_taxes[$tax_name] = $tax;
	}
	array_push( $params, array(
		"type"				=> "dropdown",
		"heading"			=> esc_html__( 'Filter by', 'vintwood' ),
		"param_name"		=> "tax",
		"value"				=> $avail_taxes
	));
	foreach ( $avail_taxes as $tax_name => $tax ) {
		if ($tax == 'title'){
			$custom_post_type = 'cws_portfolio';
			global $wpdb;
    		$results = $wpdb->get_results( $wpdb->prepare( "SELECT ID, post_title FROM {$wpdb->posts} WHERE post_type LIKE %s and post_status = 'publish'", $custom_post_type ) );
    		$titles_arr = array();
		    foreach( $results as $index => $post ) {
		    	$post_title = $post->post_title;
		        $titles_arr[$post_title] =  $post->ID;
		    }
			array_push( $params, array(
				"type"			=> "cws_dropdown",
				"multiple"		=> "true",
				"heading"		=> esc_html__( 'Titles', 'vintwood' ),
				"param_name"	=> "titles",
				"dependency"	=> array(
									"element"	=> "tax",
									"value"		=> 'title'
								),
				"value"			=> $titles_arr
			));		
		} else {
			$terms = get_terms( $tax );
			$avail_terms =  array();
			$hierarchy = _get_term_hierarchy($tax);
			if ( !is_a( $terms, 'WP_Error' ) ){
				foreach($terms as $term) {
					if(isset($term)){
						if($term->parent) {
							continue;
						} 			
						$avail_terms[] = $term->name;  
						if(isset($hierarchy[$term->term_id])) {	
							$children = _get_term_children($term->term_id, $terms, $tax);										
							foreach($children as $child) {
								$child = get_term($child, $tax);
								$ancestors = get_ancestors( $child->term_id, $child->taxonomy );
								$depth = $ancestors = count($ancestors);
								if($child->count > 0){
									if($depth <= $ancestors){							
										$avail_terms[] =  str_repeat("-", $depth) . ' ('.$term->name.') '.$child->slug;
									}
								}
							}
						}					
					}				
				}

			}

			array_push( $params, array(
				"type"			=> "cws_dropdown",
				"multiple"		=> "true",
				"heading"		=> $tax_name,
				"param_name"	=> "{$tax}_terms",
				"dependency"	=> array(
									"element"	=> "tax",
									"value"		=> $tax
								),
				"value"			=> $avail_terms, 
			));	
		} 		
	}
	$params2 = array(
		array(
			"type"			=> "checkbox",
			"param_name"	=> "en_isotope",
			"dependency" 	=> array(
					"element"	=> 'display_style',
					"value"		=> 'grid'
				),
			'value'			=> array(
				esc_html__( 'Use Isotope', 'vintwood' ) => true
			)
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "carousel_auto",
			"dependency" 	=> array(
								"element"	=> 'display_style',
								"value"		=> array( "carousel" )
							),
			'value'			=> array(
				esc_html__( 'AutoPlay Carousel', 'vintwood' ) => true
			)
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "carousel_pagination",
			"dependency" 	=> array(
								"element"	=> 'display_style',
								"value"		=> array( "carousel" )
							),
			'value'			=> array(
				esc_html__( 'Pagination', 'vintwood' ) => true
			)
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Hover', 'vintwood' ),
			"param_name"	=> "anim_style",
			"value"			=> array(
								esc_html__( 'Default Hover', 'vintwood' ) => 'hoverdef',
								esc_html__( 'Solid Color with Zoomed Border', 'vintwood' ) => 'hoverbi',
								esc_html__( 'Solid Color with Border', 'vintwood' ) => 'hoverbi2',
								esc_html__( 'Mouse Follow', 'vintwood' ) => 'hoverdir',
								// esc_html__( '3D Hover', 'vintwood' ) => 'hover3d',
								esc_html__( 'Zoom Slow Motion', 'vintwood' ) => 'hoverzs',
								esc_html__( 'Zoom With Rotation', 'vintwood' ) => 'hoversr',
								esc_html__( 'Zoom With Blur', 'vintwood' ) => 'hoverzb',
								esc_html__( 'No Hover With Link', 'vintwood' ) => 'hover_none_link',
								esc_html__( 'No Hover', 'vintwood' ) => 'hover_none',
							),
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"dependency" 	=> array(
					"element"	=> 'display_style',
					"value"		=> array( "carousel" ,"grid" , "filter", "filter_with_ajax" )
				),
		),
		array(
			'type'				=> 'cws_dropdown',
			'multiple'			=> "true",
			'heading'			=> esc_html__( 'Show', 'vintwood' ),
			'param_name'		=> 'link_show',					
			"dependency" 	=> array(
					"element"	=> 'anim_style',
					"value"		=> array( "hoverdef" ,"hoverdir" , "hoverbi", "hoverbi2", "hoverzs", "hoversr", "hoverzb" )
				),
			'value'				=> array(
				esc_html__( 'Make Image Clickable', 'vintwood' )	=> 'area_link',
				esc_html__( 'Show Image PoPup Icon', 'vintwood' )	=> 'popup_link',
			)
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "en_hover_color",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			'value'			=> array(
				esc_html__( 'Edit Fill Color', 'vintwood' ) => true
			),
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"dependency" 	=> array(
					"element"	=> 'anim_style',
					"value"		=> array( "hoverdef" ,"hoverdir" , "hoverbi", "hoverbi2", "hoverzs", "hoversr", "hoverzb" )
				),
		),		
		array(
			"type"			=> "colorpicker",
			"param_name"	=> "hover_color",
			"dependency"	=> array(
				"element"	=> "en_hover_color",
				"not_empty"	=> true
			),
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"value"			=> $helper_color,
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "en_title_color",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			'value'			=> array(
				esc_html__( 'Edit Title Color', 'vintwood' ) => true
			),
			"dependency" 	=> array(
					"element"	=> 'anim_style',
					"value"		=> array( "hoverdef" ,"hoverdir" , "hoverbi", "hoverbi2", "hoverzs", "hoversr", "hoverzb" )
				),
		),
		array(
			"type"			=> "colorpicker",
			"param_name"	=> "title_color",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"dependency"	=> array(
				"element"	=> "en_title_color",
				"not_empty"	=> true
			),
			"value"			=> "#f7ebd5"
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "en_title_bg_color",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			'value'			=> array(
				esc_html__( 'Edit Title Background Color', 'vintwood' ) => true
			),
			"dependency" 	=> array(
				"element"	=> 'anim_style',
				"value"		=> array( "hoverdef" ,"hoverdir" , "hoverbi", "hoverbi2", "hoverzs", "hoversr", "hoverzb" )
			),
		),
		array(
			"type"			=> "colorpicker",
			"param_name"	=> "title_bg_color",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"dependency"	=> array(
				"element"	=> "en_title_bg_color",
				"not_empty"	=> true
			),
			"value"			=> $helper_color
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "en_cat_color",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			'value'			=> array(
				esc_html__( 'Edit Category Color', 'vintwood' ) => true
			),
			"dependency" 	=> array(
					"element"	=> 'anim_style',
					"value"		=> array( "hoverdef" ,"hoverdir" , "hoverbi", "hoverbi2", "hoverzs", "hoversr", "hoverzb" )
				),
		),
		array(
			"type"			=> "colorpicker",
			"param_name"	=> "cat_color",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"dependency"	=> array(
				"element"	=> "en_cat_color",
				"not_empty"	=> true
			),
			"value"			=> "#f7ebd5"
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "en_cat_bg_color",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			'value'			=> array(
				esc_html__( 'Edit Category Background Color', 'vintwood' ) => true
			),
			"dependency" 	=> array(
				"element"	=> 'anim_style',
				"value"		=> array( "hoverdef" ,"hoverdir" , "hoverbi", "hoverbi2", "hoverzs", "hoversr", "hoverzb" )
			),
		),
		array(
			"type"			=> "colorpicker",
			"param_name"	=> "cat_bg_color",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"dependency"	=> array(
				"element"	=> "en_cat_bg_color",
				"not_empty"	=> true
			),
			"value"			=> $second_color
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Animation', 'vintwood' ),
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"param_name"	=> "appear_style",
			"value"			=> array(
				esc_html__( 'None', 'vintwood' ) => 'none',
				esc_html__( 'Bounce', 'vintwood' ) => 'callout.bounce',
				esc_html__( 'Shake', 'vintwood' ) => 'callout.shake',
				esc_html__( 'Flash', 'vintwood' ) => 'callout.flash',
				esc_html__( 'Pulse', 'vintwood' ) => 'callout.pulse',
				esc_html__( 'Swing', 'vintwood' ) => 'callout.swing',
				esc_html__( 'Tada', 'vintwood' ) => 'callout.tada',
				esc_html__( 'Fade In', 'vintwood' ) => 'transition.fadeIn',
				esc_html__( 'Flip X In', 'vintwood' ) => 'transition.flipXIn',
				esc_html__( 'Flip Y In', 'vintwood' ) => 'transition.flipYIn',
				esc_html__( 'Shrink In', 'vintwood' ) => 'transition.shrinkIn',
				esc_html__( 'Expand In', 'vintwood' ) => 'transition.expandIn',
				esc_html__( 'Grow', 'vintwood' ) => 'transition.grow',
				esc_html__( 'Slide Up', 'vintwood' ) => 'transition.slideUpBigIn',
				esc_html__( 'Slide Down', 'vintwood' ) => 'transition.slideDownBigIn',
				esc_html__( 'Slide Left', 'vintwood' ) => 'transition.slideLeftBigIn',
				esc_html__( 'Slide Right', 'vintwood' ) => 'transition.slideRightBigIn',
				esc_html__( 'Perspective Up', 'vintwood' ) => 'transition.perspectiveUpIn',
				esc_html__( 'Perspective Down', 'vintwood' ) => 'transition.perspectiveDownIn',
				esc_html__( 'Perspective Left', 'vintwood' ) => 'transition.perspectiveLeftIn',
				esc_html__( 'Perspective Right', 'vintwood' ) => 'transition.perspectiveRightIn',
			),
			"dependency" 	=> array(
				"element"	=> 'display_style',
				"value"		=> array( "carousel" ,"grid" , "filter", "filter_with_ajax" )
			),
		),

		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Show Title and Description', 'vintwood' ),
			'param_name'	=> 'info_pos',
			'value'			=> array(
					esc_html__( 'On Image Hover', 'vintwood' ) => 'inside_img',
					esc_html__( 'Under Image', 'vintwood' ) => 'under_img',
				),
			"dependency" 	=> array(
								"element"	=> 'layout',
								"value"		=> array( "def","1","2","3","4","5" )
				),
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "customize_carousel",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			'value'			=> array(
				esc_html__( 'Customize Carousel', 'vintwood' ) => true
			),
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"dependency" 	=> array(
					"element"	=> 'display_style',
					"value"		=> "carousel"
				),
		),
		array(
			"type"			=> "colorpicker",
			"param_name"	=> "pagination_carousel",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"heading"		=> esc_html__( 'Navigation Color', 'vintwood' ),
			"dependency"	=> array(
				"element"	=> "customize_carousel",
				"not_empty"	=> true
			),
			"value"			=> ""
		),		
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Info Alignment', 'vintwood' ),
			"param_name"	=> "info_align",
			"value"			=> array(
					esc_html__( 'Center', 'vintwood' ) 	=> 'center',
					esc_html__( 'Left', 'vintwood' )	=> 'left',
					esc_html__( 'Right', 'vintwood' ) 	=> 'right',
			),
			"dependency"	=> array(
				"element"	=> "info_pos",
				"value"		=> 'under_img'
			),
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Shape', 'vintwood' ),
			"param_name"	=> "portfolio_style",
			"value"			=> array(
					esc_html__( 'Square', 'vintwood' ) => 'def_style',
					esc_html__( 'Square with no spacing', 'vintwood' ) => 'wide_style',
							),
			"dependency" 	=> array(
								"element"	=> 'info_pos',
								"value"		=> 'inside_img'
				),
			"group"			=> esc_html__( "Styling", 'vintwood' ),
		),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Items to display', 'vintwood' ),
			"param_name"	=> "total_items_count",
			"value"			=> esc_html( get_option( 'posts_per_page' ) )
		),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Items per Page', 'vintwood' ),
			"param_name"	=> "items_pp",
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "grid", "filter", "filter_with_ajax" )
							),
			"value"			=> esc_html( get_option( 'posts_per_page' ) )
		),
		array(
			'type'			=> 'checkbox',
			'param_name'	=> 'cws_portfolio_show_data_override',
			'value'			=> array(
				esc_html__( 'Show Meta Data', 'vintwood' ) => true
			)
		),		
		array(
			'type'				=> 'cws_dropdown',
			'multiple'			=> "true",
			'param_name'		=> 'cws_portfolio_data_to_show',
			'dependency'		=> array(
				'element'			=> 'cws_portfolio_show_data_override',
				'not_empty'			=> true
			),
			'value'				=> array(
				esc_html__( 'None', 'vintwood' )			=> '',
				esc_html__( 'Title', 'vintwood' )		=> 'title',
				esc_html__( 'Excerpt', 'vintwood' )		=> 'excerpt',
				esc_html__( 'Categories', 'vintwood' )	=> 'cats'
			)
		),	
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Content Character Limit', 'vintwood' ),
			'param_name'	=> 'chars_count',
			'dependency'	=> array(
				'element'		=> 'cws_portfolio_show_data_override',
				'not_empty'		=> true
			),
			'value'			=> 	''	
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Pagination', 'vintwood' ),
			"param_name"	=> "pagination_grid",
			"dependency" 	=> array(
								"element"	=> "display_style",
								"value"		=> array( "grid", "filter", "filter_with_ajax" )
							),
			"value"			=> array(
				esc_html__( "Standard", 'vintwood' ) 	=> 'standard_with_ajax',
				esc_html__( "Load More", 'vintwood' )	=> 'load_more',
			)		
		),
			
	);
	$params = array_merge($params, $params2);
	array_push( $params, array(
		"type"				=> "textfield",
		"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
		"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
		"param_name"		=> "el_class",
		"value"				=> ""
	));
	vc_map( array(
		"name"				=> esc_html__( 'CWS Portfolio', 'vintwood' ),
		"base"				=> "cws_sc_portfolio_posts_grid",
		'category'			=> "By CWS",
		"weight"			=> 80,
		"icon"     			=> "cws_icon",		
		"params"			=> $params
	));
	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Portfolio_Posts_Grid extends WPBakeryShortCode {
	    }
	}
?>