<?php
	// Map Shortcode in Visual Composer
	global $cws_theme_funcs;
	$body_font_options 		= $cws_theme_funcs->cws_get_option( 'body-font' );
	$body_font_color 		= esc_attr( $body_font_options['color'] );
	$icon_params 			= cws_ext_icon_vc_sc_config_params( "customize", true );
	$params 				= cws_ext_merge_arrs( array(
		array(
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Type', 'vintwood' ),
				"param_name"	=> "type",
				"value"			=> array(
					esc_html__( 'Success', 'vintwood' )				=> 'success',
					esc_html__( 'Warning', 'vintwood' )				=> 'warn',
					esc_html__( 'Error', 'vintwood' )				=> 'error',
					esc_html__( 'Informational', 'vintwood' )		=> 'info',
				) 
			),
			array(
				"type"			=> "textfield",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Title', 'vintwood' ),
				"param_name"	=> "title",
			),
			array(
				"type"			=> "textarea",
				"heading"		=> esc_html__( 'Text', 'vintwood' ),
				"param_name"	=> "text",
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "is_closable",
				"value"			=> array(
					esc_html__( 'Closable', 'vintwood' ) => true
				)
			),			
			array(
				"type"			=> "checkbox",
				"param_name"	=> "customize",
				"value"			=> array( esc_html__( 'Customize', 'vintwood' ) => true )
			)
		),
		$icon_params,
		array(
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Main Color', 'vintwood' ),
				"param_name"	=> "custom_fill_color",
				"dependency"	=> array(
					"element"	=> "customize",
					"not_empty"	=> true
				),
				"value"			=> "#e6eaed"
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Font Color', 'vintwood' ),
				"param_name"	=> "custom_font_color",
				"dependency"	=> array(
					"element"	=> "customize",
					"not_empty"	=> true
				),
				"value"			=> $body_font_color
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			)
		)
	));
	vc_map( array(
		"name"				=> esc_html__( 'CWS Message Box', 'vintwood' ),
		"base"				=> "cws_sc_msg_box",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Msg_Box extends WPBakeryShortCode {
	    }
	}
?>