<?php
	// Map Shortcode in Visual Composer
	global $cws_theme_funcs;
	$first_color 			= $cws_theme_funcs->cws_get_option( 'theme-first-color' );
	$second_color 			= $cws_theme_funcs->cws_get_option( 'theme-second-color' );
	$helper_color 			= $cws_theme_funcs->cws_get_option( 'theme-helper-color' );
	$icon_params 			= cws_ext_icon_vc_sc_config_params();	
	$params 				= cws_ext_merge_arrs( array(
		array(
			array(
				"type"			=> "textfield",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Title', 'vintwood' ),
				"param_name"	=> "title",
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Description', 'vintwood' ),
				"param_name"	=> "desc",
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Number', 'vintwood' ),
				"description"	=> esc_html__( 'Integer', 'vintwood' ),
				"param_name"	=> "number",
				"value"			=> "100",
				"save_always"	=> true
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Speed', 'vintwood' ),
				"description"	=> esc_html__( 'Integer', 'vintwood' ),
				"param_name"	=> "speed",
				"value"			=> "2000",
				"save_always"	=> true
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Module Alignment', 'vintwood' ),
				"param_name"	=> "module_alignment",
				"value"			=> array(
					esc_html__( 'Center', 'vintwood' )	=> 'center',
					esc_html__( 'Left', 'vintwood' )		=> 'left',
					esc_html__( 'Right', 'vintwood' )	=> 'right'
				) 
			),
		),
		$icon_params,
		array(
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Icon Size', 'vintwood' ),
				"param_name"	=> "size",
				"value"			=> array(
					esc_html__( 'Medium', 'vintwood' )			=> '3x',
					esc_html__( 'Mini', 'vintwood' )			=> 'lg',
					esc_html__( 'Small', 'vintwood' )			=> '2x',
					esc_html__( 'Large', 'vintwood' )			=> '4x',
					esc_html__( 'Extra Large', 'vintwood' )		=> '5x',
				) 
			),
			// array(
			// 	"type"			=> "dropdown",
			// 	"heading"		=> esc_html__( 'Icon Position', 'vintwood' ),
			// 	"param_name"	=> "icon_pos",
			// 	"value"			=> array(
			// 		esc_html__( 'Left', 'vintwood' )		=> 'left',
			// 		esc_html__( 'Center', 'vintwood' )	=> 'center',
			// 		esc_html__( 'Right', 'vintwood' )	=> 'right'
			// 	) 
			// ),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "custom_size_i",
				"value"			=> array( esc_html__( 'Customize Sizes', 'vintwood' ) => true )
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Icon Size', 'vintwood' ),
				"param_name"	=> "size_i",
				"dependency"	=> array(
					"element"	=> "custom_size_i",
					"not_empty"	=> true
				),
				"value"			=> "48px"
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "custom_color",
				"value"			=> array( esc_html__( 'Customize Colors', 'vintwood' ) => true )
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Icon Color', 'vintwood' ),
				"param_name"	=> "icon_color",
				"dependency"	=> array(
					"element"	=> "custom_color",
					"not_empty"	=> true
				),
				"value"			=> $helper_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Title Color', 'vintwood' ),
				"param_name"	=> "title_color",
				"dependency"	=> array(
					"element"	=> "custom_color",
					"not_empty"	=> true
				),
				"value"			=> $helper_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Text Color', 'vintwood' ),
				"param_name"	=> "text_color",
				"dependency"	=> array(
					"element"	=> "custom_color",
					"not_empty"	=> true
				),
				"value"			=> $second_color
			),		
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Number Color', 'vintwood' ),
				"param_name"	=> "number_color",
				"dependency"	=> array(
					"element"	=> "custom_color",
					"not_empty"	=> true
				),
				"value"			=> $first_color
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			)
		)
	));
	vc_map( array(
		"name"				=> esc_html__( 'CWS Milestone', 'vintwood' ),
		"base"				=> "cws_sc_milestone",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Milestone extends WPBakeryShortCode {
	    }
	}
?>