<?php
	global $cws_theme_funcs;
	$helper_color 	= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-helper-color' ) );

	$params = cws_ext_merge_arrs( array(
		array(
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Title', 'vintwood' ),
				"param_name"		=> "info_title",
				"value"				=> ""
			),
			array(
				"type"			=> "attach_image",
				"heading"		=> esc_html__( 'Image', 'vintwood' ),
				"param_name"	=> "image",
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "info_divider",
				"value"			=> array( esc_html__( 'Add Divider', 'vintwood' ) => true )
			),
			array(
				"type"			=> "textarea_html",
				"heading"		=> esc_html__( 'Text', 'vintwood' ),
				"param_name"	=> "content",
			),
			array(
				"type"			=> "attach_image",
				"heading"		=> esc_html__( 'Background Image', 'vintwood' ),
				"param_name"	=> "bg_image",
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "bordered_bg",
				"value"			=> array( esc_html__( 'Background in border', 'vintwood' ) => true )
			),
			array(
				"type"			=> "attach_image",
				"heading"		=> esc_html__( 'Background Pattern', 'vintwood' ),
				"param_name"	=> "bg_pattern",
				"dependency"	=> array(
					"element"	=> "bordered_bg",
					"not_empty"	=> true
				),
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "customize",
				"value"			=> array( esc_html__( 'Customize Colors', 'vintwood' ) => true )
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Title Color', 'vintwood' ),
				"param_name"	=> "title_color",
				"dependency"	=> array(
					"element"	=> "customize",
					"not_empty"	=> true
				),
				"value"			=> '#E9E4DD'
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Title Background Color', 'vintwood' ),
				"param_name"	=> "title_background_color",
				"dependency"	=> array(
					"element"	=> "customize",
					"not_empty"	=> true
				),
				"value"			=> $helper_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Divider Color', 'vintwood' ),
				"param_name"	=> "divider_color",
				"dependency"	=> array(
					"element"	=> "customize",
					"not_empty"	=> true
				),
				"value"			=> $helper_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Text Color', 'vintwood' ),
				"param_name"	=> "text_color",
				"dependency"	=> array(
					"element"	=> "customize",
					"not_empty"	=> true
				),
				"value"			=> '#333333'
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			),
			array(
				"type"			=> "css_editor",
				"param_name"	=> "custom_styles",
				"group"			=> esc_html__( "Styling", 'vintwood' )
			)
		),
	));

	vc_map( array(
		"name"				=> esc_html__( 'CWS Info', 'vintwood' ),
		"base"				=> "cws_sc_info",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Info extends WPBakeryShortCode {
	    }
	}
?>