<?php
	// Map Shortcode in Visual Composer
	global $cws_theme_funcs;
	$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	$second_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-second-color' ) );
	$helper_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-helper-color' ) );

	$icon_params = cws_ext_icon_vc_sc_config_params ();

	$settings = array(
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Link', 'vintwood' ),
			"param_name"	=> "icon_url",
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Style', 'vintwood' ),
			"param_name"	=> "icon_style",
			"value"			=> array(
				esc_html__( 'Advanced', 'vintwood' ) => 'advanced',
				esc_html__( 'Simple', 'vintwood' ) => 'simple',
			) 
		),
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Alignment', 'vintwood' ),
			"param_name"	=> "icon_align",
			"value"			=> array(
				esc_html__( 'Left', 'vintwood' ) => 'left',
				esc_html__( 'Center', 'vintwood' ) => 'center',
				esc_html__( 'Right', 'vintwood' ) => 'right',
			) 
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "icon_settings",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"value"			=> array( 
				esc_html__( 'Customize Icon', 'vintwood' ) => true 
			)
		),
		array(
			"type"				=> "textfield",
			"heading"			=> esc_html__( 'Icon Size', 'vintwood' ),
			"param_name"		=> "icon_size",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_settings",
				"not_empty"		=> true
			),
			"value"				=> "42px"
		),
		array(
			"type"				=> "textfield",
			"heading"			=> esc_html__( 'Icon Size on Hover', 'vintwood' ),
			"param_name"		=> "icon_hover_size",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_settings",
				"not_empty"		=> true
			),
			"value"				=> "42px"
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Icon Color', 'vintwood' ),
			"param_name"		=> "icon_color",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_settings",
				"not_empty"		=> true
			),
			"value"				=> '#DCD0BF'
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Icon Color on Hover', 'vintwood' ),
			"param_name"		=> "icon_hover_color",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_settings",
				"not_empty"		=> true
			),
			"value"				=> $second_color
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "icon_background",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"dependency"	=> array(
				"element"	=> "icon_style",
				"value"		=> "advanced"
			),
			"value"			=> array( 
				esc_html__( 'Customize Icon Background', 'vintwood' ) => true 
			)
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Background Color', 'vintwood' ),
			"param_name"		=> "icon_bg_color",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_background",
				"not_empty"		=> true
			),
			"value"				=> $second_color
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Background Color on Hover', 'vintwood' ),
			"param_name"		=> "icon_bg_hover_color",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_background",
				"not_empty"		=> true
			),
			"value"				=> 'transparent'
		),
		array(
			"type"			=> "checkbox",
			"param_name"	=> "icon_inner",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"dependency"	=> array(
				"element"	=> "icon_style",
				"value"		=> "advanced"
			),
			"value"			=> array( 
				esc_html__( 'Customize Inner Border', 'vintwood' ) => true 
			)
		),
		array(
			"type"				=> "textfield",
			"heading"			=> esc_html__( 'Border Size', 'vintwood' ),
			"param_name"		=> "inner_size",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_inner",
				"not_empty"		=> true
			),
			"value"				=> "22px"
		),
		array(
			"type"				=> "textfield",
			"heading"			=> esc_html__( 'Border Size on Hover', 'vintwood' ),
			"param_name"		=> "inner_hover_size",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_inner",
				"not_empty"		=> true
			),
			"value"				=> "32px"
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Border Color', 'vintwood' ),
			"param_name"		=> "icon_inner_color",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_inner",
				"not_empty"		=> true
			),
			"value"				=> 'transparent'
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Border Color on Hover', 'vintwood' ),
			"param_name"		=> "icon_inner_hover_color",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_inner",
				"not_empty"		=> true
			),
			"value"				=> 'transparent'
		),

		array(
			"type"			=> "checkbox",
			"param_name"	=> "icon_outer",
			"group"			=> esc_html__( "Styling", 'vintwood' ),
			"dependency"	=> array(
				"element"	=> "icon_style",
				"value"		=> "advanced"
			),
			"value"			=> array( 
				esc_html__( 'Customize Outer Border', 'vintwood' ) => true 
			)
		),
		array(
			"type"				=> "textfield",
			"heading"			=> esc_html__( 'Border Size', 'vintwood' ),
			"param_name"		=> "outer_size",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_outer",
				"not_empty"		=> true
			),
			"value"				=> "13px"
		),
		array(
			"type"				=> "textfield",
			"heading"			=> esc_html__( 'Border Size on Hover', 'vintwood' ),
			"param_name"		=> "outer_hover_size",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_outer",
				"not_empty"		=> true
			),
			"value"				=> "13px"
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Border Color', 'vintwood' ),
			"param_name"		=> "icon_outer_color",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_outer",
				"not_empty"		=> true
			),
			"value"				=> $helper_color
		),
		array(
			"type"				=> "colorpicker",
			"heading"			=> esc_html__( 'Border Color on Hover', 'vintwood' ),
			"param_name"		=> "icon_outer_hover_color",
			"edit_field_class" 	=> "vc_col-xs-6",
			"group"				=> esc_html__( "Styling", 'vintwood' ),
			"dependency"		=> array(
				"element"		=> "icon_outer",
				"not_empty"		=> true
			),
			"value"				=> $helper_color
		),
		vc_map_add_css_animation(),
		array(
			"type"				=> "textfield",
			"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
			"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
			"param_name"		=> "el_class",
			"value"				=> ""
		)
	);

	$params = array_merge( $icon_params, $settings );
	
	$args = array(
		"name"				=> esc_html__( 'CWS Icon', 'vintwood' ),
		"base"				=> "cws_sc_icon",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> $params
	);
	vc_map( $args );

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Icon extends WPBakeryShortCode {
	    }
	}
?>