<?php
	global $cws_theme_funcs;
	$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	// Map Shortcode in Visual Composer
	vc_map( array(
		"name"				=> esc_html__( 'CWS Gift Cards', 'vintwood' ),
		"base"				=> "cws_sc_gift_cards",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> array(
			array(
				"type"			=> "textfield",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Title', 'vintwood' ),
				"param_name"	=> "title",
				"value"			=> esc_html__( 'Gift Voucher', 'vintwood' ),
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_divider",
				'std'			=> true,
				"value"			=> array( esc_html__( 'Add Divider', 'vintwood' ) => true )
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Currency', 'vintwood' ),
				"param_name"	=> "currency",
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Currency Location', 'vintwood' ),
				"param_name"	=> "curency_alignment",
				"value"			=> array(
					esc_html__( 'Before', 'vintwood' )		=> 'before',
					esc_html__( 'After', 'vintwood' )		=> 'after',
				) 
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Price', 'vintwood' ),
				"description"	=> esc_html__( 'Split integer and decimal part by dot symbol', 'vintwood' ),
				"param_name"	=> "price",
				"value"			=> "29.99",
				"save_always"	=> true
			),
			array(
				"type"			=> "attach_image",
				"heading"		=> esc_html__( 'Logo', 'vintwood' ),
				"param_name"	=> "cards_logo",
			),	
			array(
				"type"			=> "checkbox",
				"param_name"	=> "use_custom_color",
				"value"			=> array( esc_html__( 'Customize', 'vintwood' ) => true )			
			),			
			array(
				"type"			=> "attach_image",
				"heading"		=> esc_html__( 'Background Image', 'vintwood' ),
				"param_name"	=> "cards_img",
				"dependency"	=> array(
					"element"	=> "use_custom_color",
					"not_empty"	=> true
				),
			),	
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Text Color', 'vintwood' ),
				"param_name"	=> "custom_color",
				"dependency"	=> array(
					"element"	=> "use_custom_color",
					"not_empty"	=> true
				),
				"value"			=> $first_color,
			),			
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Background Overlay', 'vintwood' ),
				"param_name"	=> "bg_color",
				"dependency"	=> array(
					"element"	=> "use_custom_color",
					"not_empty"	=> true
				),
				"value"			=> $first_color,
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_discount",
				"value"			=> array( esc_html__( 'Add Discount', 'vintwood' ) => true )
			),
			array(
				"type"			=> "textfield",
				"param_name"	=> "discount_text",
				"dependency"	=> array(
					"element"	=> "add_discount",
					"not_empty"	=> true
				),
			),			
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Discount Color', 'vintwood' ),
				"param_name"	=> "discount_color",
				"dependency"	=> array(
					"element"	=> "add_discount",
					"not_empty"	=> true
				),
				"value"			=> $first_color,
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_url",
				"value"			=> array( esc_html__( 'Add Url', 'vintwood' ) => true )
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Url', 'vintwood' ),
				"param_name"	=> "button_url",
				"dependency"	=> array(
					"element"	=> "add_url",
					"not_empty"	=> true
				)
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_url_new_tab",
				"dependency"	=> array(
					"element"	=> "add_url",
					"not_empty"	=> true
				),
				"value"			=> array( esc_html__( 'Open Link in New Tab', 'vintwood' ) => true )
			),
			array(
				"type"			=> "textarea_html",
				"heading"		=> esc_html__( 'Content', 'vintwood' ),
				"param_name"	=> "content",
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			)
		)
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Gift_Cards extends WPBakeryShortCode {
	    }
	}
?>