<?php
	global $cws_theme_funcs;
	$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	$icon_params 		= cws_ext_icon_vc_sc_config_params("separate_type", false, array( "iconic" ) );
	// Map Shortcode in Visual Composer
	$params 				= cws_ext_merge_arrs( array(
		array(
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Height', 'vintwood' ),
				"description"	=> esc_html__( 'Integer', 'vintwood' ),
				"param_name"	=> "height_divider",
				"value"			=> "3"
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Margin Top', 'vintwood' ),
				"description"	=> esc_html__( 'in pixels', 'vintwood' ),
				"param_name"	=> "mtop",
				"value"			=> ""
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Margin Bottom', 'vintwood' ),
				"description"	=> esc_html__( 'in pixels', 'vintwood' ),
				"param_name"	=> "mbottom",
				"value"			=> ""
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_stars",
				"value"			=> array( esc_html__( '"Star" type', 'vintwood' ) => true )
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_separate",
				"value"			=> array( esc_html__( 'Add Icon', 'vintwood' ) => true )
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Separate Type', 'vintwood' ),
				"param_name"	=> "separate_type",
				"dependency"	=> array(
					"element"	=> "add_separate",
					"not_empty"	=> true
				),
				"value"			=> array(
					esc_html__( 'Icon', 'vintwood' )		=> 'iconic',
					esc_html__( 'Image', 'vintwood' )		=> 'image',
				) 
			),
			array(
				"type"			=> "attach_image",
				"heading"		=> esc_html__( 'Image', 'vintwood' ),
				"param_name"	=> "plan_img",
				"dependency"	=> array(
					"element"	=> "separate_type",
					"value"		=> array( "image" )
				),
			),
		),
		$icon_params,
		array(			
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Icon Spacings', 'vintwood' ),
				"description"	=> esc_html__( 'in pixels', 'vintwood' ),
				"param_name"	=> "icon_spacings",
				"value"			=> "40px"
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( "Icon Color", 'vintwood' ),
				"param_name"	=> "custom_color_icon",
				"dependency"	=> array(
					"element"	=> "separate_type",
					"value"		=> array( "iconic" )
				),
				"value"			=> $first_color
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Icon Size', 'vintwood' ),
				"param_name"	=> "size",
				"dependency"	=> array(
					"element"	=> "separate_type",
					"value"		=> array( "iconic" )
				),
				"value"			=> array(
					esc_html__( 'Small', 'vintwood' )		=> '2x',
					esc_html__( 'Mini', 'vintwood' )		=> 'lg',
					esc_html__( 'Medium', 'vintwood' )		=> '3x',
					esc_html__( 'Large', 'vintwood' )		=> '4x',
					esc_html__( 'Extra Large', 'vintwood' )	=> '5x'
				) 
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "customize_colors",
				"value"			=> array( esc_html__( 'Customize Divider', 'vintwood' ) => true )
			),
			array(
				"type"			=> "colorpicker",
				"param_name"	=> "custom_color",
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $first_color
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			)
		)
	));

	vc_map( array(
		"name"				=> esc_html__( 'CWS Divider', 'vintwood' ),
		"base"				=> "cws_sc_divider",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Divider extends WPBakeryShortCode {
	    }
	}
?>