<?php
	// Map Shortcode in Visual Composer
	global $cws_theme_funcs;
	$params = array(
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_html__( 'Columns', 'vintwood' ),
			"param_name"	=> "columns",
			"value"			=> array(
				esc_html__( 'One', 'vintwood' )		=> '1',
				esc_html__( 'Two', 'vintwood' )		=> '2',
				esc_html__( 'Three', 'vintwood' )	=> '3',
				esc_html__( 'Four', 'vintwood' )	=> '4',
			),
			"std"			=> '3'
		),	
		array(
            "type"          => "checkbox",
            "param_name"    => "square",
            "std"           => true,
            "value"         => array( esc_html__( 'Square Images', 'vintwood' ) => true )
        ),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Count', 'vintwood' ),
			"param_name"	=> "count",
			"value"			=> "3"
		),
		array(
            "type"          => "checkbox",
            "param_name"    => "use_carousel",
            "value"         => array( esc_html__( 'Use Carousel', 'vintwood' ) => true )
        ),
        array(
            "type"          => "checkbox",
            "param_name"    => "autoplay",
            "value"         => array( esc_html__( 'Autoplay', 'vintwood' ) => true ),
            "dependency"	=> array(
				"element"	=> "use_carousel",
				"not_empty"	=> true
			),
        ),
		array(
			"type"			=> "textfield",
			"heading"		=> esc_html__( 'Autoplay Speed', 'vintwood' ),
			"param_name"	=> "autoplay_speed",
            "dependency"	=> array(
				"element"	=> "autoplay",
				"not_empty"	=> true
			),
			"value" 		=> "3000"
		),
	);
	$terms = get_terms( 'category' );
	$avail_terms = array(
		esc_html__( 'None', 'vintwood' )	=> ''
		);
	if ( !is_a( $terms, 'WP_Error' ) ){
		foreach ( $terms as $term ) {
			$avail_terms[$term->name] = $term->slug;
		}
	}
	array_push( $params, array(
		"type"			=> "cws_dropdown",
		"multiple"		=> "true",
		"heading"		=> esc_html__( 'Filter by Categories', 'vintwood' ),
		"param_name"	=> "cat_terms",
		"value"			=> $avail_terms
		));	
	$params2 = array(
		vc_map_add_css_animation(),
		array(
			"type"				=> "textfield",
			"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
			"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
			"param_name"		=> "el_class",
			"value"				=> ""
		)
	);
	$params = array_merge($params, $params2);
	vc_map( array(
		"name"				=> esc_html__( 'CWS Categories', 'vintwood' ),
		"base"				=> "cws_sc_categories",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,	
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Categories extends WPBakeryShortCode {
	    }
	}
?>