<?php
	// Map Shortcode in Visual Composer
	global $cws_theme_funcs;
	$first_color 	= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	$second_color 	= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-second-color' ) );

	vc_map( array(
		"name"				=> esc_html__( 'CWS Carousel', 'vintwood' ),
		"base"				=> "cws_sc_carousel",
		'content_element' 	=> true,
		'as_parent'			=> array('only' => 'cws_sc_milestone, vc_column_text, cws_sc_vc_testimonial, cws_sc_button, cws_sc_msg_box, cws_sc_text, cws_sc_progress_bar, cws_sc_services, cws_sc_widget_text, cq_vc_hotspot, vc_single_image, cws_sc_tips'),
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",		
		"weight"			=> 80,
		'js_view' 			=> 'VcColumnView',
		"params"			=> array(
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Carousel Columns', 'vintwood' ),
				"param_name"	=> "columns",
				"value"			=> array(
					esc_html__( "One", 'vintwood' ) 	=> '1',
					esc_html__( "Two", 'vintwood' )		=> '2',
					esc_html__( "Three", 'vintwood' )	=> '3',
					esc_html__( "Four", 'vintwood' )	=> '4'
				)		
			),
			array(
				"type"				=> "checkbox",
				"param_name"		=> "custom_border",
				"value"				=> array( esc_html__( 'Add Border', 'vintwood' ) => true )
			),
			array(
				"type"				=> "checkbox",
				"param_name"		=> "bullets_nav",
				"value"				=> array( esc_html__( 'Add Navigation Bullets', 'vintwood' ) => true )
			),
			array(
				"type"				=> "checkbox",
				"param_name"		=> "arrows_nav",
				"edit_field_class"	=> "vc_col-xs-6",
				"value"				=> array( esc_html__( 'Add Navigation Arrows', 'vintwood' ) => true )
			),
			array(
				"type"				=> "checkbox",
				"param_name"		=> "arrows_on_hover",
				"edit_field_class"	=> "vc_col-xs-6",
				"std"				=> '1',
				"value"				=> array( esc_html__( 'Show Arrows on Hover', 'vintwood' ) => true )
			),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Carousel Padings', 'vintwood' ),
				"description"		=> esc_html__( '1, 2( top/bottom, left/right ) or 4, space separated, values with units', 'vintwood' ),
				"param_name"		=> "carousel_paddings",
				"group"				=> esc_html__( "Styling", 'vintwood' ),
				"value"				=> "0px 0px 0px 0px"
			),			
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Pagination Margins Offset', 'vintwood' ),
				"description"		=> esc_html__( '1, 2( top/bottom, left/right ) or 4, space separated, values with units', 'vintwood' ),
				"param_name"		=> "margins_pagination",
				"edit_field_class"	=> "vc_col-xs-6",
				"group"				=> esc_html__( "Styling", 'vintwood' ),
				"value"				=> "0px 0px 0px 0px"
			),
			array(
				"type"				=> "checkbox",
				"param_name"		=> "customize_colors",
				"group"				=> esc_html__( "Styling", 'vintwood' ),
				"value"				=> array( esc_html__( 'Edit Colors', 'vintwood' ) => true )
			),
			array(
				"type"				=> "colorpicker",
				"heading"			=> esc_html__( 'Background Color', 'vintwood' ),
				"param_name"		=> "background_color",
				"group"				=> esc_html__( "Styling", 'vintwood' ),
				"dependency"		=> array(
					"element"		=> "customize_colors",
					"not_empty"		=> true
				),
				"value"				=> ""
			),
			array(
				"type"				=> "colorpicker",
				"heading"			=> esc_html__( 'Arrows Color', 'vintwood' ),
				"param_name"		=> "custom_arrow_color",
				"edit_field_class"	=> "vc_col-xs-6",
				"group"				=> esc_html__( "Styling", 'vintwood' ),
				"dependency"		=> array(
					"element"		=> "customize_colors",
					"not_empty"		=> true
				),
				"value"				=> ""
			),
			array(
				"type"				=> "colorpicker",
				"heading"			=> esc_html__( 'Bullets Color', 'vintwood' ),
				"param_name"		=> "custom_pagination_color",
				"edit_field_class"	=> "vc_col-xs-6",
				"group"				=> esc_html__( "Styling", 'vintwood' ),
				"dependency"		=> array(
					"element"		=> "customize_colors",
					"not_empty"		=> true
				),
				"value"				=> $second_color
			),
			vc_map_add_css_animation(),
		)
	));

	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Carousel extends WPBakeryShortCodesContainer {
	    }
	}
?>