<?php
	global $cws_theme_funcs;
	$first_color 			= esc_attr( $cws_theme_funcs->cws_get_option( "theme-first-color" ) );
	// Map Shortcode in Visual Composer
	$icon_params 			= cws_ext_icon_vc_sc_config_params();
	$params 				= cws_ext_merge_arrs( array(
		array(
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Subtitle', 'vintwood' ),
				"param_name"	=> "subtitle",
			),			

			array(
				"type"			=> "textarea",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Title', 'vintwood' ),
				"param_name"	=> "title",
			),			
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Description', 'vintwood' ),
				"param_name"	=> "desc_subtitle",
			),
		),
		$icon_params,
		array(
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Display', 'vintwood' ),
				"param_name"	=> "display_settings",
				"value"			=> array(
					esc_html__( 'Button', 'vintwood' )		=> 'button_s',
					esc_html__( 'Banner', 'vintwood' )	=> 'banner',
				) 
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_button",
				"dependency"	=> array(
					"element"	=> "display_settings",
					"value"	=> array("button_s")
				),
				"value"			=> array( esc_html__( 'Add Button', 'vintwood' ) => true )
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Button Text', 'vintwood' ),
				"param_name"	=> "button_title",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				),
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Button Url', 'vintwood' ),
				"param_name"	=> "button_url",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				)
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "button_new_tab",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				),
				"value"			=> array( esc_html__( 'Open Link in New Tab', 'vintwood' ) => true )
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_banner",
				"dependency"	=> array(
					"element"	=> "display_settings",
					"value"	=> array("banner")
				),
				"value"			=> array( esc_html__( 'Add Banner', 'vintwood' ) => true )
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Banner Title', 'vintwood' ),
				"param_name"	=> "banner_title",
				"dependency"	=> array(
					"element"	=> "add_banner",
					"not_empty"	=> true
				),
			),			
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Banner Discount', 'vintwood' ),
				"param_name"	=> "banner_price",
				"dependency"	=> array(
					"element"	=> "add_banner",
					"not_empty"	=> true
				),
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Banner Discount Description', 'vintwood' ),
				"param_name"	=> "banner_description",
				"dependency"	=> array(
					"element"	=> "add_banner",
					"not_empty"	=> true
				),
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Banner Url', 'vintwood' ),
				"param_name"	=> "banner_url",
				"dependency"	=> array(
					"element"	=> "add_banner",
					"not_empty"	=> true
				)
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "banner_new_tab",
				"dependency"	=> array(
					"element"	=> "add_banner",
					"not_empty"	=> true
				),
				"value"			=> array( esc_html__( 'Open Link in New Tab', 'vintwood' ) => true )
			),
			array(
				"type"			=> "css_editor",
				"param_name"	=> "custom_styles",
				"group"			=> esc_html__( "Styling", 'vintwood' )
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "customize_colors",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> array( esc_html__( 'Customize Colors', 'vintwood' ) => true )
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Featured Color', 'vintwood' ),
				"param_name"	=> "featured_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $first_color
			),			
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Overlay Color', 'vintwood' ),
				"param_name"	=> "overlay_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> ""
			),		
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Featured Link Color', 'vintwood' ),
				"param_name"	=> "display_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $first_color
			),			
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Featured Link Font Color', 'vintwood' ),
				"param_name"	=> "display_font_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $first_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Icon Color', 'vintwood' ),
				"param_name"	=> "icon_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> "rgba(0,0,0,0.065)"
			),
			vc_map_add_css_animation(),	
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			)
		)
	));
	vc_map( array(
		"name"				=> esc_html__( 'CWS Call To Action', 'vintwood' ),
		"base"				=> "cws_sc_call_to_action",
		'category'			=> "By CWS",
		"weight"			=> 80,
		"icon"     			=> "cws_icon",
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Call_To_Action extends WPBakeryShortCode {
	    }
	}
?>