<?php
	// Map Shortcode in Visual Composer
	global $cws_theme_funcs;
	$header_font = $cws_theme_funcs->cws_get_option('header-font');
	$header_color = esc_attr( $header_font['color'] );
	$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	$second_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-second-color' ) );

	$icon_params 		= cws_ext_icon_vc_sc_config_params();
	$params 			= cws_ext_merge_arrs( array(
		array(
			array(
				"type"			=> "textfield",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Title', 'vintwood' ),
				"param_name"	=> "title",
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Link', 'vintwood' ),
				"param_name"	=> "url",
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "new_tab",
				"value"			=> array( esc_html__( 'Open in New Tab', 'vintwood' ) => true )
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Button type', 'vintwood' ),
				"param_name"	=> "btn_type",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> array(
					esc_html__( 'Simple', 'vintwood' )		=> 'simple',
					esc_html__( 'Advanced', 'vintwood' )	=> 'advanced',
				),
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Size', 'vintwood' ),
				"param_name"	=> "size",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> array(
					esc_html__( 'Regular', 'vintwood' )		=> 'regular',
					esc_html__( 'Small', 'vintwood' )		=> 'small',
					esc_html__( 'Large', 'vintwood' )		=> 'large',
				),
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Custom Paddings', 'vintwood' ),
				"description"	=> esc_html__( 'Units Required. Separate with space if needed.', 'vintwood' ),
				"param_name"	=> "ofs",
				"value"			=> '',
				"group"			=> esc_html__( "Styling", 'vintwood' ),
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Aligning', 'vintwood' ),
				"param_name"	=> "aligning",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> array(
					esc_html__( 'Left', 'vintwood' )		=> 'left',
					esc_html__( 'Center', 'vintwood' )		=> 'center',
					esc_html__( 'Right', 'vintwood' )		=> 'right',
				) 
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Aligning on mobile devices', 'vintwood' ),
				"param_name"	=> "aligning_mob",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> array(
					esc_html__( 'Center', 'vintwood' )		=> 'center',
					esc_html__( 'Left', 'vintwood' )		=> 'left',
					esc_html__( 'Right', 'vintwood' )		=> 'right',
				) 
			),
		),
		array(
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Icon Position', 'vintwood' ),
				"param_name"	=> "icon_pos",
				"value"			=> array(
					esc_html__( 'Right', 'vintwood' )		=> 'right',
					esc_html__( 'Left', 'vintwood' )		=> 'left'
				) 
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "customize_size_title",
				"group"			=> esc_html__( "Styling", 'vintwood' ),			
				"value"			=> array( esc_html__( 'Edit Title', 'vintwood' ) => true )			
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Font Size Title', 'vintwood' ),
				"param_name"	=> "size_t",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_size_title",
					"not_empty"	=> true
				),
				"value"			=> "22px"
			),				
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Font Weight Title', 'vintwood' ),
				"param_name"	=> "weight_t",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"dependency"	=> array(
					"element"	=> "customize_size_title",
					"not_empty"	=> true
				),
				"value"			=> "400"
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Font Color', 'vintwood' ),
				"param_name"	=> "font_color",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> "",
				"edit_field_class" => "vc_col-xs-6",
			),			
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Font Color (Hover)', 'vintwood' ),
				"param_name"	=> "font_color_hover",
				"group"			=> esc_html__( "Styling", 'vintwood' ),
				"value"			=> "",
				"edit_field_class" => "vc_col-xs-6",
			),	
			vc_map_add_css_animation(),	
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			)
		)
	));
	vc_map( array(
		"name"				=> esc_html__( 'CWS Button', 'vintwood' ),
		"base"				=> "cws_sc_button",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Button extends WPBakeryShortCode {
	    }
	}
?>