<?php
	global $cws_theme_funcs;
	$first_color 	= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	$second_color 	= esc_attr( $cws_theme_funcs->cws_get_option( 'theme-second-color' ) );

	$params = cws_ext_merge_arrs(
		array(
			array(
				array(
					"type"			=> "textfield",
					"heading"		=> esc_html__( 'Subtitle', 'vintwood' ),
					"param_name"	=> "subtitle",
				),
				array(
					"type"			=> "textfield",
					"heading"		=> esc_html__( 'Subtitle Note', 'vintwood' ),
					"param_name"	=> "subtitle_note",
				),
				array(
					"type"			=> "textfield",
					"heading"		=> esc_html__( 'Title', 'vintwood' ),
					"param_name"	=> "title",
				),
				array(
					"type"			=> "textfield",
					"heading"		=> esc_html__( 'Category', 'vintwood' ),
					"param_name"	=> "category",
				),
				array(
					"type"			=> "textfield",
					"heading"		=> esc_html__( 'Description', 'vintwood' ),
					"param_name"	=> "description",
				),
				array(
					"type"			=> "textfield",
					"heading"		=> esc_html__( 'Module Height', 'vintwood' ),
					"param_name"	=> "block_size",
					"description"	=> esc_html__( 'Information will always be in the center. Enter values in pixels', 'vintwood' ),
				),
				array(
					"type"			=> "textfield",
					"heading"		=> esc_html__( 'Module Height on Tablets(Portrait) & Phones', 'vintwood' ),
					"param_name"	=> "block_size_mob",
					"description"	=> esc_html__( 'Information will always be in the center. Enter values in pixels', 'vintwood' ),
				),
				array(
					"type"			=> "checkbox",
					"param_name"	=> "no_paddings",
					"value"			=> array( esc_html__( 'Remove default paddings', 'vintwood' ) => true )
				),
				array(
					"type"			=> "checkbox",
					"param_name"	=> "add_button",
					"value"			=> array( esc_html__( 'Add Button', 'vintwood' ) => true )
				),
				array(
					"type"			=> "textfield",
					"heading"		=> esc_html__( 'Button URL', 'vintwood' ),
					"param_name"	=> "button_url",
					"dependency"	=> array(
						"element"	=> "add_button",
						"not_empty"	=> true
					),
				),
				array(
					"type"			=> "textfield",
					"heading"		=> esc_html__( 'Button Link', 'vintwood' ),
					"param_name"	=> "button_link",
					"dependency"	=> array(
						"element"	=> "add_button",
						"not_empty"	=> true
					),
				),
				array(
					"type"			=> "checkbox",
					"param_name"	=> "new_window",
					"dependency"	=> array(
						"element"	=> "add_button",
						"not_empty"	=> true
					),
					"value"			=> array( esc_html__( 'Open In New Window', 'vintwood' ) => true )
				),
				array(
					"type"			=> "checkbox",
					"param_name"	=> "customize_colors",
					"value"			=> array( esc_html__( 'Customize Colors', 'vintwood' ) => true )
				),
				array(
					"type"			=> "colorpicker",
					"heading"		=> esc_html__( 'Background Color', 'vintwood' ),
					"param_name"	=> "background_color",
					"dependency"	=> array(
						"element"	=> "customize_colors",
						"not_empty"	=> true
					),
					"value"			=> $first_color
				),
				array(
					"type"			=> "colorpicker",
					"heading"		=> esc_html__( 'Background Color on Hover', 'vintwood' ),
					"param_name"	=> "background_color_hover",
					"dependency"	=> array(
						"element"	=> "customize_colors",
						"not_empty"	=> true
					),
					"value"			=> $second_color
				),
				array(
					"type"			=> "colorpicker",
					"heading"		=> esc_html__( 'Subtitle Color', 'vintwood' ),
					"param_name"	=> "subtitle_color",
					"dependency"	=> array(
						"element"	=> "customize_colors",
						"not_empty"	=> true
					),
					"value"			=> $second_color
				),
				array(
					"type"			=> "colorpicker",
					"heading"		=> esc_html__( 'Text Color', 'vintwood' ),
					"param_name"	=> "text_color",
					"dependency"	=> array(
						"element"	=> "customize_colors",
						"not_empty"	=> true
					),
					"value"			=> '#fff'
				),
				array(
					"type"			=> "colorpicker",
					"heading"		=> esc_html__( 'Text Color on Hover', 'vintwood' ),
					"param_name"	=> "text_color_hover",
					"dependency"	=> array(
						"element"	=> "customize_colors",
						"not_empty"	=> true
					),
					"value"			=> '#fff'
				),
				array(
					"type"			=> "colorpicker",
					"heading"		=> esc_html__( 'Button Color', 'vintwood' ),
					"param_name"	=> "button_color",
					"dependency"	=> array(
						"element"	=> "customize_colors",
						"not_empty"	=> true
					),
					"value"			=> '#fff'
				),
				array(
					"type"			=> "colorpicker",
					"heading"		=> esc_html__( 'Button Color on Hover', 'vintwood' ),
					"param_name"	=> "button_color_hover",
					"dependency"	=> array(
						"element"	=> "customize_colors",
						"not_empty"	=> true
					),
					"value"			=> '#fff'
				),
				vc_map_add_css_animation(),
			)
		)
	);

	vc_map( array(
		"name"				=> esc_html__( 'CWS Benefits', 'vintwood' ),
		"base"				=> "cws_sc_benefits",
		'category'			=> "By CWS",
		"icon"     			=> "cws_icon",
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Benefits extends WPBakeryShortCode {
	    }
	}
?>