<?php
	global $cws_theme_funcs;
	$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
	$second_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-second-color' ) );
	$helper_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-helper-color' ) );
	$header_font = $cws_theme_funcs->cws_get_option('header-font');
	$icon_params = cws_ext_icon_vc_sc_config_params('banner_style', 'simple', false );

	// Map Shortcode in Visual Composer
	$params = cws_ext_merge_arrs( array(
		array(
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Style', 'vintwood' ),
				"param_name"	=> "banner_style",
				"value"		=> array(
					esc_html__( 'Simple', 'vintwood' ) 	=> 'simple',
					esc_html__( 'Advanced', 'vintwood' ) => 'advanced',
				)
			)
		),
		$icon_params,
		array(
			array(
				"type"			=> "textarea",
				"admin_label"	=> true,
				"heading"		=> esc_html__( 'Title', 'vintwood' ),
				"param_name"	=> "title",
			),
			array(
				"type"			=> "textarea",
				"heading"		=> esc_html__( 'Title Description', 'vintwood' ),
				"param_name"	=> "offer",
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Url', 'vintwood' ),
				"param_name"	=> "banner_url",
				"dependency"	=> array(
					"element"	=> "banner_style",
					"value"		=> "simple"
				),
				"value"			=> "#"
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Text Alignment', 'vintwood' ),
				"param_name"	=> "text_pos",
				"dependency"	=> array(
					"element" => "banner_style",
					"value"	  => "advanced"
				),
				"value"		=> array(
					esc_html__( 'Left', 'vintwood' ) 	=> 'left',
					esc_html__( 'Center', 'vintwood' ) => 'center',
					esc_html__( 'Right', 'vintwood' ) 	=> 'right',
				)
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "add_button",
				"dependency"	=> array(
					"element" => "banner_style",
					"value"	  => "advanced"
				),
				"value"			=> array( esc_html__( 'Add Button', 'vintwood' ) => true )
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Button Title', 'vintwood' ),
				"param_name"	=> "button_text",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				),
			),
			array(
				"type"			=> "textfield",
				"heading"		=> esc_html__( 'Url', 'vintwood' ),
				"param_name"	=> "button_url",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				)
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Button Style', 'vintwood' ),
				"param_name"	=> "button_style",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				),
				"value"		=> array(
					esc_html__( 'Simple', 'vintwood' ) 	=> 'simple',
					esc_html__( 'Advanced', 'vintwood' )	=> 'advanced',
				)
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "button_new_tab",
				"dependency"	=> array(
					"element"	=> "add_button",
					"not_empty"	=> true
				),
				"value"			=> array( esc_html__( 'Open Link in New Tab', 'vintwood' ) => true )
			),
			array(
				"type"			=> "checkbox",
				"param_name"	=> "customize_colors",
				"value"			=> array( esc_html__( 'Edit Colors', 'vintwood' ) => true )			
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Button Color', 'vintwood' ),
				"param_name"	=> "font_color",
				"edit_field_class" => "vc_col-xs-6",
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> '#e9e4dd'
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Button Hover Color', 'vintwood' ),
				"param_name"	=> "font_color_hover",
				"edit_field_class" => "vc_col-xs-6",
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> $second_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Text Font Color', 'vintwood' ),
				"param_name"	=> "text_font_color",
				"edit_field_class" => "vc_col-xs-6",
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> '#333333'
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Text Secondary Color', 'vintwood' ),
				"param_name"	=> "text_secondary_color",
				"edit_field_class" => "vc_col-xs-6",
				"dependency"	=> array(
					"element"	=> "customize_colors",
					"not_empty"	=> true
				),
				"value"			=> '#e9e4dd'
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Background Color', 'vintwood' ),
				"param_name"	=> "bg_color",
				"edit_field_class" => "vc_col-xs-6",
				"value"			=> $helper_color
			),
			array(
				"type"			=> "colorpicker",
				"heading"		=> esc_html__( 'Border Color', 'vintwood' ),
				"param_name"	=> "border_color",
				"edit_field_class" => "vc_col-xs-6",
				"value"			=> '#333333'
			),
			vc_map_add_css_animation(),
			array(
				"type"				=> "textfield",
				"heading"			=> esc_html__( 'Extra class name', 'vintwood' ),
				"description"		=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vintwood' ),
				"param_name"		=> "el_class",
				"value"				=> ""
			)
		),
	));

	vc_map( array(
		"name"				=> esc_html__( 'CWS Banner', 'vintwood' ),
		"base"				=> "cws_sc_banners",
		'category'			=> "By CWS",
		'icon' 				=> 'cws_icon',
		"weight"			=> 80,
		"params"			=> $params
	));

	if ( class_exists( 'WPBakeryShortCode' ) ) {
	    class WPBakeryShortCode_CWS_Sc_Banners extends WPBakeryShortCode {
	    }
	}
?>