<?php
	if ( !class_exists( 'cws_ext_VC_Config' ) ){
		class cws_ext_VC_Config extends Vintwood_Funcs{

			public function __construct ( $args = array() ){

				require_once(trailingslashit(get_template_directory()) . '/vc/vc_extends/cws_vc_extends.php');
				add_action( 'admin_init', array( $this, 'remove_meta_boxes' ) );
				add_action( 'admin_menu', array( $this, 'remove_grid_elements_menu' ) );
				add_action( 'vc_iconpicker-type-cws_flaticons', array( $this, 'add_cws_flaticons' ) );
				add_action( 'init', array( $this, 'remove_vc_elements' ) );
				
				add_action( 'init', array( $this, 'config' ) );
				if ( function_exists('cws_rewrite_slug') ){
					add_action( 'init', array( $this, 'extend_shortcodes' ) );
				}	
				add_action( 'init', array( $this, 'extend_params' ) );
				add_action( 'init', array( $this, 'modify_vc_elements' ) );
				add_action('admin_enqueue_scripts', array($this, 'cws_vc_init' ) );
			}
			public function add_cws_shortcode($name, $param1, $param2)  {
				$short = 'shortcode';
				call_user_func('vc_add_' . $short.$name, $param1, $param2);
			}			
			public function config (){
				vc_set_default_editor_post_types( array(
					'page',					
					'megamenu_item'
				)); 
			}
			public function get_defaults (){
				$this->args = wp_parse_args( $this->args, $this->defaults );
			}
			// Extend Composer with Theme Shortcodes
			public function extend_shortcodes (){
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_banners.php' );
				// Uncomment this line to activate Benefits
				// require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_benefits.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_vc_blog.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_button.php' );
				// Uncomment this line to activate Call to action
				// require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_call_to_action.php' );			
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_carousel.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_categories.php' );
				//Uncomment this line to activate Classes
				// require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_classes_posts_grid.php' );		
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_divider.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_embed.php' );
				// Uncomment this line to activate Gift cards
				// require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_gift_cards.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_icon.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_info.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_milestone.php' );			
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_msg_box.php' );	
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_portfolio_posts_grid.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_pricing_plan.php' );	
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_progress_bar.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_ribbon.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_services.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_social_icons.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_spacing.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_staff_posts_grid.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_testimonial.php' );
				// Uncomment this line to activate Testimonial
				// require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_testimonial_posts.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_text.php' );
				// Uncomment this line to activate Tips
				// require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_tips.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/theme_shortcodes/cws_sc_twitter.php' );
			}
			// Extend Composer with Custom Parametres
			public function extend_params (){
				require_once( trailingslashit( get_template_directory() ) . 'vc/params/cws_dropdown.php' );
				require_once( trailingslashit( get_template_directory() ) . 'vc/params/cws_svg.php' );
			}
			// Modify VC Elements
			public function modify_vc_elements (){
				if ( function_exists( 'vc_add'.'_shortcode_param' ) ) {
 					$this->add_cws_shortcode('_param' , 'cws_svg' , 'cws_vc_svg');
				}				
				vc_remove_param( 'vc_row', 'columns_placement' );		
				vc_add_param('vc_row',array(
					"type" => "textfield",
					"heading" => esc_html__("Minimum Height", 'vintwood'),
					"param_name"		=> "cws_row_min_height",
					"value" => '0px',
					"description"	=> esc_html__( 'Add a minimum height to the row so you can have a row without any content but still display it at a certain height. Such as a background with a video or image background but without any content', 'vintwood' ),
				));	

				vc_remove_param( 'vc_tta_accordion', 'style' );
				vc_remove_param( 'vc_tta_accordion', 'shape' );
				vc_remove_param( 'vc_tta_accordion', 'color' );
				vc_remove_param( 'vc_tta_accordion', 'no_fill' );
				vc_remove_param( 'vc_tta_accordion', 'spacing' );
				vc_remove_param( 'vc_tta_accordion', 'gap' );

				vc_remove_param( 'vc_tta_tabs', 'style' );
				vc_remove_param( 'vc_tta_tabs', 'shape' );
				vc_remove_param( 'vc_tta_tabs', 'color' );
				vc_remove_param( 'vc_tta_tabs', 'no_fill_content_area' );
				vc_remove_param( 'vc_tta_tabs', 'spacing' );
				vc_remove_param( 'vc_tta_tabs', 'gap' );
				vc_remove_param( 'vc_tta_tabs', 'pagination_style' );
				vc_remove_param( 'vc_tta_tabs', 'pagination_color' );

				vc_remove_param( 'vc_toggle', 'style' );
				vc_remove_param( 'vc_toggle', 'color' );
				vc_remove_param( 'vc_toggle', 'size' );
				vc_remove_param( 'vc_toggle', 'use_custom_heading' );

				vc_remove_param( 'vc_images_carousel', 'partial_view' );	
			}
			// Remove VC Elements
			public function remove_vc_elements (){
				vc_remove_element( 'vc_separator' );
				vc_remove_element( 'vc_text_separator' );
				vc_remove_element( 'vc_message' );
				vc_remove_element( 'vc_gallery' );
				vc_remove_element( 'vc_tta_tour' );
				vc_remove_element( 'vc_tta_pageable' );
				vc_remove_element( 'vc_custom_heading' );
				vc_remove_element( 'vc_btn' );
				vc_remove_element( 'vc_cta' );
				vc_remove_element( 'vc_posts_slider' );
				vc_remove_element( 'vc_progress_bar' );
				vc_remove_element( 'vc_basic_grid' );
				vc_remove_element( 'vc_media_grid' );
				vc_remove_element( 'vc_masonry_grid' );
				vc_remove_element( 'vc_masonry_media_grid' );
				vc_remove_element( 'vc_widget_sidebar' );
			}
			public function add_cws_flaticons ( $icons ){
				$icon_id = "";
				$fi_array = array();
				$fi_icons = cws_get_all_flaticon_icons();
				$fi_exists = is_array( $fi_icons ) && !empty( $fi_icons );				
				if ( !is_array( $fi_icons ) || empty( $fi_icons ) ){
					return $icons;
				}
				for ( $i = 0; $i < count( $fi_icons ); $i++ ){
					$icon_id = $fi_icons[$i];
					$icon_class = "flaticon-{$icon_id}";
					array_push( $fi_array, array( "$icon_class" => $icon_id ) );
				}
				$icons = array_merge( $icons, $fi_array );
				return $icons;
			}
			// Remove teaser metabox
			public function remove_meta_boxes() {
				remove_meta_box( 'vc_teaser', 'page', 		'side' );
				remove_meta_box( 'vc_teaser', 'post', 		'side' );
				remove_meta_box( 'vc_teaser', 'portfolio', 	'side' );
				remove_meta_box( 'vc_teaser', 'product', 	'side' );
			}
			// Remove 'Grid Elements' from Admin menu
			public function remove_grid_elements_menu(){
			  remove_menu_page( 'edit.php?post_type=vc_grid_item' );
			}
			public function cws_vc_init(){
				wp_enqueue_style( 'vc-css-styles', trailingslashit( get_template_directory_uri() ) . 'vc/vc_extends/css/cws_vc.css' );
			}
		}
	}
	/**/
	/* Config and enable extension */
	/**/
	$vc_config = new cws_ext_VC_Config ();
	/**/
	/* \Config and enable extension */


	if(!class_exists('VC_CWS_Background')){
		class VC_CWS_Background extends cws_ext_VC_Config{
			static public $columns = 0;
			static public $row_atts = '';
			static public $column_atts = '';

			function __construct(){
				add_action('admin_init',array($this,'cws_bg_init'));
			}
			public static function cws_open_vc_shortcode($atts, $content){
				global $cws_theme_funcs;
				$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
				$bg_image_position = $bg_cws_size = $bg_cws_attachment = $customize_colors_overlay = $cws_overlay_color = $bg_cws_repeat = $row_custom_border = $html = $bg_layer_position = $bg_layer_margin = $bg_layer_min_height = $data_layer_margin = $el_style_layer = $extra_layer_pos = $extra_layer_width = $extra_layer_height = $extra_layer_size = $extra_layer_position = $extra_layer_repeat = $extra_layer_bg = "";
				extract( shortcode_atts( array(
				    "gap" => "",
				    "bg_cws_repeat" => "repeat",		   
				    "bg_image_position" => "left_top",
				    "bg_layer_position" => "",
				    "bg_layer_margin" => "",
				    "bg_layer_min_height" => "",
				    "customize_colors_overlay" => "",
				    "full_width" => "",
				    "bg_cws_size" => "initial",
				    "bg_cws_attachment" => "scroll",
				    "cws_overlay_color" => $first_color,
				    "add_layers_parallax" => "",
				    "bg_layer_parallax_speed" => "0.05",
				    "over_section"		=> "",
				    "row_custom_border"	=> "",
				    "cws_bg_hovering"		=> "",
				    "cws_row_min_height"		=> "",
					"extra_layer_pos"	=> "left",
					"extra_layer_width"	=> "",
					"extra_layer_height"	=> "",
					"extra_layer_size"	=> "",
					"extra_layer_position"	=> "center center",
					"extra_layer_repeat"	=> "no-repeat",
					"extra_layer_bg"	=> ""
				), $atts ) );

				$output = '<!-- CWS Row -->';
				$el_style_bg = !empty($bg_cws_repeat) ? 'background-repeat:'.$bg_cws_repeat.';' : '';
				$el_style_bg .= !empty($bg_cws_size) ? 'background-size:'.$bg_cws_size.';' : '';
				$el_style_bg .= !empty($bg_cws_attachment) ? 'background-attachment:'.$bg_cws_attachment.';' : '';
				$el_style_bg .= !empty($cws_row_min_height) ? 'min-height:'.(int) $cws_row_min_height .'px;' : '';

				if(isset($bg_image_position) && !empty($bg_image_position)){
					switch ($bg_image_position) {
						case 'left_top':
							$el_style_bg .= 'background-position:0% 0%;';
							break;
						case 'left_center':
							$el_style_bg .= 'background-position:0% 50%;';
							break;
						case 'left_bottom':
							$el_style_bg .= 'background-position:0% 100%;';
							break;
						case 'right_top':
							$el_style_bg .= 'background-position:100% 0%;';
							break;
						case 'right_center':
							$el_style_bg .= 'background-position:100% 50%;';
							break;
						case 'right_bottom':
							$el_style_bg .= 'background-position:100% 100%;';
							break;
						case 'center_top':
							$el_style_bg .= 'background-position:50% 0%;';
							break;
						case 'center_center':
							$el_style_bg .= 'background-position:50% 50%;';
							break;
						case 'center_bottom':
							$el_style_bg .= 'background-position:50% 100%;';
							break;
					}
				}

				$output .= '<div class="cws-content'.(!empty($cws_bg_hovering) ? ' add_hovering' : "") . ($row_custom_border ? ' cws_custom_border' : '') . (!empty($cws_row_min_height) ? ' row_full_height' : "").'"'.(!empty($el_style_bg) ? ' style="'.esc_attr($el_style_bg).'"' : "").'>';
					$output .= '<div class="cws_extra_wrapper">';

				self::$row_atts = $atts;

				if(isset(self::$row_atts['bg_layer_position']) && !empty(self::$row_atts['bg_layer_position'])){
					switch (self::$row_atts['bg_layer_position']) {
						case 'left_top':
						$el_style_layer .= 'background-position:0% 0%;';
						break;
						case 'left_center':
						$el_style_layer .= 'background-position:0% 50%;';
						break;
						case 'left_bottom':
						$el_style_layer .= 'background-position:0% 100%;';
						break;
						case 'right_top':
						$el_style_layer .= 'background-position:100% 0%;';
						break;
						case 'right_center':
						$el_style_layer .= 'background-position:100% 50%;';
						break;
						case 'right_bottom':
						$el_style_layer .= 'background-position:100% 100%;';
						break;
						case 'center_top':
						$el_style_layer .= 'background-position:50% 0%;';
						break;
						case 'center_center':
						$el_style_layer .= 'background-position:50% 50%;';
						break;
						case 'center_bottom':
						$el_style_layer .= 'background-position:50% 100%;';
						break;
					}
				}	
				$tag = "vc_row";
				
				$el_class = $full_height = $parallax_speed_bg = $parallax_speed_video = $full_width = $equal_height = $flex_row = $columns_placement = $content_placement = $parallax = $parallax_image = $css = $el_id = $video_bg = $video_bg_url = $video_bg_parallax = $css_animation = '';
				$disable_element = '';
				$after_output = '';

				$sc_obj = Vc_Shortcodes_Manager::getInstance()->getElementClass( $tag );
				$row_class_vc = vc_map_get_attributes( $sc_obj->getShortcode(), $atts );
				extract( $row_class_vc );
				wp_enqueue_script( 'wpb_composer_front_js' );
				$el_class = $sc_obj->getExtraClass( $el_class ) . $sc_obj->getCSSAnimation( $css_animation );

				$css_classes = array(
					'vc_row',
					'wpb_row',
					'vc_row-fluid',
				);

				if ( 'yes' === $disable_element ) {
					if ( vc_is_page_editable() ) {
						$css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
					} else {
						return '';
					}
				}

				if ( vc_shortcode_custom_css_has_property( $css, array(
						'border',
						'background',
					) ) || $video_bg || $parallax
				) {
					$css_classes[] = 'vc_row-has-fill';
				}

				if ( ! empty( $atts['gap'] ) ) {
					$css_classes[] = 'vc_column-gap-' . $atts['gap'];
				}

				$wrapper_attributes = array();
				// build attributes for wrapper
				if ( ! empty( $el_id ) ) {
					$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
				}
				// $cws_layer_atts = '';
				if ( ! empty( $full_width ) ) {
					$wrapper_attributes[] = 'data-vc-full-width="true"';
					$wrapper_attributes[] = 'data-vc-full-width-init="false"';
					// $cws_layer_atts .= 'data-vc-full-width="true" data-vc-full-width-init="false"';
					if ( 'stretch_row_content' === $full_width ) {
						$wrapper_attributes[] = 'data-vc-stretch-content="true"';
						// $cws_layer_atts .= 'data-vc-stretch-content="true"';
					} elseif ( 'stretch_row_content_no_spaces' === $full_width ) {
						$wrapper_attributes[] = 'data-vc-stretch-content="true"';
						$css_classes[] = 'vc_row-no-padding';
						// $cws_layer_atts .= 'data-vc-stretch-content="true"';
					}
					$after_output .= '<div class="vc_row-full-width vc_clearfix" style="color: red !important;"></div>';
				}
				if(!empty($add_layers_parallax)){
					$css_classes[] = 'cws_prlx_layer';
				}
				if(!empty($full_width) && $full_width == 'stretch_row'){
					$css_classes[] = 'cws_stretch_row';
				}
				$css_classes[] = 'cws-layer';
				
				$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $tag, $atts ) );
				$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

				if(!empty($add_layers_parallax)){
					$wrapper_attributes[] = ' data-scroll-speed=" ' .(!empty($bg_layer_parallax_speed) ? esc_attr($bg_layer_parallax_speed) : "0.05"). '"';
				}

				if(isset(self::$row_atts['bg_layer_margin']) && !empty(self::$row_atts['bg_layer_margin'])){
					$data_layer_margin .=  self::$row_atts['bg_layer_margin'];			
				}					

				if(isset(self::$row_atts['bg_layer_min_height']) && !empty(self::$row_atts['bg_layer_min_height'])){
					$el_style_layer .=  'min-height:'.(int)self::$row_atts['bg_layer_min_height']."px;";		
				}

				if(isset(self::$row_atts['add_layers'])){

					if(isset(self::$row_atts['cws_layer_image']) && !empty(self::$row_atts['cws_layer_image'])){
						$src = wp_get_attachment_image_src(self::$row_atts['cws_layer_image'], 'full');
					}

					$extra_styles = '';

					if(!empty($src)){
						$extra_styles .= 'background-image:url("'.esc_attr($src[0]).'");';
					}

					$extra_styles .= "
						".(!empty($extra_layer_pos) ? $extra_layer_pos.":0%;" : '')."
						".(!empty($extra_layer_width) ? " width:".(float)$extra_layer_width."% !important;" : '')."
						".(!empty($extra_layer_height) ? " height:".(float)$extra_layer_height."% !important;" : '')."
						".(!empty($extra_layer_size) ? " background-size:".$extra_layer_size.";" : '')."
						".(!empty($extra_layer_position) ? " background-position:".$extra_layer_position.";" : '')."
						".(!empty($extra_layer_repeat) ? " background-repeat:".$extra_layer_repeat.";" : '')."
						".(!empty($extra_layer_bg) ? " background-color:".$extra_layer_bg.";" : '')."
					";

					$output .= "<div ".( implode( ' ', $wrapper_attributes ) ).">";

						$output .= "<div style='".esc_attr($extra_styles)."'></div>";
						$output .= $after_output;

					$output .= "</div>";

					if($full_width == 'stretch_row_content' || $full_width == 'stretch_row_content_no_spaces' || $full_width == 'stretch_row'){
						$output .= "<div class='vc_row-full-width vc_clearfix'></div>";
					}
				}

				return $output;
			}

			public static function cws_open_vc_shortcode_column_inner($atts, $content){
				$output = '';

				$inner_col_bg_repeat = $inner_col_bg_attachment = $inner_col_bg_size = $inner_col_bg_position = $inner_col_box_shadow = $place_ahead = $custom_border = $el_class = '';

				extract( shortcode_atts( array(
					"mobile_paddings"			=> "0px 0px 0px 0px",
					"custom_border"				=> "",
				    "inner_col_bg_repeat" 		=> "repeat",
				    "inner_col_bg_attachment" 	=> "scroll",
				    "inner_col_bg_size" 		=> "initial",
				    "inner_col_bg_position" 	=> "left_top",
				    "inner_col_box_shadow" 		=> "",
				), $atts ) );

				$tag = "vc_column_inner";
				$sc_obj = Vc_Shortcodes_Manager::getInstance()->getElementClass( $tag );


				$atts = vc_map_get_attributes( $sc_obj->getShortcode(), $atts );
				extract( $atts );

				$el_style = '';

				$el_style = !empty($inner_col_bg_repeat) ? 'background-repeat:'.$inner_col_bg_repeat.';' : '';
				$el_style .= !empty($inner_col_bg_size) ? 'background-size:'.$inner_col_bg_size.';' : '';
				$el_style .= !empty($inner_col_bg_attachment) ? 'background-attachment:'.$inner_col_bg_attachment.';' : '';
				if(isset($inner_col_bg_position) && !empty($inner_col_bg_position)){
					switch ($inner_col_bg_position) {
						case 'left_top':
							$el_style .= 'background-position:0% 0%;';
							break;
						case 'left_center':
							$el_style .= 'background-position:0% 50%;';
							break;
						case 'left_bottom':
							$el_style .= 'background-position:0% 100%;';
							break;
						case 'right_top':
							$el_style .= 'background-position:100% 0%;';
							break;
						case 'right_center':
							$el_style .= 'background-position:100% 50%;';
							break;
						case 'right_bottom':
							$el_style .= 'background-position:100% 100%;';
							break;
						case 'center_top':
							$el_style .= 'background-position:50% 0%;';
							break;
						case 'center_center':
							$el_style .= 'background-position:50% 50%;';
							break;
						case 'center_bottom':
							$el_style .= 'background-position:50% 100%;';
							break;
					}
				}

				$el_style_inner = '';
				$el_style_border = '';
				$styles = '';

				if(isset($inner_col_box_shadow) && !empty($inner_col_box_shadow)){
					$el_style_inner .= 'box-shadow: '.$inner_col_box_shadow.';';
					$el_style_inner .= '-moz-box-shadow: '.$inner_col_box_shadow.';';
					$el_style_inner .= '-webkit-box-shadow: '.$inner_col_box_shadow.';';
				}

				if( $custom_border ){
					$el_style .= 'padding: 15px;';
					$el_style_border .= 'display: block !important;';
				}

				$temp_buff = preg_match('/^\.(.*){/', $atts['css'], $matches);

				if(isset($matches[1])){
					$inner_column_class = $matches[1];

					$styles .= ".{$inner_column_class}{".esc_attr($el_style)."}";
					$styles .= ".{$inner_column_class}:before{".esc_attr($el_style_border)."}";
					$styles .= ".{$inner_column_class} > .wpb_wrapper{".esc_attr($el_style_inner)."}";
				}

				if(!empty($mobile_paddings) && isset($inner_column_class)){
					$styles .= "
							@media screen and ( max-width: 767px ){
								.{$inner_column_class} > .wpb_wrapper{
									padding: ".esc_attr($mobile_paddings)." !important;
								}
							}
						";
				}

				if(!empty($styles)){
					Cws_shortcode_css()->enqueue_cws_css($styles);
				}

				if( $place_ahead ){
					$output .= '<div class="first_col_trigger"></div>';
				}

				return $output;
			}

			public static function cws_open_vc_shortcode_column($atts, $content){					
				$output = '';
				self::$columns++;
				$el_style_layer = '';	
					
				if(self::$columns == 1){

					$el_style = '';
					if(isset(self::$row_atts['bg_cws_color']) && !empty(self::$row_atts['bg_cws_color'])){
						if(self::$row_atts['bg_cws_color'] == 'gradient'){
							$el_style = cws_render_builder_gradient_rules(self::$row_atts);
						}else if(isset(self::$row_atts['cws_overlay_color'])){
							if(!empty(self::$row_atts['cws_overlay_color'])){
								$el_style =  "background-color:". self::$row_atts['cws_overlay_color'].";";
							}
						}
					}	

					if(!empty($el_style)){
						$output .= "<div class='cws-overlay-bg' style='".esc_attr($el_style)."'></div>";
					}				
					if(isset(self::$row_atts['cws_pattern_image']) && !empty(self::$row_atts['cws_pattern_image'])){
						$src = wp_get_attachment_image_src(self::$row_atts['cws_pattern_image']);
						$output .= "<div class='cws-overlay-bg' style='background-image:url(".esc_attr($src[0]).")'></div>";
					}							
				}
				global $cws_theme_funcs;
				$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
				$bg_image_position = $bg_cws_size = $bg_cws_attachment = $customize_colors_overlay = $cws_overlay_color = $bg_cws_repeat = $html = $styles = "";
				/**
				 * Shortcode attributes
				 * @var $atts
				 * @var $el_class
				 * @var $width
				 * @var $css
				 * @var $offset
				 * @var $content - shortcode content
				 * Shortcode class
				 * @var $this WPBakeryShortCode_VC_Column
				 */
				extract( shortcode_atts( array(
				    "gap" => "",
				    "bg_cws_repeat" => "",		   
				    "bg_image_position" => "",
				    "customize_colors_overlay" => "",
				    "full_width" => "",
				    "bg_cws_color" => "",
				    "bg_cws_size" => "",
				    "cws_pattern_image" => "",
				    "place_ahead" => "",
				    "ripped_effect" => "",
				    "custom_border" => "",
				    "cws_mobile_paddings" => "0px 0px 0px 0px",
				    "cws_tablet_portrait_paddings" => "0px 0px 0px 0px",
				    "cws_tablet_landscape_paddings" => "0px 0px 0px 0px",
				    "cws_layer_image" => "",
				    "bg_cws_attachment" => "",
				    "cws_overlay_color" => $first_color,
					
				), $atts ) );	
				$tag = "vc_column";
				$sc_obj = Vc_Shortcodes_Manager::getInstance()->getElementClass( $tag );
				$el_class = $width = $offset = $mm_column_title = '';
				$atts = vc_map_get_attributes( $sc_obj->getShortcode(), $atts );
				extract( $atts );

				$width = wpb_translateColumnWidthToSpan( $width );
				$width = vc_column_offset_class_merge( $offset, $width );
				$css_classes = array(
					$sc_obj->getExtraClass( $el_class ),
					'wpb_column',
					'vc_column_container',
					$width,
				);

				if (vc_shortcode_custom_css_has_property( $css, array('border', 'background') )) {
					$css_classes[]='vc_col-has-fill';
				}
				if (vc_shortcode_custom_css_has_property( $css, array('border') )) {
					$css_classes[]='vc_col-has-border';
				}
				if (vc_shortcode_custom_css_has_property( $css, array('padding') )) {
					$css_classes[]='vc_col-has-padding';
				}
				if (vc_shortcode_custom_css_has_property( $css, array('margin') )) {
					$css_classes[]='vc_col-has-margin';
				}
				if ($place_ahead){
					$css_classes[]='vc_col-first-place';
				}
				if ($ripped_effect){
					$css_classes[]='vc_col_ripped';
				}
				if ($custom_border){
					$css_classes[]='vc_col_custom_border';
				}

				$wrapper_attributes = array();

				$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $tag, $atts ) );
			
				$css_class .= " cws-column";
				$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';
	
				$el_style_bg = !empty($bg_cws_repeat) ? 'background-repeat:'.$bg_cws_repeat.';' : '';
				$el_style_bg .= !empty($bg_cws_size) ? 'background-size:'.$bg_cws_size.';' : '';
				$el_style_bg .= !empty($bg_cws_attachment) ? 'background-attachment:'.$bg_cws_attachment.';' : '';
				if(isset($bg_image_position) && !empty($bg_image_position)){
					switch ($bg_image_position) {
						case 'left_top':
							$el_style_bg .= 'background-position:0% 0%;';
							break;
						case 'left_center':
							$el_style_bg .= 'background-position:0% 50%;';
							break;
						case 'left_bottom':
							$el_style_bg .= 'background-position:0% 100%;';
							break;
						case 'right_top':
							$el_style_bg .= 'background-position:100% 0%;';
							break;
						case 'right_center':
							$el_style_bg .= 'background-position:100% 50%;';
							break;
						case 'right_bottom':
							$el_style_bg .= 'background-position:100% 100%;';
							break;
						case 'center_top':
							$el_style_bg .= 'background-position:50% 0%;';
							break;
						case 'center_center':
							$el_style_bg .= 'background-position:50% 50%;';
							break;
						case 'center_bottom':
							$el_style_bg .= 'background-position:50% 100%;';
							break;
					}
				}
				if(!empty(trim( vc_shortcode_custom_css_class( $css ) )) && ($cws_mobile_paddings != '0px 0px 0px 0px' || $cws_tablet_portrait_paddings != '0px 0px 0px 0px' || $cws_tablet_landscape_paddings != '0px 0px 0px 0px')){
					if($cws_tablet_landscape_paddings != '0px 0px 0px 0px' && !empty($cws_tablet_landscape_paddings)){
						$styles .= '
							@media screen and ( max-width: 1200px ){
								.vc_row:not(.vc_row-no-padding) .vc_column_container>.vc_column-inner.'.esc_attr( trim( vc_shortcode_custom_css_class( $css ) ) ).',
								.cws_vc_column-inner .vc_column-inner.'.esc_attr( trim( vc_shortcode_custom_css_class( $css ) ) ).'{
									padding: '.esc_attr($cws_tablet_landscape_paddings).' !important;
								}
							}
						';
					}
					if($cws_tablet_portrait_paddings != '0px 0px 0px 0px' && !empty($cws_tablet_portrait_paddings)){
						$styles .= '
							@media screen and ( max-width: 980px ){
								.vc_row:not(.vc_row-no-padding) .vc_column_container>.vc_column-inner.'.esc_attr( trim( vc_shortcode_custom_css_class( $css ) ) ).',
								.cws_vc_column-inner .vc_column-inner.'.esc_attr( trim( vc_shortcode_custom_css_class( $css ) ) ).'{
									padding: '.esc_attr($cws_tablet_portrait_paddings).' !important;
								}
							}
						';
					}
					if($cws_mobile_paddings != '0px 0px 0px 0px' && !empty($cws_mobile_paddings)){
						$styles .= '
							@media screen and ( max-width: 767px ){
								.vc_row:not(.vc_row-no-padding) .vc_column_container>.vc_column-inner.'.esc_attr( trim( vc_shortcode_custom_css_class( $css ) ) ).',
								.cws_vc_column-inner .vc_column-inner.'.esc_attr( trim( vc_shortcode_custom_css_class( $css ) ) ).'{
									padding: '.esc_attr($cws_mobile_paddings).' !important;
								}
							}
						';
					}

					Cws_shortcode_css()->enqueue_cws_css($styles);
				}

				$output .= "<div " . implode( ' ', $wrapper_attributes ).(!empty($el_style_bg) ? " style='".esc_attr($el_style_bg)."'" : "").">";	
				$output .= '<div class="cws_vc_column-inner ' . esc_attr( trim( vc_shortcode_custom_css_class( $css ) ) ) . '">';
				return $output;
			} 
			public static function cws_close_vc_shortcode_column($atts, $content){			
				global $cws_theme_funcs;
				$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );		
				$bg_image_position = $bg_cws_size = $bg_cws_attachment = $customize_colors_overlay = $cws_overlay_color = $bg_cws_repeat = $html = "";
				extract( shortcode_atts( array(
				    "gap" => "",
				    "bg_cws_repeat" => "",		   
				    "bg_image_position" => "",
				    "customize_colors_overlay" => "",
				    "full_width" => "",
				    "bg_cws_size" => "",
				    "bg_cws_color" => "",
				    "cws_pattern_image" => "",
				    "cws_layer_image" 	=> "",
				    "bg_layer_position" 	=> "",
				    "bg_cws_attachment" => "",
				    "cws_overlay_color" => $first_color,
					
				), $atts ) );	
				$output = '<!-- CWS Column --> ';
				$el_style = '';

				if(isset($bg_cws_color) && !empty($bg_cws_color)){
					if($bg_cws_color == 'gradient'){
						$el_style = cws_render_builder_gradient_rules($atts);
					}else{
						$el_style =  "background-color:". $cws_overlay_color.";";
					}
				}

				if(!empty($el_style)){
					$output .= "<div class='cws-overlay-bg' style='".esc_attr($el_style)."'></div>";
				}				
				if(isset($cws_layer_image) && !empty($cws_layer_image)){
					$src = wp_get_attachment_image_src($cws_layer_image);
					$output .= "<div class='cws-layer cws_prlx_layer' style='background-image:url(".esc_attr($src[0]).")'></div>";
				}
				if(isset($cws_pattern_image) && !empty($cws_pattern_image)){
					$src = wp_get_attachment_image_src($cws_pattern_image);
					$output .= "<div class='cws-overlay-bg' style='background-image:url(".esc_attr($src[0]).")'></div>";
				}

				$output .= "</div>";
				$output .= "</div>";
				return $output;
			} 
			/* end parallax_shortcode */			

			public static function cws_accordion_customzize($atts, $content){					
								/**
				 * Shortcode attributes
				 * Shortcode class
				 * @var $this WPBakeryShortCode_VC_Accordion
				 */													
						
				global $cws_theme_funcs;
				$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
				extract( shortcode_atts( array(
					"add_customize"	=> "",

					"title_color"	=> $first_color,
					"active_title_color"	=> $first_color,

				    "body_color" => $first_color,
				    "active_body_color" => "#fff",

					"header_fill_color"	=> "#fff",
					"body_fill_color"	=> $first_color,

					"active_header_fill_color"	=> "#fff",
					"active_body_fill_color"	=> $first_color,
				), $atts ) );
				$tag = "vc_tta_accordion";
				$sc_obj = Vc_Shortcodes_Manager::getInstance()->getElementClass( $tag );
				$el_class = $width = $css = $offset = $mm_column_title = $styles = '';
				$atts = vc_map_get_attributes( $sc_obj->getShortcode(), $atts );
				extract( $atts );

				$out = '';
				$accordion_id = uniqid( "cws_vc_shortcode_acc_" );
				$out .= "<div id='{$accordion_id}'>";
					if ( !empty( $add_customize ) ){
						

						if(!empty($title_color)){
							$styles .= "
								#{$accordion_id} .vc_tta.vc_general.vc_tta-accordion .vc_tta-panel h4 a,
								#{$accordion_id} .vc_tta.vc_general.vc_tta-accordion .vc_tta-panel h4 a  > *{
									color: $title_color;
								}
							";							
						}		

						if(!empty($active_title_color)){
							$styles .= "
								#{$accordion_id} .vc_tta.vc_general.vc_tta-accordion .vc_tta-panel.cws_active h4 a,
								#{$accordion_id} .vc_tta.vc_general.vc_tta-accordion .vc_tta-panel.cws_active h4 a  > *{
									color: $active_title_color;
								}
							";							
						}

						if(!empty($body_color)){
							$styles .= "
								#{$accordion_id} .vc_tta.vc_general.vc_tta-accordion .vc_tta-panel .vc_tta-panel-body{
									color: $body_color;
								}
							";
						}

						if(!empty($active_body_color)){
							$styles .= "
								#{$accordion_id} .vc_tta.vc_general.vc_tta-accordion .vc_tta-panel.cws_active .vc_tta-panel-body{
									color:$active_body_color;
								}
							";							
						}					

						if(!empty($header_fill_color)){
							$styles .= "
								#{$accordion_id} .vc_tta.vc_general.vc_tta-accordion .vc_tta-panel .vc_tta-panel-heading{
									background:$header_fill_color;
								}
							";			
						}		

						if(!empty($active_header_fill_color)){
							$styles .= "
								#{$accordion_id} .vc_tta.vc_general.vc_tta-accordion .vc_tta-panel.cws_active .vc_tta-panel-heading{
									background:$active_header_fill_color;
								}
							";							
								}								

						if(!empty($body_fill_color)){
							$styles .= "
								#{$accordion_id} .vc_tta.vc_general.vc_tta-accordion .vc_tta-panel .vc_tta-panel-body{
									background:$body_fill_color;
								}
							";							
						}	

						if(!empty($active_body_fill_color)){
							$styles .= "
								#{$accordion_id} .vc_tta.vc_general.vc_tta-accordion .vc_tta-panel.cws_active .vc_tta-panel-body{
									background:$active_body_fill_color;
								}
							";							
						}				

					}
					if ( !empty( $styles ) ){
						$out .= "<style id='{$accordion_id}_acc_style' scoped>";
							$out .= $styles;
						$out .= "</style>";			
					}
				return $out;
			} 			

			public static function cws_accordion_close($atts, $content){				
				return "</div>";
			} 
			/* end parallax_shortcode */

			public static function cws_close_vc_shortcode($atts, $content){	
				self::$row_atts = '';
				if(isset(self::$columns) && !empty(self::$columns)){
					self::$columns = 0;
				}
				return $output = "</div></div>";
			}

			function cws_bg_init(){
				$group_name = esc_html__('Design Options', 'vintwood');

				global $cws_theme_funcs;
				$first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );
				if(function_exists('vc_add_param')){

					vc_add_param('vc_row',array(
							"type" => "checkbox",
							"param_name"		=> "row_custom_border",
							"group" => $group_name,						
							"value"			=> array( esc_html__( 'Add custom border', 'vintwood' ) => true )
						)
					);							
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Image Repeat", 'vintwood'),
							"param_name" => "bg_cws_repeat",
							"value" => array(							
								esc_html__("Repeat", 'vintwood') => "repeat",
								esc_html__("No Repeat", 'vintwood') => "no-repeat",
								esc_html__("Repeat X", 'vintwood') => "repeat-x",
								esc_html__("Repeat Y", 'vintwood') => "repeat-y",
								),
							"description" => esc_html__("Options to control repeatation of the background image. Learn on <a href='http://www.w3schools.com/cssref/playit.asp?filename=playcss_background-repeat' target='_blank'>W3School</a>", 'vintwood'),
							"group" => $group_name,
						)
					);
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Attachment", 'vintwood'),
							"param_name" => "bg_cws_attachment",
							"value" => array(
								esc_html__("Scroll", 'vintwood') => "scroll",
								esc_html__("Fixed", 'vintwood') => "fixed",
								),
							"group" => $group_name,
						)
					);
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Image Size", 'vintwood'),
							"param_name" => "bg_cws_size",
							"value" => array(
								esc_html__("Initial", 'vintwood') => "initial",
								esc_html__("Cover", 'vintwood') => "cover",
								esc_html__("Contain", 'vintwood') => "contain",
								),
							"group" => $group_name,
						)
					);
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Image Position", 'vintwood'),
							"param_name" => "bg_image_position",
							"value" => array(
								esc_html__("Left Top", 'vintwood') => "left_top",
								esc_html__("Left Center", 'vintwood') => "left_center",
								esc_html__("Left Bottom", 'vintwood') => "left_bottom",
								esc_html__("Right Top", 'vintwood') => "right_top",
								esc_html__("Right Center", 'vintwood') => "right_center",
								esc_html__("Right Bottom", 'vintwood') => "right_bottom",
								esc_html__("Center Top", 'vintwood') => "center_top",
								esc_html__("Center Center", 'vintwood') => "center_center",
								esc_html__("Center Bottom", 'vintwood') => "center_bottom",
								),	
							"group" => $group_name,
						)
					);
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Color", 'vintwood'),
							"param_name"		=> "bg_cws_color",
							"value" => array(
								esc_html__("None", 'vintwood') => "none",
								esc_html__("Color", 'vintwood') => "color",
								esc_html__("Gradient", 'vintwood') => "gradient",
								),
							"group" => $group_name,
						)
					);
					vc_add_param('vc_row',array(
							"type" => "colorpicker",
							"class" => "",
							"heading"		=> esc_html__( 'Color', 'vintwood' ),
							"param_name" => "cws_overlay_color",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "bg_cws_color",
								'value' => 'color',
								
							),
							"value"			=> $first_color
						)
					);						
					vc_add_param('vc_row',array(
							"type" => "colorpicker",
							"class" => "",
							"heading"		=> esc_html__( 'From', 'vintwood' ),
							"param_name" => "cws_gradient_color_from",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "bg_cws_color",
								'value' => 'gradient',
								
							),
							"value"			=> $first_color
						)
					);					
					vc_add_param('vc_row',array(
							"type" => "colorpicker",
							"class" => "",
							"heading"		=> esc_html__( 'To', 'vintwood' ),
							"param_name" => "cws_gradient_color_to",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "bg_cws_color",
								'value' => 'gradient',
								
							),
							"value"			=> $first_color
						)
					);
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Type", 'vintwood'),
							"param_name"		=> "cws_gradient_type",
							"value" => array(
								esc_html__("Linear", 'vintwood') => "linear",
								esc_html__("Radial", 'vintwood') => "radial",
								),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "bg_cws_color",
								'value' => 'gradient',
								
							),
						)
					);	
					vc_add_param('vc_row',array(
							"type"			=> "textfield",
							"class" => "",
							"heading"		=> esc_html__( 'Angle', 'vintwood' ),
							"param_name"	=> "cws_gradient_angle",
							"value" => '45',
							"description"	=> esc_html__( 'Degrees: -360 to 360', 'vintwood' ),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "cws_gradient_type",
								'value' => 'linear',						
							),
						)
					);
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Shape variant", 'vintwood'),
							"param_name"		=> "cws_gradient_shape_variant_type",
							"value" => array(
								esc_html__("Simple", 'vintwood') => "simple",
								esc_html__("Extended", 'vintwood') => "extended",
								),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "cws_gradient_type",
								'value' => 'radial',	
							),
						)
					);					
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Shape", 'vintwood'),
							"param_name"		=> "cws_gradient_shape_type",
							"value" => array(
								esc_html__("Ellipse", 'vintwood') => "ellipse",
								esc_html__("Circle", 'vintwood') => "circle",
								),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "cws_gradient_shape_variant_type",
								'value' => 'simple',	
							),
						)
					);						
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Size keyword", 'vintwood'),
							"param_name"		=> "cws_gradient_size_keyword_type",
							"value" => array(
								esc_html__("Closest side", 'vintwood') => "closest_side",
								esc_html__("Farthest side", 'vintwood') => "farthest_side",
								esc_html__("Closest corner", 'vintwood') => "closest_corner",
								esc_html__("Farthest corner", 'vintwood') => "farthest_corner",
								),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "cws_gradient_shape_variant_type",
								'value' => 'extended',	
							),
						)
					);						
					vc_add_param('vc_row',array(
							"type" => "textfield",
							"class" => "",
							"heading" => esc_html__("Size", 'vintwood'),
							"param_name"		=> "cws_gradient_size_type",
							"value" => '60% 55%',
							"description"	=> esc_html__( 'Two space separated percent values, for example (60% 55%)', 'vintwood' ),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "cws_gradient_shape_variant_type",
								'value' => 'extended',	
							),
						)
					);					
					vc_add_param('vc_row',array(
							"type" => "attach_image",
							"class" => "",
							"heading" => esc_html__("Pattern", 'vintwood'),
							"param_name"		=> "cws_pattern_image",
							"group" => $group_name,
						)
					);
					vc_add_param('vc_row',array(
							"type" => "checkbox",
							"param_name"		=> "add_layers",
							"group" => $group_name,						
							"value"			=> array( esc_html__( 'Add Layer', 'vintwood' ) => true )
						)
					);					
					vc_add_param('vc_row',array(
							"type" => "attach_image",
							"class" => "",
							"heading" => esc_html__("Layer", 'vintwood'),
							"param_name"		=> "cws_layer_image",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "add_layers",
								"not_empty"	=> true
							),
						)
					);
					vc_add_param('vc_row', array(
							'type' => 'dropdown',
							'heading' => esc_html__( 'Layer position', 'vintwood' ),
							'param_name' => 'extra_layer_pos',
							'value' => array(
								__( 'Left', 'vintwood' ) => 'left',
								__( 'Right', 'vintwood' ) => 'right',
							),
							"group" => $group_name,
							'dependency' => array(
								'element' => 'add_layers',
								'not_empty' => true,
							),
						)
					);
					vc_add_param('vc_row', array(
							'type' => 'textfield',
							'heading' => esc_html__( 'Layer width', 'vintwood' ),
							'param_name' => 'extra_layer_width',
							'description' => esc_html__( 'In percents', 'vintwood' ),
							"group" => $group_name,
							'dependency' => array(
								'element' => 'add_layers',
								'not_empty' => true,
							),
						)
					);
					vc_add_param('vc_row', array(
							'type' => 'textfield',
							'heading' => esc_html__( 'Layer height', 'vintwood' ),
							'param_name' => 'extra_layer_height',
							'description' => esc_html__( 'In percents', 'vintwood' ),
							"group" => $group_name,
							'dependency' => array(
								'element' => 'add_layers',
								'not_empty' => true,
							),
						)
					);
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Layer Image Size", 'vintwood'),
							"param_name" => "extra_layer_size",
							"dependency"	=> array(
								"element"	=> "add_layers",
								"not_empty"	=> true
							),
							"value" => array(
								esc_html__("Initial", 'vintwood') => "initial",
								esc_html__("Cover", 'vintwood') => "cover",
								esc_html__("Contain", 'vintwood') => "contain",
								),	
							"group" => $group_name,
						)
					);
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Layer Image Position", 'vintwood'),
							"param_name" => "extra_layer_position",
							"dependency"	=> array(
								"element"	=> "add_layers",
								"not_empty"	=> true
							),
							"value" => array(
								esc_html__("Left Top", 'vintwood') => "left top",
								esc_html__("Left Center", 'vintwood') => "left center",
								esc_html__("Left Bottom", 'vintwood') => "left bottom",
								esc_html__("Right Top", 'vintwood') => "right top",
								esc_html__("Right Center", 'vintwood') => "right center",
								esc_html__("Right Bottom", 'vintwood') => "right bottom",
								esc_html__("Center Top", 'vintwood') => "center top",
								esc_html__("Center Center", 'vintwood') => "center center",
								esc_html__("Center Bottom", 'vintwood') => "center bottom",
							),	
							"group" => $group_name,
						)
					);
					vc_add_param('vc_row',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Layer Image Repeat", 'vintwood'),
							"param_name" => "extra_layer_repeat",
							"dependency"	=> array(
								"element"	=> "add_layers",
								"not_empty"	=> true
							),
							"value" => array(
								esc_html__("No Repeat", 'vintwood') => "no-repeat",
								esc_html__("Repeat", 'vintwood') => "repeat",
								esc_html__("Repeat X", 'vintwood') => "repeat-x",
								esc_html__("Repeat Y", 'vintwood') => "repeat-y",
							),	
							"group" => $group_name,
						)
					);			
					vc_add_param('vc_row',array(
							"type" => "colorpicker",
							"class" => "",
							"heading" => esc_html__("Layer Background Color", 'vintwood'),
							"param_name" => "extra_layer_bg",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "add_layers",
								"not_empty"	=> true
							),
							"value"			=> '',
						)
					);		
					vc_add_param('vc_row',array(
							"type" => "textfield",
							"class" => "",
							"heading" => esc_html__("Layer Margin", 'vintwood'),
							"param_name" => "extra_layer_margin",
							"dependency"	=> array(
								"element"	=> "add_layers",
								"not_empty"	=> true
							),
							"value" => "0px 0px",
							"description"	=> esc_html__( '1, 2( top/bottom, left/right ) or 4, space separated, values with units', 'vintwood' ),
							"group" => $group_name,
						)
					);
					//VC_COLUMN_INNER
					vc_add_param('vc_column_inner',array(
							"type" => "checkbox",
							"param_name" => "place_ahead",
							"group" => $group_name,
							"value"	=> array( esc_html__( 'Set it first on mobiles', 'vintwood' ) => true )
						)
					);
					vc_add_param('vc_column_inner',array(
							"type" => "checkbox",
							"param_name" => "custom_border",
							"group" => $group_name,
							"value"	=> array( esc_html__( 'Add custom border', 'vintwood' ) => true )
						)
					);
					vc_add_param('vc_column_inner', array(
							'type' => 'textfield',
							'heading' => esc_html__( 'Mobile paddings', 'vintwood' ),
							'param_name' => 'mobile_paddings',
							"value" => '0px 0px 0px 0px',
							"description"	=> esc_html__( 'Enter value with units. Top/Right/Bottom/Left @<768px', 'vintwood' ),
							"group" => $group_name,
						)
					);	
					vc_add_param('vc_column_inner',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Repeat", 'vintwood'),
							"param_name" => "inner_col_bg_repeat",
							"value" => array(							
								esc_html__("Repeat", 'vintwood') => "repeat",
								esc_html__("No Repeat", 'vintwood') => "no-repeat",
								esc_html__("Repeat X", 'vintwood') => "repeat-x",
								esc_html__("Repeat Y", 'vintwood') => "repeat-y",
								),
							"description" => esc_html__("Options to control repeatation of the background image. Learn on <a href='http://www.w3schools.com/cssref/playit.asp?filename=playcss_background-repeat' target='_blank'>W3School</a>", 'vintwood'),
							"group" => $group_name,
						)
					);
					vc_add_param('vc_column_inner',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Attachment", 'vintwood'),
							"param_name" => "inner_col_bg_attachment",
							"value" => array(
								esc_html__("Scroll", 'vintwood') => "scroll",
								esc_html__("Fixed", 'vintwood') => "fixed",
								),
							"group" => $group_name,
						)
					);
					vc_add_param('vc_column_inner',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Image Size", 'vintwood'),
							"param_name" => "inner_col_bg_size",
							"value" => array(
								esc_html__("Initial", 'vintwood') => "initial",
								esc_html__("Cover", 'vintwood') => "cover",
								esc_html__("Contain", 'vintwood') => "contain",
								),
							"group" => $group_name,
						)
					);
					vc_add_param('vc_column_inner',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Image Position", 'vintwood'),
							"param_name" => "inner_col_bg_position",
							"value" => array(
								esc_html__("Left Top", 'vintwood') => "left_top",
								esc_html__("Left Center", 'vintwood') => "left_center",
								esc_html__("Left Bottom", 'vintwood') => "left_bottom",
								esc_html__("Right Top", 'vintwood') => "right_top",
								esc_html__("Right Center", 'vintwood') => "right_center",
								esc_html__("Right Bottom", 'vintwood') => "right_bottom",
								esc_html__("Center Top", 'vintwood') => "center_top",
								esc_html__("Center Center", 'vintwood') => "center_center",
								esc_html__("Center Bottom", 'vintwood') => "center_bottom",
								),	
							"group" => $group_name,
						)
					);
					vc_add_param('vc_column_inner', array(
							'type' => 'textfield',
							'heading' => esc_html__( 'Box-shadow properties', 'vintwood' ),
							'param_name' => 'inner_col_box_shadow',
							'description' => esc_html__( 'Enter box-shadow properties. Example: 0px 5px 40px 3px rgba(0,0,0,0.1)', 'vintwood' ),
							"group" => $group_name,
						)
					);
					//--VC_COLUMN_INNER
					vc_add_param('vc_column',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Image Repeat", 'vintwood'),
							"param_name" => "bg_cws_repeat",
							"value" => array(							
								esc_html__("Repeat", 'vintwood') => "repeat",
								esc_html__("No Repeat", 'vintwood') => "no-repeat",
								esc_html__("Repeat X", 'vintwood') => "repeat-x",
								esc_html__("Repeat Y", 'vintwood') => "repeat-y",
								),
							"description" => esc_html__("Options to control repeatation of the background image. Learn on <a href='http://www.w3schools.com/cssref/playit.asp?filename=playcss_background-repeat' target='_blank'>W3School</a>", 'vintwood'),
							"group" => $group_name,
						)
					); 
					vc_add_param('vc_column',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Attachment", 'vintwood'),
							"param_name" => "bg_cws_attachment",
							"value" => array(
								esc_html__("Scroll", 'vintwood') => "scroll",
								esc_html__("Fixed", 'vintwood') => "fixed",
								),
							"group" => $group_name,
						)
					);
					vc_add_param('vc_column',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Image Size", 'vintwood'),
							"param_name" => "bg_cws_size",
							"value" => array(
								esc_html__("Initial", 'vintwood') => "initial",
								esc_html__("Cover", 'vintwood') => "cover",
								esc_html__("Contain", 'vintwood') => "contain",
								),
							"group" => $group_name,
						)
					);
					vc_add_param('vc_column',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Image Position", 'vintwood'),
							"param_name" => "bg_image_position",
							"value" => array(
								esc_html__("Left Top", 'vintwood') => "left_top",
								esc_html__("Left Center", 'vintwood') => "left_center",
								esc_html__("Left Bottom", 'vintwood') => "left_bottom",
								esc_html__("Right Top", 'vintwood') => "right_top",
								esc_html__("Right Center", 'vintwood') => "right_center",
								esc_html__("Right Bottom", 'vintwood') => "right_bottom",
								esc_html__("Center Top", 'vintwood') => "center_top",
								esc_html__("Center Center", 'vintwood') => "center_center",
								esc_html__("Center Bottom", 'vintwood') => "center_bottom",
								),	
							"group" => $group_name,
						)
					);
					vc_add_param('vc_column',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Background Color", 'vintwood'),
							"param_name"		=> "bg_cws_color",
							"value" => array(
								esc_html__("None", 'vintwood') => "none",
								esc_html__("Color", 'vintwood') => "color",
								esc_html__("Gradient", 'vintwood') => "gradient",
								),
							"group" => $group_name,
						)
					);
					vc_add_param('vc_column',array(
							"type" => "colorpicker",
							"class" => "",
							"heading"		=> esc_html__( 'Color', 'vintwood' ),
							"param_name" => "cws_overlay_color",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "bg_cws_color",
								'value' => 'color',
								
							),
							"value"			=> $first_color
						)
					);						
					vc_add_param('vc_column',array(
							"type" => "colorpicker",
							"class" => "",
							"heading"		=> esc_html__( 'From', 'vintwood' ),
							"param_name" => "cws_gradient_color_from",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "bg_cws_color",
								'value' => 'gradient',
								
							),
							"value"			=> $first_color
						)
					);					
					vc_add_param('vc_column',array(
							"type" => "colorpicker",
							"class" => "",
							"heading"		=> esc_html__( 'To', 'vintwood' ),
							"param_name" => "cws_gradient_color_to",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "bg_cws_color",
								'value' => 'gradient',
								
							),
							"value"			=> $first_color
						)
					);
					vc_add_param('vc_column',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Type", 'vintwood'),
							"param_name"		=> "cws_gradient_type",
							"value" => array(
								esc_html__("Linear", 'vintwood') => "linear",
								esc_html__("Radial", 'vintwood') => "radial",
								),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "bg_cws_color",
								'value' => 'gradient',
								
							),
						)
					);	
					vc_add_param('vc_column',array(
							"type"			=> "textfield",
							"class" => "",
							"heading"		=> esc_html__( 'Angle', 'vintwood' ),
							"param_name"	=> "cws_gradient_angle",
							"value" => '45',
							"description"	=> esc_html__( 'Degrees: -360 to 360', 'vintwood' ),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "cws_gradient_type",
								'value' => 'linear',						
							),
						)
					);
					vc_add_param('vc_column',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Shape variant", 'vintwood'),
							"param_name"		=> "cws_gradient_shape_variant_type",
							"value" => array(
								esc_html__("Simple", 'vintwood') => "simple",
								esc_html__("Extended", 'vintwood') => "extended",
								),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "cws_gradient_type",
								'value' => 'radial',	
							),
						)
					);					
					vc_add_param('vc_column',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Shape", 'vintwood'),
							"param_name"		=> "cws_gradient_shape_type",
							"value" => array(
								esc_html__("Ellipse", 'vintwood') => "ellipse",
								esc_html__("Circle", 'vintwood') => "circle",
								),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "cws_gradient_shape_variant_type",
								'value' => 'simple',	
							),
						)
					);						
					vc_add_param('vc_column',array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Size keyword", 'vintwood'),
							"param_name"		=> "cws_gradient_size_keyword_type",
							"value" => array(
								esc_html__("Closest side", 'vintwood') => "closest_side",
								esc_html__("Farthest side", 'vintwood') => "farthest_side",
								esc_html__("Closest corner", 'vintwood') => "closest_corner",
								esc_html__("Farthest corner", 'vintwood') => "farthest_corner",
								),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "cws_gradient_shape_variant_type",
								'value' => 'extended',	
							),
						)
					);						
					vc_add_param('vc_column',array(
							"type" => "textfield",
							"class" => "",
							"heading" => esc_html__("Size", 'vintwood'),
							"param_name"		=> "cws_gradient_size_type",
							"value" => '60% 55%',
							"description"	=> esc_html__( 'Two space separated percent values, for example (60% 55%)', 'vintwood' ),
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "cws_gradient_shape_variant_type",
								'value' => 'extended',	
							),
						)
					);					
					vc_add_param('vc_column',array(
							"type" => "attach_image",
							"class" => "",
							"heading" => esc_html__("Pattern", 'vintwood'),
							"param_name"		=> "cws_pattern_image",
							"group" => $group_name,
						)
					);
					vc_add_param('vc_column',array(
							"type" => "checkbox",
							"param_name" => "place_ahead",
							"group" => $group_name,
							"value"	=> array( esc_html__( 'Set it first on mobiles', 'vintwood' ) => true )
						)
					);
					vc_add_param('vc_column',array(
							"type" => "checkbox",
							"param_name" => "ripped_effect",
							"group" => $group_name,
							"value"	=> array( esc_html__( 'Add ripped effect', 'vintwood' ) => true )
						)
					);
					vc_add_param('vc_column',array(
							"type" => "checkbox",
							"param_name" => "custom_border",
							"group" => $group_name,
							"value"	=> array( esc_html__( 'Add custom border', 'vintwood' ) => true )
						)
					);
					vc_add_param('vc_column',array(
							"type"			=> "textfield",
							"class" => "",
							"heading"		=> esc_html__( 'Mobile Paddings', 'vintwood' ),
							"param_name"	=> "cws_mobile_paddings",
							"value" => '0px 0px 0px 0px',
							"description"	=> esc_html__( 'Enter value with units. Top/Right/Bottom/Left @<768px', 'vintwood' ),
							"group" => $group_name,
						)
					);	
					vc_add_param('vc_column',array(
							"type"			=> "textfield",
							"class" => "",
							"heading"		=> esc_html__( 'Tablets Paddings (Portrait)', 'vintwood' ),
							"param_name"	=> "cws_tablet_portrait_paddings",
							"value" => '0px 0px 0px 0px',
							"description"	=> esc_html__( 'Enter value with units. Top/Right/Bottom/Left @<981px', 'vintwood' ),
							"group" => $group_name,
						)
					);
					vc_add_param('vc_column',array(
							"type"			=> "textfield",
							"class" => "",
							"heading"		=> esc_html__( 'Tablets Paddings (Landscape)', 'vintwood' ),
							"param_name"	=> "cws_tablet_landscape_paddings",
							"value" => '0px 0px 0px 0px',
							"description"	=> esc_html__( 'Enter value with units. Top/Right/Bottom/Left @<1200px', 'vintwood' ),
							"group" => $group_name,
						)
					);				
					vc_add_param('vc_tta_accordion',array(
							"type" => "checkbox",
							"param_name"		=> "add_customize",
							"group" => $group_name,
							"value"			=> array( esc_html__( 'Cusomize Accordion', 'vintwood' ) => true )
						)
					);				
					vc_add_param('vc_tta_accordion',array(
							"type" => "colorpicker",
							"class" => "",
							"heading" => esc_html__("Title Color", 'vintwood'),
							"param_name"		=> "title_color",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "add_customize",
								"not_empty"	=> true
							),
							'value' => $first_color,
							"edit_field_class" => "vc_col-xs-6",
						)
					);						
					vc_add_param('vc_tta_accordion',array(
							"type" => "colorpicker",
							"class" => "",
							"heading" => esc_html__("Active Title Color", 'vintwood'),
							"param_name"		=> "active_title_color",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "add_customize",
								"not_empty"	=> true
							),
							'value' => $first_color,
							"edit_field_class" => "vc_col-xs-6",
						)
					);						
					vc_add_param('vc_tta_accordion',array(
							"type" => "colorpicker",
							"class" => "",
							"heading" => esc_html__("Body Color", 'vintwood'),
							"param_name"		=> "body_color",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "add_customize",
								"not_empty"	=> true
							),
							'value' => $first_color,
							"edit_field_class" => "vc_col-xs-6",
						)
					);
					vc_add_param('vc_tta_accordion',array(
							"type" => "colorpicker",
							"class" => "",
							"heading" => esc_html__("Active Body Color", 'vintwood'),
							"param_name"		=> "active_body_color",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "add_customize",
								"not_empty"	=> true
							),
							'value' => "#fff",
							"edit_field_class" => "vc_col-xs-6",
						)
					);		
					vc_add_param('vc_tta_accordion',array(
							"type" => "colorpicker",
							"class" => "",
							"heading" => esc_html__("Header Fill Color", 'vintwood'),
							"param_name"		=> "header_fill_color",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "add_customize",
								"not_empty"	=> true
							),
							'value' => "#fff",
							"edit_field_class" => "vc_col-xs-6",
						)
					);														
					vc_add_param('vc_tta_accordion',array(
							"type" => "colorpicker",
							"class" => "",
							"heading" => esc_html__("Active Header Fill Color", 'vintwood'),
							"param_name"		=> "active_header_fill_color",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "add_customize",
								"not_empty"	=> true
							),
							'value' => "#fff",
							"edit_field_class" => "vc_col-xs-6",
						)
					);	
					vc_add_param('vc_tta_accordion',array(
							"type" => "colorpicker",
							"class" => "",
							"heading" => esc_html__("Body Fill Color", 'vintwood'),
							"param_name"		=> "body_fill_color",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "add_customize",
								"not_empty"	=> true
							),
							'value' => $first_color,
							"edit_field_class" => "vc_col-xs-6",
						)
					);											
					vc_add_param('vc_tta_accordion',array(
							"type" => "colorpicker",
							"class" => "",
							"heading" => esc_html__("Active Body Fill Color", 'vintwood'),
							"param_name"		=> "active_body_fill_color",
							"group" => $group_name,
							"dependency"	=> array(
								"element"	=> "add_customize",
								"not_empty"	=> true
							),
							'value' => $first_color,
							"edit_field_class" => "vc_col-xs-6",
						)
					);	
				}
			} 
		}
		new VC_CWS_Background;
	}
	
	if ( !function_exists( 'vc_theme_before_vc_row' ) ) {
		function vc_theme_before_vc_row($atts, $content = null) {
			$GLOBALS['cws_row_atts'] = $atts;
			return VC_CWS_Background::cws_open_vc_shortcode($atts, $content);
		}
	}

	if ( !function_exists( 'vc_theme_before_vc_column' ) ) {
		function vc_theme_before_vc_column($atts, $content = null) {
			new VC_CWS_Background();
			return VC_CWS_Background::cws_open_vc_shortcode_column($atts, $content);
		}
	}
	if ( !function_exists( 'vc_theme_before_vc_column_inner' ) ) {
		function vc_theme_before_vc_column_inner($atts, $content = null) {
			new VC_CWS_Background();
			return VC_CWS_Background::cws_open_vc_shortcode_column_inner($atts, $content);
		}
	}
	if ( !function_exists( 'vc_theme_before_vc_tta_accordion' ) ) {
		function vc_theme_before_vc_tta_accordion($atts, $content = null) {
			new VC_CWS_Background();
			return VC_CWS_Background::cws_accordion_customzize($atts, $content);
		}
	}	
	if ( !function_exists( 'vc_theme_after_vc_tta_accordion' ) ) {
		function vc_theme_after_vc_tta_accordion($atts, $content = null) {
			new VC_CWS_Background();
			return VC_CWS_Background::cws_accordion_close($atts, $content);
		}
	}				
	if ( !function_exists( 'vc_theme_after_vc_column' ) ) {
		function vc_theme_after_vc_column($atts, $content = null) {
			new VC_CWS_Background();
			return VC_CWS_Background::cws_close_vc_shortcode_column($atts, $content);
		}
	}	
	if ( !function_exists( 'vc_theme_after_vc_row' ) ) {
		function vc_theme_after_vc_row($atts, $content = null) {
			unset($GLOBALS['cws_row_atts']);
			return VC_CWS_Background::cws_close_vc_shortcode($atts, $content);
		}
	}
	
?>